package com.talpa.tengine.store

import java.util.*

/**
 * @author CY 2019-05-13
 */
//@Entity(tableName = "TransStatus")
data class TransStatus(
    /**
     * 翻译接口的名称
     */
    //@ColumnInfo(name = "trans_name")
    val transName: String = "",
    /**
     * 翻译接口状态
     */
    //@ColumnInfo(name = "trans_status")
    val status: Int = TRANS_STATUS_AVAILABLE,

    /**
     * 是否翻译成功
     */
    val isTransSuccess: Boolean = true,
    /**
     * 最近翻译的时间
     */
    //@ColumnInfo(name = "last_timed")
    val lastTimed: Date,

    /**
     * 失败原因
     */
    //@ColumnInfo(name = "failed_cause")
    val failedCause: Int = 0,
    /**
     * 失败原因信息
     */
    //@ColumnInfo(name = "failed_case_message")
    val failedCauseMessage: String = ""
) {


    companion object {

        /* 翻译状态 */
        /**
         * 可用
         */
        const val TRANS_STATUS_AVAILABLE = 100
        /**
         * 不可用
         */
        const val TRANS_STATUS_UNAVAILABLE = 101

        /* 失败原因 */
        /**
         * 没有网络
         */
        const val FAILED_CAUSE_NO_NETWORK = 100
        /**
         * 网络超时
         */
        const val FAILED_CAUSE_NETWORK_TIMEOUT = 101
        /**
         * 网络 CODE [400-500)
         */
        const val FAILED_CAUSE_NETWORK_400 = 102
        /**
         * 网络 CODE [500-600)
         */
        const val FAILED_CAUSE_NETWORK_500 = 103
        /**
         * 其它异常导致
         */
        const val FAILED_CAUSE_THROWABLE = 103
    }

}