package com.talpa.tengine.charge

import com.google.gson.*
import com.talpa.tengine.lang.LANG
import io.reactivex.Flowable
import okhttp3.MediaType
import okhttp3.RequestBody
import okhttp3.ResponseBody


/**
 * 微软付费翻译
 * @author CY 19-2-27
 */
class MicrosoftTranslate(private val key: String) : TranslateFactory() {

    override val isSupportMultiTextTranslate: Boolean = true

    override fun setFormData(from: String, to: String, text: String): TranslateFactory {
        if (langMap.containsKey(to)) {
            formData["to"] = langMap[to]!!
        }
        formData["text"] = text
        return this
    }

    override fun parses(response: retrofit2.Response<ResponseBody>): List<String> {

        if (response.isSuccessful) {
            val responseBody = response.body()!!
            val text = responseBody.string()
            //{"error":{"code":401000,"message":"The request is not authorized because credentials are missing or invalid."}}
            //[{"detectedLanguage":{"language":"zh-Hans","score":1.0},"translations":[{"text":"How are you doing","to":"en"}]}]
            println("text=$text")
            val jsonElement = Gson().fromJson<JsonElement>(text, JsonElement::class.java)
            val jsonObject = (jsonElement as? JsonArray)?.get(0)?.asJsonObject
            val resultArray = jsonObject?.getAsJsonArray("translations")
            resultArray ?: throw Exception("Microsoft Trans error.$text")
            val language = jsonObject.getAsJsonObject("detectedLanguage")
                ?.getAsJsonPrimitive("language")?.asString
            //识别的源语言
            //  detectLang = if (language == null) null else microsoftCodeToLang(language)
            val list = arrayListOf<String>()
            resultArray.forEach { ja ->
                val tran = ja.asJsonObject.get("text").asString
                list.add(tran)
            }
            return list
        }

        throw Exception("Microsoft Cloud Code=${response.code()}")
    }

    fun parses2(response: retrofit2.Response<ResponseBody>): Map<String, String> {
        if (response.isSuccessful) {
            val responseBody = response.body()!!
            val text = responseBody.string()
            //{"error":{"code":401000,"message":"The request is not authorized because credentials are missing or invalid."}}
            //[{"detectedLanguage":{"language":"zh-Hans","score":1.0},"translations":[{"text":"How are you doing","to":"en"}]}]
            println("text=$text")
            val jsonElement = Gson().fromJson<JsonElement>(text, JsonElement::class.java)
            val jsonObject = (jsonElement as? JsonArray)?.get(0)?.asJsonObject
            val resultArray = jsonObject?.getAsJsonArray("translations")
            resultArray ?: throw Exception("Microsoft Trans error.$text")
            val language = jsonObject.getAsJsonObject("detectedLanguage")
                ?.getAsJsonPrimitive("language")?.asString ?: ""
            //识别的源语言
            // val detectLang = if (language == null) "" else microsoftCodeToLang(language) ?: ""
            /*    val list = arrayListOf<String>()
                resultArray.forEach { ja ->
                    val tran = ja.asJsonObject.get("text").asString
                    list.add(tran)
                }*/
            val translation = resultArray.first().asJsonObject.get("text").asString
            return mapOf(language to translation)
        }

        throw Exception("Microsoft Cloud Code=${response.code()}")
    }

    override fun setLangSupport(langMap: HashMap<String, String>) {
        langMap[LANG.AUTO] = "auto-detect"
        langMap[LANG.NL] = "af"//南非荷兰语
        langMap[LANG.AR] = "ar"//阿拉伯语
        langMap[LANG.BG] = "bg"//保加利亚语
        langMap[LANG.BN] = "bn-BD"//孟加拉语
        langMap[LANG.FA] = "bs-Latn"//波斯尼亚语
        langMap[LANG.CA] = "ca"//加泰隆语
        langMap[LANG.CS] = "cs"//捷克语
        langMap[LANG.CY] = "cy"//威尔士语
        langMap[LANG.DA] = "da"//丹麦语
        langMap[LANG.DE] = "de"//德语
        langMap[LANG.EL] = "el"//希腊语
        langMap[LANG.EN] = "en"//英语
        langMap[LANG.ES] = "es"//西班牙语
        langMap[LANG.ET] = "et"//爱沙尼亚语
        langMap[LANG.FA] = "fa"//波斯语
        langMap[LANG.FI] = "fi"//芬兰语
        langMap[LANG.TL] = "fil"//菲律宾语
        //langMap[LANG.FJ] = "fj"//斐济
        langMap[LANG.FR] = "fr"//法语
        langMap[LANG.HE] = "he"//希伯来语
        langMap[LANG.HI] = "hi"//印地语
        langMap[LANG.HR] = "hr"//克罗地亚语
        langMap[LANG.HT] = "ht"//海地克里奥尔语
        langMap[LANG.HU] = "hu"//匈牙利语
        langMap[LANG.ID] = "id"//印度尼西亚语
        langMap[LANG.IS] = "is"//冰岛语
        langMap[LANG.IT] = "it"//意大利语
        langMap[LANG.JA] = "ja"//日语
        langMap[LANG.KO] = "ko"//朝鲜语
        langMap[LANG.LT] = "lt"//立陶宛语
        langMap[LANG.LV] = "lv"//拉脱维亚语
        langMap[LANG.MG] = "mg"//马尔加什语
        langMap[LANG.MS] = "ms"//马来语
        langMap[LANG.MT] = "mt"//马耳他语
        langMap[LANG.HMN] = "mww"//白苗文
        langMap[LANG.NO] = "nb"//挪威语
        langMap[LANG.NL] = "nl"//荷兰语
        //langMap[LANG.OTQ] = "otq"//克雷塔罗奥托米语
        langMap[LANG.PL] = "pl"//波兰语
        langMap[LANG.PT] = "pt"//葡萄牙语
        langMap[LANG.RO] = "ro"//罗马尼亚语
        langMap[LANG.RU] = "ru"//俄语
        langMap[LANG.SK] = "sk"//斯洛伐克语
        langMap[LANG.SL] = "sl"//斯洛文尼亚语
        langMap[LANG.SM] = "sm"//萨摩亚语
        langMap[LANG.SR] = "sr-Cyrl"//塞尔维亚语 (西里尔文)
        langMap[LANG.ST] = "sr-Latn"//塞尔维亚语 (拉丁文)
        langMap[LANG.SV] = "sv"//瑞典语
        langMap[LANG.SW] = "sw"//斯瓦希里语
        langMap[LANG.TA] = "ta"//泰米尔语
        langMap[LANG.TE] = "te"//泰卢固语
        langMap[LANG.TH] = "th"//泰语
        //langMap[LANG.FILH] = "tlh"//克林贡语
        //langMap[LANG.TO] = "to"//汤加语
        langMap[LANG.TR] = "tr"//土耳其语
        //langMap[LANG.TY] = "ty"//塔希提语
        langMap[LANG.UK] = "uk"//乌克兰语
        langMap[LANG.UR] = "ur"//乌尔都语
        langMap[LANG.VI] = "vi"//越南语
        //langMap[LANG.YUA] = "yua"//尤卡坦玛雅语
        //langMap[LANG.YUE] = "yue"//粤语(繁体)
        langMap[LANG.ZH_CN] = "zh-Hans"//简体中文
        langMap[LANG.ZH_TW] = "zh-Hant"//繁体中文
    }

    override fun execute(): Flowable<retrofit2.Response<ResponseBody>> {

        val text =
            formData["text"]//"Welcome to Microsoft Translator. Guess how many languages I speak!"

        val mediaType = MediaType.parse("application/json")

        val jsonObject = JsonObject().apply { addProperty("Text", text) }
        val jsonArray = JsonArray().apply { add(jsonObject) }
        val content = jsonArray.toString()
        val requestBody = RequestBody.create(
            mediaType,
            content
        )

        val headerMap = hashMapOf(
            "Ocp-Apim-Subscription-Key" to key,
            "Content-type" to "application/json"
        )
        return com.talpa.tengine.request.RequestHelper.postBody(
            BASE_URL,
            PATHS,
            headerMap,
            requestBody,
            params = mapOf("to" to formData["to"]!!)//to=de,zh-Hans
        )
    }

    // This function prettifies the json response.
    fun prettify(json_text: String): String {
        val parser = JsonParser()
        val json = parser.parse(json_text)
        val gson = GsonBuilder().setPrettyPrinting().create()
        return gson.toJson(json)
    }


    companion object {
        //var url = "https://api.cognitive.microsofttranslator.com/translate?api-version=3.0&to=de,zh-Hans"
        private const val BASE_URL = "https://api.cognitive.microsofttranslator.com/"
        private const val PATHS = "translate?api-version=3.0"
//        private const val subscriptionKey = "03e8ecf560e3484d83f51d5e36f44783"
    }

}

/*
[
  {
    "detectedLanguage": {
      "language": "en",
      "score": 1.0
    },
    "translations": [
      {
        "text": "Willkommen bei Microsoft Translator. Erraten Sie, wie viele Sprachen ich spreche!",
        "to": "de"
      },
      {
        "text": "欢迎来到微软翻译。猜猜我说了多少种语言!",
        "to": "zh-Hans"
      }
    ]
  }
]
*/

fun main() {
    //val subscriptionKey = "3f3610cc8c0d4feabdc937b7df30dfb1"
    //val subscriptionKey = "e3c691d51faa411ca01acaa098f7de5b"
//    val subscriptionKey = "cac5b3ef22d14d758df0ec3c73d5c46c"//cac5b3ef22d14d758df0ec3c73d5c46c
//    val subscriptionKey = "10b34a0f4a4c44ce8ff42b9d39263895"//cac5b3ef22d14d758df0ec3c73d5c46c
    //val subscriptionKey = "31738e7c934842cdbeb5feb13b82c021"//cac5b3ef22d14d758df0ec3c73d5c46c
    val subscriptionKey = "68b73090d61341dab9073364c9d11704"//68b73090d61341dab9073364c9d11704

    val translate = MicrosoftTranslate(subscriptionKey)
    translate.setFormData(LANG.ZH_CN, LANG.EN, "你好")
    val d = translate.execute().subscribe({
        println(translate.parses(it))
    }, Throwable::printStackTrace)

//    val root = Gson().fromJson<JsonObject>(json, JsonObject::class.java)
//
//    val translation = root.getAsJsonObject("translation")
//    val keys = translation.keySet()
//    //langMap[LANG.EN] = "en"
//    val sb = StringBuilder()
//    println("keys=${keys.size}")
//    for (key in keys) {
//        sb.append("langMap[LANG.${key.toUpperCase()}]")
//        sb.append("=\"")
//        sb.append(key)
//        sb.append("\"//")
//        sb.append(translation.getAsJsonObject(key).get("name").asString)
//        sb.append('\n')
//    }
//    println(sb.toString())
}

