package com.talpa.tengine.charge


import com.talpa.tengine.lang.LANG
import com.talpa.tengine.store.TransStatus
import okhttp3.ResponseBody

/**
 *  翻译基类
 *  @author CY 2019-01-13
 */
abstract class TranslateFactory : AbstractFactory() {

    /**
     * 翻译状态
     */
    var transStatus: TransStatus? = null

    /**
     * 是否支持多文本翻译
     */
    abstract val isSupportMultiTextTranslate: Boolean

    /**
     * 设置表单数据
     */
    abstract fun setFormData(from: String = LANG.AUTO, to: String, text: String): TranslateFactory

    /**
     * 解析结果
     */
    abstract fun parses(response: retrofit2.Response<ResponseBody>): List<String>

    /**
     * 探测出的源语言，可能为null
     */
    var detectLang: String? = null
}
