package com.talpa.tengine.free

import android.content.Context
import android.util.Log
import com.google.gson.*
import com.talpa.tengine.lang.LANG
import com.talpa.tengine.request.RequestHelper
import com.talpa.tengine.tools.googleTk
import io.reactivex.Flowable
import okhttp3.ResponseBody
import java.io.ByteArrayInputStream
import java.io.File
import java.io.InputStreamReader
import java.io.StringReader
import java.util.*
import javax.script.Invocable
import javax.script.ScriptEngineManager


/**
 *  @author CY 2019-01-13
 */
class GoogleTranslate(private val context: Context) : TranslateFactory() {

    override val isSupportMultiTextTranslate: Boolean = true

    override fun setLangSupport(langMap: HashMap<String, String>) {
        langMap[LANG.AUTO] = "auto"
        langMap[LANG.AF] = "af"//南非荷兰语
        langMap[LANG.SQ] = "sq"//阿尔巴尼亚语
        langMap[LANG.AM] = "am"//阿姆哈拉语
        langMap[LANG.AR] = "ar"//阿拉伯语
        langMap[LANG.HY] = "hy"//亚美尼亚语
        langMap[LANG.AZ] = "az"//阿塞拜疆语
        langMap[LANG.EU] = "eu"//巴斯克语
        langMap[LANG.BE] = "be"//白俄罗斯语
        langMap[LANG.BN] = "bn"//孟加拉语
        langMap[LANG.BS] = "bs"//波斯尼亚语
        langMap[LANG.BG] = "bg"//保加利亚语
        langMap[LANG.CA] = "ca"//加泰罗尼亚语
        langMap[LANG.CEB] = "ceb"//宿务语
        langMap[LANG.ZH_CN] = "zh-CN"//中文
        langMap[LANG.ZH_TW] = "zh-TW"//中文
        langMap[LANG.CO] = "co"//科西嘉语
        langMap[LANG.HR] = "hr"//克罗地亚语
        langMap[LANG.CS] = "cs"//捷克语
        langMap[LANG.DA] = "da"//丹麦语
        langMap[LANG.NL] = "nl"//荷兰语
        langMap[LANG.EN] = "en"//英语
        langMap[LANG.EO] = "eo"//世界语
        langMap[LANG.ET] = "et"//爱沙尼亚语
        langMap[LANG.FI] = "fi"//芬兰语
        langMap[LANG.FR] = "fr"//法语
        langMap[LANG.FY] = "fy"//西弗里西亚语
        langMap[LANG.GL] = "gl"//加利西亚语
        langMap[LANG.KA] = "ka"//格鲁吉亚语
        langMap[LANG.DE] = "de"//德语
        langMap[LANG.EL] = "el"//希腊语
        langMap[LANG.GU] = "gu"//古吉拉特语
        langMap[LANG.HT] = "ht"//海地克里奥尔语
        langMap[LANG.HA] = "ha"//豪萨语
        langMap[LANG.HAW] = "haw"//夏威夷语
        langMap[LANG.HE] = "he"//希伯来语
        langMap[LANG.HI] = "hi"//印地语
        langMap[LANG.HMN] = "hmn"//苗语
        langMap[LANG.HU] = "hu"//匈牙利语
        langMap[LANG.IS] = "is"//冰岛语
        langMap[LANG.IG] = "ig"//伊博语
        langMap[LANG.ID] = "id"//印度尼西亚语
        langMap[LANG.GA] = "ga"//爱尔兰语
        langMap[LANG.IT] = "it"//意大利语
        langMap[LANG.JA] = "ja"//日语
        langMap[LANG.JV] = "jv"//爪哇语
        langMap[LANG.KN] = "kn"//卡纳达语
        langMap[LANG.KK] = "kk"//哈萨克语
        langMap[LANG.KM] = "km"//高棉语
        langMap[LANG.RW] = "rw"//卢旺达语
        langMap[LANG.KO] = "ko"//韩语
        langMap[LANG.KU] = "ku"//库尔德语
        langMap[LANG.KY] = "ky"//柯尔克孜语
        langMap[LANG.LO] = "lo"//老挝语
        langMap[LANG.LA] = "la"//拉丁语
        langMap[LANG.LV] = "lv"//拉脱维亚语
        langMap[LANG.LT] = "lt"//立陶宛语
        langMap[LANG.LB] = "lb"//卢森堡语
        langMap[LANG.MK] = "mk"//马其顿语
        langMap[LANG.MG] = "mg"//马拉加斯语
        langMap[LANG.MS] = "ms"//马来语
        langMap[LANG.ML] = "ml"//马拉雅拉姆语
        langMap[LANG.MT] = "mt"//马耳他语
        langMap[LANG.MI] = "mi"//毛利语
        langMap[LANG.MR] = "mr"//马拉地语
        langMap[LANG.MN] = "mn"//蒙古语
        langMap[LANG.MY] = "my"//缅甸语
        langMap[LANG.NE] = "ne"//尼泊尔语
        langMap[LANG.NO] = "no"//挪威语
        langMap[LANG.NY] = "ny"//齐切瓦语
        langMap[LANG.OR] = "or"//奥里亚语
        langMap[LANG.PS] = "ps"//普什图语
        langMap[LANG.FA] = "fa"//波斯语
        langMap[LANG.PL] = "pl"//波兰语
        langMap[LANG.PT] = "pt"//葡萄牙语
        langMap[LANG.PA] = "pa"//旁遮普语
        langMap[LANG.RO] = "ro"//罗马尼亚语
        langMap[LANG.RU] = "ru"//俄语
        langMap[LANG.SM] = "sm"//萨摩亚语
        langMap[LANG.GD] = "gd"//苏格兰盖尔语
        langMap[LANG.SR] = "sr"//塞尔维亚语
        langMap[LANG.ST] = "st"//南索托语
        langMap[LANG.SN] = "sn"//绍纳语
        langMap[LANG.SD] = "sd"//信德语
        langMap[LANG.SI] = "si"//僧伽罗语
        langMap[LANG.SK] = "sk"//斯洛伐克语
        langMap[LANG.SL] = "sl"//斯洛文尼亚语
        langMap[LANG.SO] = "so"//索马里语
        langMap[LANG.ES] = "es"//西班牙语
        langMap[LANG.SU] = "su"//巽他语
        langMap[LANG.SW] = "sw"//斯瓦希里语
        langMap[LANG.SV] = "sv"//瑞典语
        langMap[LANG.TL] = "tl"//他加禄语
        langMap[LANG.TG] = "tg"//塔吉克语
        langMap[LANG.TA] = "ta"//泰米尔语
        langMap[LANG.TT] = "tt"//鞑靼语
        langMap[LANG.TE] = "te"//泰卢固语
        langMap[LANG.TH] = "th"//泰语
        langMap[LANG.TR] = "tr"//土耳其语
        langMap[LANG.TK] = "tk"//土库曼语
        langMap[LANG.UK] = "uk"//乌克兰语
        langMap[LANG.UR] = "ur"//乌尔都语
        langMap[LANG.UG] = "ug"//维吾尔语
        langMap[LANG.UZ] = "uz"//乌兹别克语
        langMap[LANG.VI] = "vi"//越南语
        langMap[LANG.CY] = "cy"//威尔士语
        langMap[LANG.XH] = "xh"//科萨语
        langMap[LANG.YI] = "yi"//意第绪语
        langMap[LANG.YO] = "yo"//约鲁巴语
        langMap[LANG.ZU] = "zu"//祖玛语

    }

    override fun setFormData(from: String, to: String, text: String): GoogleTranslate {
        formData["client"] = "webapp"//"t"
        formData["sl"] = langMap[from]!!
        formData["tl"] = langMap[to]!!
        formData["hl"] = "zh-CN"
        formData["dt"] = "at"
        formData["dt"] = "bd"
        formData["dt"] = "ex"
        formData["dt"] = "ld"
        formData["dt"] = "md"
        formData["dt"] = "qca"
        formData["dt"] = "rw"
        formData["dt"] = "rm"
        formData["dt"] = "ss"
        formData["dt"] = "t"
        formData["ie"] = "UTF-8"
        formData["oe"] = "UTF-8"
        formData["source"] = "btn"
        formData["ssel"] = "0"
        formData["tsel"] = "0"
        formData["kc"] = "0"
        formData["tk"] = token(text)

        formData["q"] = text
        return this
    }

    /**
     * 请在子线程中执行
     */
    override fun parses(response: retrofit2.Response<ResponseBody>): List<String> {

        if (response.isSuccessful) {
            val responseBody = response.body()!!
            val text = responseBody.string()

            //[[["Hello there","你好",null,null,1]],null,"zh-CN"]
            //[[["Hello\n","你好啊\n",null,null,1],["Hello there\n","你好\n",null,null,1],["I'm very good","我很好",null,null,1],[null,null,null,"Nǐ hǎo a\nnǐ hǎo\nwǒ hěn hǎo"]],null,"zh-CN",null,null,[["你好啊",null,[["Hello",1000,true,false],["Hello.",0,true,false]],[[0,3]],"你好啊",0,0],["\n",null,null,[[0,1]],"\n",0,0],["你好",null,[["Hello there",1000,true,false],["Hello",1000,true,false],["Hi",1000,true,false]],[[0,2]],"你好",0,0],["\n",null,null,[[0,1]],"\n",0,0],["我很好",null,[["I'm very good",1000,true,false],["I'm fine",1000,true,false],["I am fine",0,true,false],["I'm fine.",0,true,false]],[[0,3]],"我很好",0,0]],1,null,[["zh-CN"],null,[1],["zh-CN"]]]
            //println("text=$text")
            return try {
                val jsonArray = Gson().fromJson<JsonArray>(text, JsonArray::class.java)

                if (jsonArray.size() > 2 && jsonArray[2].isJsonPrimitive) {
                    //detectLang = googleCodeToLang(jsonArray[2].asString)
                }


                val resultArray = jsonArray.get(0).asJsonArray
                val list = arrayListOf<String>()
                for (ja in resultArray) {
                    val tran = ja.asJsonArray.get(0).asString
                    list.add(tran)
                }
                list
            } catch (e: Exception) {
                // exceptionParser(text)
                throw Exception("Google translator parser exception.text=$text")
            }
        }

        throw Exception("Google Code=${response.code()}")


    }

    /**
     * 解析异常，调用备用解析方案
     */
    private fun exceptionParser(text: String): ArrayList<String> {

        //https://raw.githubusercontent.com/tmxdyf/sources/master/google_trans_selector
        val json = prettify(text)

        val isr = InputStreamReader(ByteArrayInputStream(json.toByteArray()))
        val list = isr.readLines()
        isr.close()

        return try {
            val rowIndex = getRow()
            val row = list[rowIndex]
            val content = row.substring(row.indexOf('"') + 1, row.lastIndexOf('"'))
            arrayListOf(content)
        } catch (e: java.lang.Exception) {
            val rowIndex = getRow(0)
            val row = list[rowIndex]
            val content = row.substring(row.indexOf('"') + 1, row.lastIndexOf('"'))
            arrayListOf(content)
        }


    }

    private fun getRow(maxAge: Int = 3600 * 24 * 90): Int {
        val baseUrl = "https://raw.githubusercontent.com/"
        val paths = "tmxdyf/sources/master/google_trans_selector"
        val headerMap = mapOf("Cache-Control" to "public,max-age=$maxAge")
        RequestHelper.cacheFile = File("/home/cy/文档/cache")
        val response = RequestHelper.get(headerMap = headerMap, baseUrl = baseUrl, paths = paths)
            .blockingFirst()
        if (response.isSuccessful) {
            val responseBody = response.body()!!

            val stream = responseBody.charStream()
            val jsonObject = Gson().fromJson<JsonObject>(stream, JsonObject::class.java)
            stream.close()
            responseBody.close()
            val resultRow = jsonObject.get("google").asJsonObject.get("resultRow").asInt
            return resultRow
        }

        return 0

    }

    /**
     * 格式化JSON
     */
    private fun prettify(json_text: String): String {
        val parser = JsonParser()
        val json = parser.parse(json_text)
        val gson = GsonBuilder().setPrettyPrinting().create()
        return gson.toJson(json)
    }


    override fun execute(): Flowable<retrofit2.Response<ResponseBody>> {


        /*
        cookie: _ga=GA1.3.522939218.1554863528; _gid=GA1.3.1649833551.1556095286; NID=182=loH3xwcxUd6eQawj2qc3puKAv7Laz9IoD6tFUU7O63Qc6CP-rk_sRDJEfXzykvV2DE839lmcqebNBpgJASQm7q-b1quFWWWj7Y_qH20yNVNxcjtOr8GfweaITOwmYFwV_oG15ZhM0KC-bPFjJV1Iqvat2cg004mdSOPSpRyHgcM; _gat=1; 1P_JAR=2019-4-24-9
referer: https://translate.google.cn/
user-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36
x-client-data: CIy2yQEIpLbJAQipncoBCKijygEIuKTKAQixp8oBCOKoygEI8anKAQivrMoBCLmsygE=
         */
        val headerMap = mapOf(

            "Cache-Control" to "public,max-age=${3600 * 24 * 365}",
            "user-agent" to "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36"
        )
        /*
        val formData = mapOf(
            "client" to "webapp",
            "sl" to "zh-CN",
            "tl" to "ja",
            "hl" to "zh-CN",
            "dt" to "at",
            "dt" to "bd",
            "dt" to "ex",
            "dt" to "ld",
            "dt" to "md",
            "dt" to "qca",
            "dt" to "rw",
            "dt" to "rm",
            "dt" to "ss",
            "dt" to "t",
            "otf" to "2",
            "ssel" to "0",
            "tsel" to "0",
            "kc" to "1",
            "tk" to "736186.896620",
            "q" to "你好你好"
        )
        */

        //Translator.context.assets.open("")
        //obtainHost()

        val language = Locale.getDefault().language
        val baseUrl = if (language == "zh") GOOGLE_URL_CN else GOOGLE_URL_COM

        return RequestHelper.get(
            baseUrl = baseUrl,
            paths = GOOGLE_PATHS,
            params = formData,
            headerMap = headerMap
        )
    }


    private fun token(text: String): String {

        var tk = ""
        var tkReader: StringReader? = null
        /*try {
            Translator.context
        } catch (e: Throwable) {
            return tk
        }*/
        try {

            val engine = ScriptEngineManager().getEngineByName("rhino")//rhino,js

            Log.d("ScriptEngineManager", "rhino#engine=$engine")

            engine?.let {
                tkReader = StringReader(googleTk(context))
                engine.eval(tkReader)
            }
            if (engine is Invocable) {
                val invoke = engine as Invocable
                tk = invoke.invokeFunction("token", text).toString()//tk
            }
        } catch (e: Throwable) {
            e.printStackTrace()
        } finally {
            tkReader?.close()
        }

        return tk
    }


    companion object {
        //  const val GOOGLE_URL = "https://translate.google.cn/translate_a/single"
        const val GOOGLE_URL_CN = "https://translate.google.cn/"//国外使用com
        const val GOOGLE_URL_COM = "https://translate.google.com/"//国外使用com
        //const val GOOGLE_URL = "https://translate.google.com.hk/"//香港，一个不行用另外一个

        const val GOOGLE_PATHS = "translate_a/single"
    }

}

fun main() {
    //textExecute()

}
//
//
//private fun translate() {
//
//
//    val json = JsonArray().apply {
//        add("今天天气如何?")
//        add("你")
//        add("今天开心吗")
//        add("今天天气如何")
//        add("上班族通过单位申请办理是最方便的，拿到表格填写后提交给单位走流程即可")
//        add("房租要在填报个税减免申请后才可以根据租客与房东约定好的租房合同来进行减免，提交申请需要填写以下几项内容：出租人的主要工作城市、租赁住房坐落的地址（需照实填写）；出租人（如有配偶，也需填写配偶信息）姓名及身份证类型以及身份证号码或者出租方单位名称及纳税人识别号（社会统一信用代码）；租赁起止时间以及用户留存备查的资料有住房租赁合同或者协议等；用户可以通过远程办税端，电子或纸质报纸来报送。申报成功后房租抵扣个税就可以在单位没有发放的工资中进行扣除或者在年度汇算清缴的自行纳税申报环节办理。")
//    }.toString()
//
//    //println("json=$json")
//
//    val le = "拿到表格填写后提交给单位走流程即可房租要在填报个税减免申请后才可以根据租客与房东约定好的租房合同来进行减免，提交申请需要填写以下几项内容：出租人的主要\r\n"
//    //println("le=${le.length}")
//    //最大单句７５个字符，不包含换行符\r\n，加上换行符７7个字符
//
//    val text =
//        "哈哈哈\r\n你\r\n今天开心吗\r\n今天天气如何\r\n上班族通过单位申请办理是最方便的\r\n拿到表格填写后提交给单位走流程即可\r\n房租要在填报个税减免申请后才可以根据租客与房东约定好的租房合同来进行减免，\r\n提交申请需要填写以下几项内容：出租人的主要工作城市、\r\n租赁住房坐落的地址（需照实填写）；\r\n出租人（如有配偶，也需填写配偶信息）\r\n姓名及身份证类型以及身份证号码或者出租方单位名称及纳税人识别号（社会统一信用代码）；\r\n租赁起止时间以及用户留存备查的资料有住房租赁合同或者协议等；\r\n用户可以通过远程办税端，\r\n电子或纸质报纸来报送。\r\n申报成功后房租抵扣个税就可以在单位没有发放的工资中进行扣除\r\n或者在年度汇算清缴的自行纳税申报环节办理。\r\n"
//    val translate = GoogleTranslate()
//    translate.setFormData(LANG.ZH_CN, LANG.IN, text)
//
//    val startTime = System.currentTimeMillis()
//    val d = translate.execute().subscribe({
//
//        val endTime = time(startTime)
//
//        // println(translate.parses(it) + "  endTime=$endTime s")
//    }, Throwable::printStackTrace)
//
//}
//
//private fun time(startTime: Long): String {
//    val lastTime = System.currentTimeMillis()
//    val time = String.format("%.2f", (lastTime - startTime) / 1000.0)
//    // println("onFailure  $time s")
//    //File.separator
//    return time
//}

/*
/**
 * 测试执行
 */
private fun textExecute() {
    val d = execute2().subscribe({}, Throwable::printStackTrace)
}

val errorHosts = hashSetOf<String>()

private fun execute2(): Flowable<ResponseBody> {

    return Flowable.create<ResponseBody>({ emitter ->

        val translate = GoogleTranslate()
        translate.setFormData(LANG.ZH_CN, LANG.IN, "你好")

        var isCancel = false

        var i = 0
        while (!isCancel) {
            val host = obtainHost()
            try {
                println("host=$host                 index=${++i}")
                val response = call(host, translate.formData)
                val isSuccessful = response.isSuccessful
                errorHosts.add(host)
                val body = response.body()
                val code = response.code()
                println("body=${body?.string()}   code=$code")
                if (isSuccessful) {
                    emitter.onNext(body!!)
                    //break
                } else {
                    errorHosts.add(host)
                }

                if (i >= 3) {
                    break
                }

            } catch (e: Throwable) {
                e.printStackTrace()
                errorHosts.add(host)
                emitter.tryOnError(e)
            }
            Thread.sleep(1000)
        }
        emitter.setCancellable { println("isCancel=${emitter.isCancelled}") }

        emitter.onComplete()

    }, BackpressureStrategy.LATEST)
    //return RequestHelper.get(baseUrl = GOOGLE_URL, paths = GOOGLE_PATHS, params = formData, headerMap = headerMap)
}

/**
 * 获取域名
 */
private fun obtainHost(): String {
    val file =
        File("/home/cy/CYWork/Projects/Translator/AndroidTranslator/Translator/Translator/translator/src/main/assets/google_domain.json")
    val jsonArray = Gson().fromJson(FileReader(file), JsonArray::class.java)

    var domain = ""
    val defaultLanguageTag = Locale.getDefault().toLanguageTag()

    //根据位置信息获取
    for (jsonObj in jsonArray) {
        val jo = jsonObj.asJsonObject
        val localeDomain = jo.get("domain").asString
        val languageTag = jo.get("languageTag").asString
        if (defaultLanguageTag == languageTag && !errorHosts.contains(localeDomain)) {
            domain = jo.get("domain").asString
            break
        }
    }

    //根据位置信息获取不成功，则顺序取
    if (domain == "") {
        for (jsonObj in jsonArray) {
            val jo = jsonObj.asJsonObject
            val localeDomain = jo.get("domain").asString
            if (!errorHosts.contains(localeDomain) && localeDomain != "") {
                domain = localeDomain
                break
            }

        }
    }
    //顺序取不成功，则清空错误地址，重新取
    if (domain == "") {
        errorHosts.clear()
        for (jsonObj in jsonArray) {
            val jo = jsonObj.asJsonObject
            val localeDomain = jo.get("domain").asString
            if (localeDomain != null || localeDomain != "") {
                domain = localeDomain
                break
            }
        }
    }
    return domain
}

private fun call(googleHost: String, formData: Map<String, String>): Response {

    val maxCacheSize: Long = 1024 * 1024 * 10
    val timeOut = 3000L

    val cacheFile = Translator.cacheFile
    val cache = if (cacheFile != null && cacheFile.exists()) Cache(cacheFile, maxCacheSize) else null

    /*
    // val proxy = java.net.Proxy(java.net.Proxy.Type.HTTP, InetSocketAddress("", 5678))


    var baidu = "https://www.baidu.com"
    val username = "username"
    val password = "password"

    val proxy = Proxy(Proxy.Type.HTTP, InetSocketAddress("45.76.132.213", 5678))

    val proxyAuthenticator: Authenticator = Authenticator { route, response ->
        val credential = Credentials.basic(username, password)
        response.request().newBuilder()
            .header("Proxy-Authorization", credential)
            .build()
    }
    */


    val client = OkHttpClient.Builder()
        .cache(cache)
//        .proxy(proxy)
//        .proxyAuthenticator(proxyAuthenticator)

        .callTimeout(timeOut, TimeUnit.MILLISECONDS)
        .connectTimeout(timeOut, TimeUnit.MILLISECONDS)
        .readTimeout(timeOut, TimeUnit.MILLISECONDS)
        .writeTimeout(timeOut, TimeUnit.MILLISECONDS)
        .build()

    val url = "https://$googleHost/${GoogleTranslate.GOOGLE_PATHS}"

    val urlBuilder = HttpUrl.get(url).newBuilder()
    for ((key, value) in formData) {
        urlBuilder.addQueryParameter(key, value)
    }
    val httpUrl = urlBuilder.build()
    val request = Request.Builder()
        .header("Cache-Control", "public,max-age=${3600 * 24 * 365}")
        .get()
        .url(httpUrl)
        .build()
    val call = client.newCall(request)
    return call.execute()
}

*/
/*

val NOP_TRUST_MANAGER: X509TrustManager = object : X509TrustManager {
    override fun checkClientTrusted(chain: Array<out java.security.cert.X509Certificate>?, authType: String?) {
    }

    override fun checkServerTrusted(chain: Array<out java.security.cert.X509Certificate>?, authType: String?) {
    }

    override fun getAcceptedIssuers(): Array<java.security.cert.X509Certificate> = arrayOf<X509Certificate>()


}

interface ProxyConfigProvider {
    val proxyConfig: ProxyConfig
}

val NOP_HOSTNAME_VERIFIER: HostnameVerifier = HostnameVerifier { hostname, session -> true }

class ProxySocketFactory(private val proxyConfigProvider: ProxyConfigProvider) : SocketFactory() {

    override fun createSocket(): Socket {
        val proxyConfig = proxyConfigProvider.getProxyConfig()
        return if (proxyConfig != null) {
            Socket(proxyConfig!!.getProxy())
        } else {
            Socket()
        }
    }

    override fun createSocket(host: String, port: Int): Socket {
        val socket = createSocket()
        try {
            socket.connect(InetSocketAddress(host, port))
        } catch (e: IOException) {
            socket.close()
            throw e
        }

        return socket
    }

    override fun createSocket(address: InetAddress, port: Int): Socket {
        val socket = createSocket()
        try {
            socket.connect(InetSocketAddress(address, port))
        } catch (e: IOException) {
            socket.close()
            throw e
        }

        return socket
    }

    override fun createSocket(
        host: String, port: Int,
        clientAddress: InetAddress, clientPort: Int
    ): Socket {
        val socket = createSocket()
        try {
            socket.bind(InetSocketAddress(clientAddress, clientPort))
            socket.connect(InetSocketAddress(host, port))
        } catch (e: IOException) {
            socket.close()
            throw e
        }

        return socket
    }

    override fun createSocket(
        address: InetAddress, port: Int,
        clientAddress: InetAddress, clientPort: Int
    ): Socket {
        val socket = createSocket()
        try {
            socket.bind(InetSocketAddress(clientAddress, clientPort))
            socket.connect(InetSocketAddress(address, port))
        } catch (e: IOException) {
            socket.close()
            throw e
        }

        return socket
    }
}

class ProxySSLSocketFactory(
    private val configProvider: ProxyConfigProvider,
    private val socketFactory: SSLSocketFactory
) : SSLSocketFactory() {
    override fun getDefaultCipherSuites() = socketFactory.getDefaultCipherSuites()

    override fun getSupportedCipherSuites() = socketFactory.getSupportedCipherSuites()


    override fun createSocket(): Socket {
        val proxyConfig = configProvider.getProxyConfig()
        return if (proxyConfig != null) {
            Socket(proxyConfig!!.getProxy())
        } else {
            Socket()
        }
    }

    override fun createSocket(host: String, port: Int): Socket {
        val socket = createSocket()
        try {
            return socketFactory.createSocket(socket, host, port, true)
        } catch (e: IOException) {
            socket.close()
            throw e
        }

    }

    override fun createSocket(
        s: Socket, host: String,
        port: Int, autoClose: Boolean
    ): Socket {
        //TODO 无法代理
        return socketFactory.createSocket(s, host, port, autoClose)
    }

    override fun createSocket(address: InetAddress, port: Int): Socket {
        val socket = createSocket()
        try {
            return socketFactory.createSocket(socket, address.hostAddress, port, true)
        } catch (e: IOException) {
            socket.close()
            throw e
        }

    }

    override fun createSocket(
        host: String, port: Int,
        clientAddress: InetAddress, clientPort: Int
    ): Socket {
        val socket = createSocket()
        try {
            socket.bind(InetSocketAddress(clientAddress, clientPort))
            return socketFactory.createSocket(socket, host, port, true)
        } catch (e: IOException) {
            socket.close()
            throw e
        }

    }

    override fun createSocket(
        address: InetAddress, port: Int,
        clientAddress: InetAddress, clientPort: Int
    ): Socket {
        val socket = createSocket()
        try {
            socket.bind(InetSocketAddress(clientAddress, clientPort))
            return socketFactory.createSocket(socket, address.hostAddress, port, true)
        } catch (e: IOException) {
            socket.close()
            throw e
        }

    }
}

*/
/*
[
	[
		["Hello?\n", "你好啊？\n", null, null, 1],
		["I'm very good\n", "我很好\n", null, null, 1],
		["How are you.", "你好吗。", null, null, 1],
		[null, null, null, "Nǐ hǎo a?\nWǒ hěn hǎo\nnǐ hǎo ma."]
	], null, "zh-CN", null, null, [
		["你好啊？", null, [
				["Hello?", 1000, true, false],
				["How are you?", 0, true, false],
				["How do you do?", 0, true, false]
			],
			[
				[0, 4]
			], "你好啊？", 0, 0
		],
		["\n", null, null, [
			[0, 1]
		], "\n", 0, 0],
		["我很好", null, [
				["I'm very good", 1000, true, false],
				["I'm fine", 1000, true, false],
				["I am fine", 0, true, false],
				["I'm fine.", 0, true, false]
			],
			[
				[0, 3]
			], "我很好", 0, 0
		],
		["\n", null, null, [
			[0, 1]
		], "\n", 0, 0],
		["你好吗。", null, [
				["How are you.", 1000, true, false],
				["How are you?", 0, true, false]
			],
			[
				[0, 4]
			], "你好吗。", 0, 0
		]
	], 1, null, [
		["zh-CN"], null, [1],
		["zh-CN"]
	]
]
 */