package com.talpa.tengine.free

import com.google.gson.Gson
import com.google.gson.JsonObject
import com.talpa.tengine.lang.LANG
import com.talpa.tengine.request.RequestHelper
import io.reactivex.Flowable
import okhttp3.ResponseBody
import java.util.*

/**
 * @author CY 2019-05-10
 */
class YandexTranslate(override val isSupportMultiTextTranslate: Boolean = false) : TranslateFactory() {


    /**
     * 账号key
     */
    private val keys =
        hashMapOf(
            100 to "trnsl.1.1.20190508T082006Z.9a524a73de6e7227.00e5cb8750d95a606e753b4cd838df6c29da3d9d",
            99 to "trnsl.1.1.20190508T082026Z.117acf6a7c95747e.fb35135e449f2afb40d581c4b67477da581b196e",
            98 to "trnsl.1.1.20190508T082053Z.fde41f504ff7cf1f.880821e83faf982d97e86993ef0e60a454e15d2e",
            97 to "trnsl.1.1.20190508T081649Z.cbbcaac2625f5adf.a09ecb404e9bbe3e6b8eaadac95bf69ed3dddb1e",
            96 to "trnsl.1.1.20190508T082226Z.ae8fa2b2f8c6f454.32fe46dfbb945213a700337db2a9cc8fda8f38a9",
            95 to "trnsl.1.1.20190508T082405Z.1acb7b4749797271.803d70b66f4407b11b5873c4a1266da51a229240",
            94 to "trnsl.1.1.20190508T082528Z.3d974584ee743641.d3c617ec09891720967391edbda538eea6ad3e68",
            93 to "trnsl.1.1.20190508T082641Z.733d9964ed3a568a.39b5b40cfa858312d36f81697dfdd4c8e7c3412d",
            92 to "trnsl.1.1.20190508T082746Z.9580d5e5d1688e05.db9cc209efd5d554ce4cfadae12328d7ef178e32",
            91 to "trnsl.1.1.20190508T082856Z.f17b87f8a3f7ba8f.eceb3968ead79aefdad4186039f0c45d8599138c",
            90 to "trnsl.1.1.20190508T083000Z.06891bd53303adc4.8224167c8c88bcffdbe794f223c5b5cc8cb12299",
            89 to "trnsl.1.1.20190509T081850Z.dab4e173756d5aff.0119d0a2317f137afbc0f31a0d47280c7ee33116",
            88 to "trnsl.1.1.20190509T081731Z.b63890464b4a129f.6ff8440b18a501be3201cb80a2e23313b98fb69e",
            87 to "trnsl.1.1.20190509T074923Z.ae803285085091e6.6a0becc008c14bb1f2693cd5ffad568174ab6a28",
            86 to "trnsl.1.1.20190509T074357Z.747ddbaaccb7c6d5.ead2055aa61599505a42b68d00ec73346ef447b4",
            85 to "trnsl.1.1.20190509T074246Z.8c176d786d9ba789.a731c75f05360d5b6a678d6db75b693e4757b2c1",
            84 to "trnsl.1.1.20190509T073852Z.60ba02d51f154fa7.bd5ed1c89420536accc6ad6da5ee234c89393f46",
            83 to "trnsl.1.1.20190509T073721Z.fac6d96b5836711d.9f4cbf9832c6da82fe64796eaa20b6c16ed7643a",
            82 to "trnsl.1.1.20190509T073213Z.d9474063da5dc10e.1b3e59b2b5929c11a85608b38065f3f0406b3c4f",
            81 to "trnsl.1.1.20190509T072810Z.25ea4e2a88ee4564.721f9fd340a9e3ea9ca3acba0b569b3fbbcadb3f",
            80 to "trnsl.1.1.20190509T072524Z.d027a57a633c463a.73ed1f5f3a617f30c02439753daad139ae377b51",
            79 to "trnsl.1.1.20190508T095806Z.5fb35b71d04a6efa.7b0ced1837e771517a07e6c81a5c8398b7561a94",
            78 to "trnsl.1.1.20190508T095712Z.0156a605e8e41469.4e48a8b7a98f2c9f2ae7ea12692feec1a6ef3dca",
            77 to "trnsl.1.1.20190508T095456Z.b05c3fce5cd437b4.41db6eeedd83bb7c76cf42654606e77cc6727ca3",
            76 to "trnsl.1.1.20190508T095353Z.2edfb798672e6fec.49d7119980eb1a38d60334ab5dd0c341bb162820",
            75 to "trnsl.1.1.20190508T095302Z.14376a72373aa921.acb3006dda881e5449de74f93f6f053bf2119d22",
            74 to "trnsl.1.1.20190508T095159Z.9888b8fcc7f6f446.fbd81a4adb81009f00039a52dd3eddeec6c1f23d",
            73 to "trnsl.1.1.20190508T094857Z.ec75a2118774bfa9.0e09b7d2bfee96ea728416574cf142e7d383e2bf",
            72 to "trnsl.1.1.20190508T094709Z.4a91f32b457beca5.427b719a233789dd4b3c6d3d3969cd1d8ea87143",
            71 to "trnsl.1.1.20190508T094451Z.e0cb4673fc27c77f.5c32f55ffeb2905490dd2b27c17e1b619b00b998",
            70 to "trnsl.1.1.20190508T082625Z.a25262190bd1fa7e.703c69322f507676075b8da0fe241ff35a8065e7",
            69 to "trnsl.1.1.20190508T082924Z.992c3956ee1af7d3.f4585da9db614f01a1005ffbe465948207a53af1",
            68 to "trnsl.1.1.20190508T083100Z.cf33f8ce59ce57aa.8f6e23394c7be0274543c8d31e83469d2660d583",
            67 to "trnsl.1.1.20190508T083842Z.c3b6cbef9927d921.b5cb81e4e6101f1f3dd32856ff1c193b1e50dc09",
            66 to "trnsl.1.1.20190508T084215Z.63476b0ec5be8d9d.a1bb1736ddb888baada2c2035327d11e98bb307b",
            65 to "trnsl.1.1.20190508T084425Z.382889970fb61804.0fb214796a6fcccc2bd961fd5601504bc21860e7",
            64 to "trnsl.1.1.20190509T074527Z.c08bcf7592250350.f185e2aff306c4f3cfebf2b627c56cd699615bef",
            63 to "trnsl.1.1.20190509T074256Z.59353804d907691d.e8e3761fe7a7fbeb9fa59540240997701e3cf383",
            62 to "trnsl.1.1.20190509T074117Z.be40f44079a76b41.f94357adc91bb40687e9b64e4ac2e3a318d3b667",
            61 to "trnsl.1.1.20190509T073918Z.cb25e1d101b84125.3ecdeb0ddf56c72fb69322630918100fddb55ecf",
            60 to "trnsl.1.1.20190508T090809Z.c6bad67a07931b5b.faf6bcc9a0288f81b2cbd124f9780685ad1a3aff",
            59 to "trnsl.1.1.20190508T091215Z.d1c2f0d94381debd.03fc971e8a76442eebaff017c65ebd4541cced1a",
            58 to "trnsl.1.1.20190508T091344Z.85486e25f20d3220.69096a87d66ff75c2f64788e1bd839677bcbf0a2",
            57 to "trnsl.1.1.20190508T091456Z.1dd8aefda40ea635.df4d2e23c70de09058ee26a963dfbbc57117c509",
            56 to "trnsl.1.1.20190508T091643Z.0b929fd6c28b58b5.467921efbb764156cdfbaef8ddf9945976d59a26",
            55 to "trnsl.1.1.20190508T091829Z.d0f221fa4a14a8b8.c30ac290c773e94c1b2f647792312e645f55b65d",
            54 to "trnsl.1.1.20190509T073532Z.2f59eb9d3edbe241.57d05a1920804496e5f2e2f70d4e85044292fe75",
            53 to "trnsl.1.1.20190509T073032Z.31b5b63989152331.c9db24539cc4ce36d325ebae7fe1e9bc48603646",
            52 to "trnsl.1.1.20190509T072759Z.ab8f6ffe89aab4c8.916a817edd686317e81ed83e0d7ab0149bd7375a",
            51 to "trnsl.1.1.20190509T072239Z.7ee15842826b530a.153b152865531054afb6f51806bd52f5161dc25e",
            50 to "trnsl.1.1.20190509T071803Z.fd7fd8076c180fd0.2a3b5b796eadafd242dc3757faddb59e3ec9a4b6",
            49 to "trnsl.1.1.20190509T071546Z.9954a8bbaf36a51f.4c665fdf1ac89d8441956001b7d1d637b821ee51",
            48 to "trnsl.1.1.20190509T074825Z.32e25c355501a8b1.4d6079362bf461d6ee99f9150fb126a5bba0806b",
            47 to "trnsl.1.1.20190509T070356Z.d41c421984c24f1e.37d4749bfc4017654fd9841feb760e67e86b000d",
            46 to "trnsl.1.1.20190509T070138Z.ddc598649f93de1f.9d0258c1149a37dba66b2195549c5b987b79999b",
            45 to "trnsl.1.1.20190508T084805Z.15522191549e5fae.e3bd3f771e3e9d47ef02fbc77801969f3672ee8f",
            44 to "trnsl.1.1.20190508T084707Z.0d7c93e5defd4a81.37cb6f3856a094073b9b01b3863e2120b559e502",
            43 to "trnsl.1.1.20190508T084608Z.8ccd0898b92256a6.3d64da24c4a5a2e60e9015709d65d6f3b15f602a",
            42 to "trnsl.1.1.20190508T084325Z.7cf5a4cc2077578c.c6d0dce29a1a18f8ec8da5e21a9a132eab0976b6",
            41 to "trnsl.1.1.20190508T084050Z.0fc6d81add2aa6f6.87f117d96a79cb2e9ea6b9c8039dd4d178739da9",
            40 to "trnsl.1.1.20190508T083709Z.ce580ee6ae8dfa39.7ca9d58a182aa0bd37e5381d2ef7816b147b2429",
            39 to "trnsl.1.1.20190508T084957Z.6a17f51c222e68cb.5a04328408b8f023cb52e2fa2eb1a919a18972cc",
            38 to "trnsl.1.1.20190508T084646Z.6879fe39ba80d937.6922aece4b925e989fb6af01e06f994ade1d703e",
            37 to "trnsl.1.1.20190508T084512Z.2a01389bc924c330.2e18525dc711289a08f17c74500dc0337ded686c",
            36 to "trnsl.1.1.20190508T084257Z.e5a4bbc03fc260dd.864c8a7854c55303687e64fb3a1577d55ee8cb80",
            35 to "trnsl.1.1.20190508T083904Z.7179887c29928b54.9489854bb913aa31ed73cb29d03cfa6eec400e62",
            34 to "trnsl.1.1.20190509T042111Z.b998573d24bb9fe6.aaeee574aa8bbf4fbe862734352e5c5f4a1ba3d3",
            33 to "trnsl.1.1.20190509T041838Z.7e4ac2c9c2df2301.985154d14b95ad42151159982e2fe7f81bb1625f",
            32 to "trnsl.1.1.20190509T041656Z.d392c9f2e9e87682.1bb36f411379edbf27e62ac1a8996d6224174a22",
            31 to "trnsl.1.1.20190509T041440Z.cb53518bc7b99f9e.68d97d9622399c4fa5105f539ab89f28bd8970ce",
            30 to "trnsl.1.1.20190509T041151Z.e3e95c955e70449a.8496ebd6a10217f06839394cdf1d92fe809ca443",
            29 to "trnsl.1.1.20190509T041031Z.2035140a62d855d3.270f169def5a92c7cbc40400ce4a0d6462782b7b",
            28 to "trnsl.1.1.20190509T040919Z.16b0aa92148c5d8e.8e37237a51a6e67ceff8afda4e8d97ea2137a18d",
            27 to "trnsl.1.1.20190509T040734Z.a47b7b224a70bd53.aef613ed0efa5084cce4f3fac3fd8e61b96bf90e",
            26 to "trnsl.1.1.20190509T040453Z.cdc44e86a629cb2f.527c5d74ce158d72db460185bd5e24844bd67b1b",
            25 to "trnsl.1.1.20190509T040008Z.0233e78801bd2e4c.b574b21ee30e94a9292ffe4533954e01eb523775",
            24 to "trnsl.1.1.20190509T035558Z.82364ddc81af015d.96388929eeb444887817784355a8616e15cc7319",
            23 to "trnsl.1.1.20190509T035429Z.564353e4c1d1e307.f57e04dfe070198c5082b123610a4b84fbc7e814",
            22 to "trnsl.1.1.20190509T035252Z.ddbacf0146f85e17.aee05ed23fca890095c00ac2c8ee9dc0492a919c",
            21 to "trnsl.1.1.20190509T035110Z.dcd7c7a9f9a5eab6.cab25211078dceac9bbb83737f2aa99d2da033e3",
            20 to "trnsl.1.1.20190508T092436Z.993ae293ac0265c2.92e9d853edf8e08a2799fcb2e3196f4c9cca4a33",
            19 to "trnsl.1.1.20190508T092145Z.22dd19840eb74884.fdee7cd4521343a1322cf4443198deb4215098db",
            18 to "trnsl.1.1.20190508T092000Z.eb7e14a007eba1bd.86908b136a88e6e3731efbe444fdf4f3373dadff",
            17 to "trnsl.1.1.20190508T091724Z.c97736ca5d3f27a2.9179cf3c92d7dec030f690b6811d5c2819df0ff8",
            16 to "trnsl.1.1.20190508T091616Z.9fd76047157a343c.4392d00e9882fd264c2c8c0395119019696aadab",
            15 to "trnsl.1.1.20190508T091451Z.1589e09f9f651c4a.6e523113a9e6d3aeb4588ef1a28e3772c6ff8544",
            14 to "trnsl.1.1.20190508T091214Z.0bd60509ad766811.4d79ddd45cddb05a8d1f89d34d40ad6f4822e8bb",
            13 to "trnsl.1.1.20190508T080700Z.909e00598b07dc50.86b99e0d8278043e9b6841527991b0e9f6fa2317",
            12 to "trnsl.1.1.20190508T071607Z.b15a7fe0005f7e7a.3c63859ef79d9a7fd73483d9c43857aaf9ed1bba",
            11 to "trnsl.1.1.20190508T071918Z.7a8455b72510fed0.3780682cd05c3c4786301a1a63bade425c9d84e1",
            10 to "trnsl.1.1.20190508T071607Z.b15a7fe0005f7e7a.3c63859ef79d9a7fd73483d9c43857aaf9ed1bba",
            9 to "trnsl.1.1.20190508T071234Z.d9f26edff31500bd.f1d9c94fa0512cc9c1317225ae19a708fe8a95d6",
            8 to "trnsl.1.1.20190508T070827Z.0b2944fb02e1df5c.8b1cb5bcf0640d5761248b1329ee3d6f244425df",
            7 to "trnsl.1.1.20190508T070621Z.b5e0e046fbb3a7a1.2b8a90473b617ddb1596a7c3969116930090501f",
            6 to "trnsl.1.1.20190508T070500Z.a89a062f9f839ec9.10f58586f87148578ca60de110e7353ba3987b2b",
            5 to "trnsl.1.1.20190508T070244Z.2edef7e4827fa172.ac0fa70ea278bf7f60b0cb405fa4b4eae39255f2",
            4 to "trnsl.1.1.20190508T070032Z.a1ed65dad79d87d0.874780f3a16ba983865f1174c815afd2c16fdb13",
            3 to "trnsl.1.1.20190508T065043Z.1e16ae84b0b047a8.8a31e5a72a413d3d34010f0861e245bac7f524db",
            2 to "trnsl.1.1.20190508T065004Z.ec8b5db75e715691.263cbcacfc9c5610b4d93169bf6b9158dcfd7b79",
            1 to "trnsl.1.1.20190508T032315Z.c64610846a45e071.13575a91668a33aa471b2b44af86a5ee8f5bf7b2"
        )

    override fun setFormData(from:String, to:String, text: String): TranslateFactory {

        val random = Random()

        val index = random.nextInt(100) + 1

        val key = keys[index]!!
        //"trnsl.1.1.20190506T065023Z.24ab4d651cee7c2c.684823db9f8d36555b71d9c4163cd28ca78af376"

        val lang = if (from == LANG.AUTO) {
            langMap[to]!!
        } else {
            "${langMap[from]!!}-${langMap[to]!!}"
        }
        formData["lang"] = lang
        formData["key"] = key
        formData["format"] = "plain"
        formData["options"] = "4"
        formData["text"] = text
        formData["reason"] = "auto"
        //reason: auto
        return this
    }

    override fun parses(response: retrofit2.Response<ResponseBody>): List<String> {
        if (response.isSuccessful) {
            val responseBody = response.body()!!
            val content = responseBody.string()
            //{"align":["0:3-0:11,0:3-0:11"],"code":200,"lang":"zh-en","text":["Who are you"]}
            val gson = Gson()
            val jsonObject = gson.fromJson<JsonObject>(content, JsonObject::class.java)
            val text = jsonObject.get("text").asJsonArray[0].asString + "\n"
            if (jsonObject.has("lang")) {
                val lang = jsonObject["lang"].asString.split("-")[0]
                //  detectLang = yandexCodeToLang(lang)
            }

            return listOf(text)
        }

        throw Exception("Yandex Code=${response.code()}")
    }

    override fun setLangSupport(langMap: HashMap<String, String>) {
        langMap[LANG.AUTO] = "auto"
        langMap[LANG.AZ] = "az"
        langMap[LANG.ML] = "ml"
        langMap[LANG.SQ] = "sq"
        langMap[LANG.MT] = "mt"
        langMap[LANG.AM] = "am"
        langMap[LANG.MK] = "mk"
        langMap[LANG.EN] = "en"
        langMap[LANG.MI] = "mi"
        langMap[LANG.AR] = "ar"
        langMap[LANG.MR] = "mr"
        langMap[LANG.HY] = "hy"
        //langMap[LANG.MHR] = "mhr"
        langMap[LANG.AF] = "af"
        langMap[LANG.MN] = "mn"
        langMap[LANG.EU] = "eu"
        langMap[LANG.DE] = "de"
        //langMap[LANG.BA] = "ba"
        langMap[LANG.NE] = "ne"
        langMap[LANG.BE] = "be"
        langMap[LANG.NO] = "no"
        langMap[LANG.BN] = "bn"
        langMap[LANG.PA] = "pa"
        langMap[LANG.MY] = "my"
        //langMap[LANG.PAP] = "pap"
        langMap[LANG.BG] = "bg"
        langMap[LANG.FA] = "fa"
        langMap[LANG.BS] = "bs"
        langMap[LANG.PL] = "pl"
        langMap[LANG.CY] = "cy"
        langMap[LANG.PT] = "pt"
        langMap[LANG.HU] = "hu"
        langMap[LANG.RO] = "ro"
        langMap[LANG.VI] = "vi"
        langMap[LANG.RU] = "ru"
        langMap[LANG.HT] = "ht"
        langMap[LANG.CEB] = "ceb"
        langMap[LANG.GL] = "gl"
        langMap[LANG.SR] = "sr"
        langMap[LANG.NL] = "nl"
        langMap[LANG.SI] = "si"
        //langMap[LANG.MRJ] = "mrj"
        langMap[LANG.SK] = "sk"
        langMap[LANG.EL] = "el"
        langMap[LANG.SL] = "sl"
        langMap[LANG.KA] = "ka"
        langMap[LANG.SW] = "sw"
        langMap[LANG.GU] = "gu"
        langMap[LANG.SU] = "su"
        langMap[LANG.DA] = "da"
        langMap[LANG.TG] = "tg"
        langMap[LANG.HE] = "he"
        langMap[LANG.TH] = "th"
        langMap[LANG.YI] = "yi"
        langMap[LANG.TL] = "tl"
        langMap[LANG.ID] = "id"
        langMap[LANG.TA] = "ta"
        langMap[LANG.GA] = "ga"
        //langMap[LANG.TT] = "tt"//鞑靼
        langMap[LANG.IT] = "it"
        langMap[LANG.TE] = "te"
        langMap[LANG.IS] = "is"
        langMap[LANG.TR] = "tr"
        langMap[LANG.ES] = "es"
        //langMap[LANG.UDM] = "udm"
        langMap[LANG.KK] = "kk"
        langMap[LANG.UZ] = "uz"
        langMap[LANG.KN] = "kn"
        langMap[LANG.UK] = "uk"
        langMap[LANG.CA] = "ca"
        langMap[LANG.UR] = "ur"
        langMap[LANG.KY] = "ky"
        langMap[LANG.FI] = "fi"
        langMap[LANG.ZH_CN] = "zh"
        langMap[LANG.FR] = "fr"
        langMap[LANG.KO] = "ko"
        langMap[LANG.HI] = "hi"
        langMap[LANG.XH] = "xh"
        langMap[LANG.HR] = "hr"
        langMap[LANG.KM] = "km"
        langMap[LANG.CS] = "cs"
        langMap[LANG.LO] = "lo"
        langMap[LANG.SV] = "sv"
        langMap[LANG.LA] = "la"
        langMap[LANG.GD] = "gd"
        langMap[LANG.LV] = "lv"
        langMap[LANG.ET] = "et"
        langMap[LANG.LT] = "lt"
        langMap[LANG.EO] = "eo"
        langMap[LANG.LB] = "lb"
        langMap[LANG.JV] = "jv"
        langMap[LANG.MG] = "mg"
        langMap[LANG.JA] = "ja"
        langMap[LANG.MS] = "ms"
    }

    override fun execute(): Flowable<retrofit2.Response<ResponseBody>> {

        val baseUrl = "https://translate.yandex.net/"
        val paths = "api/v1.5/tr.json/translate"
        val headerMap = hashMapOf<String, String>()


        return RequestHelper.get(baseUrl, paths, headerMap, formData)
    }
}

fun main() {
//
//
//    val gson = Gson()
//
//    val jsonArray = gson.fromJson<JsonArray>(lang, JsonArray::class.java)
//
//    val newJsonArray = JsonArray()
//
//    val sb = StringBuilder()
//
//    for (jo in jsonArray) {
//        val j = jo.asJsonObject
//        val l = j.get("Language").asString
//        val c = j.get("Code").asString
//
//
//        val jsonObject = JsonObject()
//        jsonObject.addProperty("Language", l)
//        jsonObject.addProperty("Code", c)
//        newJsonArray.add(jsonObject)
//        sb.append("langMap[LANG.${c.toUpperCase()}] = \"$c\"").append("\n")
//        if (j.has("Language2")) {
//            val l2 = j.get("Language2").asString
//            val c2 = j.get("Code2").asString
//            val jsonObject2 = JsonObject()
//            jsonObject2.addProperty("Language", l2)
//            jsonObject2.addProperty("Code", c2)
//            newJsonArray.add(jsonObject2)
//            sb.append("langMap[LANG.${c2.toUpperCase()}] = \"$c2\"").append("\n")
//        }
//
//        // langMap[LANG.EN] = "en"
//
//    }

    //[{"Language":"Azerbaijan","Code":"az"},{"Language":"Malayalam","Code":"ml"},{"Language":"Albanian","Code":"sq"},{"Language":"Maltese","Code":"mt"},{"Language":"Amharic","Code":"am"},{"Language":"Macedonian","Code":"mk"},{"Language":"English","Code":"en"},{"Language":"Maori","Code":"mi"},{"Language":"Arabic","Code":"ar"},{"Language":"Marathi","Code":"mr"},{"Language":"Armenian","Code":"hy"},{"Language":"Mari","Code":"mhr"},{"Language":"Afrikaans","Code":"af"},{"Language":"Mongolian","Code":"mn"},{"Language":"Basque","Code":"eu"},{"Language":"German","Code":"de"},{"Language":"Bashkir","Code":"ba"},{"Language":"Nepali","Code":"ne"},{"Language":"Belarusian","Code":"be"},{"Language":"Norwegian","Code":"no"},{"Language":"Bengali","Code":"bn"},{"Language":"Punjabi","Code":"pa"},{"Language":"Burmese","Code":"my"},{"Language":"Papiamento","Code":"pap"},{"Language":"Bulgarian","Code":"bg"},{"Language":"Persian","Code":"fa"},{"Language":"Bosnian","Code":"bs"},{"Language":"Polish","Code":"pl"},{"Language":"Welsh","Code":"cy"},{"Language":"Portuguese","Code":"pt"},{"Language":"Hungarian","Code":"hu"},{"Language":"Romanian","Code":"ro"},{"Language":"Vietnamese","Code":"vi"},{"Language":"Russian","Code":"ru"},{"Language":"Haitian (Creole)","Code":"ht"},{"Language":"Cebuano","Code":"ceb"},{"Language":"Galician","Code":"gl"},{"Language":"Serbian","Code":"sr"},{"Language":"Dutch","Code":"nl"},{"Language":"Sinhala","Code":"si"},{"Language":"Hill Mari","Code":"mrj"},{"Language":"Slovakian","Code":"sk"},{"Language":"Greek","Code":"el"},{"Language":"Slovenian","Code":"sl"},{"Language":"Georgian","Code":"ka"},{"Language":"Swahili","Code":"sw"},{"Language":"Gujarati","Code":"gu"},{"Language":"Sundanese","Code":"su"},{"Language":"Danish","Code":"da"},{"Language":"Tajik","Code":"tg"},{"Language":"Hebrew","Code":"he"},{"Language":"Thai","Code":"th"},{"Language":"Yiddish","Code":"yi"},{"Language":"Tagalog","Code":"tl"},{"Language":"Indonesian","Code":"id"},{"Language":"Tamil","Code":"ta"},{"Language":"Irish","Code":"ga"},{"Language":"Tatar","Code":"tt"},{"Language":"Italian","Code":"it"},{"Language":"Telugu","Code":"te"},{"Language":"Icelandic","Code":"is"},{"Language":"Turkish","Code":"tr"},{"Language":"Spanish","Code":"es"},{"Language":"Udmurt","Code":"udm"},{"Language":"Kazakh","Code":"kk"},{"Language":"Uzbek","Code":"uz"},{"Language":"Kannada","Code":"kn"},{"Language":"Ukrainian","Code":"uk"},{"Language":"Catalan","Code":"ca"},{"Language":"Urdu","Code":"ur"},{"Language":"Kyrgyz","Code":"ky"},{"Language":"Finnish","Code":"fi"},{"Language":"Chinese","Code":"zh"},{"Language":"French","Code":"fr"},{"Language":"Korean","Code":"ko"},{"Language":"Hindi","Code":"hi"},{"Language":"Xhosa","Code":"xh"},{"Language":"Croatian","Code":"hr"},{"Language":"Khmer","Code":"km"},{"Language":"Czech","Code":"cs"},{"Language":"Laotian","Code":"lo"},{"Language":"Swedish","Code":"sv"},{"Language":"Latin","Code":"la"},{"Language":"Scottish","Code":"gd"},{"Language":"Latvian","Code":"lv"},{"Language":"Estonian","Code":"et"},{"Language":"Lithuanian","Code":"lt"},{"Language":"Esperanto","Code":"eo"},{"Language":"Luxembourgish","Code":"lb"},{"Language":"Javanese","Code":"jv"},{"Language":"Malagasy","Code":"mg"},{"Language":"Japanese","Code":"ja"},{"Language":"Malay","Code":"ms"}]
//    println(newJsonArray.toString())
//    println()
//    println(sb.toString())

    val yandexTranslate = YandexTranslate()
    yandexTranslate.setFormData(LANG.AUTO, LANG.EN, "你是谁")
    val d = yandexTranslate.execute().subscribe({

        println(yandexTranslate.parses(it))
    }, Throwable::printStackTrace)

    //keys()
}

/*
private fun keys() {
    val gson = Gson()
    val map =
        hashMapOf(
            100 to "trnsl.1.1.20190508T082006Z.9a524a73de6e7227.00e5cb8750d95a606e753b4cd838df6c29da3d9d",
            99 to "trnsl.1.1.20190508T082026Z.117acf6a7c95747e.fb35135e449f2afb40d581c4b67477da581b196e",
            98 to "trnsl.1.1.20190508T082053Z.fde41f504ff7cf1f.880821e83faf982d97e86993ef0e60a454e15d2e",
            97 to "trnsl.1.1.20190508T081649Z.cbbcaac2625f5adf.a09ecb404e9bbe3e6b8eaadac95bf69ed3dddb1e",
            96 to "trnsl.1.1.20190508T082226Z.ae8fa2b2f8c6f454.32fe46dfbb945213a700337db2a9cc8fda8f38a9",
            95 to "trnsl.1.1.20190508T082405Z.1acb7b4749797271.803d70b66f4407b11b5873c4a1266da51a229240",
            94 to "trnsl.1.1.20190508T082528Z.3d974584ee743641.d3c617ec09891720967391edbda538eea6ad3e68",
            93 to "trnsl.1.1.20190508T082641Z.733d9964ed3a568a.39b5b40cfa858312d36f81697dfdd4c8e7c3412d",
            92 to "trnsl.1.1.20190508T082746Z.9580d5e5d1688e05.db9cc209efd5d554ce4cfadae12328d7ef178e32",
            91 to "trnsl.1.1.20190508T082856Z.f17b87f8a3f7ba8f.eceb3968ead79aefdad4186039f0c45d8599138c",
            90 to "trnsl.1.1.20190508T083000Z.06891bd53303adc4.8224167c8c88bcffdbe794f223c5b5cc8cb12299",
            89 to "trnsl.1.1.20190509T081850Z.dab4e173756d5aff.0119d0a2317f137afbc0f31a0d47280c7ee33116",
            88 to "trnsl.1.1.20190509T081731Z.b63890464b4a129f.6ff8440b18a501be3201cb80a2e23313b98fb69e",
            87 to "trnsl.1.1.20190509T074923Z.ae803285085091e6.6a0becc008c14bb1f2693cd5ffad568174ab6a28",
            86 to "trnsl.1.1.20190509T074357Z.747ddbaaccb7c6d5.ead2055aa61599505a42b68d00ec73346ef447b4",
            85 to "trnsl.1.1.20190509T074246Z.8c176d786d9ba789.a731c75f05360d5b6a678d6db75b693e4757b2c1",
            84 to "trnsl.1.1.20190509T073852Z.60ba02d51f154fa7.bd5ed1c89420536accc6ad6da5ee234c89393f46",
            83 to "trnsl.1.1.20190509T073721Z.fac6d96b5836711d.9f4cbf9832c6da82fe64796eaa20b6c16ed7643a",
            82 to "trnsl.1.1.20190509T073213Z.d9474063da5dc10e.1b3e59b2b5929c11a85608b38065f3f0406b3c4f",
            81 to "trnsl.1.1.20190509T072810Z.25ea4e2a88ee4564.721f9fd340a9e3ea9ca3acba0b569b3fbbcadb3f",
            80 to "trnsl.1.1.20190509T072524Z.d027a57a633c463a.73ed1f5f3a617f30c02439753daad139ae377b51",
            79 to "trnsl.1.1.20190508T095806Z.5fb35b71d04a6efa.7b0ced1837e771517a07e6c81a5c8398b7561a94",
            78 to "trnsl.1.1.20190508T095712Z.0156a605e8e41469.4e48a8b7a98f2c9f2ae7ea12692feec1a6ef3dca",
            77 to "trnsl.1.1.20190508T095456Z.b05c3fce5cd437b4.41db6eeedd83bb7c76cf42654606e77cc6727ca3",
            76 to "trnsl.1.1.20190508T095353Z.2edfb798672e6fec.49d7119980eb1a38d60334ab5dd0c341bb162820",
            75 to "trnsl.1.1.20190508T095302Z.14376a72373aa921.acb3006dda881e5449de74f93f6f053bf2119d22",
            74 to "trnsl.1.1.20190508T095159Z.9888b8fcc7f6f446.fbd81a4adb81009f00039a52dd3eddeec6c1f23d",
            73 to "trnsl.1.1.20190508T094857Z.ec75a2118774bfa9.0e09b7d2bfee96ea728416574cf142e7d383e2bf",
            72 to "trnsl.1.1.20190508T094709Z.4a91f32b457beca5.427b719a233789dd4b3c6d3d3969cd1d8ea87143",
            71 to "trnsl.1.1.20190508T094451Z.e0cb4673fc27c77f.5c32f55ffeb2905490dd2b27c17e1b619b00b998",
            70 to "trnsl.1.1.20190508T082625Z.a25262190bd1fa7e.703c69322f507676075b8da0fe241ff35a8065e7",
            69 to "trnsl.1.1.20190508T082924Z.992c3956ee1af7d3.f4585da9db614f01a1005ffbe465948207a53af1",
            68 to "trnsl.1.1.20190508T083100Z.cf33f8ce59ce57aa.8f6e23394c7be0274543c8d31e83469d2660d583",
            67 to "trnsl.1.1.20190508T083842Z.c3b6cbef9927d921.b5cb81e4e6101f1f3dd32856ff1c193b1e50dc09",
            66 to "trnsl.1.1.20190508T084215Z.63476b0ec5be8d9d.a1bb1736ddb888baada2c2035327d11e98bb307b",
            65 to "trnsl.1.1.20190508T084425Z.382889970fb61804.0fb214796a6fcccc2bd961fd5601504bc21860e7",
            64 to "trnsl.1.1.20190509T074527Z.c08bcf7592250350.f185e2aff306c4f3cfebf2b627c56cd699615bef",
            63 to "trnsl.1.1.20190509T074256Z.59353804d907691d.e8e3761fe7a7fbeb9fa59540240997701e3cf383",
            62 to "trnsl.1.1.20190509T074117Z.be40f44079a76b41.f94357adc91bb40687e9b64e4ac2e3a318d3b667",
            61 to "trnsl.1.1.20190509T073918Z.cb25e1d101b84125.3ecdeb0ddf56c72fb69322630918100fddb55ecf",
            60 to "trnsl.1.1.20190508T090809Z.c6bad67a07931b5b.faf6bcc9a0288f81b2cbd124f9780685ad1a3aff",
            59 to "trnsl.1.1.20190508T091215Z.d1c2f0d94381debd.03fc971e8a76442eebaff017c65ebd4541cced1a",
            58 to "trnsl.1.1.20190508T091344Z.85486e25f20d3220.69096a87d66ff75c2f64788e1bd839677bcbf0a2",
            57 to "trnsl.1.1.20190508T091456Z.1dd8aefda40ea635.df4d2e23c70de09058ee26a963dfbbc57117c509",
            56 to "trnsl.1.1.20190508T091643Z.0b929fd6c28b58b5.467921efbb764156cdfbaef8ddf9945976d59a26",
            55 to "trnsl.1.1.20190508T091829Z.d0f221fa4a14a8b8.c30ac290c773e94c1b2f647792312e645f55b65d",
            54 to "trnsl.1.1.20190509T073532Z.2f59eb9d3edbe241.57d05a1920804496e5f2e2f70d4e85044292fe75",
            53 to "trnsl.1.1.20190509T073032Z.31b5b63989152331.c9db24539cc4ce36d325ebae7fe1e9bc48603646",
            52 to "trnsl.1.1.20190509T072759Z.ab8f6ffe89aab4c8.916a817edd686317e81ed83e0d7ab0149bd7375a",
            51 to "trnsl.1.1.20190509T072239Z.7ee15842826b530a.153b152865531054afb6f51806bd52f5161dc25e",
            50 to "trnsl.1.1.20190509T071803Z.fd7fd8076c180fd0.2a3b5b796eadafd242dc3757faddb59e3ec9a4b6",
            49 to "trnsl.1.1.20190509T071546Z.9954a8bbaf36a51f.4c665fdf1ac89d8441956001b7d1d637b821ee51",
            48 to "trnsl.1.1.20190509T074825Z.32e25c355501a8b1.4d6079362bf461d6ee99f9150fb126a5bba0806b",
            47 to "trnsl.1.1.20190509T070356Z.d41c421984c24f1e.37d4749bfc4017654fd9841feb760e67e86b000d",
            46 to "trnsl.1.1.20190509T070138Z.ddc598649f93de1f.9d0258c1149a37dba66b2195549c5b987b79999b",
            45 to "trnsl.1.1.20190508T084805Z.15522191549e5fae.e3bd3f771e3e9d47ef02fbc77801969f3672ee8f",
            44 to "trnsl.1.1.20190508T084707Z.0d7c93e5defd4a81.37cb6f3856a094073b9b01b3863e2120b559e502",
            43 to "trnsl.1.1.20190508T084608Z.8ccd0898b92256a6.3d64da24c4a5a2e60e9015709d65d6f3b15f602a",
            42 to "trnsl.1.1.20190508T084325Z.7cf5a4cc2077578c.c6d0dce29a1a18f8ec8da5e21a9a132eab0976b6",
            41 to "trnsl.1.1.20190508T084050Z.0fc6d81add2aa6f6.87f117d96a79cb2e9ea6b9c8039dd4d178739da9",
            40 to "trnsl.1.1.20190508T083709Z.ce580ee6ae8dfa39.7ca9d58a182aa0bd37e5381d2ef7816b147b2429",
            39 to "trnsl.1.1.20190508T084957Z.6a17f51c222e68cb.5a04328408b8f023cb52e2fa2eb1a919a18972cc",
            38 to "trnsl.1.1.20190508T084646Z.6879fe39ba80d937.6922aece4b925e989fb6af01e06f994ade1d703e",
            37 to "trnsl.1.1.20190508T084512Z.2a01389bc924c330.2e18525dc711289a08f17c74500dc0337ded686c",
            36 to "trnsl.1.1.20190508T084257Z.e5a4bbc03fc260dd.864c8a7854c55303687e64fb3a1577d55ee8cb80",
            35 to "trnsl.1.1.20190508T083904Z.7179887c29928b54.9489854bb913aa31ed73cb29d03cfa6eec400e62",
            34 to "trnsl.1.1.20190509T042111Z.b998573d24bb9fe6.aaeee574aa8bbf4fbe862734352e5c5f4a1ba3d3",
            33 to "trnsl.1.1.20190509T041838Z.7e4ac2c9c2df2301.985154d14b95ad42151159982e2fe7f81bb1625f",
            32 to "trnsl.1.1.20190509T041656Z.d392c9f2e9e87682.1bb36f411379edbf27e62ac1a8996d6224174a22",
            31 to "trnsl.1.1.20190509T041440Z.cb53518bc7b99f9e.68d97d9622399c4fa5105f539ab89f28bd8970ce",
            30 to "trnsl.1.1.20190509T041151Z.e3e95c955e70449a.8496ebd6a10217f06839394cdf1d92fe809ca443",
            29 to "trnsl.1.1.20190509T041031Z.2035140a62d855d3.270f169def5a92c7cbc40400ce4a0d6462782b7b",
            28 to "trnsl.1.1.20190509T040919Z.16b0aa92148c5d8e.8e37237a51a6e67ceff8afda4e8d97ea2137a18d",
            27 to "trnsl.1.1.20190509T040734Z.a47b7b224a70bd53.aef613ed0efa5084cce4f3fac3fd8e61b96bf90e",
            26 to "trnsl.1.1.20190509T040453Z.cdc44e86a629cb2f.527c5d74ce158d72db460185bd5e24844bd67b1b",
            25 to "trnsl.1.1.20190509T040008Z.0233e78801bd2e4c.b574b21ee30e94a9292ffe4533954e01eb523775",
            24 to "trnsl.1.1.20190509T035558Z.82364ddc81af015d.96388929eeb444887817784355a8616e15cc7319",
            23 to "trnsl.1.1.20190509T035429Z.564353e4c1d1e307.f57e04dfe070198c5082b123610a4b84fbc7e814",
            22 to "trnsl.1.1.20190509T035252Z.ddbacf0146f85e17.aee05ed23fca890095c00ac2c8ee9dc0492a919c",
            21 to "trnsl.1.1.20190509T035110Z.dcd7c7a9f9a5eab6.cab25211078dceac9bbb83737f2aa99d2da033e3",
            20 to "trnsl.1.1.20190508T092436Z.993ae293ac0265c2.92e9d853edf8e08a2799fcb2e3196f4c9cca4a33",
            19 to "trnsl.1.1.20190508T092145Z.22dd19840eb74884.fdee7cd4521343a1322cf4443198deb4215098db",
            18 to "trnsl.1.1.20190508T092000Z.eb7e14a007eba1bd.86908b136a88e6e3731efbe444fdf4f3373dadff",
            17 to "trnsl.1.1.20190508T091724Z.c97736ca5d3f27a2.9179cf3c92d7dec030f690b6811d5c2819df0ff8",
            16 to "trnsl.1.1.20190508T091616Z.9fd76047157a343c.4392d00e9882fd264c2c8c0395119019696aadab",
            15 to "trnsl.1.1.20190508T091451Z.1589e09f9f651c4a.6e523113a9e6d3aeb4588ef1a28e3772c6ff8544",
            14 to "trnsl.1.1.20190508T091214Z.0bd60509ad766811.4d79ddd45cddb05a8d1f89d34d40ad6f4822e8bb",
            13 to "trnsl.1.1.20190508T080700Z.909e00598b07dc50.86b99e0d8278043e9b6841527991b0e9f6fa2317",
            12 to "trnsl.1.1.20190508T071607Z.b15a7fe0005f7e7a.3c63859ef79d9a7fd73483d9c43857aaf9ed1bba",
            11 to "trnsl.1.1.20190508T071918Z.7a8455b72510fed0.3780682cd05c3c4786301a1a63bade425c9d84e1",
            10 to "trnsl.1.1.20190508T071607Z.b15a7fe0005f7e7a.3c63859ef79d9a7fd73483d9c43857aaf9ed1bba",
            9 to "trnsl.1.1.20190508T071234Z.d9f26edff31500bd.f1d9c94fa0512cc9c1317225ae19a708fe8a95d6",
            8 to "trnsl.1.1.20190508T070827Z.0b2944fb02e1df5c.8b1cb5bcf0640d5761248b1329ee3d6f244425df",
            7 to "trnsl.1.1.20190508T070621Z.b5e0e046fbb3a7a1.2b8a90473b617ddb1596a7c3969116930090501f",
            6 to "trnsl.1.1.20190508T070500Z.a89a062f9f839ec9.10f58586f87148578ca60de110e7353ba3987b2b",
            5 to "trnsl.1.1.20190508T070244Z.2edef7e4827fa172.ac0fa70ea278bf7f60b0cb405fa4b4eae39255f2",
            4 to "trnsl.1.1.20190508T070032Z.a1ed65dad79d87d0.874780f3a16ba983865f1174c815afd2c16fdb13",
            3 to "trnsl.1.1.20190508T065043Z.1e16ae84b0b047a8.8a31e5a72a413d3d34010f0861e245bac7f524db",
            2 to "trnsl.1.1.20190508T065004Z.ec8b5db75e715691.263cbcacfc9c5610b4d93169bf6b9158dcfd7b79",
            1 to "trnsl.1.1.20190508T032315Z.c64610846a45e071.13575a91668a33aa471b2b44af86a5ee8f5bf7b2"
        )

//    for (i in 100 downTo 1) {
//
//        print("$i to \"\",")
//    }

    val ja = JsonArray()
    for (i in 1..100) {
        val jo = JsonObject()
        jo.addProperty("account", "CYTranslate$i")

        jo.add("keys", JsonArray().apply { add(map[i]) })
        ja.add(jo)
    }


    val json = ja.toString()
    println(json)


}
        */