//package com.talpa.tengine.free
//
//import com.talpa.tengine.Trans
//import com.talpa.tengine.Exception
//import com.talpa.tengine.TranslateFactory
//import com.talpa.tengine.http.RequestHelper
//import com.talpa.tengine.lang.LANG
//import com.talpa.tengine.lang.youdaoCodeToLang
//import com.google.gson.Gson
//import com.google.gson.JsonObject
//import io.reactivex.Flowable
//import okhttp3.ResponseBody
//import okio.ByteString
//import java.nio.ByteBuffer
//
///**
// *  @author CY 2019-01-13
// */
//class YoudaoTranslate : TranslateFactory() {
//    override val isSupportMultiTextTranslate: Boolean = false
//    override fun setLangSupport(langMap: HashMap<String, String>) {
//        langMap[LANG.AUTO] = "auto"
//        langMap[LANG.ZH_CN] = "zh-CHS"
//        langMap[LANG.EN] = "en"
//        langMap[LANG.JA] = "ja"
//        langMap[LANG.KO] = "ko"
//        langMap[LANG.FR] = "fr"
//        langMap[LANG.RU] = "ru"
//        langMap[LANG.DE] = "de"
//        langMap[LANG.ES] = "es"
//        langMap[LANG.PT] = "pt"
//        langMap[LANG.VI] = "vi"
//        langMap[LANG.IN] = "id"
//        langMap[LANG.AR] = "ar"
//    }
//
//    override fun setFormData(from:String, to:String, text: String): TranslateFactory {
//
//        if (!isSupportLanguage(from) || !isSupportLanguage(to)) throw IllegalStateException("不支持的翻译语言")
//
//        val timeMillis = System.currentTimeMillis()
//        val slat = (timeMillis + (Math.random() * 10 + 1).toLong()).toString()
//
//        val signStr = "fanyideskweb" + text + slat + "ebSeFb%=XZ%T[KZ)c(sy!"
//        val sign = ByteString.of(ByteBuffer.wrap(signStr.toByteArray())).md5().hex()
//
//        formData["i"] = text
//        formData["from"] = langMap[from]!!
//        formData["to"] = langMap[to]!!
//        formData["smartresult"] = "dict"
//        formData["client"] = "fanyideskweb"
//        formData["salt"] = slat
//        formData["sign"] = sign ?: ""
//        formData["ts"] = timeMillis.toString()
//        formData["doctype"] = "json"
//        formData["version"] = "2.1"
//        formData["keyfrom"] = "fanyi.web"
//        formData["action"] = "FY_BY_CLICKBUTTION"
//        formData["typoResult"] = "false"
//        return this
//    }
//
//
//    override fun execute(): Flowable<retrofit2.Response<ResponseBody>> {
//        val headerMap = hashMapOf(
//                "Cookie" to "OUTFOX_SEARCH_USER_ID=1799185238@10.169.0.83;",
//                "Referer" to "http://fanyi.youdao.com/",
//                "User-Agent" to "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36",
//                "Cache-Control" to "public,max-age=${3600 * 24 * 365}"
//        )
//        return RequestHelper.post(baseUrl = BASE_URL, paths = PATHS, headerMap = headerMap, params = formData)
//    }
//
//    override fun parses(response: retrofit2.Response<ResponseBody>): List<String> {
//
//
//        if (response.isSuccessful) {
//            val responseBody = response.body()!!
//
//            val text = responseBody.string()
//            /*
//            {
//        "translateResult": [
//            [{
//                "tgt": "What's the weather like today?",
//                "src": "今天天气如何?"
//            }],
//            [{
//                "tgt": "Hello,",
//                "src": "你好啊,"
//            }],
//            [{
//                "tgt": "Happy today?",
//                "src": "今天开心吗"
//            }],
//            [{
//                "tgt": "What's the weather like today",
//                "src": "今天天气如何"
//            }]
//        ],
//        "errorCode": 0,
//        "type": "zh-CHS2en"
//    }
//             */
//            //println("text=$text")
//            val jsonObject = Gson().fromJson<JsonObject>(text, JsonObject::class.java)
//            if (jsonObject.getAsJsonPrimitive("errorCode").asInt != 0) {
//                throw Exception("You dao translator parser exception")
//            }
//
//            if (jsonObject.has("type")) {
//                val sourceLang = jsonObject.get("type").asString.split("2")[0]
//                detectLang = youdaoCodeToLang(sourceLang)
//            }
//
//            val jsonArray = jsonObject.getAsJsonArray("translateResult").asJsonArray
//
//            val list = arrayListOf<String>()
//            for (jObj in jsonArray) {
//                val tgt = jObj.asJsonArray[0].asJsonObject.get("tgt").asString
//                list.add(tgt)
//            }
//            if (list.isEmpty()) {
//                throw Exception("Youdao translator parser exception")
//            }
//            return list
//        }
//        throw Exception("You Dao Code=${response.code()}")
//    }
//
//
//    companion object {
//        //private const val URL = "https://fanyi.youdao.com/translate_o?smartresult=dict&smartresult=rule"
//        private const val BASE_URL = "https://fanyi.youdao.com/"
//        private const val PATHS = "translate_o?smartresult=dict&smartresult=rule"
//
//    }
//}
//
//fun main() {
//
//    val trans = Trans(
//            LANG.ZH_CN,
//            LANG.EN,
//            "今天天气如何?"
//    )
//    val text = trans.text//multiText.joinToString("\r\n")
//
//
//    val translate = YoudaoTranslate()
//
//    translate.setFormData(
//            LANG.ZH_CN,
//            LANG.EN,
//            text
//    )
//    val d = translate.execute().subscribe({
//
//        println(translate.parses(it))
//    }, Throwable::printStackTrace)
//}