package com.talpa.tengine.store

import android.util.Base64
import com.talpa.translate.kv.KeyValue

/**
 * @author CY 2020/4/27
 */


/**
 * Store
 */
fun storeTranslation(
    sourceLanguage: String?,
    targetLanguage: String,
    text: String,
    translation: String
) {

    val preferKey: String =
        generateKey(sourceLanguage, targetLanguage, text)

    KeyValue.put(preferKey, translation)
}

/**
 * Read
 */
fun readTranslation(
    sourceLanguage: String?,
    targetLanguage: String,
    text: String
): String? {

    val preferKey: String =
        generateKey(sourceLanguage, targetLanguage, text)
    return KeyValue.get(preferKey)

}

private fun generateKey(
    sourceLanguage: String?, targetLanguage: String, text: String
): String {
    val content = "$sourceLanguage-$targetLanguage-$text"
    return Base64.encodeToString(content.toByteArray(), Base64.DEFAULT)
}