package com.talpa.translate

import android.content.ComponentName
import android.content.ServiceConnection
import android.graphics.Rect
import android.os.IBinder
import androidx.annotation.Keep
import com.talpa.overlay.view.FloatingContainer
import com.talpa.overlay.view.FloatingContainer.Companion.STATE_SERVICE_PREPARED
import com.talpa.translate.base.BaseApp
import com.talpa.translate.network.HiTranslator
import com.talpa.translate.network.TransResponse
import com.talpa.translate.record.CaptureTransResult
import com.talpa.translate.record.IRecordListener
import com.talpa.translate.record.IRecordService
import kotlinx.coroutines.runBlocking

/**
 * Create by chenjunsheng on 2021/6/15
 */
object RecordTranslation: ServiceConnection {

    var mCurrentState = FloatingContainer.STATE_INITIALIZE
    var mRecordService: IRecordService? = null

    /*@Keep
    interface TextRecognizeListener {

        fun onRecognizeServiceReady()

        fun onRecognized(index: Int, result: CaptureTransResult)

        fun onRecognizedFail(rect: Rect)

        *//**
         * 识别区域确定时回调
         * @param rect 指示区域，起始坐标为相对截图坐标起始点的距离
         *//*
        fun onAreaConfirmed(rect: Rect)

        fun getTransSourceLanguage(): String
        fun getTransTargetLanguage(): String



    }*/

    fun postTranslateSingle(from: String, to: String, texts: List<String>): TransResponse {
        return runBlocking {
            HiTranslator.getInstance(BaseApp.appContext)
                .postTranslateSingle(
                    from, to, texts
                )
        }
    }

    //var mResultListener: TextRecognizeListener? = null

    private val mRemoteCallback = object : IRecordListener.Stub() {

        override fun onRecordServiceReady() {
            //mResultListener?.onRecognizeServiceReady()
        }

    }

    /*fun setTextRecognizeListener(listener: TextRecognizeListener) {
        mResultListener = listener
    }*/

    override fun onServiceConnected(name: ComponentName?, service: IBinder?) {
        mRecordService = IRecordService.Stub.asInterface(service)
            .also {
                try {
                    it.registerListener(mRemoteCallback)
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
        //mRecordServiceMessenger = Messenger(service)
        //mRecordServiceMessenger?.send(getMessage(mClientMessenger, SEND_CLIENT_MESSENGER))
        mCurrentState = STATE_SERVICE_PREPARED
    }

    override fun onServiceDisconnected(name: ComponentName?) {
        mRecordService = null
    }

}