package com.talpa.translate.record

import android.content.Context
import android.graphics.Bitmap
import android.util.Log
import com.talpa.translate.factory.TranslatorFactory
import com.talpa.translate.ocr.PhotoAnalyzer
import com.talpa.translate.ocr.result.Block
import com.talpa.translate.ocr.result.OcrResult
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.runBlocking

/**
 * Create by chenjunsheng on 2020/8/5
 */
class OcrController(private val context: Context) : IOcrController {

    private var ocrResult: OcrResult? = null

    override fun setImage(bitmap: Bitmap) {
        val textAreas = PhotoAnalyzer.findTextAreaFast(bitmap).filter {
            it.height() > 32 && it.width() > 32
        }
        val recognizer = TranslatorFactory.getFirebaseRecognizer(context)
        ocrResult = OcrResult(arrayListOf())
        textAreas.forEach { textArea ->
            try {
                val textBitmap = Bitmap.createBitmap(bitmap, textArea.left,
                    textArea.top, textArea.width(), textArea.height())

                ocrResult!!.blocks.addAll(
                    runBlocking {
                        recognizer.doOcr(PhotoAnalyzer.compressBitmap(textBitmap)).blocks.onEach {
                            it.rect.offset(textArea.left, textArea.top)
                            it.blockCorners.onEach {
                                it.offset(textArea.left, textArea.top)
                            }
                            it.lines.onEach {
                                it.linePoint.onEach {
                                    it.offset(textArea.left, textArea.top)
                                }
                            }
                        }
                    }
                )
            } catch (e: Exception) {
                Log.d("cjslog", "sr ocr error", e)
            }

        }
    }

    override fun getOcrResult(): OcrResult? {
        return ocrResult
    }

    override fun clearImage() {}

    override fun destroy() {}

}