/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.service;

import android.accessibilityservice.AccessibilityService;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Build;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.Window;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.webkit.WebView;
import android.widget.ImageButton;
import android.widget.ImageView;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.talpa.overlay.R;
import com.talpa.overlay.RxRelay;
import com.talpa.overlay.data.ActivityChangedEvent;
import com.talpa.overlay.service.AccessService;
import com.talpa.overlay.service.AccessServiceKt;
import com.talpa.overlay.state.FloatingStateMachine;
import com.talpa.overlay.tools.PermissionHelperKt;
import com.talpa.overlay.view.FloatingManager;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 F2\u00020\u0001:\u0001FB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0$H\u0002J\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0&2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010'\u001a\u00020\u0006H\u0002J\b\u0010(\u001a\u00020\u001eH\u0002J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020\u001eH\u0002J\b\u0010-\u001a\u00020\u001eH\u0002J\b\u0010.\u001a\u00020\u001eH\u0002J\u0010\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u0004H\u0002J\u001e\u00101\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001a0&H\u0002J\u0010\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u001eH\u0016J\b\u00107\u001a\u00020\u001eH\u0016J\u0010\u00108\u001a\u00020\u00062\u0006\u00109\u001a\u00020!H\u0014J\b\u0010:\u001a\u00020\u001eH\u0016J\u0012\u0010;\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010<\u001a\u00020\u001eH\u0014J\"\u0010=\u001a\u00020!2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010>\u001a\u00020!2\u0006\u0010?\u001a\u00020!H\u0016J\u0012\u0010@\u001a\u00020\u00062\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0016\u0010A\u001a\u00020\u00062\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001a0&H\u0002J\u0010\u0010B\u001a\u00020\u001e2\u0006\u0010C\u001a\u00020DH\u0002J\b\u0010E\u001a\u00020\u001eH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0012j\b\u0012\u0004\u0012\u00020\u0004`\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000e\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/talpa/overlay/service/AccessService;", "Landroid/accessibilityservice/AccessibilityService;", "()V", "currentAction", "", "isAccessibilityEvent", "", "lastPackageName", "", "localBroadcastManager", "Landroidx/localbroadcastmanager/content/LocalBroadcastManager;", "getLocalBroadcastManager", "()Landroidx/localbroadcastmanager/content/LocalBroadcastManager;", "localBroadcastManager$delegate", "Lkotlin/Lazy;", "multiDisposable", "Lio/reactivex/disposables/Disposable;", "nodeRectSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getNodeRectSet", "()Ljava/util/HashSet;", "nodeRectSet$delegate", "pointNodeBound", "Landroid/graphics/Rect;", "rootNodeInfo", "Landroid/view/accessibility/AccessibilityNodeInfo;", "unBindingDialog", "Landroid/app/AlertDialog;", "findNodeByPoint", "", "nodeInfo", "x", "", "y", "nodeInfoList", "Ljava/util/ArrayList;", "findNodes", "Ljava/util/LinkedHashSet;", "floatingVisible", "handleActionDown", "handleActionPoint", "intent", "Landroid/content/Intent;", "handleActionStartMultiNode", "handleActionStopMultiNode", "invisibleFloating", "log", "message", "nodeCate", "nodeSet", "onAccessibilityEvent", "event", "Landroid/view/accessibility/AccessibilityEvent;", "onCreate", "onDestroy", "onGesture", "gestureId", "onInterrupt", "onRebind", "onServiceConnected", "onStartCommand", "flags", "startId", "onUnbind", "shouldRefresh", "showUnbindDialog", "context", "Landroid/content/Context;", "visibleFloating", "Companion", "overlay_foreignRelease"})
public final class AccessService
extends AccessibilityService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Rect pointNodeBound = new Rect();
    @Nullable
    private String currentAction;
    @Nullable
    private Disposable multiDisposable;
    private boolean isAccessibilityEvent;
    @Nullable
    private AccessibilityNodeInfo rootNodeInfo;
    @Nullable
    private CharSequence lastPackageName;
    @NotNull
    private final Lazy nodeRectSet$delegate = LazyKt.lazy((Function0)nodeRectSet.2.INSTANCE);
    @Nullable
    private AlertDialog unBindingDialog;
    @NotNull
    private final Lazy localBroadcastManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LocalBroadcastManager>(this){
        final /* synthetic */ AccessService this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final LocalBroadcastManager invoke() {
            return LocalBroadcastManager.getInstance((Context)this.this$0.getApplicationContext());
        }
    }));
    @NotNull
    public static final String TAG = "AccessService";
    @NotNull
    private static final String ACTION_DOWN = "com.talpa.overlay.core.AccessService#ACTION_DOWN";
    @NotNull
    private static final String ACTION_POINT = "com.talpa.overlay.core.AccessService#ACTION_POINT";
    @NotNull
    private static final String ACTION_NODES_START = "com.talpa.overlay.core.AccessService#ACTION_NODES_START";
    @NotNull
    private static final String ACTION_NODES_STOP = "com.talpa.overlay.core.AccessService#ACTION_NODES_STOP";
    @NotNull
    private static final String EXTRA_POINT_X = "point_x";
    @NotNull
    private static final String EXTRA_POINT_Y = "point_y";
    @NotNull
    public static final String BROADCAST_ACTION_SERVICE_CONNECTED = "com.talpa.overlay.service#BROADCAST_ACTION_CONNECTED";
    @NotNull
    private static final String BROADCAST_ACTION_UN_BIND = "com.talpa.overlay.service#BROADCAST_ACTION_UN_BIND";
    @NotNull
    private static final String BROADCAST_ACTION_RE_BIND = "com.talpa.overlay.service#BROADCAST_ACTION_RE_BIND";
    @NotNull
    public static final String BROADCAST_ACTION_DESTROY = "com.talpa.overlay.service#BROADCAST_ACTION_DESTROY";
    @NotNull
    public static final String BROADCAST_ACTION_REQUEST = "com.talpa.overlay.service#BROADCAST_ACTION_REQUEST";
    private static final long MILLIS_DELAY = 1500L;
    private static boolean isAccessibilityServiceRun;
    @NotNull
    private static final String BROADCAST_ACTION_FLOATING_OPEN = "BROADCAST_ACTION_FLOATING_OPEN";
    @NotNull
    private static final String BROADCAST_ACTION_FLOATING_CLOSE = "BROADCAST_ACTION_FLOATING_CLOSE";

    private final HashSet<String> getNodeRectSet() {
        Lazy lazy = this.nodeRectSet$delegate;
        boolean bl = false;
        return (HashSet)lazy.getValue();
    }

    private final LocalBroadcastManager getLocalBroadcastManager() {
        Lazy lazy = this.localBroadcastManager$delegate;
        boolean bl = false;
        return (LocalBroadcastManager)lazy.getValue();
    }

    private final void log(String message2) {
        Log.d((String)TAG, (String)message2);
    }

    public void onCreate() {
        super.onCreate();
        this.log("onCreate");
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        block16: {
            this.log("onStartCommand");
            Object object = intent;
            this.currentAction = object == null ? null : object.getAction();
            Intent intent2 = intent;
            String string = object = intent2 == null ? null : intent2.getAction();
            if (object == null) break block16;
            int n = -1;
            switch (((String)object).hashCode()) {
                case 2015780739: {
                    if (((String)object).equals(ACTION_NODES_START)) {
                        n = 1;
                    }
                    break;
                }
                case -1458995039: {
                    if (((String)object).equals(ACTION_NODES_STOP)) {
                        n = 2;
                    }
                    break;
                }
                case -1322867937: {
                    if (((String)object).equals(ACTION_POINT)) {
                        n = 3;
                    }
                    break;
                }
                case -1151408877: {
                    if (((String)object).equals(ACTION_DOWN)) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 3: {
                    this.handleActionPoint(intent);
                    break;
                }
                case 1: {
                    this.handleActionStartMultiNode();
                    break;
                }
                case 2: {
                    this.handleActionStopMultiNode();
                    break;
                }
                case 4: {
                    this.handleActionDown();
                }
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    private final void handleActionPoint(Intent intent) {
        int x = intent.getIntExtra(EXTRA_POINT_X, -1);
        int y = intent.getIntExtra(EXTRA_POINT_Y, -1);
        AccessibilityNodeInfo nodeInfo = this.getRootInActiveWindow();
        if (x != -1 && y != -1 && nodeInfo != null) {
            ArrayList<AccessibilityNodeInfo> nodeInfoList = new ArrayList<AccessibilityNodeInfo>();
            this.findNodeByPoint(nodeInfo, x, y, nodeInfoList);
        }
    }

    private final void handleActionStartMultiNode() {
        this.handleActionStopMultiNode();
        Function mapper1 = arg_0 -> AccessService.handleActionStartMultiNode$lambda-0(this, arg_0);
        Predicate predicate = arg_0 -> AccessService.handleActionStartMultiNode$lambda-1(this, arg_0);
        Function mapper2 = arg_0 -> AccessService.handleActionStartMultiNode$lambda-2(this, arg_0);
        long initialDelay = 0L;
        this.multiDisposable = Single.create(arg_0 -> AccessService.handleActionStartMultiNode$lambda-3(this, arg_0)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(AccessService::handleActionStartMultiNode$lambda-4, AccessService::handleActionStartMultiNode$lambda-5);
    }

    private final void handleActionStopMultiNode() {
        Disposable disposable = this.multiDisposable;
        if (Intrinsics.areEqual((Object)(disposable == null ? null : Boolean.valueOf(disposable.isDisposed())), (Object)false) && (disposable = this.multiDisposable) != null) {
            disposable.dispose();
        }
        if ((disposable = this.rootNodeInfo) != null) {
            disposable.recycle();
        }
        this.rootNodeInfo = null;
        this.getNodeRectSet().clear();
        this.lastPackageName = null;
    }

    private final void handleActionDown() {
        Disposable dis = Flowable.create(arg_0 -> AccessService.handleActionDown$lambda-6(this, arg_0), (BackpressureStrategy)BackpressureStrategy.LATEST).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(AccessService::handleActionDown$lambda-7, Throwable::printStackTrace);
    }

    private final AccessibilityNodeInfo rootNodeInfo() {
        AccessibilityNodeInfo accessibilityNodeInfo = this.rootNodeInfo;
        return accessibilityNodeInfo == null ? this.getRootInActiveWindow() : accessibilityNodeInfo;
    }

    private final LinkedHashSet<AccessibilityNodeInfo> findNodes(AccessibilityNodeInfo rootNodeInfo) {
        LinkedHashSet<AccessibilityNodeInfo> nodes = new LinkedHashSet<AccessibilityNodeInfo>();
        this.rootNodeInfo = rootNodeInfo;
        AccessibilityNodeInfo accessibilityNodeInfo = rootNodeInfo;
        this.lastPackageName = accessibilityNodeInfo == null ? null : accessibilityNodeInfo.getPackageName();
        accessibilityNodeInfo = rootNodeInfo;
        if (accessibilityNodeInfo != null) {
            AccessibilityNodeInfo accessibilityNodeInfo2 = accessibilityNodeInfo;
            boolean bl = false;
            boolean bl2 = false;
            AccessibilityNodeInfo $this$findNodes_u24lambda_u2d8 = accessibilityNodeInfo2;
            boolean bl3 = false;
            AccessibilityNodeInfo nodeInfo = AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)$this$findNodes_u24lambda_u2d8);
            Intrinsics.checkNotNullExpressionValue((Object)nodeInfo, (String)"nodeInfo");
            this.nodeCate(nodeInfo, nodes);
        }
        return nodes;
    }

    private final void findNodeByPoint(AccessibilityNodeInfo nodeInfo, int x, int y, ArrayList<AccessibilityNodeInfo> nodeInfoList) {
        int childCount = nodeInfo.getChildCount();
        String viewIdResourceName = nodeInfo.getViewIdResourceName();
        int n = 0;
        if (n < childCount) {
            do {
                int index;
                AccessibilityNodeInfo accessibilityNodeInfo;
                if ((accessibilityNodeInfo = nodeInfo.getChild(index = n++)) == null) continue;
                AccessibilityNodeInfo child = accessibilityNodeInfo;
                this.findNodeByPoint(child, x, y, nodeInfoList);
                return;
            } while (n < childCount);
        }
        nodeInfo.getBoundsInScreen(this.pointNodeBound);
        if (this.pointNodeBound.contains(x, y)) {
            nodeInfoList.add(nodeInfo);
        }
    }

    private final void nodeCate(AccessibilityNodeInfo nodeInfo, LinkedHashSet<AccessibilityNodeInfo> nodeSet) {
        CharSequence charSequence;
        int childCount = nodeInfo.getChildCount();
        CharSequence charSequence2 = nodeInfo.getText();
        String text = charSequence2 == null ? null : ((Object)charSequence2).toString();
        CharSequence contentDescription = nodeInfo.getContentDescription();
        CharSequence className = nodeInfo.getClassName();
        CharSequence packageName = nodeInfo.getPackageName();
        boolean isVisibleToUser = nodeInfo.isVisibleToUser();
        boolean isContentInvalid = nodeInfo.isContentInvalid();
        String viewIdResourceName = nodeInfo.getViewIdResourceName();
        if (isVisibleToUser && !Intrinsics.areEqual((Object)(charSequence = className), (Object)ImageView.class.getName()) && !Intrinsics.areEqual((Object)charSequence, (Object)ImageButton.class.getName()) && !Intrinsics.areEqual((Object)charSequence, (Object)WebView.class.getName())) {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                nodeSet.add(nodeInfo);
            } else if (!TextUtils.isEmpty((CharSequence)contentDescription) && nodeInfo.getChildCount() == 0) {
                if (Build.VERSION.SDK_INT >= 24) {
                    int drawingOrder = nodeInfo.getDrawingOrder();
                    if (drawingOrder > 0) {
                        nodeSet.add(nodeInfo);
                    }
                } else {
                    nodeSet.add(nodeInfo);
                }
            }
        }
        int n = 0;
        if (n < childCount) {
            do {
                int index;
                AccessibilityNodeInfo accessibilityNodeInfo;
                if ((accessibilityNodeInfo = nodeInfo.getChild(index = n++)) == null) continue;
                AccessibilityNodeInfo child = accessibilityNodeInfo;
                this.nodeCate(child, nodeSet);
            } while (n < childCount);
        }
    }

    private final boolean shouldRefresh(LinkedHashSet<AccessibilityNodeInfo> nodeSet) {
        int size = nodeSet.size();
        float percent = 0.5f;
        float progress = 0.0f;
        boolean bl = false;
        HashSet<String> temp = new HashSet<String>();
        for (AccessibilityNodeInfo info : nodeSet) {
            Rect rectInScreen = new Rect();
            info.getBoundsInScreen(rectInScreen);
            Intrinsics.checkNotNullExpressionValue((Object)info, (String)"info");
            String key = AccessServiceKt.nodeKey(info, rectInScreen);
            if (this.getNodeRectSet().contains(key)) {
                float f = progress;
                progress = f + 1.0f;
            }
            temp.add(key);
        }
        this.getNodeRectSet().clear();
        this.getNodeRectSet().addAll((Collection<String>)temp);
        temp.clear();
        if (size == 0) {
            return true;
        }
        return progress / (float)this.getNodeRectSet().size() < percent;
    }

    protected boolean onGesture(int gestureId) {
        return super.onGesture(gestureId);
    }

    public void onInterrupt() {
    }

    public void onAccessibilityEvent(@NotNull AccessibilityEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AccessibilityEvent accessibilityEvent = event;
        CharSequence packageName = accessibilityEvent.getPackageName();
        AccessibilityEvent accessibilityEvent2 = event;
        CharSequence className = accessibilityEvent2.getClassName();
        if (!(event.getEventType() != 2048 || TextUtils.isEmpty((CharSequence)packageName) || TextUtils.isEmpty((CharSequence)className) || Intrinsics.areEqual((Object)packageName, (Object)"com.android.systemui") || Intrinsics.areEqual((Object)packageName, (Object)this.getApplication().getPackageName()))) {
            Message message2 = Message.obtain(null, (int)40, (Object)new ActivityChangedEvent(((Object)packageName).toString(), ((Object)className).toString()));
            Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"message");
            RxRelay.INSTANCE.post(message2);
        }
        this.isAccessibilityEvent = true;
        this.rootNodeInfo = null;
    }

    protected void onServiceConnected() {
        super.onServiceConnected();
        this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_SERVICE_CONNECTED));
        isAccessibilityServiceRun = true;
    }

    public boolean onUnbind(@Nullable Intent intent) {
        isAccessibilityServiceRun = false;
        this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_UN_BIND));
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        if (PermissionHelperKt.canDrawOverlays(context)) {
            context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            this.showUnbindDialog(context);
        }
        return false;
    }

    public void onRebind(@Nullable Intent intent) {
        super.onRebind(intent);
        this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_RE_BIND));
        isAccessibilityServiceRun = true;
        AlertDialog alertDialog = this.unBindingDialog;
        if (Intrinsics.areEqual((Object)(alertDialog == null ? null : Boolean.valueOf(alertDialog.isShowing())), (Object)true) && (alertDialog = this.unBindingDialog) != null) {
            alertDialog.dismiss();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        isAccessibilityServiceRun = false;
        this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_DESTROY));
    }

    private final void visibleFloating() {
        if (!this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_FLOATING_OPEN)) && PermissionHelperKt.canDrawOverlays((Context)this)) {
            FloatingStateMachine.INSTANCE.sendMessage(110);
        }
    }

    private final void invisibleFloating() {
        if (!this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_FLOATING_CLOSE))) {
            FloatingStateMachine.INSTANCE.sendMessage(170);
        }
    }

    private final boolean floatingVisible() {
        return FloatingManager.INSTANCE.isFloatingVisible((Context)this) && !(FloatingStateMachine.INSTANCE.currentState() instanceof FloatingStateMachine.FloatingState.InvisibleState);
    }

    private final void showUnbindDialog(Context context) {
        Window window;
        AlertDialog alertDialog = this.unBindingDialog;
        if (Intrinsics.areEqual((Object)(alertDialog == null ? null : Boolean.valueOf(alertDialog.isShowing())), (Object)true)) {
            return;
        }
        DialogInterface.OnClickListener onPositionClick = AccessService::showUnbindDialog$lambda-9;
        this.unBindingDialog = new AlertDialog.Builder(context).setTitle(0x1040014).setMessage(R.string.text_access_unbind_alert).setPositiveButton(17039370, onPositionClick).setCancelable(false).create();
        int type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        AlertDialog alertDialog2 = this.unBindingDialog;
        if (alertDialog2 != null && (window = alertDialog2.getWindow()) != null) {
            window.setType(type);
        }
        try {
            alertDialog2 = this.unBindingDialog;
            if (alertDialog2 != null) {
                alertDialog2.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final AccessibilityNodeInfo handleActionStartMultiNode$lambda-0(AccessService this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.rootNodeInfo();
    }

    private static final boolean handleActionStartMultiNode$lambda-1(AccessService this$0, AccessibilityNodeInfo rootNodeInfo) {
        boolean packageNameChanged;
        AccessibilityNodeInfo accessibilityNodeInfo;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        boolean bl = this$0.lastPackageName != null && !Intrinsics.areEqual((Object)((accessibilityNodeInfo = rootNodeInfo) == null ? null : accessibilityNodeInfo.getPackageName()), (Object)this$0.lastPackageName) ? true : (packageNameChanged = false);
        if (packageNameChanged) {
            FloatingStateMachine.INSTANCE.sendMessage(110);
        }
        return !packageNameChanged;
    }

    private static final LinkedHashSet handleActionStartMultiNode$lambda-2(AccessService this$0, AccessibilityNodeInfo rootNodeInfo) {
        LinkedHashSet<Object> linkedHashSet;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            linkedHashSet = this$0.findNodes(rootNodeInfo);
        }
        catch (Throwable e) {
            boolean bl = false;
            linkedHashSet = new LinkedHashSet();
        }
        return linkedHashSet;
    }

    private static final void handleActionStartMultiNode$lambda-3(AccessService this$0, SingleEmitter it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AccessibilityNodeInfo info = this$0.rootNodeInfo();
        it.onSuccess(this$0.findNodes(info));
    }

    private static final void handleActionStartMultiNode$lambda-4(LinkedHashSet nodes) {
        Message message2 = Message.obtain(null, (int)20, (Object)nodes);
        Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"obtain(null, EVENT_NODE_INFO_MULTI, nodes)");
        RxRelay.INSTANCE.postByEventBus(message2);
        FloatingStateMachine.INSTANCE.sendMessage(110);
    }

    private static final void handleActionStartMultiNode$lambda-5(Throwable it) {
        it.printStackTrace();
        FloatingStateMachine.INSTANCE.sendMessage(110);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void handleActionDown$lambda-6(AccessService this$0, FlowableEmitter emitter) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        try {
            if (!emitter.isCancelled()) {
                AccessibilityNodeInfo rootNodeInfo = this$0.rootNodeInfo();
                emitter.onNext(this$0.findNodes(rootNodeInfo));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (!emitter.isCancelled()) {
                emitter.tryOnError(t);
            }
        }
        finally {
            if (!emitter.isCancelled()) {
                emitter.onComplete();
            }
        }
    }

    private static final void handleActionDown$lambda-7(LinkedHashSet nodes) {
        Message message2 = Message.obtain(null, (int)10, (Object)nodes);
        Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"obtain(null, EVENT_NODE_INFO_DOWN, nodes)");
        RxRelay.INSTANCE.post(message2);
    }

    private static final void showUnbindDialog$lambda-9(DialogInterface dialog, int which) {
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lcom/talpa/overlay/service/AccessService$Companion;", "", "()V", "ACTION_DOWN", "", "ACTION_NODES_START", "ACTION_NODES_STOP", "ACTION_POINT", "BROADCAST_ACTION_DESTROY", "BROADCAST_ACTION_FLOATING_CLOSE", "BROADCAST_ACTION_FLOATING_OPEN", "BROADCAST_ACTION_REQUEST", "BROADCAST_ACTION_RE_BIND", "BROADCAST_ACTION_SERVICE_CONNECTED", "BROADCAST_ACTION_UN_BIND", "EXTRA_POINT_X", "EXTRA_POINT_Y", "MILLIS_DELAY", "", "TAG", "isAccessibilityServiceRun", "", "()Z", "setAccessibilityServiceRun", "(Z)V", "startServiceForDown", "", "context", "Landroid/content/Context;", "startServiceForPoint", "x", "", "y", "startServiceForStartMultiNodes", "startServiceForStopMultiNodes", "overlay_foreignRelease"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAccessibilityServiceRun() {
            return isAccessibilityServiceRun;
        }

        public final void setAccessibilityServiceRun(boolean bl) {
            isAccessibilityServiceRun = bl;
        }

        /*
         * WARNING - void declaration
         */
        public final void startServiceForPoint(@NotNull Context context, int x, int y) {
            void $this$startServiceForPoint_u24lambda_u2d0;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent(context, AccessService.class);
            boolean bl = false;
            boolean bl2 = false;
            Intent intent2 = intent;
            Context context2 = context;
            boolean bl3 = false;
            $this$startServiceForPoint_u24lambda_u2d0.setPackage(context.getPackageName());
            $this$startServiceForPoint_u24lambda_u2d0.setAction(AccessService.ACTION_POINT);
            $this$startServiceForPoint_u24lambda_u2d0.putExtra(AccessService.EXTRA_POINT_X, x);
            $this$startServiceForPoint_u24lambda_u2d0.putExtra(AccessService.EXTRA_POINT_Y, y);
            Unit unit = Unit.INSTANCE;
            context2.startService(intent);
        }

        /*
         * WARNING - void declaration
         */
        public final void startServiceForStartMultiNodes(@NotNull Context context) {
            void $this$startServiceForStartMultiNodes_u24lambda_u2d1;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent(context, AccessService.class);
            boolean bl = false;
            boolean bl2 = false;
            Intent intent2 = intent;
            Context context2 = context;
            boolean bl3 = false;
            $this$startServiceForStartMultiNodes_u24lambda_u2d1.setPackage(context.getPackageName());
            $this$startServiceForStartMultiNodes_u24lambda_u2d1.setAction(AccessService.ACTION_NODES_START);
            Unit unit = Unit.INSTANCE;
            context2.startService(intent);
        }

        /*
         * WARNING - void declaration
         */
        public final void startServiceForStopMultiNodes(@NotNull Context context) {
            void $this$startServiceForStopMultiNodes_u24lambda_u2d2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent(context, AccessService.class);
            boolean bl = false;
            boolean bl2 = false;
            Intent intent2 = intent;
            Context context2 = context;
            boolean bl3 = false;
            $this$startServiceForStopMultiNodes_u24lambda_u2d2.setPackage(context.getPackageName());
            $this$startServiceForStopMultiNodes_u24lambda_u2d2.setAction(AccessService.ACTION_NODES_STOP);
            Unit unit = Unit.INSTANCE;
            context2.startService(intent);
        }

        /*
         * WARNING - void declaration
         */
        public final void startServiceForDown(@NotNull Context context) {
            void $this$startServiceForDown_u24lambda_u2d3;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent(context, AccessService.class);
            boolean bl = false;
            boolean bl2 = false;
            Intent intent2 = intent;
            Context context2 = context;
            boolean bl3 = false;
            $this$startServiceForDown_u24lambda_u2d3.setPackage(context.getPackageName());
            $this$startServiceForDown_u24lambda_u2d3.setAction(AccessService.ACTION_DOWN);
            Unit unit = Unit.INSTANCE;
            context2.startService(intent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

