/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.tools;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.util.Log;
import android.view.accessibility.AccessibilityManager;
import com.talpa.overlay.service.AccessService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"TAG", "", "accessibilityEnabled", "", "context", "Landroid/content/Context;", "checkAccessibilityMalfunctioning", "isAccessibilitySettingsOn", "overlay_foreignRelease"})
public final class AccessibilityPermissionKt {
    @NotNull
    private static final String TAG = "Hi-Accessibility";

    public static final boolean isAccessibilitySettingsOn(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("accessibility");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.accessibility.AccessibilityManager");
        }
        AccessibilityManager accessibilityManager = (AccessibilityManager)object;
        List list = accessibilityManager.getEnabledAccessibilityServiceList(16);
        List list2 = list;
        if (list2 != null) {
            List list3 = list2;
            boolean bl = false;
            boolean bl2 = false;
            List it = list3;
            boolean bl3 = false;
            Iterable $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AccessibilityServiceInfo info = (AccessibilityServiceInfo)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)info.getResolveInfo().serviceInfo.name, (Object)AccessService.class.getName()) || !Intrinsics.areEqual((Object)info.getResolveInfo().serviceInfo.packageName, (Object)context.getPackageName())) continue;
                return info.getResolveInfo().serviceInfo.enabled;
            }
        }
        return false;
    }

    public static final boolean accessibilityEnabled(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            List list;
            List list2;
            String accessibilityEnabled;
            String string2 = accessibilityEnabled = Settings.Secure.getString((ContentResolver)context.getApplicationContext().getContentResolver(), (String)"enabled_accessibility_services");
            if (string2 == null) {
                list2 = null;
            } else {
                String[] stringArray = new String[]{":"};
                list2 = list = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            }
            if (list == null) {
                return false;
            }
            List services = list;
            Iterable $this$forEach$iv = services;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)(context.getPackageName() + '/' + AccessService.class.getName()))) continue;
                return true;
            }
            Log.v((String)TAG, (String)Intrinsics.stringPlus((String)"accessibilityEnabled = ", (Object)accessibilityEnabled));
            return false;
        }
        catch (Settings.SettingNotFoundException e) {
            Log.e((String)TAG, (String)Intrinsics.stringPlus((String)"Error finding setting, default accessibility to not found: ", (Object)e.getMessage()));
            return false;
        }
    }

    public static final boolean checkAccessibilityMalfunctioning(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return AccessibilityPermissionKt.accessibilityEnabled(context) && !AccessibilityPermissionKt.isAccessibilitySettingsOn(context);
    }
}

