/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.view.overlay;

import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.talpa.overlay.R;
import com.talpa.overlay.data.SharedPreferKt;
import com.talpa.overlay.service.AccessServiceKt;
import com.talpa.overlay.state.FloatingStateMachine;
import com.talpa.overlay.view.overlay.BaseOverlayView;
import com.talpa.overlay.view.overlay.OverlayImpl;
import com.talpa.tengine.Trans;
import com.talpa.translate.network.Result;
import com.talpa.translate.network.TransResponse;
import com.talpa.translate.repository.box.translate.CombinedTrans;
import com.talpa.translate.repository.db.StarTable;
import com.trello.rxlifecycle3.kotlin.RxlifecycleKt;
import io.reactivex.Single;
import io.reactivex.disposables.Disposable;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.anko.CustomViewPropertiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J8\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0016J \u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J4\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\b\u0010!\u001a\u00020\u0007H\u0002J\b\u0010\"\u001a\u00020\u0007H\u0016J\u0012\u0010#\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0002J8\u0010$\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020'J\u001a\u0010*\u001a\u00020\u00072\u0006\u0010)\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016\u00a8\u0006-"}, d2={"Lcom/talpa/overlay/view/overlay/SimpleOverlayView;", "Lcom/talpa/overlay/view/overlay/OverlayImpl;", "Landroid/view/View$OnClickListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "addContentView", "", "x", "", "y", "createContentView", "Landroid/view/View;", "dealNodeInfo", "sourceText", "", "sourceLanguageTag", "targetLanguageTag", "packageName", "nodeInfo", "Landroid/view/accessibility/AccessibilityNodeInfo;", "needGrammarCheck", "", "hideProgressBar", "contentView", "onClick", "v", "postTranslate", "translation", "tvTranslation", "Landroid/widget/TextView;", "combinedTrans", "Lcom/talpa/translate/repository/box/translate/CombinedTrans;", "preTranslate", "removeContentView", "showProgressBar", "translate", "updateContentView", "bounds", "Landroid/graphics/Rect;", "updateTransFailed", "location", "updateTransResult", "response", "Lcom/talpa/translate/network/TransResponse;", "overlay_foreignRelease"})
public class SimpleOverlayView
extends OverlayImpl
implements View.OnClickListener {
    public SimpleOverlayView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @Override
    @NotNull
    public View createContentView() {
        Context $receiver$iv = this.getContext();
        Object object = $receiver$iv.getSystemService("layout_inflater");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.LayoutInflater");
        }
        View view = ((LayoutInflater)object).inflate(R.layout.layout_content_view_simple, null);
        view.setOnTouchListener((arg_0, arg_1) -> SimpleOverlayView.createContentView$lambda-0(this, arg_0, arg_1));
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.talpa.overlay.view.overlay.BaseOverlayView");
        }
        ((BaseOverlayView)view).setSetOnBackClickListener(new BaseOverlayView.BackClickListener(view, this){
            final /* synthetic */ View $view;
            final /* synthetic */ SimpleOverlayView this$0;
            {
                this.$view = $view;
                this.this$0 = $receiver;
            }

            public boolean onBackClickListener() {
                try {
                    if (((BaseOverlayView)this.$view).isAttachedToWindow()) {
                        this.this$0.removeContentView();
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        });
        return view;
    }

    @Override
    public void addContentView(int x, int y) {
        super.addContentView(x, y);
        this.getContentView().setBackgroundResource(R.drawable.shape_overlay_bg);
        ViewGroup.LayoutParams layoutParams = this.getContentView().getLayoutParams();
        WindowManager.LayoutParams params = this.overlayParams(layoutParams instanceof WindowManager.LayoutParams ? (WindowManager.LayoutParams)layoutParams : null);
        params.x = x;
        params.y = y;
        this.getContentView().setVisibility(8);
        try {
            if (!this.getContentView().isAttachedToWindow()) {
                this.getWindowManager().addView(this.getContentView(), (ViewGroup.LayoutParams)params);
            } else {
                this.getWindowManager().updateViewLayout(this.getContentView(), (ViewGroup.LayoutParams)params);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void updateTransFailed(@NotNull Rect location) {
        Rect originLoc;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Object object = this.getContentView().getTag(R.id.id_content_view_node_info);
        Rect rect = originLoc = object instanceof Rect ? (Rect)object : null;
        if (Intrinsics.areEqual((Object)location, (Object)originLoc)) {
            ((TextView)this.getContentView().findViewById(R.id.tv_translation)).setText(R.string.text_translating_error);
            this.hideProgressBar(this.getContentView());
        }
    }

    public final void updateContentView(@NotNull Rect bounds) {
        ViewGroup.LayoutParams layoutParams;
        Object tempNode;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        if (!this.getContentView().isAttachedToWindow()) {
            try {
                this.getWindowManager().addView(this.getContentView(), this.getContentView().getLayoutParams());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Intrinsics.areEqual((Object)(tempNode = this.getContentView().getTag(R.id.id_content_view_node_info)), (Object)bounds) && this.getContentView().getVisibility() == 0) {
            return;
        }
        this.getContentView().setTag(R.id.id_content_view_node_info, (Object)bounds);
        ((TextView)this.getContentView().findViewById(R.id.tv_translation)).setText((CharSequence)"");
        if (this.getContentView().getVisibility() != 0) {
            this.getContentView().setVisibility(0);
        }
        if ((layoutParams = this.getContentView().getLayoutParams()) == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams contentParams = (WindowManager.LayoutParams)layoutParams;
        contentParams.width = bounds.width();
        contentParams.height = bounds.height();
        contentParams.x = bounds.left;
        contentParams.y = bounds.top;
        contentParams.gravity = 0x800033;
        try {
            this.preTranslate();
            this.getWindowManager().updateViewLayout(this.getContentView(), (ViewGroup.LayoutParams)contentParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateTransResult(@NotNull Rect location, @Nullable TransResponse response) {
        Rect originLoc;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Object object = this.getContentView().getTag(R.id.id_content_view_node_info);
        Rect rect = originLoc = object instanceof Rect ? (Rect)object : null;
        if (Intrinsics.areEqual((Object)originLoc, (Object)location)) {
            TextView tvTranslation = (TextView)this.getContentView().findViewById(R.id.tv_translation);
            if (response == null) {
                tvTranslation.setText(R.string.translate_fail);
            } else {
                List list;
                StringBuilder stringBuilder = new StringBuilder();
                Result result2 = response.getResult();
                if (result2 != null && (list = result2.getTexts()) != null) {
                    Iterable $this$forEachIndexed$iv = list;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        int n;
                        void s;
                        int n2 = index$iv++;
                        boolean bl = false;
                        if (n2 < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String string2 = (String)item$iv;
                        int index = n2;
                        boolean bl2 = false;
                        stringBuilder.append((String)s);
                        Result result3 = response.getResult();
                        List list2 = result3 == null ? null : result3.getTexts();
                        if (index >= (list2 == null ? 0 : (n = list2.size())) - 1) continue;
                        stringBuilder.append(",");
                    }
                }
                tvTranslation.setText((CharSequence)stringBuilder.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)tvTranslation, (String)"tvTranslation");
            CustomViewPropertiesKt.setTextColorResource((TextView)tvTranslation, (int)R.color.color_floating_translation);
            tvTranslation.setTag(R.id.id_translation_view_trans_result, (Object)tvTranslation.getText());
            this.hideProgressBar(this.getContentView());
        }
    }

    @Override
    public void updateContentView(@NotNull AccessibilityNodeInfo nodeInfo) {
        Object tempNode;
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        if (!this.getContentView().isAttachedToWindow()) {
            try {
                this.getWindowManager().addView(this.getContentView(), this.getContentView().getLayoutParams());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Intrinsics.areEqual((Object)(tempNode = this.getContentView().getTag(R.id.id_content_view_node_info)), (Object)nodeInfo) && this.getContentView().getVisibility() == 0) {
            return;
        }
        this.getContentView().setTag(R.id.id_content_view_node_info, (Object)nodeInfo);
        if (this.getContentView().getVisibility() != 0) {
            this.getContentView().setVisibility(0);
        }
        Rect bounds = new Rect();
        nodeInfo.getBoundsInScreen(bounds);
        ViewGroup.LayoutParams layoutParams = this.getContentView().getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams contentParams = (WindowManager.LayoutParams)layoutParams;
        contentParams.width = bounds.width();
        contentParams.height = bounds.height();
        contentParams.x = bounds.left;
        contentParams.y = bounds.top;
        contentParams.gravity = 0x800033;
        try {
            String string2 = ((Object)AccessServiceKt.nodeText(nodeInfo)).toString();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String sourceText = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            if (!TextUtils.isEmpty((CharSequence)sourceText)) {
                String string4;
                CharSequence charSequence = nodeInfo.getPackageName();
                String packageName = charSequence == null ? "" : ((string4 = ((Object)charSequence).toString()) == null ? "" : string4);
                string4 = SharedPreferKt.readOverlayEditTextLanguageTag$default(this.getContext(), null, 2, null);
                String targetLanguageTag = string4 == null ? "en" : string4;
                String string5 = SharedPreferKt.readOverlayTextLanguageTag$default(this.getContext(), null, 2, null);
                String sourceLanguageTag = string5 == null ? Locale.getDefault().getLanguage() : string5;
                Intrinsics.checkNotNullExpressionValue((Object)sourceLanguageTag, (String)"sourceLanguageTag");
                this.dealNodeInfo(sourceText, sourceLanguageTag, targetLanguageTag, packageName, nodeInfo, FloatingStateMachine.INSTANCE.getGrammarCheckEnable());
            }
            this.getWindowManager().updateViewLayout(this.getContentView(), (ViewGroup.LayoutParams)contentParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeContentView() {
        if (this.getContentView().isAttachedToWindow()) {
            try {
                this.getWindowManager().removeViewImmediate(this.getContentView());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.getGrammarDetailView().isAttachedToWindow()) {
            try {
                this.getWindowManager().removeViewImmediate((View)this.getGrammarDetailView());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.removeContentView();
    }

    public void onClick(@Nullable View v) {
    }

    /*
     * WARNING - void declaration
     */
    private final void showProgressBar(View contentView2) {
        ProgressBar progressBar2;
        View view = contentView2;
        if (view == null) {
            progressBar2 = null;
        } else {
            void $receiver$iv;
            View view2 = view;
            int id$iv = R.id.loading_progress_bar;
            View view3 = $receiver$iv.findViewById(id$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(id)");
            progressBar2 = (ProgressBar)view3;
        }
        ProgressBar progressBar3 = progressBar2;
        view = progressBar3;
        if (view != null) {
            view.setVisibility(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void hideProgressBar(View contentView2) {
        ProgressBar progressBar2;
        View view = contentView2;
        if (view == null) {
            progressBar2 = null;
        } else {
            void $receiver$iv;
            View view2 = view;
            int id$iv = R.id.loading_progress_bar;
            View view3 = $receiver$iv.findViewById(id$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(id)");
            progressBar2 = (ProgressBar)view3;
        }
        ProgressBar progressBar3 = progressBar2;
        view = progressBar3;
        if (view != null) {
            view.setVisibility(8);
        }
    }

    private final void preTranslate() {
        this.showProgressBar(this.getContentView());
    }

    private final void postTranslate(String sourceText, String translation, String targetLanguageTag, AccessibilityNodeInfo nodeInfo, CombinedTrans combinedTrans) {
        TextView tvTranslation = (TextView)this.getContentView().findViewById(R.id.tv_translation);
        tvTranslation.setText((CharSequence)translation);
        Intrinsics.checkNotNullExpressionValue((Object)tvTranslation, (String)"tvTranslation");
        CustomViewPropertiesKt.setTextColorResource((TextView)tvTranslation, (int)R.color.color_floating_translation);
        tvTranslation.setTag(R.id.id_translation_view_trans_result, (Object)tvTranslation.getText());
        this.hideProgressBar(this.getContentView());
        this.postTranslate(translation, targetLanguageTag, tvTranslation);
    }

    static /* synthetic */ void postTranslate$default(SimpleOverlayView simpleOverlayView2, String string2, String string3, String string4, AccessibilityNodeInfo accessibilityNodeInfo, CombinedTrans combinedTrans, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: postTranslate");
        }
        if ((n & 0x10) != 0) {
            combinedTrans = null;
        }
        simpleOverlayView2.postTranslate(string2, string3, string4, accessibilityNodeInfo, combinedTrans);
    }

    public void postTranslate(@NotNull String translation, @NotNull String targetLanguageTag, @NotNull TextView tvTranslation) {
        Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
        Intrinsics.checkNotNullParameter((Object)targetLanguageTag, (String)"targetLanguageTag");
        Intrinsics.checkNotNullParameter((Object)tvTranslation, (String)"tvTranslation");
    }

    private final void dealNodeInfo(String sourceText, String sourceLanguageTag, String targetLanguageTag, String packageName, AccessibilityNodeInfo nodeInfo, boolean needGrammarCheck) {
        TextView tvTranslation = (TextView)this.getContentView().findViewById(R.id.tv_translation);
        this.preTranslate();
        OverlayImpl.logStartTranslate$default(this, null, sourceText, targetLanguageTag, packageName, 1, null);
        Single<StarTable> single = this.readTranslateHistory(sourceText, sourceLanguageTag, targetLanguageTag);
        Intrinsics.checkNotNullExpressionValue((Object)tvTranslation, (String)"tvTranslation");
        Disposable disposable = RxlifecycleKt.bindToLifecycle(single, (View)((View)tvTranslation)).subscribe(arg_0 -> SimpleOverlayView.dealNodeInfo$lambda-2(this, sourceText, packageName, targetLanguageTag, nodeInfo, sourceLanguageTag, needGrammarCheck, arg_0), arg_0 -> SimpleOverlayView.dealNodeInfo$lambda-3(this, sourceText, sourceLanguageTag, targetLanguageTag, packageName, nodeInfo, needGrammarCheck, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"readTranslateHistory(sourceText, sourceLanguageTag, targetLanguageTag)\n            .bindToLifecycle(tvTranslation)\n            .subscribe({\n\n                if (!TextUtils.isEmpty(it.text) && !TextUtils.isEmpty(it.translation)) {\n\n                    logSuccessTranslate(\n                        sourceText = sourceText,\n                        sourceLanguage = it.sourceLanguageTag,\n                        targetLanguage = it.targetLanguageTag,\n                        packageName = packageName,\n                        isCached = true,\n                        source = STORE\n                    )\n                    postTranslate(sourceText, it.translation, targetLanguageTag, nodeInfo)\n                } else {\n                    translate(sourceText, sourceLanguageTag, targetLanguageTag, packageName, nodeInfo, needGrammarCheck)\n                }\n            }, {\n                translate(sourceText, sourceLanguageTag, targetLanguageTag, packageName, nodeInfo, needGrammarCheck)\n            })");
        Disposable d = disposable;
    }

    private final void translate(String sourceText, String sourceLanguageTag, String targetLanguageTag, String packageName, AccessibilityNodeInfo nodeInfo, boolean needGrammarCheck) {
        TextView tvTranslation = (TextView)this.getContentView().findViewById(R.id.tv_translation);
        Function1 onSuccess2 = (Function1)new Function1<CombinedTrans, Unit>(this, sourceText, targetLanguageTag, packageName, nodeInfo){
            final /* synthetic */ SimpleOverlayView this$0;
            final /* synthetic */ String $sourceText;
            final /* synthetic */ String $targetLanguageTag;
            final /* synthetic */ String $packageName;
            final /* synthetic */ AccessibilityNodeInfo $nodeInfo;
            {
                this.this$0 = $receiver;
                this.$sourceText = $sourceText;
                this.$targetLanguageTag = $targetLanguageTag;
                this.$packageName = $packageName;
                this.$nodeInfo = $nodeInfo;
                super(1);
            }

            public final void invoke(@NotNull CombinedTrans combinedTrans) {
                String translation;
                Object object;
                String string2;
                Trans.Result result2;
                Intrinsics.checkNotNullParameter((Object)combinedTrans, (String)"combinedTrans");
                Object object2 = combinedTrans.getTrans();
                Trans.Result result3 = result2 = object2 == null ? null : object2.getResult();
                if (result2 == null) {
                    string2 = null;
                } else {
                    object2 = result2.getTranslation();
                    if (object2 == null) {
                        string2 = null;
                    } else {
                        object = object2;
                        boolean bl = false;
                        string2 = translation = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)translation)) {
                    Trans trans = combinedTrans.getTrans();
                    object = trans == null ? null : trans.getResult();
                    Intrinsics.checkNotNull((Object)object);
                    object2 = object.getDetectLang();
                    String sourceLanguage = object2 == null ? "AUTO" : object2;
                    object = combinedTrans.getTrans();
                    Trans.Result result4 = object2 = object == null ? null : object.getResult();
                    OverlayImpl.logSuccessTranslate$default(this.this$0, null, this.$sourceText, sourceLanguage, this.$targetLanguageTag, this.$packageName, false, object2 == null ? "unknown" : ((object = object2.getSource()) == null ? "unknown" : object), 33, null);
                    Intrinsics.checkNotNull((Object)translation);
                    SimpleOverlayView.access$postTranslate(this.this$0, this.$sourceText, translation, this.$targetLanguageTag, this.$nodeInfo, combinedTrans);
                } else {
                    SimpleOverlayView.access$hideProgressBar(this.this$0, this.this$0.getContentView());
                }
            }
        };
        Function1 onError2 = (Function1)new Function1<CombinedTrans, Unit>(this, sourceText, targetLanguageTag, packageName){
            final /* synthetic */ SimpleOverlayView this$0;
            final /* synthetic */ String $sourceText;
            final /* synthetic */ String $targetLanguageTag;
            final /* synthetic */ String $packageName;
            {
                this.this$0 = $receiver;
                this.$sourceText = $sourceText;
                this.$targetLanguageTag = $targetLanguageTag;
                this.$packageName = $packageName;
                super(1);
            }

            public final void invoke(@NotNull CombinedTrans combinedTrans) {
                Trans.Result result2;
                Intrinsics.checkNotNullParameter((Object)combinedTrans, (String)"combinedTrans");
                Object object = combinedTrans.getTrans();
                Trans.Result result3 = result2 = object == null ? null : object.getResult();
                OverlayImpl.logFailTranslate$default(this.this$0, null, this.$sourceText, this.$targetLanguageTag, this.$packageName, result2 == null ? "unknown" : ((object = result2.getErrorMessage()) == null ? "unknown" : object), 1, null);
                SimpleOverlayView.access$hideProgressBar(this.this$0, this.this$0.getContentView());
            }
        };
        Intrinsics.checkNotNullExpressionValue((Object)tvTranslation, (String)"tvTranslation");
        this.translateForOverlayText(tvTranslation, sourceText, sourceLanguageTag, targetLanguageTag, (Function1<? super CombinedTrans, Unit>)onSuccess2, (Function1<? super CombinedTrans, Unit>)onError2, needGrammarCheck);
    }

    private static final boolean createContentView$lambda-0(SimpleOverlayView this$0, View v, MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = event.getAction();
        if (n == 4) {
            this$0.removeContentView();
        }
        return false;
    }

    private static final void dealNodeInfo$lambda-2(SimpleOverlayView this$0, String $sourceText, String $packageName, String $targetLanguageTag, AccessibilityNodeInfo $nodeInfo, String $sourceLanguageTag, boolean $needGrammarCheck, StarTable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sourceText, (String)"$sourceText");
        Intrinsics.checkNotNullParameter((Object)$packageName, (String)"$packageName");
        Intrinsics.checkNotNullParameter((Object)$targetLanguageTag, (String)"$targetLanguageTag");
        Intrinsics.checkNotNullParameter((Object)$nodeInfo, (String)"$nodeInfo");
        Intrinsics.checkNotNullParameter((Object)$sourceLanguageTag, (String)"$sourceLanguageTag");
        if (!TextUtils.isEmpty((CharSequence)it.getText()) && !TextUtils.isEmpty((CharSequence)it.getTranslation())) {
            OverlayImpl.logSuccessTranslate$default(this$0, null, $sourceText, it.getSourceLanguageTag(), it.getTargetLanguageTag(), $packageName, true, "store", 1, null);
            SimpleOverlayView.postTranslate$default(this$0, $sourceText, it.getTranslation(), $targetLanguageTag, $nodeInfo, null, 16, null);
        } else {
            this$0.translate($sourceText, $sourceLanguageTag, $targetLanguageTag, $packageName, $nodeInfo, $needGrammarCheck);
        }
    }

    private static final void dealNodeInfo$lambda-3(SimpleOverlayView this$0, String $sourceText, String $sourceLanguageTag, String $targetLanguageTag, String $packageName, AccessibilityNodeInfo $nodeInfo, boolean $needGrammarCheck, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sourceText, (String)"$sourceText");
        Intrinsics.checkNotNullParameter((Object)$sourceLanguageTag, (String)"$sourceLanguageTag");
        Intrinsics.checkNotNullParameter((Object)$targetLanguageTag, (String)"$targetLanguageTag");
        Intrinsics.checkNotNullParameter((Object)$packageName, (String)"$packageName");
        Intrinsics.checkNotNullParameter((Object)$nodeInfo, (String)"$nodeInfo");
        this$0.translate($sourceText, $sourceLanguageTag, $targetLanguageTag, $packageName, $nodeInfo, $needGrammarCheck);
    }

    public static final /* synthetic */ void access$postTranslate(SimpleOverlayView $this, String sourceText, String translation, String targetLanguageTag, AccessibilityNodeInfo nodeInfo, CombinedTrans combinedTrans) {
        $this.postTranslate(sourceText, translation, targetLanguageTag, nodeInfo, combinedTrans);
    }

    public static final /* synthetic */ void access$hideProgressBar(SimpleOverlayView $this, View contentView2) {
        $this.hideProgressBar(contentView2);
    }
}

