package com.talpa.overlay.view

import android.annotation.SuppressLint
import android.content.Context
import android.graphics.Rect
import android.util.AttributeSet
import android.util.Log
import android.view.*
import android.widget.FrameLayout
import android.widget.TextView
import androidx.core.view.children
import com.talpa.overlay.R

/**
 * Create by chenjunsheng on 2021/7/22
 */
@SuppressLint("ClickableViewAccessibility")
class MultiLocateView @JvmOverloads constructor(
    context: Context,
    attributes: AttributeSet? = null,
    defStyleAttr: Int = 0
) : FrameLayout(context, attributes, defStyleAttr) {

    private var nodeInfoList: MutableList<MultiOverlayActivity.NodeInfo> = arrayListOf()

    fun addOverlay(nodeInfos: List<MultiOverlayActivity.NodeInfo>) {
        nodeInfoList.clear()
        nodeInfoList.addAll(nodeInfos)
        repeat(nodeInfos.size) {
            val view = LayoutInflater.from(context)
                .inflate(R.layout.layout_content_view_simple, this, false)
            val params = FrameLayout.LayoutParams(nodeInfos[it].rectInScreen.width(), nodeInfos[it].rectInScreen.height())
            params.topMargin = nodeInfos[it].rectInScreen.top
            params.marginStart = nodeInfos[it].rectInScreen.left
            showProgress(view)
            addView(view, params)
        }
    }

    fun addOverlay(nodeInfo: MultiOverlayActivity.NodeInfo) {
        val view = LayoutInflater.from(context)
            .inflate(R.layout.layout_content_view_simple, this, false)
        val params = FrameLayout.LayoutParams(nodeInfo.rectInScreen.width(), nodeInfo.rectInScreen.height())
        params.topMargin = nodeInfo.rectInScreen.top
        params.marginStart = nodeInfo.rectInScreen.left
        view.setTag(nodeInfo)
        showProgress(view)
        addView(view, params)
    }

    fun updateOverlay( nodeInfo: MultiOverlayActivity.NodeInfo) {
        repeat(childCount) {
            val child = getChildAt(it)
            if (child.getTag() == nodeInfo) {
                hideProgress(child)
                val text = nodeInfo.transResponse
                child.findViewById<TextView>(R.id.tv_translation)
                    .setText(text)
            }
        }
    }

    interface OnTouchOutsideListener {
        fun touchOutside()
    }

    private var touchOutsideListener: OnTouchOutsideListener? = null

    fun setTouchOutSideListener(touchOutsideListener: OnTouchOutsideListener) {
        this.touchOutsideListener = touchOutsideListener
    }

    private val gestureDetector: GestureDetector

    init {
        gestureDetector =
            GestureDetector(context, object : GestureDetector.SimpleOnGestureListener() {
                override fun onDown(e: MotionEvent?): Boolean {
                    e ?: return true
                    val rect = Rect()
                    var flag = true
                    kotlin.run {
                        repeat(childCount) {
                            val child = getChildAt(it)
                            child.getGlobalVisibleRect(rect)
                            if (rect.contains(e.rawX.toInt(), e.rawY.toInt())) {
                                flag = false
                                return@run
                            }
                        }
                    }

                    if (flag) {
                        touchOutsideListener?.touchOutside()
                    }
                    return super.onSingleTapUp(e)
                }
            })
    }

    override fun onTouchEvent(event: MotionEvent?): Boolean {
        gestureDetector.onTouchEvent(event)
        return super.onTouchEvent(event)
    }

    private fun showProgress(view: View) {
        view.findViewById<View>(R.id.loading_progress_bar).visibility = View.VISIBLE
    }

    private fun hideProgress(view: View) {
        view.findViewById<View>(R.id.loading_progress_bar).visibility = View.GONE
    }

    fun updateTransResult() {
        repeat(nodeInfoList.size) {
            val child = getChildAt(it)
            hideProgress(child)
            val text = nodeInfoList[it].transResponse
            child.findViewById<TextView>(R.id.tv_translation)
                .setText(text)
        }
    }

    /*override fun measureChild(
        child: View,
        parentWidthMeasureSpec: Int,
        parentHeightMeasureSpec: Int
    ) {
        val index = children.indexOf(child)
        if (index != -1) {
            child.measure(
                View.MeasureSpec.makeMeasureSpec(
                    nodeInfoList[index].rectInScreen.width(),
                    View.MeasureSpec.AT_MOST
                ),
                View.MeasureSpec.makeMeasureSpec(
                    nodeInfoList[index].rectInScreen.height(),
                    View.MeasureSpec.AT_MOST
                )
            )
        }
        super.measureChild(child, parentWidthMeasureSpec, parentHeightMeasureSpec)
    }*/

    override fun onLayout(changed: Boolean, l: Int, t: Int, r: Int, b: Int) {
        repeat(childCount) {
            val child = getChildAt(it)
            val nodeInfo = child.getTag() as MultiOverlayActivity.NodeInfo
            child.layout(
                nodeInfo.rectInScreen.left,
                nodeInfo.rectInScreen.top,
                nodeInfo.rectInScreen.right,
                nodeInfo.rectInScreen.bottom
            )
        }
    }

}