package com.talpa.overlay.view

import android.app.Application
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.LiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.asLiveData
import com.talpa.translate.network.HiTranslator
import com.talpa.translate.network.TransResponse
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.flowOn

/**
 * Create by chenjunsheng on 2021/7/22
 */
class MultiOverlayViewModel(application: Application): AndroidViewModel(application) {

    fun multiTrans(from: String, to: String, texts: List<String>): LiveData<TransResponse?> {
        return flow {
            emit(HiTranslator.getInstance(getApplication())
                .postTranslate(from, to, texts))
        }.flowOn(Dispatchers.IO)
            .asLiveData()
    }
}