package com.talpa.overlay.view.menu

import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import android.graphics.Point
import android.view.WindowManager
import androidx.localbroadcastmanager.content.LocalBroadcastManager

/**
 * Create by chenjunsheng on 2021/6/22
 */
/**
 * 获取屏幕尺寸
 */
fun Context.getSize(): Point {
    val outSize = Point()
    val wm = getSystemService(Context.WINDOW_SERVICE) as WindowManager
    wm.defaultDisplay.getSize(outSize)
    return outSize
}

private fun Context.pendingStartActivity(action: String) {
    val intent = Intent(action)
    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
    intent.setPackage(packageName)
    val pendingIntent =
        PendingIntent.getActivity(this, 100, intent, PendingIntent.FLAG_UPDATE_CURRENT)
    //pendingIntent.send()
}

/**
 * Send Broadcast
 */
fun LocalBroadcastManager.sendAction(action: String) {
    sendBroadcast(Intent(action))
}