package com.talpa.translate.record

import android.content.Context
import android.graphics.Bitmap
import android.graphics.Rect
import android.util.Log
import com.talpa.translate.factory.TranslatorFactory
import com.talpa.translate.ocr.PhotoAnalyzer
import com.talpa.translate.ocr.result.Block
import com.talpa.translate.ocr.result.OcrResult
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.runBlocking

/**
 * Create by chenjunsheng on 2020/8/5
 */
class OcrController(private val context: Context) : IOcrController {

    private var textAreaList: List<Rect> = arrayListOf()

    override fun setImage(bitmap: Bitmap) {
        textAreaList = PhotoAnalyzer.findTextAreaFast(bitmap).filter {
            it.height() > 32 && it.width() > 32
        }
    }

    override fun getOcrResult(): List<Rect> {
        return textAreaList
    }

    override fun clearImage() {}

    override fun destroy() {}

}