/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.view.overlay;

import android.content.Context;
import android.graphics.Rect;
import android.util.Log;
import android.widget.TextView;
import android.widget.Toast;
import com.talpa.overlay.R;
import com.talpa.overlay.data.SharedPreferKt;
import com.talpa.overlay.tools.TextSpeech;
import com.talpa.overlay.view.overlay.SimpleOverlayView;
import com.talpa.translate.network.TransResponse;
import com.talpa.translate.ocr.result.OcrResult;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.anko.CustomViewPropertiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\"\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/talpa/overlay/view/overlay/SpeechOverlayView;", "Lcom/talpa/overlay/view/overlay/SimpleOverlayView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "postTranslate", "", "translation", "", "targetLanguageTag", "tvTranslation", "Landroid/widget/TextView;", "removeContentView", "updateTransResult", "location", "Landroid/graphics/Rect;", "ocrResult", "Lcom/talpa/translate/ocr/result/OcrResult;", "response", "Lcom/talpa/translate/network/TransResponse;", "overlay_googleRelease"})
public final class SpeechOverlayView
extends SimpleOverlayView {
    @Override
    public void postTranslate(@NotNull String translation, @NotNull String targetLanguageTag, @NotNull TextView tvTranslation) {
        Intrinsics.checkParameterIsNotNull((Object)translation, (String)"translation");
        Intrinsics.checkParameterIsNotNull((Object)targetLanguageTag, (String)"targetLanguageTag");
        Intrinsics.checkParameterIsNotNull((Object)tvTranslation, (String)"tvTranslation");
        super.postTranslate(translation, targetLanguageTag, tvTranslation);
        CustomViewPropertiesKt.setTextColorResource((TextView)tvTranslation, (int)R.color.color_floating_translation_speech_default);
        if (this.getTextSpeech().isSpeaking()) {
            this.getTextSpeech().stopSpeak();
        }
        Locale locale = Locale.forLanguageTag(targetLanguageTag);
        StringBuilder stringBuilder = new StringBuilder().append("speak");
        TextSpeech textSpeech2 = this.getTextSpeech();
        Locale locale2 = locale;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"locale");
        Log.d((String)"cjslog", (String)stringBuilder.append(textSpeech2.isLanguageAvailable(locale2)).append(' ').append(locale).toString());
        if (this.getTextSpeech().isLanguageAvailable(locale) && !this.getTextSpeech().speak(translation, locale)) {
            Toast.makeText((Context)this.getContext().getApplicationContext(), (int)R.string.playback_error, (int)0).show();
        }
    }

    @Override
    public void removeContentView() {
        super.removeContentView();
        if (this.getTextSpeech().isSpeaking()) {
            this.getTextSpeech().stopSpeak();
        }
    }

    @Override
    public void updateTransResult(@NotNull Rect location, @Nullable OcrResult ocrResult, @NotNull TransResponse response) {
        String targetLanguageTag;
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        super.updateTransResult(location, ocrResult, response);
        if (this.getTextSpeech().isSpeaking()) {
            this.getTextSpeech().stopSpeak();
        }
        String string2 = targetLanguageTag = SharedPreferKt.readOverlayTextLanguageTag$default(this.getContext(), null, 2, null);
        if (string2 == null) {
            return;
        }
        Locale locale = Locale.forLanguageTag(string2);
        StringBuilder sb = new StringBuilder();
        Object object = response.getResult();
        if (object != null && (object = object.getTexts()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                sb.append(it);
                sb.append(",");
            }
        }
        TextSpeech textSpeech2 = this.getTextSpeech();
        Locale locale2 = locale;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"locale");
        if (textSpeech2.isLanguageAvailable(locale2)) {
            TextSpeech textSpeech3 = this.getTextSpeech();
            String string3 = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sb.toString()");
            if (!textSpeech3.speak(string3, locale)) {
                Toast.makeText((Context)this.getContext().getApplicationContext(), (int)R.string.playback_error, (int)0).show();
            }
        }
    }

    public SpeechOverlayView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
    }
}

