package com.talpa.overlay.view

//package com.talpa.overlay
//
//import android.app.AlertDialog
//import android.content.Context
//import android.graphics.*
//import android.os.*
//import android.text.TextUtils
//import android.util.AttributeSet
//import android.util.Range
//import android.view.*
//import android.view.accessibility.AccessibilityNodeInfo
//import android.widget.TextView
//import android.widget.Toast
//import androidx.constraintlayout.widget.ConstraintLayout
//import androidx.core.content.ContextCompat
//import com.talpa.overlay.RxRelay.EVENT_NODE_INFO_DOWN
//import com.cy.trans.Result
//import com.cy.trans.Trans
//import com.cy.trans.Translator
//import com.cy.trans.lang.LANG
//import com.google.android.material.shape.CutCornerTreatment
//import com.google.android.material.shape.MaterialShapeDrawable
//import com.google.android.material.shape.ShapePathModel
//import com.google.android.material.shape.TriangleEdgeTreatment
//import kotlinx.android.synthetic.main.layout_floating.view.*
//import org.jetbrains.anko.*
//import java.io.File
//import java.util.concurrent.Executors
//
///**
// * 悬浮视图，备份包含手势悬停事件代码备份
// * @author CY 2019-6-11
// */
//class FloatingContainerBackup : ConstraintLayout {
//
//    companion object {
//        /**
//         * 悬停时间（毫秒）
//         */
//        private const val THREAD_SLEEP_MILLIS = 100L
//
//        /**
//         * 悬停坐标误差值
//         */
//        private const val POSITION_ERROR_RANGE = 5
//
//        /**
//         * 探测悬停事件
//         */
//        private const val WHAT_HOVER = 1
//    }
//
//    /**
//     * 上一次位置x,y
//     */
//    private var lastX = 0f
//    private var lastY = 0f
//
//    /**
//     * 计时位置，每间隔$THREAD_SLEEP_MILLIS 记录一次位置lastX，timerY
//     */
//    private var timerX = 0f
//    private var timerY = 0f
//    private var lastMillis = 0L
//
//    /**
//     * 范围矩阵，当前时间-上一次时间,期间位置始终在范围矩阵中，则认为停留事件
//     */
//    private val range = RectF()
//
//    /**
//     * 每次的偏移量
//     */
//    private var dx = 0f
//    private var dy = 0f
//
//
//    /**
//     * WindowManager
//     */
//    private val windowManager by lazy { context.getSystemService(Context.WINDOW_SERVICE) as WindowManager }
//
//    /**
//     * 识别视图
//     */
//    private val recognizerView by lazy { findViewById<View>(R.id.floating) }
//
//    /**
//     * 识别视图的中心位置
//     */
//    private val recognizerCenterPoint = intArrayOf(0, 0)
//
//    /**
//     * 节点信息
//     */
//    private var nodeSet: LinkedHashSet<AccessibilityNodeInfo>? = null
//
//    private val rectInScreen = Rect()
//
//    /**
//     * 矩形背景视图
//     */
//    private val rectView: View by lazy {
//        View(context.applicationContext).apply {
//            this.setBackgroundColor(resources.getColor(R.color.colorRect))
//        }
//    }
//
//    /**
//     * 内容视图
//     */
//    private val contentView: View by lazy {
//        createContentView()
//
//    }
//
//
//    /**
//     * 子线程 Handler
//     */
//    private val localHandler by lazy {
//        val handlerThread = object : HandlerThread("Floating") {
//            override fun onLooperPrepared() {
//                super.onLooperPrepared()
//                println("HandlerThread#onLooperPrepared")
//            }
//        }.apply { start() }
//        LocalHandler(handlerThread.looper)
//    }
//
//    /**
//     * 定义　Handler 类，Kotlin 默认不持有外部类引用，因此不会发生内存泄漏
//     */
//    class LocalHandler(looper: Looper) : Handler(looper) {
//
//        private var lastHoverX = -1f
//        private var lastHoverY = -1f
//
//        override fun handleMessage(msg: Message?) {
//            super.handleMessage(msg)
//
//            when (msg?.what) {
//
//                /**
//                 * 悬停事件算法
//                 */
//                WHAT_HOVER -> {
//
//                    val pair = msg.obj as Pair<Float, Float>
//
//                    val rawX = pair.first
//                    val rawY = pair.second
//
//
//                    //前后距离差值
//                    val dx = Math.abs(lastHoverX - rawX)
//                    val dy = Math.abs(lastHoverY - rawY)
//                    val offset = 5
//                    //位置变化太小忽略不计
//                    if (lastHoverX != -1f
//                        && lastHoverY != -1f
//                        && dx < offset
//                        && dy < offset
//                    ) {
//                        return
//                    }
//
//                    //触发悬停
//                    println("WHAT_HOVER-------------dx=$rawX  dy=$rawY")
//
//                    lastHoverX = rawX
//                    lastHoverY = rawY
//                }
//            }
//
//        }
//    }
//
//    init {
//
//    }
//
//    constructor(context: Context?) : super(context)
//    constructor(context: Context?, attrs: AttributeSet?) : super(context, attrs)
//    constructor(context: Context?, attrs: AttributeSet?, defStyleAttr: Int) : super(context, attrs, defStyleAttr)
//
//    override fun onAttachedToWindow() {
//        super.onAttachedToWindow()
//        println("FloatingContainer#onAttachedToWindow")
//
//        RxRelay.subscribe { message ->
//            when (message.what) {
//                EVENT_NODE_INFO_DOWN -> {
//
//                    nodeSet = message.obj as LinkedHashSet<AccessibilityNodeInfo>
//                }
//            }
//        }
//    }
//
//    override fun onDetachedFromWindow() {
//        super.onDetachedFromWindow()
//        println("FloatingContainer#onDetachedFromWindow")
//
//    }
//
//    override fun onTouchEvent(event: MotionEvent?): Boolean {
//        when (event?.action) {
//            MotionEvent.ACTION_DOWN -> {
//                lastX = event.rawX
//                lastY = event.rawY
//                lastMillis = System.currentTimeMillis()
//                down(event)
//                addRectView()
//                removeContentView()
//                addContentView(lastX.toInt(), lastY.toInt())
//
//            }
//            MotionEvent.ACTION_MOVE -> {
//
//                val rawX = event.rawX
//                val rawY = event.rawY
//
//                dx = rawX - lastX
//                dy = rawY - lastY
//
//                updateViewLayout()
//
//                lastMillis = System.currentTimeMillis()
//
//                localHandler.removeMessages(WHAT_HOVER)
//
//                val message = Message.obtain(localHandler, WHAT_HOVER, rawX to rawY)
//
//                localHandler.sendMessageDelayed(message, THREAD_SLEEP_MILLIS)
//
//                lastX = rawX
//                lastY = rawY
//
//                /**
//                 * 捕捉
//                 */
//                val (cx, cy) = recognizerLocation()
//                val nodeInfo = findNodeByPosition(cx, cy, nodeSet ?: return super.onTouchEvent(event))
//                if (nodeInfo != null) {
//                    updateRectView(nodeInfo)
//                    updateContentView(nodeInfo)
//                }
//            }
//            MotionEvent.ACTION_UP -> {
//                removeRectView()
//                //countDownRemoveContentView()
//            }
//        }
//        return super.onTouchEvent(event)
//    }
//
//    private fun updateViewLayout() {
//        val params = layoutParams as WindowManager.LayoutParams
//        params.x += dx.toInt()
//        params.y += dy.toInt()
//        windowManager.updateViewLayout(this, params)
//    }
//
//
//    /**
//     * 识别器相对于屏幕的中心位置
//     */
//    private fun recognizerLocation(): IntArray {
//
//        recognizerView.getLocationOnScreen(recognizerCenterPoint)
//
//        recognizerCenterPoint[0] = recognizerCenterPoint[0] + recognizerView.width / 2
//        recognizerCenterPoint[1] = recognizerCenterPoint[1] + recognizerView.height / 2
//
//        return recognizerCenterPoint
//    }
//
//
//    /**
//     * 处理　Down 事件
//     */
//    private fun down(event: MotionEvent?) {
//        AccessService.startServiceForDown(context)
//    }
//
//    /**
//     * 悬浮视图Params
//     */
//    private fun overlayParams(): WindowManager.LayoutParams {
//        val type = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O)
//            WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY
//        else WindowManager.LayoutParams.TYPE_PHONE
//        val flags = WindowManager.LayoutParams.FLAG_WATCH_OUTSIDE_TOUCH or
//                WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL or
//                WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE or
//                WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN or
//                WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED
//        val params = WindowManager.LayoutParams(type, flags, PixelFormat.TRANSLUCENT)
//        params.x = 0
//        params.y = 0
//        params.gravity = Gravity.START or Gravity.TOP
//
//        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
//            params.layoutInDisplayCutoutMode = WindowManager.LayoutParams.LAYOUT_IN_DISPLAY_CUTOUT_MODE_SHORT_EDGES
//        }
//
//        params.format = PixelFormat.RGBA_8888
//        return params
//    }
//
//    /**
//     * 添加矩形背景
//     */
//    private fun addRectView() {
//        val params = overlayParams()
//
//        windowManager.addView(rectView, params)
//    }
//
//    /**
//     * 移除矩形背景
//     */
//    private fun removeRectView() {
//        windowManager.removeView(rectView)
//    }
//
//
//    /**
//     * 更新矩形背景
//     */
//    private fun updateRectView(nodeInfo: AccessibilityNodeInfo) {
//        nodeInfo.getBoundsInScreen(rectInScreen)
//        val wm = context.applicationContext.getSystemService(Context.WINDOW_SERVICE) as WindowManager
//        val params = rectView.layoutParams as WindowManager.LayoutParams
//        params.x = rectInScreen.left
//        params.y = rectInScreen.top
//        params.width = rectInScreen.width()
//        params.height = rectInScreen.height()
//        wm.updateViewLayout(rectView, params)
//    }
//
//    /**
//     * 通过侦测视图位置(建议中心点位置)，寻找相应节点
//     */
//    private fun findNodeByPosition(
//        cx: Int,
//        cy: Int,
//        nodeSet: LinkedHashSet<AccessibilityNodeInfo>
//    ): AccessibilityNodeInfo? {
//        for (nodeInfo in nodeSet) {
//            nodeInfo.getBoundsInScreen(rectInScreen)
//            //是否包含某个点
//            if (rectInScreen.contains(cx, cy)) {
//                return nodeInfo
//            }
//        }
//        return null
//    }
//
//
//    /**
//     * 添加内容视图
//     */
//    private fun addContentView(x: Int, y: Int) {
//
//        val params = overlayParams()
//        params.x = x
//        params.y = y
//        params.width = 0
//        params.height = 0
//
//        println("contentView.parentStart =${contentView.parent}   contentView.isAttachedToWindow=${contentView.isAttachedToWindow}")
//        windowManager.addView(contentView, params)
//        println("contentView.parentEnd =${contentView.parent}    contentView.isAttachedToWindow=${contentView.isAttachedToWindow}")
//    }
//
//    /**
//     * 更新内容视图
//     */
//    private fun updateContentView(nodeInfo: AccessibilityNodeInfo) {
//        val contentParams = contentView.layoutParams as WindowManager.LayoutParams
//        contentParams.width = WindowManager.LayoutParams.MATCH_PARENT
//        contentParams.height = WindowManager.LayoutParams.WRAP_CONTENT//200
//        contentParams.gravity = Gravity.TOP or Gravity.START
//
//        val rectViewParams = rectView.layoutParams as WindowManager.LayoutParams
//        val rectViewX = rectViewParams.x
//        val rectViewY = rectViewParams.y
//        val rectViewWidth = rectViewParams.width
//        val rectViewHeight = rectViewParams.height
//
//
//        //先设置假坐标获取视图高度
//        contentParams.y = -100000
//        val tvContent = contentView.findViewById<TextView>(R.id.tv_content)
//        tvContent.text = if (TextUtils.isEmpty(nodeInfo.text)) nodeInfo.contentDescription else nodeInfo.text
//        windowManager.updateViewLayout(contentView, contentParams)
//
//        //再设置真实坐标
//        val contentViewHeight = contentView.height
//
//        contentParams.y = contentViewY(rectViewY, rectViewHeight, contentViewHeight)
//        windowManager.updateViewLayout(contentView, contentParams)
//
//        println("contentParams=end$${contentParams.height}  contentView=$contentViewHeight")
//    }
//
//    /**
//     * 计算内容视图Y轴
//     */
//    private fun contentViewY(rectViewY: Int, rectViewHeight: Int, contentViewHeight: Int): Int {
//
//        val yOffset = resources.getDimension(R.dimen.dp30).toInt()
//
//        val topHeight = contentViewHeight + yOffset
//
//        val bottomHeight = rectViewHeight + yOffset
//
//        var y = rectViewY - topHeight
//
//        if (y <= 0) {
//            y = rectViewY + bottomHeight
//        }
//
//        return y
//    }
//
//    /**
//     * 移除内容视图
//     */
//    private fun removeContentView() {
//        if (contentView.isAttachedToWindow) {
//            windowManager.removeView(contentView)
//        }
//
//    }
//
//    /**
//     * 创建内容视图
//     */
//    private fun createContentView(): View {
//
//        val shapePathModel = ShapePathModel().apply {
//            setAllCorners(CutCornerTreatment(px2dp(5)))
//            setAllEdges(TriangleEdgeTreatment(px2dp(5), true))
//        }
//        val materialShapeDrawable = MaterialShapeDrawable(shapePathModel)
//
//        val view = context.layoutInflater.inflate(R.layout.layout_content_view, null)
//
//        view.setOnTouchListener { v, event ->
//
//            when (event.action) {
//                MotionEvent.ACTION_OUTSIDE -> {
//                    removeContentView()
//                }
//            }
//
//            return@setOnTouchListener false
//        }
//        return view
//
//    }
//
//
//    private fun translate(sourceText: String) {
//
//        val flowable = Translator.translate(Trans(LANG.AUTO, LANG.EN, arrayOf(sourceText)))
//        val d = flowable.subscribe({ trans ->
//            //dialog(sourceText, trans)
//        }, {
//
//        })
//    }
//
//    private fun px2dp(px: Int): Float = px / context.resources.displayMetrics.density + 0.5f
//}