package com.talpa.overlay.view.overlay

import android.content.Context
import android.graphics.Rect
import android.text.Html
import android.util.Log
import android.widget.TextView
import android.widget.Toast
import com.talpa.overlay.R
import com.talpa.overlay.data.readOverlayTextLanguageTag
import com.talpa.translate.network.TransResponse
import com.talpa.translate.ocr.result.OcrResult
import org.jetbrains.anko.textColorResource
import java.lang.StringBuilder
import java.util.*

/**
 * @author CY 2019-12-02
 */
class SpeechOverlayView(context: Context) : SimpleOverlayView(context) {

    override fun postTranslate(
        translation: String,
        targetLanguageTag: String,
        tvTranslation: TextView
    ) {
        super.postTranslate(translation, targetLanguageTag, tvTranslation)

        tvTranslation.textColorResource = R.color.color_floating_translation_speech_default

        if (textSpeech.isSpeaking()) {
            textSpeech.stopSpeak()
        }

        val locale = Locale.forLanguageTag(targetLanguageTag)

        Log.d("cjslog", "speak${textSpeech.isLanguageAvailable(locale)} ${locale}")
        if (textSpeech.isLanguageAvailable(locale)) {
            if (!textSpeech.speak(translation, locale)) {
                Toast.makeText(context.applicationContext, R.string.playback_error, Toast.LENGTH_SHORT).show()
            }
        }

    }

    override fun removeContentView() {
        super.removeContentView()
        if (textSpeech.isSpeaking()) {
            textSpeech.stopSpeak()
        }
    }

    override fun updateTransResult(location: Rect, ocrResult: OcrResult?, response: TransResponse) {
        super.updateTransResult(location, ocrResult, response)


        if (textSpeech.isSpeaking()) {
            textSpeech.stopSpeak()
        }

        val targetLanguageTag = readOverlayTextLanguageTag(context)
        val locale = Locale.forLanguageTag(targetLanguageTag ?: return)

        val sb = StringBuilder()
        response.result?.texts?.forEach {
            sb.append(Html.fromHtml(it))
            sb.append(",")
        }
        if (textSpeech.isLanguageAvailable(locale)) {
            if (!textSpeech.speak(sb.toString(), locale)) {
                Toast.makeText(context.applicationContext, R.string.playback_error, Toast.LENGTH_SHORT).show()
            }
        }
    }
}