/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageView;
import com.talpa.overlay.R;

public class CustomRoundAngleImageView
extends AppCompatImageView {
    private float width;
    private float height;
    private int defaultRadius = 0;
    private int radius;
    private int leftTopRadius;
    private int rightTopRadius;
    private int rightBottomRadius;
    private int leftBottomRadius;
    private Path mPath = new Path();

    public CustomRoundAngleImageView(Context context) {
        this(context, null);
        this.init(context, null);
    }

    public CustomRoundAngleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.init(context, attrs);
    }

    public CustomRoundAngleImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setLayerType(1, null);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.CustomRoundAngleImageView);
        this.radius = array.getDimensionPixelOffset(R.styleable.CustomRoundAngleImageView_radius, this.defaultRadius);
        this.leftTopRadius = array.getDimensionPixelOffset(R.styleable.CustomRoundAngleImageView_left_top_radius, this.defaultRadius);
        this.rightTopRadius = array.getDimensionPixelOffset(R.styleable.CustomRoundAngleImageView_right_top_radius, this.defaultRadius);
        this.rightBottomRadius = array.getDimensionPixelOffset(R.styleable.CustomRoundAngleImageView_right_bottom_radius, this.defaultRadius);
        this.leftBottomRadius = array.getDimensionPixelOffset(R.styleable.CustomRoundAngleImageView_left_bottom_radius, this.defaultRadius);
        if (this.defaultRadius == this.leftTopRadius) {
            this.leftTopRadius = this.radius;
        }
        if (this.defaultRadius == this.rightTopRadius) {
            this.rightTopRadius = this.radius;
        }
        if (this.defaultRadius == this.rightBottomRadius) {
            this.rightBottomRadius = this.radius;
        }
        if (this.defaultRadius == this.leftBottomRadius) {
            this.leftBottomRadius = this.radius;
        }
        array.recycle();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    protected void onDraw(Canvas canvas) {
        int maxLeft = Math.max(this.leftTopRadius, this.leftBottomRadius);
        int maxRight = Math.max(this.rightTopRadius, this.rightBottomRadius);
        int minWidth = maxLeft + maxRight;
        int maxTop = Math.max(this.leftTopRadius, this.rightTopRadius);
        int maxBottom = Math.max(this.leftBottomRadius, this.rightBottomRadius);
        int minHeight = maxTop + maxBottom;
        if (this.width >= (float)minWidth && this.height > (float)minHeight) {
            this.mPath.reset();
            this.mPath.moveTo((float)this.leftTopRadius, 0.0f);
            this.mPath.lineTo(this.width - (float)this.rightTopRadius, 0.0f);
            this.mPath.quadTo(this.width, 0.0f, this.width, (float)this.rightTopRadius);
            this.mPath.lineTo(this.width, this.height - (float)this.rightBottomRadius);
            this.mPath.quadTo(this.width, this.height, this.width - (float)this.rightBottomRadius, this.height);
            this.mPath.lineTo((float)this.leftBottomRadius, this.height);
            this.mPath.quadTo(0.0f, this.height, 0.0f, this.height - (float)this.leftBottomRadius);
            this.mPath.lineTo(0.0f, (float)this.leftTopRadius);
            this.mPath.quadTo(0.0f, 0.0f, (float)this.leftTopRadius, 0.0f);
            canvas.clipPath(this.mPath);
        }
        super.onDraw(canvas);
    }
}

