package com.talpa.overlay

import android.os.Message
import com.jakewharton.rxrelay2.PublishRelay
import io.reactivex.Observer
import io.reactivex.Scheduler
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import io.reactivex.schedulers.Schedulers
import org.greenrobot.eventbus.EventBus

/**
 * 事件中继
 * @author CY 2019-06-19
 */
object RxRelay {

    private val relay by lazy { PublishRelay.create<Message>() }

    private val eventBus by lazy {
        EventBus.builder().build()
    }

    fun post(message: Message) {
        relay.accept(message)
    }

    fun postByEventBus(message: Message) {
        eventBus.post(message)
    }

    fun registerByEventBus(subscriber: Any) {

        try {
            if (!eventBus.isRegistered(subscriber)) {
                eventBus.register(subscriber)
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    fun unregisterByEventBus(subscriber: Any) {

        try {
            if (eventBus.isRegistered(subscriber)) {
                synchronized(eventBus) {
                    eventBus.unregister(subscriber)
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    fun subscribe(
        subscribeOn: Scheduler = AndroidSchedulers.mainThread(),
        observer: Observer<Message>
    ) {
        relay.subscribeOn(subscribeOn).subscribe(observer)
    }

    fun subscribe(
        onNext: (Message) -> Unit
    ): Disposable {
        return relay.subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread())
            .subscribe(onNext, Throwable::printStackTrace)
    }

    const val EVENT_NODE_INFO_DOWN = 10
    const val EVENT_NODE_INFO_MULTI = 20
    //const val EVENT_PACKAGE_NAME_CHANGE = 30
    const val EVENT_ACTIVITY_CHANGE = 40


    //悬浮球状态事件
    const val EVENT_IDLE_ENTER = 100
    const val EVENT_IDLE_EXIT = 101
    const val EVENT_LIGHT_ENTER = 110
    const val EVENT_LIGHT_EXIT = 111
    const val EVENT_DARK_ENTER = 120
    const val EVENT_DARK_EXIT = 121
    const val EVENT_DETECT_ENTER = 130
    const val EVENT_DETECT_EXIT = 131
    const val EVENT_FIND_LOCATION_ENTER = 140
    const val EVENT_MENU_ENTER = 150
    const val EVENT_MENU_EXIT = 151
    const val EVENT_HIGHLIGHT_ENTER = 160
    const val EVENT_HIGHLIGHT_EXIT = 161
    const val EVENT_INVISIBLE_ENTER = 170
    const val EVENT_COPY_ENTER = 180

    //粘贴板事件
//    /**
//     * 开启粘贴板监听
//     */
//    const val EVENT_CLIPBOARD_ENABLED = 300
//    /**
//     * 关闭粘贴板监听
//     */
//    const val EVENT_CLIPBOARD_UN_ENABLED = 310
}