package com.talpa.overlay.view.overlay

import android.content.Context
import android.util.AttributeSet
import android.view.GestureDetector
import android.view.KeyEvent
import android.view.MotionEvent
import android.view.WindowManager
import android.widget.FrameLayout

/**
 *
 * Overlay View 容器
 *
 * @author CY 2019-11-18
 */
class BaseOverlayView : FrameLayout, GestureDetector.OnGestureListener {

    private lateinit var mGestureDetector: GestureDetector

    constructor(context: Context) : this(context, null)
    constructor(context: Context, attrs: AttributeSet?) : this(context, attrs, 0)
    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : this(
        context,
        attrs,
        defStyleAttr, 0
    )

    constructor(
        context: Context,
        attrs: AttributeSet?,
        defStyleAttr: Int,
        defStyleRes: Int
    ) : super(context, attrs, defStyleAttr, defStyleRes) {
        mGestureDetector = GestureDetector(context, this)
    }


    /**
     * 切勿添加 WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE
     */
    override fun dispatchKeyEvent(event: KeyEvent?): Boolean {

        if (event?.keyCode == KeyEvent.KEYCODE_BACK) {
            val wm = context.getSystemService(Context.WINDOW_SERVICE) as WindowManager
            /*if (isAttachedToWindow) {
                wm.removeViewImmediate(this)

                return true
            }*/
            /*if (setOnBackClickListener?.invoke() ?: false) {
                return super.dispatchKeyEvent(event)
            }*/

            return setOnBackClickListener?.onBackClickListener() ?: super.dispatchKeyEvent(event)
        }
        return super.dispatchKeyEvent(event)
    }


    var setOnBackClickListener: BackClickListener? = null

    interface BackClickListener {
        fun onBackClickListener(): Boolean
    }

    override fun onTouchEvent(event: MotionEvent?): Boolean {
        mGestureDetector.onTouchEvent(event)
        return super.onTouchEvent(event)
    }

    private var mGestureListener: GestureDetector.OnGestureListener? = null

    fun setGestureListener(l: GestureDetector.OnGestureListener) {
        mGestureListener = l
    }

    override fun onDown(e: MotionEvent?): Boolean {
        return mGestureListener?.onDown(e) ?: true
    }

    override fun onShowPress(e: MotionEvent?) {
        mGestureListener?.onShowPress(e)
    }

    override fun onSingleTapUp(e: MotionEvent?): Boolean {
        return mGestureListener?.onSingleTapUp(e) ?: true
    }

    override fun onScroll(
        e1: MotionEvent?,
        e2: MotionEvent?,
        distanceX: Float,
        distanceY: Float
    ): Boolean {
        return mGestureListener?.onScroll(e1, e2, distanceX, distanceY) ?: true
    }

    override fun onLongPress(e: MotionEvent?) {
        mGestureListener?.onLongPress(e)
    }

    override fun onFling(
        e1: MotionEvent?,
        e2: MotionEvent?,
        velocityX: Float,
        velocityY: Float
    ): Boolean {
        return mGestureListener?.onFling(e1, e2, velocityX, velocityY) ?: true
    }
}