package com.talpa.overlay.tools

import android.content.Context
import android.net.ConnectivityManager

/**
 * @author CY 2019-11-27
 */

fun Context.isNetworkConnected(): Boolean {

    val connectivityManager =
        getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
    val networkInfo = connectivityManager.activeNetworkInfo
    return networkInfo?.isAvailable == true && networkInfo.isConnected
}