package com.talpa.overlay.view.menu

import android.content.Context
import android.content.res.Configuration
import android.util.AttributeSet
import android.view.KeyEvent
import android.view.View
import android.view.WindowManager
import android.widget.FrameLayout
import com.talpa.overlay.R
import com.talpa.overlay.view.floatingResetDefaultPosition
import com.talpa.overlay.view.floatingSavePosition
import java.lang.Exception

/**
 * @author CY 2019-11-14
 */
class MenuView : FrameLayout {
    constructor(context: Context) : super(context)
    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs)
    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    )

    constructor(
        context: Context,
        attrs: AttributeSet?,
        defStyleAttr: Int,
        defStyleRes: Int
    ) : super(context, attrs, defStyleAttr, defStyleRes)

    override fun onConfigurationChanged(newConfig: Configuration?) {
        super.onConfigurationChanged(newConfig)
        //updateParams()

        context.floatingResetDefaultPosition()
    }

    private fun updateParams() {

        val floatingMenu = findViewById<View>(R.id.floating_menu)

        val params = layoutParams as WindowManager.LayoutParams
        val point = context.getSize()
        params.width = point.x
        params.height = point.y
        val wm = context.getSystemService(Context.WINDOW_SERVICE) as WindowManager
        try {
            wm.updateViewLayout(this, params)
        } catch (e: Exception) {
            e.printStackTrace()
        }


        val dp276 = resources.getDimension(R.dimen.dp276).toInt()
        val endX = (point.x - dp276) / 2f
        val endY = (point.y - dp276) / 3F//中部偏上
        floatingMenu.x = endX
        floatingMenu.y = endY
    }

//    /**
//     * 切勿添加 WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE
//     */
//    override fun dispatchKeyEvent(event: KeyEvent?): Boolean {
//
//        if (event?.keyCode == KeyEvent.KEYCODE_BACK) {
////            val wm = context.getSystemService(Context.WINDOW_SERVICE) as WindowManager
////            if (isAttachedToWindow) {
////                wm.removeViewImmediate(this)
////
////                return true
////            }
//
//            return setOnBackClickListener?.invoke() ?: super.dispatchKeyEvent(event)
//        }
//        return super.dispatchKeyEvent(event)
//    }


    var setOnBackClickListener: (() -> Boolean)? = null
}