/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.view.overlay;

import android.content.Context;
import android.graphics.Rect;
import android.widget.TextView;
import android.widget.Toast;
import com.talpa.overlay.R;
import com.talpa.overlay.data.SharedPreferKt;
import com.talpa.overlay.view.overlay.SimpleOverlayView;
import com.talpa.translate.network.Result;
import com.talpa.translate.network.TransResponse;
import com.tapla.textspeech.TextSpeech;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.anko.CustomViewPropertiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/talpa/overlay/view/overlay/SpeechOverlayView;", "Lcom/talpa/overlay/view/overlay/SimpleOverlayView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "postTranslate", "", "translation", "", "targetLanguageTag", "tvTranslation", "Landroid/widget/TextView;", "removeContentView", "updateTransResult", "location", "Landroid/graphics/Rect;", "response", "Lcom/talpa/translate/network/TransResponse;", "overlay_googleRelease"})
public final class SpeechOverlayView
extends SimpleOverlayView {
    public SpeechOverlayView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @Override
    public void postTranslate(@NotNull String translation, @NotNull String targetLanguageTag, @NotNull TextView tvTranslation) {
        Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
        Intrinsics.checkNotNullParameter((Object)targetLanguageTag, (String)"targetLanguageTag");
        Intrinsics.checkNotNullParameter((Object)tvTranslation, (String)"tvTranslation");
        super.postTranslate(translation, targetLanguageTag, tvTranslation);
        CustomViewPropertiesKt.setTextColorResource((TextView)tvTranslation, (int)R.color.color_floating_translation_speech_default);
        if (this.getTextSpeech().isSpeaking()) {
            this.getTextSpeech().stopSpeak();
        }
        Locale locale = Locale.forLanguageTag(targetLanguageTag);
        TextSpeech textSpeech2 = this.getTextSpeech();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"locale");
        if (textSpeech2.isLanguageAvailable(locale) && !this.getTextSpeech().speak((CharSequence)translation, locale)) {
            Toast.makeText((Context)this.getContext().getApplicationContext(), (int)R.string.playback_error, (int)0).show();
        }
    }

    @Override
    public void removeContentView() {
        super.removeContentView();
        if (this.getTextSpeech().isSpeaking()) {
            this.getTextSpeech().stopSpeak();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateTransResult(@NotNull Rect location, @Nullable TransResponse response) {
        String targetLanguageTag;
        String string2;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super.updateTransResult(location, response);
        if (this.getTextSpeech().isSpeaking()) {
            this.getTextSpeech().stopSpeak();
        }
        if ((string2 = (targetLanguageTag = SharedPreferKt.readOverlayTextLanguageTag$default(this.getContext(), null, 2, null))) == null) {
            return;
        }
        Locale locale = Locale.forLanguageTag(string2);
        if (response != null) {
            List list;
            StringBuilder sb = new StringBuilder();
            Object object = response.getResult();
            if (object != null && (list = object.getTexts()) != null) {
                Iterable $this$forEachIndexed$iv = list;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    int n;
                    void s;
                    int n2 = index$iv++;
                    boolean bl = false;
                    if (n2 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string3 = (String)item$iv;
                    int index = n2;
                    boolean bl2 = false;
                    sb.append((String)s);
                    Result result2 = response.getResult();
                    Intrinsics.checkNotNull((Object)result2);
                    List list2 = result2.getTexts();
                    if (index >= (list2 == null ? -1 : (n = list2.size()))) continue;
                    sb.append(",");
                }
            }
            TextSpeech textSpeech2 = this.getTextSpeech();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"locale");
            if (textSpeech2.isLanguageAvailable(locale)) {
                TextSpeech textSpeech3 = this.getTextSpeech();
                object = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
                if (!textSpeech3.speak((CharSequence)object, locale)) {
                    Toast.makeText((Context)this.getContext().getApplicationContext(), (int)R.string.playback_error, (int)0).show();
                }
            }
        }
    }
}

