package com.talpa.overlay.view.menu

import android.animation.Animator
import android.animation.AnimatorSet
import android.animation.ObjectAnimator
import android.animation.ValueAnimator
import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import android.graphics.Point
import android.os.Handler
import android.view.*
import android.view.animation.AccelerateDecelerateInterpolator
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.talpa.overlay.state.FloatingStateMachine
import com.talpa.overlay.view.FloatingManager
import android.text.TextUtils
import android.util.Log
import androidx.constraintlayout.motion.widget.MotionLayout
import androidx.core.animation.addListener
import androidx.core.view.ViewCompat
import com.talpa.overlay.R
import com.talpa.overlay.view.FloatingManager.BROADCAST_ACTION_FLOATING_CLOSE
import com.talpa.overlay.view.FloatingManager.BROADCAST_ACTION_FLOATING_OPEN
import com.talpa.overlay.view.overlayViewParams
import java.lang.Exception
import java.util.*


/**
 * @author CY 2019-09-27
 */
class FloatingMenu(val context: Context) {

    companion object {
        /**
         * Click Translate All Locale Broadcast Action
         */
        const val ACTION_MENU_CLICK_TRANS_ALL = "ACTION_MENU_CLICK_TRANS_ALL"
        const val ACTION_MENU_CLICK_SETTING = "ACTION_MENU_CLICK_SETTING"
        const val ACTION_MENU_CLICK_CLOSE = "ACTION_MENU_CLICK_CLOSE"
        const val ACTION_MENU_CLICK_MOVE = "ACTION_MENU_CLICK_MOVE"
        const val ACTION_MENU_CLICK_DICT = "ACTION_MENU_CLICK_DICT"
        const val DICT_PACKAGE = "com.talpa.translate"

        /**
         * Show Menu
         */
        const val ACTION_MENU_SHOW = "ACTION_MENU_SHOW"

        const val GLOBAL_TRANSLATE = "android.intent.action.GLOBAL_TRANSLATE"
        const val CAMERA_ACTION = "com.talpa.translate.ACTION_FOR_CARMERA"
        const val SETTING_ACTION = "com.talpa.translate.ACTION_FOR_SETTING"
    }


    private val defaultHeight by lazy { context.resources.getDimensionPixelOffset(R.dimen.dp252) }
    private val defaultWidth by lazy { context.resources.getDimensionPixelOffset(R.dimen.dp252) }

    private val paddingTop by lazy { context.resources.getDimensionPixelOffset(R.dimen.dp35) }
    private val paddingLeft by lazy { context.resources.getDimensionPixelOffset(R.dimen.dp35) }

    /**
     * 本地广播
     */
    private val localBroadcastManager by lazy { LocalBroadcastManager.getInstance(context) }


    private var menuView: MotionLayout? = null

    private val handler by lazy { Handler() }

    private fun createMenuView(context: Context): MotionLayout {

        val menuView = LayoutInflater.from(context)
            .inflate(R.layout.layout_floating_menu, null) as MotionLayout
        val tvTransAll = menuView.findViewById<View>(R.id.tv_trans_all)
        val tvMove = menuView.findViewById<View>(R.id.tv_move)
        val tvSearch = menuView.findViewById<View>(R.id.tv_camera)
        val tvClose = menuView.findViewById<View>(R.id.tv_close)
        val tvSetting = menuView.findViewById<View>(R.id.tv_setting)
        val tvDict = menuView.findViewById<View>(R.id.ib_dict)

        tvMove.setOnClickListener(this::onMenuItemClick)
        tvClose.setOnClickListener(this::onMenuItemClick)
        tvSearch.setOnClickListener(this::onMenuItemClick)
        tvSetting.setOnClickListener(this::onMenuItemClick)
        tvTransAll.setOnClickListener(this::onMenuItemClick)
        tvDict.setOnClickListener(this::onMenuItemClick)

        menuView.setOnTouchListener { v, event ->
            if (event.action == MotionEvent.ACTION_UP) {
                FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_LIGHT_ENTER)
            }
            return@setOnTouchListener false
        }

        return menuView
    }


    private fun onMenuItemClick(view: View) {
        when (view.id) {
            R.id.tv_move -> {
                FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_LIGHT_ENTER)
                FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_FIND_LOCATION_ENTER)
                localBroadcastManager.sendAction(ACTION_MENU_CLICK_MOVE)
            }
            R.id.tv_close -> {
                localBroadcastManager.sendAction(BROADCAST_ACTION_FLOATING_CLOSE)
                localBroadcastManager.sendAction(ACTION_MENU_CLICK_CLOSE)
            }
            R.id.tv_camera -> {
                FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_LIGHT_ENTER)
                val intent = Intent(CAMERA_ACTION)
                intent.setPackage(DICT_PACKAGE)
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                //view.context.startActivity(intent)
                val pendingIntent = PendingIntent.getActivity(context, 0, intent, 0);
                pendingIntent.send()
            }
            R.id.tv_setting -> {
                FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_LIGHT_ENTER)
                //val action = "com.talpa.translate.ACTION_FOR_SETTING"
                //val action = "com.talpa.translate.ACTION_FOR_MAIN"
                //view.context.pendingStartActivity(action)
                val intent = Intent(SETTING_ACTION)
                intent.setPackage(DICT_PACKAGE)
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                //view.context.startActivity(intent)
                val pendingIntent = PendingIntent.getActivity(context, 0, intent, 0);
                pendingIntent.send()
                localBroadcastManager.sendAction(ACTION_MENU_CLICK_SETTING)
            }
            R.id.tv_trans_all -> {
                localBroadcastManager.sendBroadcastSync(Intent(BROADCAST_ACTION_FLOATING_OPEN))
                localBroadcastManager.sendAction(ACTION_MENU_CLICK_TRANS_ALL)
                handler.postDelayed({
                    FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_HIGHLIGHT_ENTER)
                }, 800)

            }
            R.id.ib_dict -> {
                FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_LIGHT_ENTER)
                //val action = "com.talpa.translate.ACTION_FOR_DICTIONARY"
                //view.context.pendingStartActivity(action)
                val intent = Intent(GLOBAL_TRANSLATE)
                intent.setPackage(DICT_PACKAGE)
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
                //view.context.startActivity(intent)

                val pendingIntent = PendingIntent.getActivity(context, 0, intent, 0);
                pendingIntent.send()

                localBroadcastManager.sendAction(ACTION_MENU_CLICK_DICT)
            }
        }

    }


    /**
     * 进入菜单状态
     */
    fun enterMenu(context: Context, point: Point) {

        val menuView = menuView ?: createMenuView(context).apply { menuView = this }


        if (menuView.isAttachedToWindow) {
            return
        }

        val wm = menuView.context.getSystemService(Context.WINDOW_SERVICE) as WindowManager

        val params = overlayViewParams()
        //val point = menuView.context.getSize()
        params.width = defaultWidth//point.x
        params.height = defaultHeight//point.y


        val display = wm.defaultDisplay
        val displayPoint = Point()
        display.getSize(displayPoint)

        if (point.x > displayPoint.x / 2) {
            params.gravity = Gravity.CENTER_HORIZONTAL or Gravity.TOP
            //右边
            if (point.y < displayPoint.y / 4) {
                //右上
                Log.d("cjslog", "right top")
                menuView.loadLayoutDescription(R.xml.layout_floating_menu_right_top_scene)
                params.y = point.y + paddingTop
                params.windowAnimations = R.style.AnimationOverlay_Right_Top
            } else if (point.y > displayPoint.y * 3 / 4) {
                //右下
                Log.d("cjslog", "right bottom")
                menuView.loadLayoutDescription(R.xml.layout_floating_menu_right_bottom_scene)
                params.y = point.y + paddingTop - defaultHeight
                params.windowAnimations = R.style.AnimationOverlay_Right_Bottom
            } else {
                //右中
                Log.d("cjslog", "right center")
                menuView.loadLayoutDescription(R.xml.layout_floating_menu_right_center_scene)
                params.y = point.y + paddingTop - defaultHeight / 2
                params.windowAnimations = R.style.AnimationOverlay_Right_Center
            }
        } else {
            params.gravity = Gravity.CENTER_VERTICAL or Gravity.TOP
            //左边
            if (point.y < displayPoint.y / 4) {
                //左上
                menuView.loadLayoutDescription(R.xml.layout_floating_menu_left_top_scene)
                params.y = point.y + paddingTop
                Log.d("cjslog", "left top")
                params.windowAnimations = R.style.AnimationOverlay_Left_Top
            } else if (point.y > displayPoint.y * 3 / 4) {
                //左下
                menuView.loadLayoutDescription(R.xml.layout_floating_menu_left_bottom_scene)
                params.y = point.y + paddingTop - defaultHeight
                Log.d("cjslog", "left bottom")
                params.windowAnimations = R.style.AnimationOverlay_Left_Bottom
            } else {
                //左中
                menuView.loadLayoutDescription(R.xml.layout_floating_menu_left_center_scene)
                params.y = point.y + paddingTop - defaultHeight / 2
                Log.d("cjslog", "left center")
                params.windowAnimations = R.style.AnimationOverlay_Left_Center
            }
        }

        //params.x = paddingLeft

        menuView.post {
            menuView.transitionToEnd()
        }

        try {
            wm.addView(menuView, params)
        } catch (e: Exception) {
            e.printStackTrace()
        }

        menuView.setOnClickListener {
            FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_LIGHT_ENTER)
        }
        // animMenuEnter2(menuView)
        //animMenuEnter(menuView)

        localBroadcastManager.sendAction(ACTION_MENU_SHOW)
    }

    /**
     * 退出菜单状态
     */
    fun exitMenu() {
        val menuView = this.menuView ?: return
        menuView.transitionToStart()
        val wm = menuView.context.getSystemService(Context.WINDOW_SERVICE) as WindowManager
        wm.removeView(menuView)
    }

    private fun removeMenuFromWindow() {
        val menuView = this.menuView ?: return
        if (!menuView.isAttachedToWindow) {
            return
        }
        val wm = menuView.context.getSystemService(Context.WINDOW_SERVICE) as WindowManager
        try {
            wm.removeViewImmediate(menuView)
        } catch (e: Exception) {
            e.printStackTrace()
        }

        this.menuView = null
    }

    private fun isRtl(): Boolean {
        return TextUtils.getLayoutDirectionFromLocale(Locale.getDefault()) == View.LAYOUT_DIRECTION_RTL
    }
}

/**
 * 获取屏幕尺寸
 */
fun Context.getSize(): Point {
    val outSize = Point()
    val wm = getSystemService(Context.WINDOW_SERVICE) as WindowManager
    wm.defaultDisplay.getSize(outSize)
    return outSize
}

private fun Context.pendingStartActivity(action: String) {
    val intent = Intent(action)
    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
    intent.setPackage(packageName)
    val pendingIntent =
        PendingIntent.getActivity(this, 100, intent, PendingIntent.FLAG_UPDATE_CURRENT)
    //pendingIntent.send()
}

/**
 * Send Broadcast
 */
fun LocalBroadcastManager.sendAction(action: String) {
    sendBroadcast(Intent(action))
}