package com.talpa.overlay.view.overlay

import android.content.Context
import android.util.AttributeSet
import android.view.KeyEvent
import android.widget.FrameLayout

/**
 *
 * Overlay View 容器
 *
 * @author CY 2019-11-18
 */
class BaseOverlayView : FrameLayout {
    constructor(context: Context) : super(context)
    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs)
    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    )

    constructor(
        context: Context,
        attrs: AttributeSet?,
        defStyleAttr: Int,
        defStyleRes: Int
    ) : super(context, attrs, defStyleAttr, defStyleRes)


    /**
     * 切勿添加 WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE
     */
    override fun dispatchKeyEvent(event: KeyEvent?): Boolean {

        if (event?.keyCode == KeyEvent.KEYCODE_BACK) {
//            val wm = context.getSystemService(Context.WINDOW_SERVICE) as WindowManager
//            if (isAttachedToWindow) {
//                wm.removeViewImmediate(this)
//
//                return true
//            }

            return setOnBackClickListener?.invoke() ?: super.dispatchKeyEvent(event)
        }
        return super.dispatchKeyEvent(event)
    }


    var setOnBackClickListener: (() -> Boolean)? = null
}