/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.tools;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.accessibility.AccessibilityManager;
import com.talpa.overlay.service.AccessService;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u001a\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"TAG", "", "accessibilityEnabled", "", "context", "Landroid/content/Context;", "accessibilityServiceEnabled", "accessibility", "Ljava/lang/Class;", "Landroid/accessibilityservice/AccessibilityService;", "isAccessibilitySettingsOn", "hd-overlay-offline-free-server-charge_release"})
public final class AccessibilityPermissionKt {
    private static final String TAG = "Hi-Accessibility";

    public static final boolean isAccessibilitySettingsOn(@NotNull Context context) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("accessibility");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.accessibility.AccessibilityManager");
        }
        AccessibilityManager accessibilityManager = (AccessibilityManager)object;
        List list2 = list = accessibilityManager.getEnabledAccessibilityServiceList(16);
        if (list2 != null) {
            List list3 = list2;
            boolean bl = false;
            boolean bl2 = false;
            List it = list3;
            boolean bl3 = false;
            Iterable $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AccessibilityServiceInfo info = (AccessibilityServiceInfo)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)info.getResolveInfo().serviceInfo.name, (Object)AccessService.class.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean accessibilityEnabled(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            String accessibilityEnabled;
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            String string2 = accessibilityEnabled = Settings.Secure.getString((ContentResolver)context2.getContentResolver(), (String)"enabled_accessibility_services");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"accessibilityEnabled");
            List services = StringsKt.split$default((CharSequence)string2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            boolean enable = false;
            Iterable $this$forEach$iv = services;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)(context.getPackageName() + '/' + AccessService.class.getName()))) continue;
                return true;
            }
            Log.v((String)TAG, (String)("accessibilityEnabled = " + accessibilityEnabled));
            return false;
        }
        catch (Settings.SettingNotFoundException e) {
            Log.e((String)TAG, (String)("Error finding setting, default accessibility to not found: " + e.getMessage()));
            return false;
        }
    }

    public static final boolean accessibilityServiceEnabled(@NotNull Context context, @NotNull Class<? extends AccessibilityService> accessibility) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(accessibility, (String)"accessibility");
        Log.v((String)TAG, (String)"***ACCESSIBILITY IS ENABLED*** -----------------");
        String service = context.getPackageName() + "/" + accessibility.getCanonicalName();
        TextUtils.SimpleStringSplitter mStringColonSplitter = new TextUtils.SimpleStringSplitter(':');
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        String settingValue = Settings.Secure.getString((ContentResolver)context2.getContentResolver(), (String)"enabled_accessibility_services");
        if (settingValue != null) {
            mStringColonSplitter.setString(settingValue);
            while (mStringColonSplitter.hasNext()) {
                String accessibilityService = mStringColonSplitter.next();
                Log.v((String)TAG, (String)("-------------- > accessibilityService :: " + accessibilityService + ' ' + service));
                if (!StringsKt.equals((String)accessibilityService, (String)service, (boolean)true)) continue;
                Log.v((String)TAG, (String)"We've found the correct setting - accessibility is switched on!");
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean accessibilityServiceEnabled$default(Context context, Class clazz, int n, Object object) {
        if ((n & 2) != 0) {
            clazz = AccessService.class;
        }
        return AccessibilityPermissionKt.accessibilityServiceEnabled(context, clazz);
    }
}

