/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.tools;

import android.content.Context;
import android.os.Binder;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import com.talpa.overlay.service.AccessService;
import com.talpa.overlay.tools.AccessibilityPermissionKt;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\b\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0003\u00a8\u0006\f"}, d2={"invokeCheckOp", "", "context", "Landroid/content/Context;", "method", "Ljava/lang/reflect/Method;", "appOpsService", "", "isXiaoMi", "xiaoMiAlertWindowAllowed", "canDrawOverlays", "isAccessibilityEnabled", "hd-overlay-offline-server-charge_release"})
public final class PermissionHelperKt {
    public static final boolean canDrawOverlays(@NotNull Context $this$canDrawOverlays) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$canDrawOverlays, (String)"$this$canDrawOverlays");
        if (Build.VERSION.SDK_INT >= 23) {
            bl = Settings.canDrawOverlays((Context)$this$canDrawOverlays.getApplicationContext());
        } else if (PermissionHelperKt.isXiaoMi()) {
            Context context = $this$canDrawOverlays.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
            bl = PermissionHelperKt.xiaoMiAlertWindowAllowed(context);
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAccessibilityEnabled(@NotNull Context $this$isAccessibilityEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAccessibilityEnabled, (String)"$this$isAccessibilityEnabled");
        if (!AccessService.Companion.isAccessibilityServiceRun()) return false;
        Context context = $this$isAccessibilityEnabled.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        if (!AccessibilityPermissionKt.isAccessibilitySettingsOn$default(context, null, 2, null)) return false;
        return true;
    }

    private static final boolean isXiaoMi() {
        return StringsKt.equals((String)"XiaoMi", (String)Build.MANUFACTURER, (boolean)true);
    }

    private static final boolean xiaoMiAlertWindowAllowed(Context context) {
        try {
            Object object = context.getSystemService("appops");
            if (object == null) {
                return true;
            }
            Object mAppOpsService = object;
            Class<?> localClass = mAppOpsService.getClass();
            Class[] paramsClass = new Class[]{Integer.TYPE, Integer.TYPE, String.class};
            Method method = localClass.getMethod("checkOp", Arrays.copyOf(paramsClass, paramsClass.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"localClass.getMethod(\"checkOp\", *paramsClass)");
            Method mCheckOpMethod = method;
            return PermissionHelperKt.invokeCheckOp(context, mCheckOpMethod, mAppOpsService);
        }
        catch (Exception e) {
            Log.e((String)"PermissionHelper", (String)"isAlertWindowAllowed exception", (Throwable)e);
            return true;
        }
    }

    private static final boolean invokeCheckOp(Context context, Method method, Object appOpsService) {
        try {
            Object[] paramsValues = new Object[]{24, Binder.getCallingUid(), context.getPackageName()};
            Object result = method.invoke(appOpsService, Arrays.copyOf(paramsValues, paramsValues.length));
            if (result != null) {
                return (Integer)result == 0;
            }
        }
        catch (Exception e) {
            Log.i((String)"PermissionHelper", (String)"invokeCheckOp exception ", (Throwable)e);
        }
        return true;
    }
}

