/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.view.overlay;

import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.talpa.overlay.R;
import com.talpa.overlay.data.SharedPreferKt;
import com.talpa.overlay.service.AccessServiceKt;
import com.talpa.overlay.view.overlay.OverlayImpl;
import com.talpa.tengine.Trans;
import com.trello.rxlifecycle3.kotlin.RxlifecycleKt;
import io.reactivex.Single;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.anko.CustomViewPropertiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0012\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J \u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0002J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\u0012\u0010\u001c\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0002J \u0010\u001d\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006!"}, d2={"Lcom/talpa/overlay/view/overlay/SimpleOverlayView;", "Lcom/talpa/overlay/view/overlay/OverlayImpl;", "Landroid/view/View$OnClickListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "addContentView", "", "x", "", "y", "createContentView", "Landroid/view/View;", "dealNodeInfo", "sourceText", "", "targetLanguageTag", "packageName", "hideProgressBar", "contentView", "onClick", "v", "postTranslate", "translation", "tvTranslation", "Landroid/widget/TextView;", "preTranslate", "removeContentView", "showProgressBar", "translate", "updateContentView", "nodeInfo", "Landroid/view/accessibility/AccessibilityNodeInfo;", "hd-overlay-offline-server-charge_release"})
public class SimpleOverlayView
extends OverlayImpl
implements View.OnClickListener {
    @Override
    @NotNull
    public View createContentView() {
        Context $receiver$iv = this.getContext();
        Object object = $receiver$iv.getSystemService("layout_inflater");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.LayoutInflater");
        }
        View view = ((LayoutInflater)object).inflate(R.layout.layout_content_view_simple, null);
        view.setOnTouchListener(new View.OnTouchListener(this){
            final /* synthetic */ SimpleOverlayView this$0;

            public final boolean onTouch(View v, MotionEvent event) {
                MotionEvent motionEvent = event;
                Intrinsics.checkExpressionValueIsNotNull((Object)motionEvent, (String)"event");
                switch (motionEvent.getAction()) {
                    case 4: {
                        this.this$0.removeContentView();
                        break;
                    }
                }
                return false;
            }
            {
                this.this$0 = simpleOverlayView2;
            }
        });
        View view2 = view;
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view");
        return view2;
    }

    @Override
    public void addContentView(int x, int y) {
        super.addContentView(x, y);
        ViewGroup.LayoutParams layoutParams = this.getContentView().getLayoutParams();
        if (!(layoutParams instanceof WindowManager.LayoutParams)) {
            layoutParams = null;
        }
        WindowManager.LayoutParams params = this.overlayParams((WindowManager.LayoutParams)layoutParams);
        params.x = x;
        params.y = y;
        this.getContentView().setVisibility(8);
        try {
            if (!this.getContentView().isAttachedToWindow()) {
                this.getWindowManager().addView(this.getContentView(), (ViewGroup.LayoutParams)params);
            } else {
                this.getWindowManager().updateViewLayout(this.getContentView(), (ViewGroup.LayoutParams)params);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateContentView(@NotNull AccessibilityNodeInfo nodeInfo) {
        Object tempNode;
        Intrinsics.checkParameterIsNotNull((Object)nodeInfo, (String)"nodeInfo");
        if (!this.getContentView().isAttachedToWindow()) {
            try {
                this.getWindowManager().addView(this.getContentView(), this.getContentView().getLayoutParams());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Intrinsics.areEqual((Object)(tempNode = this.getContentView().getTag(R.id.id_content_view_node_info)), (Object)nodeInfo) && this.getContentView().getVisibility() == 0) {
            return;
        }
        this.getContentView().setTag(R.id.id_content_view_node_info, (Object)nodeInfo);
        if (this.getContentView().getVisibility() != 0) {
            this.getContentView().setVisibility(0);
        }
        Rect bounds = new Rect();
        nodeInfo.getBoundsInScreen(bounds);
        ViewGroup.LayoutParams layoutParams = this.getContentView().getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams contentParams = (WindowManager.LayoutParams)layoutParams;
        contentParams.width = bounds.width();
        contentParams.height = bounds.height();
        contentParams.x = bounds.left;
        contentParams.y = bounds.top;
        contentParams.gravity = 0x800033;
        try {
            String string2 = ((Object)AccessServiceKt.nodeText(nodeInfo)).toString();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String sourceText = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            if (!TextUtils.isEmpty((CharSequence)sourceText)) {
                String string4;
                CharSequence packageName;
                CharSequence charSequence = nodeInfo.getPackageName();
                if (charSequence == null || (charSequence = ((Object)charSequence).toString()) == null) {
                    charSequence = packageName = "";
                }
                if ((string4 = SharedPreferKt.readOverlayTextLanguageTag$default(this.getContext(), null, 2, null)) == null) {
                    string4 = "en";
                }
                String targetLanguageTag = string4;
                this.dealNodeInfo(sourceText, targetLanguageTag, (String)packageName);
            }
            this.getWindowManager().updateViewLayout(this.getContentView(), (ViewGroup.LayoutParams)contentParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeContentView() {
        if (this.getContentView().isAttachedToWindow()) {
            try {
                this.getWindowManager().removeViewImmediate(this.getContentView());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.removeContentView();
    }

    public void onClick(@Nullable View v) {
    }

    /*
     * WARNING - void declaration
     */
    private final void showProgressBar(View contentView2) {
        block2: {
            ProgressBar progressBar2;
            ProgressBar progressBar3;
            View view = contentView2;
            if (view != null) {
                void $receiver$iv;
                View view2 = view;
                int id$iv = R.id.loading_progress_bar;
                View view3 = $receiver$iv.findViewById(id$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(id)");
                progressBar3 = (ProgressBar)view3;
            } else {
                progressBar3 = null;
            }
            ProgressBar progressBar4 = progressBar2 = progressBar3;
            if (progressBar4 == null) break block2;
            progressBar4.setVisibility(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void hideProgressBar(View contentView2) {
        block2: {
            ProgressBar progressBar2;
            ProgressBar progressBar3;
            View view = contentView2;
            if (view != null) {
                void $receiver$iv;
                View view2 = view;
                int id$iv = R.id.loading_progress_bar;
                View view3 = $receiver$iv.findViewById(id$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(id)");
                progressBar3 = (ProgressBar)view3;
            } else {
                progressBar3 = null;
            }
            ProgressBar progressBar4 = progressBar2 = progressBar3;
            if (progressBar4 == null) break block2;
            progressBar4.setVisibility(8);
        }
    }

    private final void preTranslate() {
        this.showProgressBar(this.getContentView());
    }

    private final void postTranslate(String translation, String targetLanguageTag) {
        TextView tvTranslation;
        TextView textView = tvTranslation = (TextView)this.getContentView().findViewById(R.id.tv_translation);
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"tvTranslation");
        textView.setText((CharSequence)translation);
        CustomViewPropertiesKt.setTextColorResource((TextView)tvTranslation, (int)R.color.color_floating_translation);
        tvTranslation.setTag(R.id.id_translation_view_trans_result, (Object)tvTranslation.getText());
        this.hideProgressBar(this.getContentView());
        this.postTranslate(translation, targetLanguageTag, tvTranslation);
    }

    public void postTranslate(@NotNull String translation, @NotNull String targetLanguageTag, @NotNull TextView tvTranslation) {
        Intrinsics.checkParameterIsNotNull((Object)translation, (String)"translation");
        Intrinsics.checkParameterIsNotNull((Object)targetLanguageTag, (String)"targetLanguageTag");
        Intrinsics.checkParameterIsNotNull((Object)tvTranslation, (String)"tvTranslation");
    }

    private final void dealNodeInfo(String sourceText, String targetLanguageTag, String packageName) {
        TextView tvTranslation = (TextView)this.getContentView().findViewById(R.id.tv_translation);
        this.preTranslate();
        OverlayImpl.logStartTranslate$default(this, null, sourceText, targetLanguageTag, packageName, 1, null);
        Single<Object[]> single = this.readTranslateHistory(sourceText, targetLanguageTag);
        TextView textView = tvTranslation;
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"tvTranslation");
        Disposable disposable = RxlifecycleKt.bindToLifecycle(single, (View)((View)textView)).subscribe((Consumer)new Consumer<Object[]>(this, sourceText, packageName, targetLanguageTag){
            final /* synthetic */ SimpleOverlayView this$0;
            final /* synthetic */ String $sourceText;
            final /* synthetic */ String $packageName;
            final /* synthetic */ String $targetLanguageTag;

            /*
             * WARNING - void declaration
             */
            public final void accept(Object[] it) {
                if (it.length == 5 && it[4] instanceof Boolean) {
                    void translation;
                    void targetLanguageLocaleTag;
                    void sourceLanguageLocaleTag;
                    Object[] objectArray;
                    Object[] objectArray2 = objectArray = it;
                    boolean bl = false;
                    Object object = objectArray2[0];
                    objectArray2 = objectArray;
                    bl = false;
                    Object object2 = objectArray2[1];
                    objectArray2 = objectArray;
                    bl = false;
                    Object object3 = objectArray2[2];
                    objectArray2 = objectArray;
                    bl = false;
                    Object object4 = objectArray2[3];
                    objectArray2 = objectArray;
                    bl = false;
                    Object isChecked = objectArray2[4];
                    OverlayImpl.logSuccessTranslate$default(this.this$0, null, this.$sourceText, sourceLanguageLocaleTag.toString(), targetLanguageLocaleTag.toString(), this.$packageName, true, "store", 1, null);
                    SimpleOverlayView.access$postTranslate(this.this$0, translation.toString(), this.$targetLanguageTag);
                } else {
                    SimpleOverlayView.access$translate(this.this$0, this.$sourceText, this.$targetLanguageTag, this.$packageName);
                }
            }
            {
                this.this$0 = simpleOverlayView2;
                this.$sourceText = string2;
                this.$packageName = string3;
                this.$targetLanguageTag = string4;
            }
        }, (Consumer)new Consumer<Throwable>(this, sourceText, targetLanguageTag, packageName){
            final /* synthetic */ SimpleOverlayView this$0;
            final /* synthetic */ String $sourceText;
            final /* synthetic */ String $targetLanguageTag;
            final /* synthetic */ String $packageName;

            public final void accept(Throwable it) {
                SimpleOverlayView.access$translate(this.this$0, this.$sourceText, this.$targetLanguageTag, this.$packageName);
            }
            {
                this.this$0 = simpleOverlayView2;
                this.$sourceText = string2;
                this.$targetLanguageTag = string3;
                this.$packageName = string4;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"readTranslateHistory(sou\u2026ckageName)\n            })");
        Disposable d2 = disposable;
    }

    private final void translate(String sourceText, String targetLanguageTag, String packageName) {
        TextView tvTranslation = (TextView)this.getContentView().findViewById(R.id.tv_translation);
        Function1 onSuccess2 = (Function1)new Function1<Trans, Unit>(this, sourceText, targetLanguageTag, packageName){
            final /* synthetic */ SimpleOverlayView this$0;
            final /* synthetic */ String $sourceText;
            final /* synthetic */ String $targetLanguageTag;
            final /* synthetic */ String $packageName;

            public final void invoke(@NotNull Trans trans2) {
                String translation;
                String string2;
                Intrinsics.checkParameterIsNotNull((Object)trans2, (String)"trans");
                Object object = trans2.getResult();
                if (object != null && (object = object.getTranslation()) != null) {
                    Object object2 = object;
                    boolean bl = false;
                    Object object3 = object2;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
                } else {
                    string2 = translation = null;
                }
                if (!TextUtils.isEmpty((CharSequence)translation)) {
                    Object object4;
                    String sourceLanguage;
                    String string3;
                    Trans.Result result = trans2.getResult();
                    if (result == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((string3 = result.getDetectLang()) == null) {
                        string3 = sourceLanguage = "AUTO";
                    }
                    if ((object4 = trans2.getResult()) == null || (object4 = object4.getSource()) == null) {
                        object4 = "unknown";
                    }
                    OverlayImpl.logSuccessTranslate$default(this.this$0, null, this.$sourceText, sourceLanguage, this.$targetLanguageTag, this.$packageName, false, (String)object4, 33, null);
                    String string4 = translation;
                    if (string4 == null) {
                        Intrinsics.throwNpe();
                    }
                    SimpleOverlayView.access$postTranslate(this.this$0, string4, this.$targetLanguageTag);
                } else {
                    SimpleOverlayView.access$hideProgressBar(this.this$0, this.this$0.getContentView());
                }
            }
            {
                this.this$0 = simpleOverlayView2;
                this.$sourceText = string2;
                this.$targetLanguageTag = string3;
                this.$packageName = string4;
                super(1);
            }
        };
        Function1 onError2 = (Function1)new Function1<Trans, Unit>(this, sourceText, targetLanguageTag, packageName){
            final /* synthetic */ SimpleOverlayView this$0;
            final /* synthetic */ String $sourceText;
            final /* synthetic */ String $targetLanguageTag;
            final /* synthetic */ String $packageName;

            public final void invoke(@NotNull Trans trans2) {
                Intrinsics.checkParameterIsNotNull((Object)trans2, (String)"trans");
                Object object = trans2.getResult();
                if (object == null || (object = object.getErrorMessage()) == null) {
                    object = "unknown";
                }
                OverlayImpl.logFailTranslate$default(this.this$0, null, this.$sourceText, this.$targetLanguageTag, this.$packageName, (String)object, 1, null);
                SimpleOverlayView.access$hideProgressBar(this.this$0, this.this$0.getContentView());
            }
            {
                this.this$0 = simpleOverlayView2;
                this.$sourceText = string2;
                this.$targetLanguageTag = string3;
                this.$packageName = string4;
                super(1);
            }
        };
        TextView textView = tvTranslation;
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"tvTranslation");
        this.translateForOverlayText(textView, sourceText, targetLanguageTag, (Function1<? super Trans, Unit>)onSuccess2, (Function1<? super Trans, Unit>)onError2);
    }

    public SimpleOverlayView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
    }

    public static final /* synthetic */ void access$postTranslate(SimpleOverlayView $this, String translation, String targetLanguageTag) {
        $this.postTranslate(translation, targetLanguageTag);
    }

    public static final /* synthetic */ void access$translate(SimpleOverlayView $this, String sourceText, String targetLanguageTag, String packageName) {
        $this.translate(sourceText, targetLanguageTag, packageName);
    }

    public static final /* synthetic */ void access$hideProgressBar(SimpleOverlayView $this, View contentView2) {
        $this.hideProgressBar(contentView2);
    }
}

