package com.talpa.overlay

import android.app.Application
import com.talpa.translate.repository.box.ObjectBox
import com.talpa.translate.repository.box.translate.TranslateHistory1
import io.reactivex.Single


/**
 * 与 App 通信
 *
 * @author CY 2019-11-05
 */
object Transfer {

    private lateinit var mApplication: Application

    fun init(application: Application) {
        mApplication = application
    }


    /**
     *  it.text,
     *  it.translation,
     *  it.sourceLanguageLocaleTag,
     *  it.targetLanguageLocaleTag,
     *  it.star
     */
    fun queryTranslateHistory(
        text: String,
        sourceLanguageLocaleTag: String,
        targetLanguageLocaleTag: String
    ): Single<TranslateHistory1> {

        return Single.create<TranslateHistory1> {
            val history1 = ObjectBox.queryTranslateHistory(
                text = text,
                sourceLanguageTag = sourceLanguageLocaleTag,
                targetLanguageTag = targetLanguageLocaleTag
            )?.firstOrNull()
            if (history1 == null) {
                it.onError(Throwable("no histroy"))
            } else {
                it.onSuccess(history1)
            }
        }

        /*val methodName = "queryTranslateHistory2"
        val method = mApplication.javaClass.getMethod(
            methodName,
            String::class.java,
            String::class.java,
            String::class.java
        )
        return method.invoke(
            mApplication,
            text,
            sourceLanguageLocaleTag,
            targetLanguageLocaleTag
        ) as Single<Array<Any>>*/

    }

    /**
     * 是否为离线通道
     */
    fun isOfflineModel(): Boolean {
        val methodName = "isOfflineModel"
        return mApplication.javaClass.getMethod(methodName).invoke(mApplication) as Boolean
    }
}