/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.view.overlay;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.talpa.overlay.R;
import com.talpa.overlay.data.SharedPreferKt;
import com.talpa.overlay.service.AccessServiceKt;
import com.talpa.overlay.state.FloatingStateMachine;
import com.talpa.overlay.translate.TranslateHelperKt;
import com.talpa.overlay.view.overlay.BaseOverlayView;
import com.talpa.overlay.view.overlay.OverlayImpl;
import com.talpa.tengine.Trans;
import com.talpa.translate.repository.box.grammar.GrammarNew;
import com.talpa.translate.repository.box.grammar.ResultsV2;
import com.talpa.translate.repository.box.translate.CombinedTrans;
import com.talpa.translate.repository.box.translate.StarTable;
import com.trello.rxlifecycle3.kotlin.RxlifecycleKt;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.anko.CustomViewPropertiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 .2\u00020\u0001:\u0001.B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0017J(\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J(\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u0012\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010#\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010$\u001a\u00020\nH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010&\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010'\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0002J(\u0010(\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010+\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010,\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010-\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/talpa/overlay/view/overlay/EditTextOverlayView;", "Lcom/talpa/overlay/view/overlay/OverlayImpl;", "context", "Landroid/content/Context;", "handler", "Landroid/os/Handler;", "(Landroid/content/Context;Landroid/os/Handler;)V", "rectInScreen", "Landroid/graphics/Rect;", "addContentView", "", "params", "Landroid/view/WindowManager$LayoutParams;", "x", "", "y", "createContentView", "Landroid/view/View;", "dealNodeInfo", "sourceText", "", "targetLanguageTag", "packageName", "nodeInfo", "Landroid/view/accessibility/AccessibilityNodeInfo;", "editTextNodeInfo", "executorAction", "text", "failureTranslate", "errorMessage", "hideProgressBar", "contentView", "hideStatus", "tvStatus", "Landroid/widget/TextView;", "preTranslate", "removeContentView", "restoreEditInfo", "showContentView", "showProgressBar", "storeEditInfo", "translation", "toLanguageTag", "successTranslate", "translate", "updateContentView", "Companion", "overlay_xiaomiRelease"})
public final class EditTextOverlayView
extends OverlayImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Handler handler;
    @NotNull
    private final Rect rectInScreen;
    @NotNull
    public static final String TAG = "EditTextOverlayView";

    public EditTextOverlayView(@NotNull Context context, @Nullable Handler handler2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.handler = handler2;
        this.rectInScreen = new Rect();
    }

    public /* synthetic */ EditTextOverlayView(Context context, Handler handler2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            handler2 = null;
        }
        this(context, handler2);
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    @NotNull
    public View createContentView() {
        Context $receiver$iv = this.getContext();
        Object object = $receiver$iv.getSystemService("layout_inflater");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.LayoutInflater");
        }
        View view = ((LayoutInflater)object).inflate(R.layout.layout_content_edit, null);
        view.setOnTouchListener((arg_0, arg_1) -> EditTextOverlayView.createContentView$lambda-0(this, arg_0, arg_1));
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.talpa.overlay.view.overlay.BaseOverlayView");
        }
        ((BaseOverlayView)view).setSetOnBackClickListener(new BaseOverlayView.BackClickListener(view, this){
            final /* synthetic */ View $view;
            final /* synthetic */ EditTextOverlayView this$0;
            {
                this.$view = $view;
                this.this$0 = $receiver;
            }

            public boolean onBackClickListener() {
                try {
                    if (((BaseOverlayView)this.$view).isAttachedToWindow()) {
                        this.this$0.getWindowManager().removeView(this.$view);
                        if (this.this$0.getGrammarDetailView().isAttachedToWindow()) {
                            this.this$0.getWindowManager().removeView((View)this.this$0.getGrammarDetailView());
                        }
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        });
        return view;
    }

    @Override
    public void addContentView(int x, int y) {
        super.addContentView(x, y);
        ViewGroup.LayoutParams layoutParams = this.getContentView().getLayoutParams();
        WindowManager.LayoutParams params = this.overlayParams(layoutParams instanceof WindowManager.LayoutParams ? (WindowManager.LayoutParams)layoutParams : null);
        params.x = x;
        params.y = y;
        this.getContentView().setVisibility(8);
        try {
            if (!this.getContentView().isAttachedToWindow() && this.getContentView().getParent() == null) {
                this.getWindowManager().addView(this.getContentView(), (ViewGroup.LayoutParams)params);
            } else {
                this.getWindowManager().updateViewLayout(this.getContentView(), (ViewGroup.LayoutParams)params);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void addContentView(WindowManager.LayoutParams params) {
        if (!this.getContentView().isAttachedToWindow() && this.getContentView().getParent() == null) {
            try {
                this.getWindowManager().addView(this.getContentView(), (ViewGroup.LayoutParams)params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void updateContentView(@NotNull AccessibilityNodeInfo nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        this.editTextNodeInfo(nodeInfo);
    }

    private final void showContentView(AccessibilityNodeInfo nodeInfo) {
        ViewGroup.LayoutParams layoutParams = this.getContentView().getLayoutParams();
        WindowManager.LayoutParams params = this.overlayParams(layoutParams instanceof WindowManager.LayoutParams ? (WindowManager.LayoutParams)layoutParams : null);
        params.flags |= 8;
        this.addContentView(params);
        nodeInfo.getBoundsInScreen(this.rectInScreen);
        params.x = this.rectInScreen.left;
        params.y = this.rectInScreen.top;
        params.width = this.rectInScreen.width();
        params.height = this.rectInScreen.height();
        if (this.getContentView().getVisibility() != 0) {
            this.getContentView().setVisibility(0);
        }
        if (FloatingStateMachine.INSTANCE.getGrammarCheckEnable()) {
            this.getContentView().setBackgroundResource(R.drawable.shape_overlay_grammar_bg);
        } else {
            this.getContentView().setBackgroundResource(R.drawable.shape_overlay_bg);
        }
        try {
            this.getWindowManager().updateViewLayout(this.getContentView(), (ViewGroup.LayoutParams)params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeContentView() {
        if (this.getContentView().isAttachedToWindow()) {
            try {
                TextView tvStatus;
                TextView textView = tvStatus = (TextView)this.getContentView().findViewById(R.id.tv_status);
                if (textView != null) {
                    textView.setVisibility(8);
                }
                textView = tvStatus;
                if (textView != null) {
                    textView.setText((CharSequence)"");
                }
                this.getWindowManager().removeViewImmediate(this.getContentView());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.getGrammarDetailView().isAttachedToWindow()) {
            try {
                this.getWindowManager().removeViewImmediate((View)this.getGrammarDetailView());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.removeContentView();
    }

    private final void editTextNodeInfo(AccessibilityNodeInfo nodeInfo) {
        String string2;
        String packageName;
        CharSequence text = AccessServiceKt.nodeText(nodeInfo);
        String string3 = ((Object)text).toString();
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String sourceText = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        CharSequence charSequence = nodeInfo.getPackageName();
        String string5 = charSequence == null ? "" : (packageName = (string2 = ((Object)charSequence).toString()) == null ? "" : string2);
        if (!TextUtils.isEmpty((CharSequence)sourceText)) {
            String targetLanguageTag;
            String targetText = this.restoreEditInfo(nodeInfo);
            String string6 = SharedPreferKt.readOverlayEditTextLanguageTag$default(this.getContext(), null, 2, null);
            String string7 = targetLanguageTag = string6 == null ? "en" : string6;
            if (targetText == null) {
                this.dealNodeInfo(sourceText, targetLanguageTag, packageName, nodeInfo);
            } else {
                this.executorAction(nodeInfo, targetText);
            }
        }
    }

    private final String restoreEditInfo(AccessibilityNodeInfo nodeInfo) {
        String string2 = SharedPreferKt.readOverlayEditTextLanguageTag$default(this.getContext(), null, 2, null);
        if (string2 == null) {
            return null;
        }
        String languageTag = string2;
        return SharedPreferKt.readEditNodeInfo(this.getContext(), nodeInfo, languageTag);
    }

    private final void storeEditInfo(String text, String translation, String toLanguageTag, AccessibilityNodeInfo nodeInfo) {
        SharedPreferKt.writeEditNodeInfo(this.getContext(), text, translation, toLanguageTag, nodeInfo);
    }

    private final void executorAction(AccessibilityNodeInfo nodeInfo, String text) {
        try {
            Bundle arguments = new Bundle();
            arguments.putCharSequence("ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE", (CharSequence)text);
            nodeInfo.performAction(0x200000, arguments);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showProgressBar(View contentView2) {
        ProgressBar progressBar2;
        View view = contentView2;
        if (view == null) {
            progressBar2 = null;
        } else {
            void $receiver$iv;
            View view2 = view;
            int id$iv = R.id.loading_progress_bar;
            View view3 = $receiver$iv.findViewById(id$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(id)");
            progressBar2 = (ProgressBar)view3;
        }
        ProgressBar progressBar3 = progressBar2;
        view = progressBar3;
        if (view != null) {
            view.setVisibility(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void hideProgressBar(View contentView2) {
        ProgressBar progressBar2;
        View view = contentView2;
        if (view == null) {
            progressBar2 = null;
        } else {
            void $receiver$iv;
            View view2 = view;
            int id$iv = R.id.loading_progress_bar;
            View view3 = $receiver$iv.findViewById(id$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(id)");
            progressBar2 = (ProgressBar)view3;
        }
        ProgressBar progressBar3 = progressBar2;
        view = progressBar3;
        if (view != null) {
            view.setVisibility(8);
        }
    }

    private final void preTranslate(AccessibilityNodeInfo nodeInfo) {
        this.showContentView(nodeInfo);
        this.showProgressBar(this.getContentView());
    }

    private final void successTranslate(String sourceText, String translation, String targetLanguageTag, AccessibilityNodeInfo nodeInfo) {
        this.executorAction(nodeInfo, translation);
        this.storeEditInfo(sourceText, translation, targetLanguageTag, nodeInfo);
        this.hideProgressBar(this.getContentView());
        Handler handler2 = this.handler;
        if (handler2 != null) {
            handler2.sendEmptyMessage(300);
        }
    }

    private final void failureTranslate(String sourceText, String targetLanguageTag, String packageName, String errorMessage) {
        TextView tvStatus = (TextView)this.getContentView().findViewById(R.id.tv_status);
        TextView textView = tvStatus;
        if (textView != null) {
            textView.setText(R.string.text_translating_error);
        }
        textView = tvStatus;
        if (textView != null) {
            CustomViewPropertiesKt.setTextColorResource((TextView)textView, (int)R.color.color_floating_failure);
        }
        textView = tvStatus;
        if (textView != null) {
            textView.setVisibility(0);
        }
        this.logFailTranslate("ACTION_EDIT_TEXT_TRANSLATE_ERROR", sourceText, targetLanguageTag, packageName, errorMessage);
        this.hideStatus(tvStatus);
        this.hideProgressBar(this.getContentView());
        textView = this.handler;
        if (textView != null) {
            textView.sendEmptyMessage(400);
        }
    }

    private final void dealNodeInfo(String sourceText, String targetLanguageTag, String packageName, AccessibilityNodeInfo nodeInfo) {
        this.showProgressBar(this.getContentView());
        this.logStartTranslate("ACTION_EDIT_TEXT_TRANSLATE_START", sourceText, targetLanguageTag, packageName);
        Disposable disposable = RxlifecycleKt.bindToLifecycle(this.readTranslateHistory(sourceText, targetLanguageTag), (View)this.getContentView()).subscribe(arg_0 -> EditTextOverlayView.dealNodeInfo$lambda-1(this, sourceText, packageName, nodeInfo, targetLanguageTag, arg_0), arg_0 -> EditTextOverlayView.dealNodeInfo$lambda-2(this, sourceText, targetLanguageTag, packageName, nodeInfo, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"readTranslateHistory(sourceText, targetLanguageTag)\n            .bindToLifecycle(contentView)\n            .subscribe({\n\n                if (!TextUtils.isEmpty(it.text) && !TextUtils.isEmpty(it.translation)) {\n\n\n                    logSuccessTranslate(\n                        ACTION_EDIT_TEXT_TRANSLATE_SUCCESS,\n                        sourceText,\n                        it.sourceLanguageTag,\n                        it.targetLanguageTag,\n                        packageName,\n                        isCached = true,\n                        source = STORE\n                    )\n                    if (sourceText == it.translation) {\n                        //\u64a4\u56de\n                        executorAction(nodeInfo, it.text)\n                        hideProgressBar(contentView)\n                    } else {\n                        successTranslate(\n                            sourceText,\n                            it.translation,\n                            targetLanguageTag,\n                            nodeInfo\n                        )\n                    }\n                } else {\n                    translate(sourceText, targetLanguageTag, packageName, nodeInfo)\n                }\n            }, {\n                it.printStackTrace()\n                translate(sourceText, targetLanguageTag, packageName, nodeInfo)\n            })");
        Disposable d = disposable;
    }

    private final void translate(String sourceText, String targetLanguageTag, String packageName, AccessibilityNodeInfo nodeInfo) {
        this.preTranslate(nodeInfo);
        Consumer onSuccess2 = arg_0 -> EditTextOverlayView.translate$lambda-12(this, sourceText, targetLanguageTag, packageName, nodeInfo, arg_0);
        Consumer onError2 = arg_0 -> EditTextOverlayView.translate$lambda-13(this, sourceText, targetLanguageTag, packageName, arg_0);
        TranslateHelperKt.translateForEditText(sourceText, targetLanguageTag, (Consumer<CombinedTrans>)onSuccess2, (Consumer<Throwable>)onError2, this.getContext(), FloatingStateMachine.INSTANCE.getGrammarCheckEnable());
    }

    private final void hideStatus(TextView tvStatus) {
        TextView textView = tvStatus;
        if (textView != null) {
            textView.postDelayed(() -> EditTextOverlayView.hideStatus$lambda-14(this), 1200L);
        }
    }

    private static final boolean createContentView$lambda-0(EditTextOverlayView this$0, View v, MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = event.getAction();
        if (n == 4) {
            this$0.removeContentView();
        }
        return false;
    }

    private static final void dealNodeInfo$lambda-1(EditTextOverlayView this$0, String $sourceText, String $packageName, AccessibilityNodeInfo $nodeInfo, String $targetLanguageTag, StarTable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sourceText, (String)"$sourceText");
        Intrinsics.checkNotNullParameter((Object)$packageName, (String)"$packageName");
        Intrinsics.checkNotNullParameter((Object)$nodeInfo, (String)"$nodeInfo");
        Intrinsics.checkNotNullParameter((Object)$targetLanguageTag, (String)"$targetLanguageTag");
        if (!TextUtils.isEmpty((CharSequence)it.getText()) && !TextUtils.isEmpty((CharSequence)it.getTranslation())) {
            this$0.logSuccessTranslate("ACTION_EDIT_TEXT_TRANSLATE_SUCCESS", $sourceText, it.getSourceLanguageTag(), it.getTargetLanguageTag(), $packageName, true, "store");
            if (Intrinsics.areEqual((Object)$sourceText, (Object)it.getTranslation())) {
                this$0.executorAction($nodeInfo, it.getText());
                this$0.hideProgressBar(this$0.getContentView());
            } else {
                this$0.successTranslate($sourceText, it.getTranslation(), $targetLanguageTag, $nodeInfo);
            }
        } else {
            this$0.translate($sourceText, $targetLanguageTag, $packageName, $nodeInfo);
        }
    }

    private static final void dealNodeInfo$lambda-2(EditTextOverlayView this$0, String $sourceText, String $targetLanguageTag, String $packageName, AccessibilityNodeInfo $nodeInfo, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sourceText, (String)"$sourceText");
        Intrinsics.checkNotNullParameter((Object)$targetLanguageTag, (String)"$targetLanguageTag");
        Intrinsics.checkNotNullParameter((Object)$packageName, (String)"$packageName");
        Intrinsics.checkNotNullParameter((Object)$nodeInfo, (String)"$nodeInfo");
        it.printStackTrace();
        this$0.translate($sourceText, $targetLanguageTag, $packageName, $nodeInfo);
    }

    private static final void translate$lambda-12$lambda-6$lambda-3(EditTextOverlayView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Toast.makeText((Context)this$0.getContext(), (CharSequence)this$0.getContext().getString(R.string.grammar_no_error_tips1), (int)0).show();
        this$0.removeContentView();
    }

    /*
     * WARNING - void declaration
     */
    private static final void translate$lambda-12$lambda-6$lambda-5(EditTextOverlayView this$0, GrammarNew $grammarNew, CombinedTrans $combinedTrans, View it) {
        void $this$translate_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$grammarNew, (String)"$grammarNew");
        Intrinsics.checkNotNullParameter((Object)$combinedTrans, (String)"$combinedTrans");
        Intent intent = new Intent("com.talpa.translate.GRAMMAR_CHECK_RESULT");
        boolean bl = false;
        boolean bl2 = false;
        Intent intent2 = intent;
        Context context = it.getContext();
        boolean bl3 = false;
        $this$translate_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4.putExtra("grammar_result", (Parcelable)$grammarNew);
        $this$translate_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4.putExtra("grammar_source", $combinedTrans.getGrammarSourceText());
        $this$translate_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4.addFlags(0x10000000);
        Unit unit = Unit.INSTANCE;
        context.startActivity(intent);
        this$0.removeContentView();
    }

    private static final void translate$lambda-12$lambda-10$lambda-9(EditTextOverlayView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.removeContentView();
    }

    private static final void translate$lambda-12$lambda-11(EditTextOverlayView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.removeContentView();
    }

    private static final void translate$lambda-12(EditTextOverlayView this$0, String $sourceText, String $targetLanguageTag, String $packageName, AccessibilityNodeInfo $nodeInfo, CombinedTrans combinedTrans) {
        Trans.Result result2;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sourceText, (String)"$sourceText");
        Intrinsics.checkNotNullParameter((Object)$targetLanguageTag, (String)"$targetLanguageTag");
        Intrinsics.checkNotNullParameter((Object)$packageName, (String)"$packageName");
        Intrinsics.checkNotNullParameter((Object)$nodeInfo, (String)"$nodeInfo");
        Intrinsics.checkNotNullParameter((Object)combinedTrans, (String)"combinedTrans");
        Trans trans = combinedTrans.getTrans();
        Integer n2 = n = trans == null ? null : ((result2 = trans.getResult()) == null ? null : Integer.valueOf(result2.getCode()));
        boolean bl = false;
        if (n2 != null && n2 == 0) {
            String translation;
            Object object = combinedTrans;
            result2 = object.getTrans();
            String string2 = result2 == null ? null : (translation = (object = result2.getResult()) == null ? null : object.getTranslation());
            if (translation != null) {
                CombinedTrans combinedTrans2 = combinedTrans;
                Trans trans2 = combinedTrans2.getTrans();
                Object object2 = trans2 == null ? null : trans2.getResult();
                Intrinsics.checkNotNull((Object)object2);
                object = object2.getDetectLang();
                String sourceLanguage = object == null ? "AUTO" : object;
                object2 = combinedTrans;
                combinedTrans2 = object2.getTrans();
                Trans.Result result3 = object = combinedTrans2 == null ? null : combinedTrans2.getResult();
                OverlayImpl.logSuccessTranslate$default(this$0, "ACTION_EDIT_TEXT_TRANSLATE_SUCCESS", $sourceText, sourceLanguage, $targetLanguageTag, $packageName, false, object == null ? "unknown" : ((object2 = object.getSource()) == null ? "unknown" : object2), 32, null);
                OverlayImpl.insertTranslateHistory$default(this$0, $sourceText, translation, $targetLanguageTag, false, 8, null);
                this$0.successTranslate($sourceText, translation, $targetLanguageTag, $nodeInfo);
                if (FloatingStateMachine.INSTANCE.getGrammarCheckEnable()) {
                    Object object3;
                    Unit unit;
                    object2 = combinedTrans;
                    combinedTrans2 = object2.getGrammarNew();
                    if (combinedTrans2 == null) {
                        unit = null;
                    } else {
                        int n3;
                        trans2 = combinedTrans2;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Trans grammarNew = trans2;
                        boolean bl4 = false;
                        object3 = grammarNew.getResults();
                        object3 = object3 == null ? null : object3.getAlerts();
                        boolean bl5 = false;
                        boolean bl6 = false;
                        if (object3 == null || object3.isEmpty()) {
                            this$0.getContentView().post(() -> EditTextOverlayView.translate$lambda-12$lambda-6$lambda-3(this$0));
                            return;
                        }
                        this$0.getGrammarDetailView().setVisibility(0);
                        object3 = new Object[1];
                        ResultsV2 resultsV2 = grammarNew.getResults();
                        List list = resultsV2 == null ? null : resultsV2.getAlerts();
                        object3[0] = list == null ? 1 : (n3 = list.size());
                        this$0.getGrammarDetailView().setText((CharSequence)this$0.getContext().getString(R.string.grammar_detail, (Object[])object3));
                        this$0.getGrammarDetailView().setOnClickListener(arg_0 -> EditTextOverlayView.translate$lambda-12$lambda-6$lambda-5(this$0, (GrammarNew)grammarNew, combinedTrans, arg_0));
                        this$0.getGrammarDetailView().measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                        list = this$0.getGrammarDetailView().getLayoutParams();
                        WindowManager.LayoutParams params = this$0.overlayParams(list instanceof WindowManager.LayoutParams ? (WindowManager.LayoutParams)list : null);
                        params.flags |= 8;
                        params.width = this$0.getGrammarDetailView().getMeasuredWidth();
                        params.height = this$0.getGrammarDetailView().getMeasuredHeight();
                        params.x = this$0.rectInScreen.left + this$0.rectInScreen.width() - this$0.getGrammarDetailView().getMeasuredWidth();
                        params.y = this$0.rectInScreen.top - 25 - this$0.getGrammarDetailView().getMeasuredHeight();
                        if (!this$0.getGrammarDetailView().isAttachedToWindow()) {
                            this$0.getWindowManager().addView((View)this$0.getGrammarDetailView(), (ViewGroup.LayoutParams)params);
                        }
                        TextView text = (TextView)this$0.getContentView().findViewById(R.id.tv_status);
                        text.setVisibility(0);
                        text.setText((CharSequence)translation);
                        unit = object = Unit.INSTANCE;
                    }
                    if (object == null) {
                        Unit unit2;
                        Unit unit3;
                        object2 = this$0;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        Object it = object2;
                        boolean bl9 = false;
                        this$0.getGrammarDetailView().setVisibility(4);
                        Object object4 = combinedTrans;
                        String string3 = object4.getSourceLocale();
                        if (string3 == null) {
                            unit3 = null;
                        } else {
                            object3 = string3;
                            boolean text = false;
                            boolean bl10 = false;
                            Object it2 = object3;
                            boolean bl11 = false;
                            if (!"en".equals(it2)) {
                                this$0.getGrammarDetailView().setText(R.string.eng_support);
                            }
                            unit3 = unit2 = Unit.INSTANCE;
                        }
                        if (unit2 == null) {
                            object4 = this$0;
                            boolean bl12 = false;
                            boolean bl13 = false;
                            Object it3 = object4;
                            boolean bl14 = false;
                            this$0.getGrammarDetailView().setText(R.string.grammar_check_error);
                        }
                        this$0.getContentView().post(() -> EditTextOverlayView.translate$lambda-12$lambda-10$lambda-9(this$0));
                    }
                } else {
                    this$0.getContentView().post(() -> EditTextOverlayView.translate$lambda-12$lambda-11(this$0));
                }
            } else {
                String errorMessage = "SUCCESS but translation==null";
                this$0.failureTranslate($sourceText, $targetLanguageTag, $packageName, errorMessage);
            }
        } else {
            Object object = combinedTrans;
            Trans trans3 = object.getTrans();
            Trans.Result result4 = result2 = trans3 == null ? null : trans3.getResult();
            String errorMessage = result2 == null ? "unknown" : ((object = result2.getErrorMessage()) == null ? "unknown" : object);
            this$0.failureTranslate($sourceText, $targetLanguageTag, $packageName, errorMessage);
        }
    }

    private static final void translate$lambda-13(EditTextOverlayView this$0, String $sourceText, String $targetLanguageTag, String $packageName, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sourceText, (String)"$sourceText");
        Intrinsics.checkNotNullParameter((Object)$targetLanguageTag, (String)"$targetLanguageTag");
        Intrinsics.checkNotNullParameter((Object)$packageName, (String)"$packageName");
        String string2 = it.getMessage();
        String errorMessage = string2 == null ? "unknown" : string2;
        this$0.failureTranslate($sourceText, $targetLanguageTag, $packageName, errorMessage);
    }

    private static final void hideStatus$lambda-14(EditTextOverlayView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.removeContentView();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/talpa/overlay/view/overlay/EditTextOverlayView$Companion;", "", "()V", "TAG", "", "overlay_xiaomiRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

