/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.inner.media.projection;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.media.Image;
import android.util.SparseIntArray;
import android.view.WindowManager;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.text.Text;
import com.google.mlkit.vision.text.TextRecognition;
import com.google.mlkit.vision.text.TextRecognizer;
import com.google.mlkit.vision.text.TextRecognizerOptionsInterface;
import com.google.mlkit.vision.text.latin.TextRecognizerOptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\u0006\u001a\u00020\u0002*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\f\u0010\n\u001a\u00020\u0004*\u00020\u0007H\u0002\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\tH\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a8\u0006\u0011"}, d2={"findBlock", "Lcom/google/mlkit/vision/text/Text$TextBlock;", "Lcom/google/mlkit/vision/text/Text;", "x", "", "y", "processImage", "Landroid/content/Context;", "image", "Landroid/media/Image;", "rotation", "toBitmap", "Landroid/graphics/Bitmap;", "toFile", "", "file", "Ljava/io/File;", "ht-globaltranslate_release"})
public final class ProcessImageKt {
    @NotNull
    public static final Text processImage(@NotNull Context $this$processImage, @NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)$this$processImage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Bitmap bitmap = ProcessImageKt.toBitmap(image);
        int rotation = ProcessImageKt.rotation($this$processImage);
        InputImage inputImage = InputImage.fromBitmap((Bitmap)bitmap, (int)rotation);
        Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromBitmap(bitmap, rotation)");
        InputImage inputImage2 = inputImage;
        TextRecognizer textRecognizer = TextRecognition.getClient((TextRecognizerOptionsInterface)((TextRecognizerOptionsInterface)TextRecognizerOptions.DEFAULT_OPTIONS));
        Intrinsics.checkNotNullExpressionValue((Object)textRecognizer, (String)"getClient(TextRecognizerOptions.DEFAULT_OPTIONS)");
        TextRecognizer recognizer = textRecognizer;
        Text text = (Text)Tasks.await((Task)recognizer.process(inputImage2));
        bitmap.recycle();
        image.close();
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        return text;
    }

    private static final int rotation(Context $this$rotation) {
        Object object = $this$rotation.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager2 = (WindowManager)object;
        SparseIntArray orientations = new SparseIntArray();
        orientations.append(0, 0);
        orientations.append(1, 90);
        orientations.append(2, 180);
        orientations.append(3, 270);
        int deviceRotation = windowManager2.getDefaultDisplay().getRotation();
        return orientations.get(deviceRotation);
    }

    @Nullable
    public static final Text.TextBlock findBlock(@NotNull Text $this$findBlock, int x, int y) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findBlock, (String)"<this>");
            List list = $this$findBlock.getTextBlocks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"textBlocks");
            List list2 = list;
            ListIterator listIterator = list2.listIterator(list2.size());
            while (listIterator.hasPrevious()) {
                Object e = listIterator.previous();
                Text.TextBlock block = (Text.TextBlock)e;
                boolean bl = false;
                Rect rect = block.getBoundingBox();
                if (!(rect == null ? false : rect.contains(x, y))) continue;
                v1 = e;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public static final Bitmap toBitmap(@NotNull Image $this$toBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        Image.Plane[] planeArray = $this$toBitmap.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeArray, (String)"planes");
        Image.Plane[] planes = planeArray;
        ByteBuffer buffer = planes[0].getBuffer();
        int pixelStride = planes[0].getPixelStride();
        int rowStride = planes[0].getRowStride();
        int rowPadding = rowStride - pixelStride * $this$toBitmap.getWidth();
        int newWidth = $this$toBitmap.getWidth() + rowPadding / pixelStride;
        Bitmap bitmap = Bitmap.createBitmap((int)newWidth, (int)$this$toBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)buffer);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    public static final void toFile(@NotNull Image $this$toFile, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$toFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Image.Plane[] planeArray = $this$toFile.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeArray, (String)"planes");
        Image.Plane[] planes = planeArray;
        ByteBuffer buffer = planes[0].getBuffer();
        int pixelStride = planes[0].getPixelStride();
        int rowStride = planes[0].getRowStride();
        int rowPadding = rowStride - pixelStride * $this$toFile.getWidth();
        int newWidth = $this$toFile.getWidth() + rowPadding / pixelStride;
        Bitmap bitmap = Bitmap.createBitmap((int)newWidth, (int)$this$toFile.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)buffer);
        FileOutputStream fos = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
        fos.flush();
        fos.close();
        bitmap.recycle();
        $this$toFile.close();
    }
}

