/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.inner.overlay.tools;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.text.TextUtils;
import com.talpa.inner.overlay.Log;
import com.talpa.inner.overlay.service.AccessService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0001\u001a\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"TAG", "", "accessibilityEnabled", "", "context", "Landroid/content/Context;", "accessibilityServiceEnabled", "", "accessibilityCanonicalName", "isAccessibilitySettingsOn", "ht-globaltranslate_release"})
public final class AccessibilityPermissionKt {
    @NotNull
    private static final String TAG = "Hi-Accessibility";

    public static final boolean isAccessibilitySettingsOn(@NotNull Context context, @NotNull String accessibilityCanonicalName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accessibilityCanonicalName, (String)"accessibilityCanonicalName");
        int accessibilityEnabled = AccessibilityPermissionKt.accessibilityEnabled(context);
        if (accessibilityEnabled == 1) {
            return AccessibilityPermissionKt.accessibilityServiceEnabled(context, accessibilityCanonicalName);
        }
        Log.Companion.v$default(Log.Companion, TAG, "***ACCESSIBILITY IS DISABLED***", null, 4, null);
        return false;
    }

    public static /* synthetic */ boolean isAccessibilitySettingsOn$default(Context context, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = AccessService.Companion.getAccessibilityCanonicalName();
        }
        return AccessibilityPermissionKt.isAccessibilitySettingsOn(context, string2);
    }

    public static final int accessibilityEnabled(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            int accessibilityEnabled = Settings.Secure.getInt((ContentResolver)context.getApplicationContext().getContentResolver(), (String)"accessibility_enabled");
            Log.Companion.v$default(Log.Companion, TAG, Intrinsics.stringPlus((String)"accessibilityEnabled = ", (Object)accessibilityEnabled), null, 4, null);
            return accessibilityEnabled;
        }
        catch (Settings.SettingNotFoundException e) {
            Log.Companion.e(TAG, Intrinsics.stringPlus((String)"Error finding setting, default accessibility to not found: ", (Object)e.getMessage()));
            return 0;
        }
    }

    public static final boolean accessibilityServiceEnabled(@NotNull Context context, @NotNull String accessibilityCanonicalName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accessibilityCanonicalName, (String)"accessibilityCanonicalName");
        Log.Companion.v$default(Log.Companion, TAG, "***ACCESSIBILITY IS ENABLED*** -----------------", null, 4, null);
        String service = context.getPackageName() + '/' + accessibilityCanonicalName;
        TextUtils.SimpleStringSplitter mStringColonSplitter = new TextUtils.SimpleStringSplitter(':');
        String settingValue = Settings.Secure.getString((ContentResolver)context.getApplicationContext().getContentResolver(), (String)"enabled_accessibility_services");
        if (settingValue != null) {
            mStringColonSplitter.setString(settingValue);
            while (mStringColonSplitter.hasNext()) {
                String accessibilityService = mStringColonSplitter.next();
                Log.Companion.v$default(Log.Companion, TAG, "-------------- > accessibilityService :: " + accessibilityService + ' ' + service, null, 4, null);
                if (!StringsKt.equals((String)accessibilityService, (String)service, (boolean)true)) continue;
                Log.Companion.v$default(Log.Companion, TAG, "We've found the correct setting - accessibility is switched on!", null, 4, null);
                return true;
            }
        }
        return false;
    }
}

