/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.inner.overlay.tools;

import android.app.Application;
import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0012J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0016\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010!\u001a\u00020\rH\u0002J\u0006\u0010\"\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/talpa/inner/overlay/tools/TextSpeech;", "Landroid/speech/tts/TextToSpeech$OnInitListener;", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "()V", "mApplication", "Landroid/app/Application;", "onUtteranceProgressListener", "Landroid/speech/tts/UtteranceProgressListener;", "getOnUtteranceProgressListener", "()Landroid/speech/tts/UtteranceProgressListener;", "setOnUtteranceProgressListener", "(Landroid/speech/tts/UtteranceProgressListener;)V", "textToSpeech", "Landroid/speech/tts/TextToSpeech;", "init", "", "application", "isLanguageAvailable", "", "locale", "Ljava/util/Locale;", "isSpeaking", "matchCode", "code", "", "onAudioFocusChange", "focusChange", "onInit", "status", "requestAudioFocus", "speak", "text", "", "speech", "stopSpeak", "OnUtteranceProgressListener", "ht-globaltranslate_release"})
public final class TextSpeech
implements TextToSpeech.OnInitListener,
AudioManager.OnAudioFocusChangeListener {
    @NotNull
    public static final TextSpeech INSTANCE = new TextSpeech();
    @Nullable
    private static TextToSpeech textToSpeech;
    private static Application mApplication;
    @Nullable
    private static UtteranceProgressListener onUtteranceProgressListener;

    private TextSpeech() {
    }

    @Nullable
    public final UtteranceProgressListener getOnUtteranceProgressListener() {
        return onUtteranceProgressListener;
    }

    public final void setOnUtteranceProgressListener(@Nullable UtteranceProgressListener utteranceProgressListener) {
        onUtteranceProgressListener = utteranceProgressListener;
    }

    public void onInit(int status) {
        if (status != 0) {
            textToSpeech = null;
        }
    }

    public final void init(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        mApplication = application;
        try {
            this.speech();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final TextToSpeech speech() {
        TextToSpeech textToSpeech;
        TextToSpeech textToSpeech2 = TextSpeech.textToSpeech;
        if (textToSpeech2 == null) {
            TextToSpeech textToSpeech3;
            Application application = mApplication;
            if (application == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mApplication");
                application = null;
            }
            TextToSpeech $this$speech_u24lambda_u2d0 = textToSpeech3 = new TextToSpeech((Context)application, (TextToSpeech.OnInitListener)this);
            boolean bl = false;
            TextSpeech.textToSpeech = $this$speech_u24lambda_u2d0;
            textToSpeech = textToSpeech3;
        } else {
            textToSpeech = textToSpeech2;
        }
        return textToSpeech;
    }

    public final boolean speak(@NotNull CharSequence text, @NotNull Locale locale) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        TextToSpeech textToSpeech = null;
        try {
            textToSpeech = this.speech();
            textToSpeech.setOnUtteranceProgressListener((UtteranceProgressListener)new OnUtteranceProgressListener(this));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        int code = textToSpeech.setLanguage(locale);
        if (this.matchCode(code)) {
            boolean isSuccess;
            int status = textToSpeech.speak(text, 1, null, "text_id");
            boolean bl2 = isSuccess = status == 0;
            if (isSuccess) {
                Application application = mApplication;
                if (application == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mApplication");
                    application = null;
                }
                this.requestAudioFocus(application);
            }
            bl = isSuccess;
        } else {
            TextSpeech.textToSpeech = null;
            bl = false;
        }
        return bl;
    }

    public final void stopSpeak() {
        TextToSpeech textToSpeech = this.speech();
        if (textToSpeech.isSpeaking()) {
            this.speech().stop();
        }
    }

    public final boolean isSpeaking() {
        return this.speech().isSpeaking();
    }

    public final boolean isLanguageAvailable(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        TextToSpeech textToSpeech = this.speech();
        int code = textToSpeech.isLanguageAvailable(locale);
        return this.matchCode(code);
    }

    private final boolean matchCode(int code) {
        return code == 0 || code == 2 || code == 1;
    }

    private final void requestAudioFocus(Application application) {
        Object object = application.getSystemService("audio");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
        }
        AudioManager audioManager = (AudioManager)object;
        audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 2);
    }

    public void onAudioFocusChange(int focusChange) {
        if (focusChange == -1) {
            this.stopSpeak();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000e\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0012\u0010\u0012\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/talpa/inner/overlay/tools/TextSpeech$OnUtteranceProgressListener;", "Landroid/speech/tts/UtteranceProgressListener;", "textSpeech", "Lcom/talpa/inner/overlay/tools/TextSpeech;", "(Lcom/talpa/inner/overlay/tools/TextSpeech;)V", "getTextSpeech", "()Lcom/talpa/inner/overlay/tools/TextSpeech;", "onDone", "", "utteranceId", "", "onError", "errorCode", "", "onRangeStart", "start", "end", "frame", "onStart", "ht-globaltranslate_release"})
    private static final class OnUtteranceProgressListener
    extends UtteranceProgressListener {
        @NotNull
        private final TextSpeech textSpeech;

        public OnUtteranceProgressListener(@NotNull TextSpeech textSpeech2) {
            Intrinsics.checkNotNullParameter((Object)textSpeech2, (String)"textSpeech");
            this.textSpeech = textSpeech2;
        }

        @NotNull
        public final TextSpeech getTextSpeech() {
            return this.textSpeech;
        }

        public void onDone(@Nullable String utteranceId) {
            Application application = mApplication;
            if (application == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mApplication");
                application = null;
            }
            Object object = application.getSystemService("audio");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
            }
            AudioManager audioManager = (AudioManager)object;
            audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this.textSpeech);
            UtteranceProgressListener utteranceProgressListener = INSTANCE.getOnUtteranceProgressListener();
            if (utteranceProgressListener != null) {
                utteranceProgressListener.onDone(utteranceId);
            }
        }

        public void onError(@Nullable String utteranceId) {
        }

        public void onError(@Nullable String utteranceId, int errorCode) {
            super.onError(utteranceId, errorCode);
            UtteranceProgressListener utteranceProgressListener = INSTANCE.getOnUtteranceProgressListener();
            if (utteranceProgressListener != null) {
                utteranceProgressListener.onError(utteranceId, errorCode);
            }
            System.out.println((Object)"OnUtteranceProgressListener#onError");
        }

        public void onStart(@Nullable String utteranceId) {
            UtteranceProgressListener utteranceProgressListener = INSTANCE.getOnUtteranceProgressListener();
            if (utteranceProgressListener != null) {
                utteranceProgressListener.onStart(utteranceId);
            }
            System.out.println((Object)"OnUtteranceProgressListener#onStart");
        }

        public void onRangeStart(@Nullable String utteranceId, int start, int end, int frame) {
            super.onRangeStart(utteranceId, start, end, frame);
            if (Build.VERSION.SDK_INT >= 26) {
                UtteranceProgressListener utteranceProgressListener = INSTANCE.getOnUtteranceProgressListener();
                if (utteranceProgressListener != null) {
                    utteranceProgressListener.onRangeStart(utteranceId, start, end, frame);
                }
            }
        }
    }
}

