/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.inner.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.os.BundleKt;
import com.google.gson.Gson;
import com.hiservice.connect.HiServiceConnection;
import com.hiservice.connect.HiServiceConnectionKtxKt;
import com.talpa.inner.ITranslateCallback;
import com.talpa.inner.media.projection.MediaProjectionServiceKt;
import com.talpa.inner.media.projection.ui.MultiTranslateActivityKt;
import com.talpa.inner.media.projection.ui.MultiViewItem;
import com.talpa.inner.media.projection.widget.LoadViewManagerKt;
import com.talpa.inner.overlay.Log;
import com.talpa.inner.overlay.ocr.Block;
import com.talpa.inner.overlay.ocr.VisionRecognizeResult;
import com.talpa.inner.overlay.translate.MultiTranslateKt;
import com.talpa.inner.util.BitmapToTextUtil;
import com.talpa.inner.util.BitmapUtil;
import com.talpa.open.global.GlobalTranslateApi;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\bH\u0002J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0019H\u0002JA\u0010&\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010'2\u0016\u0010(\u001a\u0012\u0012\u0004\u0012\u00020\b0)j\b\u0012\u0004\u0012\u00020\b`*2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b,\u0010-J>\u0010.\u001a\u0016\u0012\u0004\u0012\u00020/\u0018\u00010)j\n\u0012\u0004\u0012\u00020/\u0018\u0001`*2\u0006\u00100\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u0014\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u00061"}, d2={"Lcom/talpa/inner/util/BitmapToTextUtil;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mHiServiceConnection", "Lcom/hiservice/connect/HiServiceConnection;", "mLastBitmapFilePath", "", "mLastOcrHistory", "Lcom/talpa/inner/overlay/ocr/VisionRecognizeResult;", "mMainHandler", "Landroid/os/Handler;", "getMMainHandler", "()Landroid/os/Handler;", "mMainHandler$delegate", "Lkotlin/Lazy;", "bitmapToText", "bitmap", "Landroid/graphics/Bitmap;", "fromLanguage", "decodeSourceBitmap", "isInRect", "", "it", "Lcom/talpa/inner/overlay/ocr/Block;", "rect", "Landroid/graphics/Rect;", "parseBitmap", "reTranslate", "callback", "Lcom/talpa/inner/ITranslateCallback;", "runOnMain", "", "runnable", "Ljava/lang/Runnable;", "toRect", "block", "translateTexts", "", "needTranslateTexts", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "toLanguage", "translateTexts$ht_globaltranslate_release", "(Ljava/util/ArrayList;Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "translates", "Lcom/talpa/inner/media/projection/ui/MultiViewItem;", "ocrHistory", "ht-globaltranslate_release"})
@StabilityInferred(parameters=0)
public final class BitmapToTextUtil {
    @Nullable
    private HiServiceConnection mHiServiceConnection;
    @NotNull
    private final Lazy mMainHandler$delegate;
    @Nullable
    private VisionRecognizeResult mLastOcrHistory;
    @Nullable
    private String mLastBitmapFilePath;
    public static final int $stable = 8;

    public BitmapToTextUtil(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mMainHandler$delegate = LazyKt.lazy((Function0)mMainHandler.2.INSTANCE);
        HiServiceConnection hiServiceConnection = HiServiceConnection.INSTANCE.with(context);
        String string2 = GlobalTranslateApi.INSTANCE.getAppKey$ht_globaltranslate_release();
        if (string2 == null) {
            string2 = "";
        }
        HiServiceConnection hiServiceConnection2 = hiServiceConnection.setAppKey(string2);
        String string3 = GlobalTranslateApi.INSTANCE.getAppSecret$ht_globaltranslate_release();
        if (string3 == null) {
            string3 = "";
        }
        this.mHiServiceConnection = hiServiceConnection2.setAppSecret(string3);
    }

    private final Handler getMMainHandler() {
        Lazy lazy = this.mMainHandler$delegate;
        return (Handler)lazy.getValue();
    }

    public final boolean parseBitmap(@NotNull Context context, @NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.runOnMain(() -> BitmapToTextUtil.parseBitmap$lambda-0(context));
        VisionRecognizeResult visionRecognizeResult = BitmapToTextUtil.bitmapToText$default(this, bitmap, null, 2, null);
        if (visionRecognizeResult == null) {
            boolean bl = false;
            this.runOnMain(() -> BitmapToTextUtil.parseBitmap$lambda-2$lambda-1(context));
            return false;
        }
        VisionRecognizeResult ocrHistory = visionRecognizeResult;
        ArrayList<MultiViewItem> items = this.translates(ocrHistory, new Rect(0, MediaProjectionServiceKt.statusBarHeight(context), Integer.MAX_VALUE, Integer.MAX_VALUE), "", MultiTranslateKt.multiTargetLanguage(context));
        this.runOnMain(() -> BitmapToTextUtil.parseBitmap$lambda-3(context, items));
        this.mLastBitmapFilePath = null;
        File file = new File(context.getApplicationContext().getExternalCacheDir(), "image_last.jpg");
        if (file.exists()) {
            file.delete();
        }
        if (!BitmapUtil.saveBitmapToFile(bitmap, file)) {
            file.deleteOnExit();
        } else {
            this.mLastBitmapFilePath = file.getAbsolutePath();
        }
        return true;
    }

    public final boolean reTranslate(@NotNull Context context, @Nullable ITranslateCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VisionRecognizeResult visionRecognizeResult = this.mLastOcrHistory;
        if (visionRecognizeResult != null) {
            VisionRecognizeResult it = visionRecognizeResult;
            boolean bl = false;
            ITranslateCallback iTranslateCallback = callback2;
            if (iTranslateCallback != null) {
                iTranslateCallback.onStartTranslate();
            }
            ArrayList<MultiViewItem> items = this.translates(it, new Rect(0, MediaProjectionServiceKt.statusBarHeight(context), Integer.MAX_VALUE, Integer.MAX_VALUE), "", MultiTranslateKt.multiTargetLanguage(context));
            Collection collection = items;
            boolean success = !(collection == null || collection.isEmpty());
            ITranslateCallback iTranslateCallback2 = callback2;
            if (iTranslateCallback2 != null) {
                iTranslateCallback2.onDoneTranslate(success, items);
            }
            return success;
        }
        return false;
    }

    @Nullable
    public final Bitmap decodeSourceBitmap() {
        String string2 = this.mLastBitmapFilePath;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return BitmapFactory.decodeFile((String)it);
        }
        return null;
    }

    private final VisionRecognizeResult bitmapToText(Bitmap bitmap, String fromLanguage) {
        Bundle result;
        Bundle bundle;
        HiServiceConnection hiServiceConnection = this.mHiServiceConnection;
        if (hiServiceConnection == null) {
            bundle = null;
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"extra_bitmap", (Object)bitmap), TuplesKt.to((Object)"extra_rotation", (Object)0), TuplesKt.to((Object)"extra_source_language", (Object)fromLanguage)};
            bundle = HiServiceConnectionKtxKt.textChooseRecognize((HiServiceConnection)hiServiceConnection, (Bundle)BundleKt.bundleOf((Pair[])pairArray));
        }
        Bundle bundle2 = result = bundle;
        String text = bundle2 == null ? null : bundle2.getString("extra_vision_result");
        VisionRecognizeResult ocrHistory = null;
        try {
            ocrHistory = (VisionRecognizeResult)new Gson().fromJson(text, VisionRecognizeResult.class);
            Log.Companion.i("Sky_Test", "bitmap to text, code:" + ocrHistory.getCode() + ", msg:" + ocrHistory.getMsg());
            Iterable $this$forEach$iv = ocrHistory.getBlocks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Block it = (Block)element$iv;
                boolean bl = false;
                Log.Companion.i("Sky_Test", Intrinsics.stringPlus((String)"bitmap to text, code:", (Object)it.getText()));
            }
            if (ocrHistory.getCode() < 200 || ocrHistory.getCode() >= 400) {
                ocrHistory = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mLastOcrHistory = ocrHistory;
        return ocrHistory;
    }

    static /* synthetic */ VisionRecognizeResult bitmapToText$default(BitmapToTextUtil bitmapToTextUtil, Bitmap bitmap, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return bitmapToTextUtil.bitmapToText(bitmap, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<MultiViewItem> translates(VisionRecognizeResult ocrHistory, Rect rect, String fromLanguage, String toLanguage) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        ArrayList<Block> needTranslateBlocks = new ArrayList<Block>();
        ArrayList<String> needTranslateTexts = new ArrayList<String>();
        Iterable $this$filter$iv = ocrHistory.getBlocks();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            Block it = (Block)element$iv$iv;
            boolean bl = false;
            if (!this.isInRect(it, rect)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block it = (Block)element$iv;
            boolean bl = false;
            needTranslateBlocks.add(it);
            needTranslateTexts.add(it.getText());
        }
        int size = needTranslateTexts.size();
        Object[] translationResult = this.translateTexts$ht_globaltranslate_release(needTranslateTexts, fromLanguage, toLanguage);
        Integer responseSize = translationResult == null ? null : Integer.valueOf(translationResult.length);
        Integer n = responseSize;
        if (n == null || size != n) {
            Log.Companion.e("translate", Intrinsics.stringPlus((String)"translate failed.request:", needTranslateTexts));
            Log.Companion.e("translate", Intrinsics.stringPlus((String)"translate failed.response:", (Object)(translationResult == null ? null : ArraysKt.toList((Object[])translationResult))));
            return null;
        }
        ArrayList<MultiViewItem> items = new ArrayList<MultiViewItem>();
        Log.Companion.v$default(Log.Companion, "translate", Intrinsics.stringPlus((String)"translate failed.request:", needTranslateTexts), null, 4, null);
        Log.Companion.v$default(Log.Companion, "translate", Intrinsics.stringPlus((String)"translate failed.response:", (Object)ArraysKt.toList((Object[])translationResult)), null, 4, null);
        Object itemTranslateText = null;
        String itemText = null;
        int itemStatus = 0;
        int n2 = 0;
        while (n2 < size) {
            int n3;
            int index = n3 = n2++;
            boolean bl = false;
            String string2 = needTranslateTexts.get(index);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"needTranslateTexts[index]");
            itemText = string2;
            itemTranslateText = translationResult[index];
            itemStatus = !TextUtils.isEmpty((CharSequence)((CharSequence)itemTranslateText)) ? 1 : -1;
            Log.Companion.i("Sky_Test", "response, " + itemText + ':' + itemTranslateText);
            string2 = needTranslateBlocks.get(index);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"needTranslateBlocks[index]");
            items.add(new MultiViewItem(itemText, (String)itemTranslateText, itemStatus, this.toRect((Block)((Object)string2))));
        }
        return items;
    }

    static /* synthetic */ ArrayList translates$default(BitmapToTextUtil bitmapToTextUtil, VisionRecognizeResult visionRecognizeResult, Rect rect, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        return bitmapToTextUtil.translates(visionRecognizeResult, rect, string2, string3);
    }

    private final boolean isInRect(Block it, Rect rect) {
        return it.getRect().getTop() >= rect.top && it.getRect().getLeft() >= rect.left && it.getRect().getRight() <= rect.right && it.getRect().getBottom() <= rect.bottom;
    }

    @Nullable
    public final String[] translateTexts$ht_globaltranslate_release(@NotNull ArrayList<String> needTranslateTexts, @NotNull String fromLanguage, @NotNull String toLanguage) {
        Bundle translateResponses;
        Intrinsics.checkNotNullParameter(needTranslateTexts, (String)"needTranslateTexts");
        Intrinsics.checkNotNullParameter((Object)fromLanguage, (String)"fromLanguage");
        Intrinsics.checkNotNullParameter((Object)toLanguage, (String)"toLanguage");
        HiServiceConnection hiServiceConnection = this.mHiServiceConnection;
        Bundle bundle = translateResponses = hiServiceConnection == null ? null : HiServiceConnectionKtxKt.multiTranslate((HiServiceConnection)hiServiceConnection, (List)TypeIntrinsics.asMutableList(needTranslateTexts), (String)fromLanguage, (String)toLanguage);
        return bundle == null ? null : bundle.getStringArray("translate_success_translation");
    }

    private final Rect toRect(Block block) {
        Rect result = new Rect();
        int left = 0;
        left = Integer.MAX_VALUE;
        int top = 0;
        top = Integer.MAX_VALUE;
        int right = 0;
        int bottom = 0;
        Iterable $this$forEach$iv = block.getBlockCorners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Point it = (Point)element$iv;
            boolean bl = false;
            left = Math.min(left, it.x);
            right = Math.max(right, it.x);
            top = Math.min(top, it.y);
            bottom = Math.max(bottom, it.y);
        }
        result.left = left;
        result.top = top;
        result.right = right;
        result.bottom = bottom;
        return result;
    }

    private final void runOnMain(Runnable runnable) {
        if (Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper())) {
            runnable.run();
        } else {
            this.getMMainHandler().post(() -> BitmapToTextUtil.runOnMain$lambda-11(runnable));
        }
    }

    private static final void parseBitmap$lambda-0(Context $context) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        LoadViewManagerKt.showLoadingView($context);
    }

    private static final void parseBitmap$lambda-2$lambda-1(Context $context) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        LoadViewManagerKt.hideLoadingView($context);
        LoadViewManagerKt.ocrFailed($context);
    }

    private static final void parseBitmap$lambda-3(Context $context, ArrayList $items) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        LoadViewManagerKt.hideLoadingView($context);
        Collection collection = $items;
        if (collection == null || collection.isEmpty()) {
            LoadViewManagerKt.translateFailed($context);
        } else {
            MultiTranslateActivityKt.startMultiTranslateActivity($context, $items);
        }
    }

    private static final void runOnMain$lambda-11(Runnable $runnable) {
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        $runnable.run();
    }
}

