/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.inner.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapUtil {
    public static final Float BLUR_RADIUS = Float.valueOf(25.0f);
    public static final Float SCALE_DEGREE = Float.valueOf(0.1f);

    @Nullable
    public static Bitmap cropBitmap(@Nullable Bitmap bitmap, int x, int y, int width, int height, boolean isRecycled) {
        if (bitmap == null) {
            return null;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        if (w - x < width || h - y < height) {
            return null;
        }
        Bitmap result = Bitmap.createBitmap((Bitmap)bitmap, (int)x, (int)y, (int)width, (int)height, null, (boolean)false);
        if (!bitmap.isRecycled() && isRecycled) {
            bitmap.recycle();
        }
        return result;
    }

    @Nullable
    public static Bitmap blur(@Nullable Context context, @Nullable Bitmap bitmap, boolean isRecycled) {
        if (null == bitmap || null == context) {
            return null;
        }
        int width = Math.round((float)bitmap.getWidth() * SCALE_DEGREE.floatValue());
        int height = Math.round((float)bitmap.getHeight() * SCALE_DEGREE.floatValue());
        Bitmap inputBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)false);
        Bitmap outputBitmap = Bitmap.createBitmap((Bitmap)inputBitmap);
        RenderScript renderScript = RenderScript.create((Context)context);
        ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
        Allocation inputAllocation = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)inputBitmap);
        Allocation outputAllocation = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)outputBitmap);
        scriptIntrinsicBlur.setRadius(BLUR_RADIUS.floatValue());
        scriptIntrinsicBlur.setInput(inputAllocation);
        scriptIntrinsicBlur.forEach(outputAllocation);
        outputAllocation.copyTo(outputBitmap);
        if (!bitmap.isRecycled() && isRecycled) {
            bitmap.recycle();
        }
        return outputBitmap;
    }

    public static boolean saveBitmapToFile(@NonNull Bitmap bitmap, @NonNull File file) {
        try {
            boolean result;
            if (file.isDirectory()) {
                return false;
            }
            if (!file.exists() && !(result = file.createNewFile())) {
                return false;
            }
            String path = file.getAbsolutePath();
            FileOutputStream out = new FileOutputStream(path);
            return bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

