/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.inner.overlay.service;

import android.accessibilityservice.AccessibilityService;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Build;
import android.os.Message;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.webkit.WebView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.VideoView;
import androidx.annotation.Keep;
import androidx.annotation.RequiresApi;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.talpa.inner.media.projection.widget.LoadViewManagerKt;
import com.talpa.inner.overlay.Log;
import com.talpa.inner.overlay.RxRelay;
import com.talpa.inner.overlay.data.SharedPreferKt;
import com.talpa.inner.overlay.service.AccessService;
import com.talpa.inner.overlay.service.AccessServiceKt;
import com.talpa.inner.overlay.service.AccessibilityServiceState;
import com.talpa.inner.overlay.translate.MultiTranslateKt;
import com.talpa.open.global.GlobalTranslateApi;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0017\u0018\u0000 M2\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001MB\u0005\u00a2\u0006\u0002\u0010\u0004J8\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\u0016\u0010*\u001a\u0012\u0012\u0004\u0012\u00020$0+j\b\u0012\u0004\u0012\u00020$`,H\u0002J:\u0010-\u001a\u0012\u0012\u0004\u0012\u00020$0.j\b\u0012\u0004\u0012\u00020$`/2\b\u0010#\u001a\u0004\u0018\u00010$2\u0016\u00100\u001a\u0012\u0012\u0004\u0012\u00020$0.j\b\u0012\u0004\u0012\u00020$`/H\u0002J\u0011\u00101\u001a\u00020&H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J\u0019\u00103\u001a\u00020&2\u0006\u00104\u001a\u000205H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u0011\u00107\u001a\u00020&H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J\b\u00108\u001a\u00020&H\u0002J\u0010\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020\u0006H\u0002J\u0012\u0010;\u001a\u00020&2\b\u0010<\u001a\u0004\u0018\u00010=H\u0017J\b\u0010>\u001a\u00020&H\u0016J\b\u0010?\u001a\u00020&H\u0016J\u0010\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\bH\u0014J\b\u0010B\u001a\u00020&H\u0016J\u0012\u0010C\u001a\u00020&2\b\u00104\u001a\u0004\u0018\u000105H\u0016J\b\u0010D\u001a\u00020&H\u0014J\"\u0010E\u001a\u00020\b2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u0010F\u001a\u00020\b2\u0006\u0010G\u001a\u00020\bH\u0016J\u0012\u0010H\u001a\u00020\u000b2\b\u00104\u001a\u0004\u0018\u000105H\u0016J(\u0010I\u001a\u00020&2\u0006\u0010'\u001a\u00020$2\u0016\u0010J\u001a\u0012\u0012\u0004\u0012\u00020$0.j\b\u0012\u0004\u0012\u00020$`/H\u0002J\n\u0010#\u001a\u0004\u0018\u00010$H\u0002J\b\u0010K\u001a\u00020&H\u0016J \u0010L\u001a\u00020\u000b2\u0016\u0010J\u001a\u0012\u0012\u0004\u0012\u00020$0.j\b\u0012\u0004\u0012\u00020$`/H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u001cj\b\u0012\u0004\u0012\u00020\u0006`\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0013\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006N"}, d2={"Lcom/talpa/inner/overlay/service/AccessService;", "Landroid/accessibilityservice/AccessibilityService;", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "()V", "currentAction", "", "currentWindowId", "", "Ljava/lang/Integer;", "isAccessibilityEvent", "", "lastPackageName", "", "localBroadcastManager", "Landroidx/localbroadcastmanager/content/LocalBroadcastManager;", "getLocalBroadcastManager", "()Landroidx/localbroadcastmanager/content/LocalBroadcastManager;", "localBroadcastManager$delegate", "Lkotlin/Lazy;", "mainScope", "Lkotlinx/coroutines/CoroutineScope;", "getMainScope", "()Lkotlinx/coroutines/CoroutineScope;", "mainScope$delegate", "multiDisposable", "Lio/reactivex/disposables/Disposable;", "nodeRectSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getNodeRectSet", "()Ljava/util/HashSet;", "nodeRectSet$delegate", "pointNodeBound", "Landroid/graphics/Rect;", "rootNodeInfo", "Landroid/view/accessibility/AccessibilityNodeInfo;", "findNodeByPoint", "", "nodeInfo", "x", "y", "nodeInfoList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "findNodes", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "nodesContainer", "handleActionDown", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleActionPoint", "intent", "Landroid/content/Intent;", "(Landroid/content/Intent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleActionStartSingleMultiNode", "handleActionStopMultiNode", "log", "message", "onAccessibilityEvent", "event", "Landroid/view/accessibility/AccessibilityEvent;", "onCreate", "onDestroy", "onGesture", "gestureId", "onInterrupt", "onRebind", "onServiceConnected", "onStartCommand", "flags", "startId", "onUnbind", "recursionNodeCate", "nodeSet", "run", "shouldRefresh", "Companion", "ht-globaltranslate_release"})
@Keep
@RequiresApi(value=4)
@StabilityInferred(parameters=0)
public class AccessService
extends AccessibilityService
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Rect pointNodeBound = new Rect();
    @Nullable
    private String currentAction;
    @Nullable
    private Disposable multiDisposable;
    private boolean isAccessibilityEvent;
    @Nullable
    private AccessibilityNodeInfo rootNodeInfo;
    @Nullable
    private CharSequence lastPackageName;
    @NotNull
    private final Lazy nodeRectSet$delegate = LazyKt.lazy((Function0)nodeRectSet.2.INSTANCE);
    @Nullable
    private Integer currentWindowId;
    @NotNull
    private final Lazy localBroadcastManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LocalBroadcastManager>(this){
        final /* synthetic */ AccessService this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final LocalBroadcastManager invoke() {
            return LocalBroadcastManager.getInstance((Context)this.this$0.getApplicationContext());
        }
    }));
    @NotNull
    private final Lazy mainScope$delegate = LazyKt.lazy((Function0)mainScope.2.INSTANCE);
    public static final int $stable = 8;
    @NotNull
    public static final String TAG = "AccessService";
    @NotNull
    private static String accessibilityCanonicalName;
    @NotNull
    private static final String ACTION_DOWN = "com.talpa.overlay.core.AccessService#ACTION_DOWN";
    @NotNull
    private static final String ACTION_POINT = "com.talpa.overlay.core.AccessService#ACTION_POINT";
    @NotNull
    private static final String ACTION_NODES_START = "com.talpa.overlay.core.AccessService#ACTION_NODES_START";
    @NotNull
    private static final String ACTION_NODES_STOP = "com.talpa.overlay.core.AccessService#ACTION_NODES_STOP";
    @NotNull
    private static final String EXTRA_POINT_X = "point_x";
    @NotNull
    private static final String EXTRA_POINT_Y = "point_y";
    @NotNull
    public static final String BROADCAST_ACTION_SERVICE_CONNECTED = "com.talpa.overlay.service#BROADCAST_ACTION_CONNECTED";
    @NotNull
    private static final String BROADCAST_ACTION_UN_BIND = "com.talpa.overlay.service#BROADCAST_ACTION_UN_BIND";
    @NotNull
    private static final String BROADCAST_ACTION_RE_BIND = "com.talpa.overlay.service#BROADCAST_ACTION_RE_BIND";
    @NotNull
    public static final String BROADCAST_ACTION_DESTROY = "com.talpa.overlay.service#BROADCAST_ACTION_DESTROY";
    @NotNull
    public static final String BROADCAST_ACTION_PACKAGE_CHANGED = "com.talpa.overlay.service#BROADCAST_ACTION_PACKAGE_CHANGED";
    @NotNull
    public static final String EXTRA_PACKAGE_NAME = "extra_package_name";
    private static final long MILLIS_DELAY = 1000L;
    private static boolean isAccessibilityServiceRun;
    @Nullable
    private static CharSequence currentPackageName;
    @NotNull
    private static final String BROADCAST_ACTION_FLOATING_OPEN = "BROADCAST_ACTION_FLOATING_OPEN";
    @NotNull
    private static final String BROADCAST_ACTION_FLOATING_CLOSE = "BROADCAST_ACTION_FLOATING_CLOSE";

    private final HashSet<String> getNodeRectSet() {
        Lazy lazy = this.nodeRectSet$delegate;
        return (HashSet)lazy.getValue();
    }

    private final LocalBroadcastManager getLocalBroadcastManager() {
        Lazy lazy = this.localBroadcastManager$delegate;
        return (LocalBroadcastManager)lazy.getValue();
    }

    private final void log(String message) {
        Log.Companion.i("SkyCar", message);
    }

    private final CoroutineScope getMainScope() {
        Lazy lazy = this.mainScope$delegate;
        return (CoroutineScope)lazy.getValue();
    }

    public void onCreate() {
        super.onCreate();
        Log.Companion.i(TAG, "onCreate");
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        Intent intent2 = intent;
        this.currentAction = intent2 == null ? null : intent2.getAction();
        Log.Companion.i(TAG, "onStartCommand:flags = " + flags + ", startId = " + startId + ", action = " + this.currentAction);
        BuildersKt.launch$default((CoroutineScope)this.getMainScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(intent, this, null){
            int label;
            final /* synthetic */ Intent $intent;
            final /* synthetic */ AccessService this$0;
            {
                this.$intent = $intent;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 10[SWITCH]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return super.onStartCommand(intent, flags, startId);
    }

    private final Object handleActionPoint(Intent intent, Continuation<? super Unit> $completion) {
        int x = intent.getIntExtra(EXTRA_POINT_X, -1);
        int y = intent.getIntExtra(EXTRA_POINT_Y, -1);
        AccessibilityNodeInfo nodeInfo = this.getRootInActiveWindow();
        if (x != -1 && y != -1 && nodeInfo != null) {
            ArrayList<AccessibilityNodeInfo> nodeInfoList = new ArrayList<AccessibilityNodeInfo>();
            this.findNodeByPoint(nodeInfo, x, y, nodeInfoList);
        }
        return Unit.INSTANCE;
    }

    private final Object handleActionStartSingleMultiNode(Continuation<? super Unit> $completion) {
        this.handleActionStopMultiNode();
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ AccessService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = AccessService.access$rootNodeInfo(this.this$0);
                        if (v0 != null) ** GOTO lbl9
                        v1 = null;
                        ** GOTO lbl39
lbl9:
                        // 1 sources

                        var2_3 = v0;
                        var3_4 = this.this$0;
                        it = var2_3;
                        $i$a$-let-AccessService$handleActionStartSingleMultiNode$2$1 = false;
                        this.L$0 = var3_4;
                        this.L$1 = it;
                        this.label = 1;
                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(var3_4, null){
                            int label;
                            final /* synthetic */ AccessService this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Application application = this.this$0.getApplication();
                                        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"application");
                                        LoadViewManagerKt.showLoadingView((Context)application);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        if (v2 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl26
                    }
                    case 1: {
                        $i$a$-let-AccessService$handleActionStartSingleMultiNode$2$1 = false;
                        it = (AccessibilityNodeInfo)this.L$1;
                        var3_4 = (AccessService)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl26:
                        // 2 sources

                        nodes = new LinkedHashSet<E>();
                        try {
                            AccessService.access$findNodes(var3_4, it, nodes);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            AccessService.access$log(var3_4, Intrinsics.stringPlus((String)"findNodes exception:", (Object)e.getMessage()));
                        }
                        AccessService.access$log(var3_4, Intrinsics.stringPlus((String)"handleActionStartSingleMultiNode:nodes:", (Object)Boxing.boxInt((int)nodes.size())));
                        MultiTranslateKt.showMultiActivity((Context)var3_4, (Set<? extends AccessibilityNodeInfo>)nodes);
                        v1 = Unit.INSTANCE;
lbl39:
                        // 2 sources

                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final void handleActionStopMultiNode() {
        Disposable disposable = this.multiDisposable;
        if (disposable == null ? false : !disposable.isDisposed()) {
            Disposable disposable2 = this.multiDisposable;
            if (disposable2 != null) {
                disposable2.dispose();
            }
        }
        AccessibilityNodeInfo accessibilityNodeInfo = this.rootNodeInfo;
        if (accessibilityNodeInfo != null) {
            accessibilityNodeInfo.recycle();
        }
        this.rootNodeInfo = null;
        this.log("handleActionStopMultiNode, this.rootNodeInfo = null");
        this.getNodeRectSet().clear();
        this.lastPackageName = null;
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleActionDown(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof handleActionDown.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AccessService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AccessService.access$handleActionDown(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = nodes = new LinkedHashSet<AccessibilityNodeInfo>();
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LinkedHashSet<AccessibilityNodeInfo>>, Object>(this, nodes, null){
                    int label;
                    final /* synthetic */ AccessService this$0;
                    final /* synthetic */ LinkedHashSet<AccessibilityNodeInfo> $nodes;
                    {
                        this.this$0 = $receiver;
                        this.$nodes = $nodes;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                LinkedHashSet linkedHashSet;
                                ResultKt.throwOnFailure((Object)object);
                                try {
                                    AccessibilityNodeInfo rootNodeInfo = AccessService.access$rootNodeInfo(this.this$0);
                                    linkedHashSet = AccessService.access$findNodes(this.this$0, rootNodeInfo, this.$nodes);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                    linkedHashSet = this.$nodes;
                                }
                                return linkedHashSet;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super LinkedHashSet<AccessibilityNodeInfo>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                nodes = (LinkedHashSet<AccessibilityNodeInfo>)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(nodes, null){
                    int label;
                    final /* synthetic */ LinkedHashSet<AccessibilityNodeInfo> $nodes;
                    {
                        this.$nodes = $nodes;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Message message = Message.obtain(null, (int)10, this.$nodes);
                                Intrinsics.checkNotNullExpressionValue((Object)message, (String)"obtain(null, EVENT_NODE_INFO_DOWN, nodes)");
                                RxRelay.INSTANCE.post(message);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl31
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl31:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final AccessibilityNodeInfo rootNodeInfo() {
        AccessibilityNodeInfo nodeInfo;
        this.log("rootNodeInfo, this.rootNodeInfo is null:(" + this.rootNodeInfo + ')');
        AccessibilityNodeInfo accessibilityNodeInfo = this.rootNodeInfo;
        if (accessibilityNodeInfo == null) {
            accessibilityNodeInfo = this.getRootInActiveWindow();
        }
        AccessibilityNodeInfo accessibilityNodeInfo2 = nodeInfo = accessibilityNodeInfo;
        CharSequence nodePackage = accessibilityNodeInfo2 == null ? null : accessibilityNodeInfo2.getPackageName();
        this.log("rootNodeInfo, nodeInfo is :(" + nodeInfo + "), nodePackage is " + nodePackage + ", currentPackageName is " + currentPackageName);
        if (nodePackage != null && !Intrinsics.areEqual((Object)nodePackage, (Object)currentPackageName)) {
            this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_PACKAGE_CHANGED).putExtra(EXTRA_PACKAGE_NAME, nodePackage));
            currentPackageName = nodePackage;
        }
        return nodeInfo;
    }

    private final LinkedHashSet<AccessibilityNodeInfo> findNodes(AccessibilityNodeInfo rootNodeInfo, LinkedHashSet<AccessibilityNodeInfo> nodesContainer) {
        this.rootNodeInfo = rootNodeInfo;
        AccessibilityNodeInfo accessibilityNodeInfo = rootNodeInfo;
        this.lastPackageName = accessibilityNodeInfo == null ? null : accessibilityNodeInfo.getPackageName();
        AccessibilityNodeInfo accessibilityNodeInfo2 = rootNodeInfo;
        if (accessibilityNodeInfo2 != null) {
            AccessibilityNodeInfo accessibilityNodeInfo3;
            AccessibilityNodeInfo $this$findNodes_u24lambda_u2d0 = accessibilityNodeInfo3 = accessibilityNodeInfo2;
            boolean bl = false;
            AccessibilityNodeInfo nodeInfo = AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)$this$findNodes_u24lambda_u2d0);
            Intrinsics.checkNotNullExpressionValue((Object)nodeInfo, (String)"nodeInfo");
            this.recursionNodeCate(nodeInfo, nodesContainer);
        }
        return nodesContainer;
    }

    private final void findNodeByPoint(AccessibilityNodeInfo nodeInfo, int x, int y, ArrayList<AccessibilityNodeInfo> nodeInfoList) {
        int childCount = nodeInfo.getChildCount();
        String viewIdResourceName = nodeInfo.getViewIdResourceName();
        int n = 0;
        while (n < childCount) {
            int index = n++;
            AccessibilityNodeInfo accessibilityNodeInfo = nodeInfo.getChild(index);
            if (accessibilityNodeInfo == null) continue;
            AccessibilityNodeInfo child = accessibilityNodeInfo;
            this.findNodeByPoint(child, x, y, nodeInfoList);
            return;
        }
        nodeInfo.getBoundsInScreen(this.pointNodeBound);
        if (this.pointNodeBound.contains(x, y)) {
            nodeInfoList.add(nodeInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void recursionNodeCate(AccessibilityNodeInfo nodeInfo, LinkedHashSet<AccessibilityNodeInfo> nodeSet) {
        void it;
        CharSequence charSequence;
        String string2;
        int childCount = nodeInfo.getChildCount();
        CharSequence charSequence2 = nodeInfo.getText();
        String text = charSequence2 == null ? null : ((string2 = ((Object)charSequence2).toString()) == null ? null : ((Object)StringsKt.trim((CharSequence)string2)).toString());
        CharSequence charSequence3 = nodeInfo.getContentDescription();
        CharSequence contentDescription = charSequence3 == null ? null : StringsKt.trim((CharSequence)charSequence3);
        CharSequence className = nodeInfo.getClassName();
        CharSequence packageName = nodeInfo.getPackageName();
        boolean isVisibleToUser = nodeInfo.isVisibleToUser();
        boolean isContentInvalid = nodeInfo.isContentInvalid();
        String viewIdResourceName = nodeInfo.getViewIdResourceName();
        if (!(!isVisibleToUser || Intrinsics.areEqual((Object)(charSequence = className), (Object)ImageView.class.getName()) || Intrinsics.areEqual((Object)charSequence, (Object)ImageButton.class.getName()) || Intrinsics.areEqual((Object)charSequence, (Object)WebView.class.getName()) || Intrinsics.areEqual((Object)charSequence, (Object)SeekBar.class.getName()) || Intrinsics.areEqual((Object)charSequence, (Object)ProgressBar.class.getName()) || Intrinsics.areEqual((Object)charSequence, (Object)VideoView.class.getName()))) {
            if (Intrinsics.areEqual((Object)charSequence, (Object)ViewGroup.class.getName())) {
                if (!TextUtils.isEmpty((CharSequence)contentDescription) && !isContentInvalid || !TextUtils.isEmpty((CharSequence)text)) {
                    nodeSet.add(nodeInfo);
                }
            } else if (!TextUtils.isEmpty((CharSequence)text)) {
                nodeSet.add(nodeInfo);
            } else if (!TextUtils.isEmpty((CharSequence)contentDescription) && !isContentInvalid) {
                if (Build.VERSION.SDK_INT >= 24) {
                    int drawingOrder = nodeInfo.getDrawingOrder();
                    if (drawingOrder > 0) {
                        nodeSet.add(nodeInfo);
                    }
                } else {
                    nodeSet.add(nodeInfo);
                }
            }
        }
        AccessibilityNodeInfo drawingOrder = nodeInfo;
        StringBuilder stringBuilder = new StringBuilder().append("nodeInfo#className=").append((Object)className).append("\ttext=").append((Object)text).append("\tpackageName=").append((Object)packageName).append("\tcontentDescription=").append((Object)contentDescription).append("\tisVisibleToUser=").append(isVisibleToUser).append("\tisContentInvalid=").append(isContentInvalid).append("\tviewIdResourceName=").append((Object)viewIdResourceName).append("\tchildCount=").append(childCount).append("\tdrawingOrder=");
        AccessService accessService = this;
        boolean bl = false;
        int n = Build.VERSION.SDK_INT >= 24 ? it.getDrawingOrder() : 0;
        accessService.log(stringBuilder.append(n).toString());
        int n2 = 0;
        while (n2 < childCount) {
            AccessibilityNodeInfo child;
            int index;
            if (nodeInfo.getChild(index = n2++) == null) continue;
            if (nodeSet.size() > 100) break;
            this.recursionNodeCate(child, nodeSet);
        }
    }

    private final boolean shouldRefresh(LinkedHashSet<AccessibilityNodeInfo> nodeSet) {
        int size = nodeSet.size();
        float percent = 0.5f;
        float progress = 0.0f;
        HashSet<String> temp = new HashSet<String>();
        for (AccessibilityNodeInfo info : nodeSet) {
            Rect rectInScreen = new Rect();
            info.getBoundsInScreen(rectInScreen);
            Intrinsics.checkNotNullExpressionValue((Object)info, (String)"info");
            String key = AccessServiceKt.nodeKey(info, rectInScreen);
            if (this.getNodeRectSet().contains(key)) {
                float f = progress;
                progress = f + 1.0f;
            }
            temp.add(key);
        }
        this.getNodeRectSet().clear();
        this.getNodeRectSet().addAll((Collection<String>)temp);
        temp.clear();
        this.log("progress====" + progress + "   nodeRectSet.size=" + this.getNodeRectSet().size() + "  " + progress / (float)this.getNodeRectSet().size());
        if (size == 0) {
            return true;
        }
        return progress / (float)this.getNodeRectSet().size() < percent;
    }

    protected boolean onGesture(int gestureId) {
        this.log(Intrinsics.stringPlus((String)"gestureId=", (Object)gestureId));
        return super.onGesture(gestureId);
    }

    public void onInterrupt() {
        this.log("onInterrupt");
    }

    @RequiresApi(value=4)
    public void onAccessibilityEvent(@Nullable AccessibilityEvent event) {
        BuildersKt.launch$default((CoroutineScope)this.getMainScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(event, this, null){
            int label;
            final /* synthetic */ AccessibilityEvent $event;
            final /* synthetic */ AccessService this$0;
            {
                this.$event = $event;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (!GlobalTranslateApi.isInit()) {
                            return Unit.INSTANCE;
                        }
                        AccessibilityEvent accessibilityEvent = this.$event;
                        CharSequence packageName = accessibilityEvent == null ? null : accessibilityEvent.getPackageName();
                        AccessibilityEvent accessibilityEvent2 = this.$event;
                        if (!Intrinsics.areEqual((Object)(accessibilityEvent2 == null ? null : Boxing.boxInt((int)accessibilityEvent2.getWindowId())), (Object)AccessService.access$getCurrentWindowId$p(this.this$0)) && !TextUtils.isEmpty((CharSequence)packageName)) {
                            Message message = Message.obtain(null, (int)30, (Object)packageName);
                            Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
                            RxRelay.INSTANCE.post(message);
                        }
                        AccessibilityEvent accessibilityEvent3 = this.$event;
                        AccessService.access$setCurrentWindowId$p(this.this$0, accessibilityEvent3 == null ? null : Boxing.boxInt((int)accessibilityEvent3.getWindowId()));
                        AccessService.access$setAccessibilityEvent$p(this.this$0, true);
                        AccessService.access$setRootNodeInfo$p(this.this$0, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    protected void onServiceConnected() {
        super.onServiceConnected();
        Log.Companion.i(TAG, "onServiceConnected");
        this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_SERVICE_CONNECTED));
        isAccessibilityServiceRun = true;
        AccessibilityServiceState.INSTANCE.setAccessibilityServiceSetupCount(SharedPreferKt.updateAccessibilityServiceSetupCount((Context)this));
        AccessibilityServiceState.INSTANCE.isAccessibilityServiceRunning().postValue((Object)true);
    }

    public boolean onUnbind(@Nullable Intent intent) {
        this.log("onUnbind");
        isAccessibilityServiceRun = false;
        Log.Companion.i(TAG, "onUnbind");
        this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_UN_BIND));
        AccessibilityServiceState.INSTANCE.isAccessibilityServiceRunning().postValue((Object)false);
        return true;
    }

    public void onRebind(@Nullable Intent intent) {
        super.onRebind(intent);
        this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_RE_BIND));
        isAccessibilityServiceRun = true;
        Log.Companion.i(TAG, "onRebind");
        AccessibilityServiceState.INSTANCE.isAccessibilityServiceRunning().postValue((Object)true);
    }

    @Override
    public void run() {
    }

    public void onDestroy() {
        super.onDestroy();
        this.log("onDestroy");
        isAccessibilityServiceRun = false;
        this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_DESTROY));
        AccessibilityServiceState.INSTANCE.isAccessibilityServiceRunning().postValue((Object)false);
    }

    public static final /* synthetic */ void access$log(AccessService $this, String message) {
        $this.log(message);
    }

    public static final /* synthetic */ Object access$handleActionStartSingleMultiNode(AccessService $this, Continuation $completion) {
        return $this.handleActionStartSingleMultiNode((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$handleActionStopMultiNode(AccessService $this) {
        $this.handleActionStopMultiNode();
    }

    public static final /* synthetic */ Object access$handleActionDown(AccessService $this, Continuation $completion) {
        return $this.handleActionDown((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleActionPoint(AccessService $this, Intent intent, Continuation $completion) {
        return $this.handleActionPoint(intent, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ AccessibilityNodeInfo access$rootNodeInfo(AccessService $this) {
        return $this.rootNodeInfo();
    }

    public static final /* synthetic */ LinkedHashSet access$findNodes(AccessService $this, AccessibilityNodeInfo rootNodeInfo, LinkedHashSet nodesContainer) {
        return $this.findNodes(rootNodeInfo, nodesContainer);
    }

    public static final /* synthetic */ Integer access$getCurrentWindowId$p(AccessService $this) {
        return $this.currentWindowId;
    }

    public static final /* synthetic */ void access$setCurrentWindowId$p(AccessService $this, Integer n) {
        $this.currentWindowId = n;
    }

    public static final /* synthetic */ void access$setAccessibilityEvent$p(AccessService $this, boolean bl) {
        $this.isAccessibilityEvent = bl;
    }

    public static final /* synthetic */ void access$setRootNodeInfo$p(AccessService $this, AccessibilityNodeInfo accessibilityNodeInfo) {
        $this.rootNodeInfo = accessibilityNodeInfo;
    }

    static {
        String string2 = AccessService.class.getCanonicalName();
        accessibilityCanonicalName = string2 == null ? "com.talpa.inner.overlay.service.AccessService" : string2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010!\"\u0004\b\"\u0010#\u00a8\u0006*"}, d2={"Lcom/talpa/inner/overlay/service/AccessService$Companion;", "", "()V", "ACTION_DOWN", "", "ACTION_NODES_START", "ACTION_NODES_STOP", "ACTION_POINT", "BROADCAST_ACTION_DESTROY", "BROADCAST_ACTION_FLOATING_CLOSE", "BROADCAST_ACTION_FLOATING_OPEN", "BROADCAST_ACTION_PACKAGE_CHANGED", "BROADCAST_ACTION_RE_BIND", "BROADCAST_ACTION_SERVICE_CONNECTED", "BROADCAST_ACTION_UN_BIND", "EXTRA_PACKAGE_NAME", "EXTRA_POINT_X", "EXTRA_POINT_Y", "MILLIS_DELAY", "", "TAG", "accessibilityCanonicalName", "getAccessibilityCanonicalName", "()Ljava/lang/String;", "setAccessibilityCanonicalName", "(Ljava/lang/String;)V", "<set-?>", "", "currentPackageName", "getCurrentPackageName", "()Ljava/lang/CharSequence;", "isAccessibilityServiceRun", "", "()Z", "setAccessibilityServiceRun", "(Z)V", "startServiceForDown", "", "context", "Landroid/content/Context;", "startServiceForStartMultiNodes", "startServiceForStopMultiNodes", "ht-globaltranslate_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getAccessibilityCanonicalName() {
            return accessibilityCanonicalName;
        }

        public final void setAccessibilityCanonicalName(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            accessibilityCanonicalName = string2;
        }

        public final boolean isAccessibilityServiceRun() {
            return isAccessibilityServiceRun;
        }

        public final void setAccessibilityServiceRun(boolean bl) {
            isAccessibilityServiceRun = bl;
        }

        @Nullable
        public final CharSequence getCurrentPackageName() {
            return currentPackageName;
        }

        /*
         * WARNING - void declaration
         */
        public final void startServiceForStartMultiNodes(@NotNull Context context) {
            void $this$startServiceForStartMultiNodes_u24lambda_u2d0;
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent2 = intent = new Intent();
            Context context2 = context;
            boolean bl = false;
            $this$startServiceForStartMultiNodes_u24lambda_u2d0.setComponent(new ComponentName(context.getPackageName(), Companion.getAccessibilityCanonicalName()));
            $this$startServiceForStartMultiNodes_u24lambda_u2d0.setAction(AccessService.ACTION_NODES_START);
            context2.startService(intent);
        }

        /*
         * WARNING - void declaration
         */
        public final void startServiceForStopMultiNodes(@NotNull Context context) {
            void $this$startServiceForStopMultiNodes_u24lambda_u2d1;
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent2 = intent = new Intent();
            Context context2 = context;
            boolean bl = false;
            $this$startServiceForStopMultiNodes_u24lambda_u2d1.setComponent(new ComponentName(context.getPackageName(), Companion.getAccessibilityCanonicalName()));
            $this$startServiceForStopMultiNodes_u24lambda_u2d1.setAction(AccessService.ACTION_NODES_STOP);
            context2.startService(intent);
        }

        /*
         * WARNING - void declaration
         */
        public final void startServiceForDown(@NotNull Context context) {
            void $this$startServiceForDown_u24lambda_u2d2;
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent2 = intent = new Intent();
            Context context2 = context;
            boolean bl = false;
            $this$startServiceForDown_u24lambda_u2d2.setComponent(new ComponentName(context.getPackageName(), Companion.getAccessibilityCanonicalName()));
            $this$startServiceForDown_u24lambda_u2d2.setAction(AccessService.ACTION_DOWN);
            context2.startService(intent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

