/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.inner.overlay.state.framework;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.talpa.inner.overlay.state.framework.IState;
import com.talpa.inner.overlay.state.framework.State;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;

public class StateMachine {
    private static final String TAG = "StateMachine";
    private String mName;
    private static final int SM_QUIT_CMD = -1;
    private static final int SM_INIT_CMD = -2;
    public static final boolean HANDLED = true;
    public static final boolean NOT_HANDLED = false;
    private SmHandler mSmHandler;
    private HandlerThread mSmThread;

    private void initStateMachine(String name, Looper looper) {
        this.mName = name;
        this.mSmHandler = new SmHandler(looper, this);
    }

    protected StateMachine(String name) {
        this.mSmThread = new HandlerThread(name);
        this.mSmThread.start();
        Looper looper = this.mSmThread.getLooper();
        this.initStateMachine(name, looper);
    }

    protected StateMachine(String name, Looper looper) {
        this.initStateMachine(name, looper);
    }

    protected final void addState(State state, State parent) {
        this.mSmHandler.addState(state, parent);
    }

    protected final Message getCurrentMessage() {
        return this.mSmHandler.getCurrentMessage();
    }

    protected final IState getCurrentState() {
        return this.mSmHandler.getCurrentState();
    }

    protected final void addState(State state) {
        this.mSmHandler.addState(state, null);
    }

    protected final void setInitialState(State initialState) {
        this.mSmHandler.setInitialState(initialState);
    }

    protected final void transitionTo(IState destState) {
        this.mSmHandler.transitionTo(destState);
    }

    protected final void transitionToHaltingState() {
        this.mSmHandler.transitionTo(this.mSmHandler.mHaltingState);
    }

    protected final void deferMessage(Message msg) {
        this.mSmHandler.deferMessage(msg);
    }

    protected void unhandledMessage(Message msg) {
        if (this.mSmHandler.mDbg) {
            Log.e((String)TAG, (String)(this.mName + " - unhandledMessage: msg.what=" + msg.what));
        }
    }

    protected void haltedProcessMessage(Message msg) {
    }

    protected void onHalting() {
    }

    protected void onQuitting() {
    }

    public final String getName() {
        return this.mName;
    }

    public final void setLogRecSize(int maxSize) {
        this.mSmHandler.mLogRecords.setSize(maxSize);
    }

    public final int getLogRecSize() {
        return this.mSmHandler.mLogRecords.size();
    }

    public final int getLogRecCount() {
        return this.mSmHandler.mLogRecords.count();
    }

    public final LogRec getLogRec(int index) {
        return this.mSmHandler.mLogRecords.get(index);
    }

    protected void addLogRec(String string) {
        this.mSmHandler.mLogRecords.add(null, string, null, null);
    }

    protected void addLogRec(String string, State state) {
        this.mSmHandler.mLogRecords.add(null, string, state, null);
    }

    protected boolean recordLogRec(Message msg) {
        return true;
    }

    protected String getLogRecString(Message msg) {
        return "";
    }

    protected String getWhatToString(int what) {
        return null;
    }

    public final Handler getHandler() {
        return this.mSmHandler;
    }

    public final Message obtainMessage() {
        if (this.mSmHandler == null) {
            return null;
        }
        return Message.obtain((Handler)this.mSmHandler);
    }

    public final Message obtainMessage(int what) {
        if (this.mSmHandler == null) {
            return null;
        }
        return Message.obtain((Handler)this.mSmHandler, (int)what);
    }

    public final Message obtainMessage(int what, Object obj) {
        if (this.mSmHandler == null) {
            return null;
        }
        return Message.obtain((Handler)this.mSmHandler, (int)what, (Object)obj);
    }

    public final Message obtainMessage(int what, int arg1, int arg2) {
        if (this.mSmHandler == null) {
            return null;
        }
        return Message.obtain((Handler)this.mSmHandler, (int)what, (int)arg1, (int)arg2);
    }

    public final Message obtainMessage(int what, int arg1, int arg2, Object obj) {
        if (this.mSmHandler == null) {
            return null;
        }
        return Message.obtain((Handler)this.mSmHandler, (int)what, (int)arg1, (int)arg2, (Object)obj);
    }

    public final void sendMessage(int what) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.sendMessage(this.obtainMessage(what));
    }

    public final void sendMessage(int what, Object obj) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.sendMessage(this.obtainMessage(what, obj));
    }

    public final void sendMessage(Message msg) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.sendMessage(msg);
    }

    public final void sendMessageDelayed(int what, long delayMillis) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.sendMessageDelayed(this.obtainMessage(what), delayMillis);
    }

    public final void sendMessageDelayed(int what, Object obj, long delayMillis) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.sendMessageDelayed(this.obtainMessage(what, obj), delayMillis);
    }

    public final void sendMessageDelayed(Message msg, long delayMillis) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.sendMessageDelayed(msg, delayMillis);
    }

    protected final void sendMessageAtFrontOfQueue(int what, Object obj) {
        this.mSmHandler.sendMessageAtFrontOfQueue(this.obtainMessage(what, obj));
    }

    protected final void sendMessageAtFrontOfQueue(int what) {
        this.mSmHandler.sendMessageAtFrontOfQueue(this.obtainMessage(what));
    }

    protected final void sendMessageAtFrontOfQueue(Message msg) {
        this.mSmHandler.sendMessageAtFrontOfQueue(msg);
    }

    protected final void removeMessages(int what) {
        this.mSmHandler.removeMessages(what);
    }

    protected final void quit() {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.quit();
    }

    protected final void quitNow() {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.quitNow();
    }

    public boolean isDbg() {
        if (this.mSmHandler == null) {
            return false;
        }
        return this.mSmHandler.isDbg();
    }

    public void setDbg(boolean dbg) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.setDbg(dbg);
    }

    public void start() {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.completeConstruction();
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println(this.getName() + ":");
        pw.println(" total records=" + this.getLogRecCount());
        for (int i = 0; i < this.getLogRecSize(); ++i) {
            pw.printf(" rec[%d]: %s\n", i, this.getLogRec(i).toString(this));
            pw.flush();
        }
        pw.println("curState=" + this.getCurrentState().getName());
    }

    private static class SmHandler
    extends Handler {
        private boolean mDbg = false;
        private static final Object mSmHandlerObj = new Object();
        private Message mMsg;
        private LogRecords mLogRecords = new LogRecords();
        private boolean mIsConstructionCompleted;
        private StateInfo[] mStateStack;
        private int mStateStackTopIndex = -1;
        private StateInfo[] mTempStateStack;
        private int mTempStateStackCount;
        private HaltingState mHaltingState = new HaltingState();
        private QuittingState mQuittingState = new QuittingState();
        private StateMachine mSm;
        private HashMap<State, StateInfo> mStateInfo = new HashMap();
        private State mInitialState;
        private State mDestState;
        private ArrayList<Message> mDeferredMessages = new ArrayList();

        public final void handleMessage(Message msg) {
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)("handleMessage: E msg.what=" + msg.what));
            }
            this.mMsg = msg;
            if (this.mIsConstructionCompleted) {
                this.processMsg(msg);
            } else if (!this.mIsConstructionCompleted && this.mMsg.what == -2 && this.mMsg.obj == mSmHandlerObj) {
                this.mIsConstructionCompleted = true;
                this.invokeEnterMethods(0);
            } else {
                throw new RuntimeException("StateMachine.handleMessage: The start method not called, received msg: " + msg);
            }
            this.performTransitions();
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)"handleMessage: X");
            }
        }

        private void performTransitions() {
            State destState = null;
            while (this.mDestState != null) {
                if (this.mDbg) {
                    Log.d((String)StateMachine.TAG, (String)"handleMessage: new destination call exit");
                }
                destState = this.mDestState;
                this.mDestState = null;
                StateInfo commonStateInfo = this.setupTempStateStackWithStatesToEnter(destState);
                this.invokeExitMethods(commonStateInfo);
                int stateStackEnteringIndex = this.moveTempStateStackToStateStack();
                this.invokeEnterMethods(stateStackEnteringIndex);
                this.moveDeferredMessageAtFrontOfQueue();
            }
            if (destState != null) {
                if (destState == this.mQuittingState) {
                    this.mSm.onQuitting();
                    this.cleanupAfterQuitting();
                } else if (destState == this.mHaltingState) {
                    this.mSm.onHalting();
                }
            }
        }

        private final void cleanupAfterQuitting() {
            if (this.mSm.mSmThread != null) {
                this.getLooper().quit();
                this.mSm.mSmThread = null;
            }
            this.mSm.mSmHandler = null;
            this.mSm = null;
            this.mMsg = null;
            this.mLogRecords.cleanup();
            this.mStateStack = null;
            this.mTempStateStack = null;
            this.mStateInfo.clear();
            this.mInitialState = null;
            this.mDestState = null;
            this.mDeferredMessages.clear();
        }

        private final void completeConstruction() {
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)"completeConstruction: E");
            }
            int maxDepth = 0;
            for (StateInfo si : this.mStateInfo.values()) {
                int depth = 0;
                StateInfo i = si;
                while (i != null) {
                    i = i.parentStateInfo;
                    ++depth;
                }
                if (maxDepth >= depth) continue;
                maxDepth = depth;
            }
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)("completeConstruction: maxDepth=" + maxDepth));
            }
            this.mStateStack = new StateInfo[maxDepth];
            this.mTempStateStack = new StateInfo[maxDepth];
            this.setupInitialStateStack();
            this.sendMessageAtFrontOfQueue(this.obtainMessage(-2, mSmHandlerObj));
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)"completeConstruction: X");
            }
        }

        private final void processMsg(Message msg) {
            StateInfo curStateInfo = this.mStateStack[this.mStateStackTopIndex];
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)("processMsg: " + curStateInfo.state.getName()));
            }
            if (this.isQuit(msg)) {
                this.transitionTo(this.mQuittingState);
            } else {
                while (!curStateInfo.state.processMessage(msg)) {
                    curStateInfo = curStateInfo.parentStateInfo;
                    if (curStateInfo == null) {
                        this.mSm.unhandledMessage(msg);
                        break;
                    }
                    if (!this.mDbg) continue;
                    Log.d((String)StateMachine.TAG, (String)("processMsg: " + curStateInfo.state.getName()));
                }
                if (this.mSm.recordLogRec(msg)) {
                    if (curStateInfo != null) {
                        State orgState = this.mStateStack[this.mStateStackTopIndex].state;
                        this.mLogRecords.add(msg, this.mSm.getLogRecString(msg), curStateInfo.state, orgState);
                    } else {
                        this.mLogRecords.add(msg, this.mSm.getLogRecString(msg), null, null);
                    }
                }
            }
        }

        private final void invokeExitMethods(StateInfo commonStateInfo) {
            while (this.mStateStackTopIndex >= 0 && this.mStateStack[this.mStateStackTopIndex] != commonStateInfo) {
                State curState = this.mStateStack[this.mStateStackTopIndex].state;
                if (this.mDbg) {
                    Log.d((String)StateMachine.TAG, (String)("invokeExitMethods: " + curState.getName()));
                }
                curState.exit();
                this.mStateStack[this.mStateStackTopIndex].active = false;
                --this.mStateStackTopIndex;
            }
        }

        private final void invokeEnterMethods(int stateStackEnteringIndex) {
            for (int i = stateStackEnteringIndex; i <= this.mStateStackTopIndex; ++i) {
                if (this.mDbg) {
                    Log.d((String)StateMachine.TAG, (String)("invokeEnterMethods: " + this.mStateStack[i].state.getName()));
                }
                this.mStateStack[i].state.enter();
                this.mStateStack[i].active = true;
            }
        }

        private final void moveDeferredMessageAtFrontOfQueue() {
            for (int i = this.mDeferredMessages.size() - 1; i >= 0; --i) {
                Message curMsg = this.mDeferredMessages.get(i);
                if (this.mDbg) {
                    Log.d((String)StateMachine.TAG, (String)("moveDeferredMessageAtFrontOfQueue; what=" + curMsg.what));
                }
                this.sendMessageAtFrontOfQueue(curMsg);
            }
            this.mDeferredMessages.clear();
        }

        private final int moveTempStateStackToStateStack() {
            int startingIndex = this.mStateStackTopIndex + 1;
            int j = startingIndex;
            for (int i = this.mTempStateStackCount - 1; i >= 0; --i) {
                if (this.mDbg) {
                    Log.d((String)StateMachine.TAG, (String)("moveTempStackToStateStack: i=" + i + ",j=" + j));
                }
                this.mStateStack[j] = this.mTempStateStack[i];
                ++j;
            }
            this.mStateStackTopIndex = j - 1;
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)("moveTempStackToStateStack: X mStateStackTop=" + this.mStateStackTopIndex + ",startingIndex=" + startingIndex + ",Top=" + this.mStateStack[this.mStateStackTopIndex].state.getName()));
            }
            return startingIndex;
        }

        private final StateInfo setupTempStateStackWithStatesToEnter(State destState) {
            this.mTempStateStackCount = 0;
            StateInfo curStateInfo = this.mStateInfo.get(destState);
            do {
                this.mTempStateStack[this.mTempStateStackCount++] = curStateInfo;
            } while ((curStateInfo = curStateInfo.parentStateInfo) != null && !curStateInfo.active);
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)("setupTempStateStackWithStatesToEnter: X mTempStateStackCount=" + this.mTempStateStackCount + ",curStateInfo: " + curStateInfo));
            }
            return curStateInfo;
        }

        private final void setupInitialStateStack() {
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)("setupInitialStateStack: E mInitialState=" + this.mInitialState.getName()));
            }
            StateInfo curStateInfo = this.mStateInfo.get(this.mInitialState);
            this.mTempStateStackCount = 0;
            while (curStateInfo != null) {
                this.mTempStateStack[this.mTempStateStackCount] = curStateInfo;
                curStateInfo = curStateInfo.parentStateInfo;
                ++this.mTempStateStackCount;
            }
            this.mStateStackTopIndex = -1;
            this.moveTempStateStackToStateStack();
        }

        private final Message getCurrentMessage() {
            return this.mMsg;
        }

        private final IState getCurrentState() {
            return this.mStateStack[this.mStateStackTopIndex].state;
        }

        private final StateInfo addState(State state, State parent) {
            StateInfo stateInfo;
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)("addStateInternal: E state=" + state.getName() + ",parent=" + (parent == null ? "" : parent.getName())));
            }
            StateInfo parentStateInfo = null;
            if (parent != null && (parentStateInfo = this.mStateInfo.get(parent)) == null) {
                parentStateInfo = this.addState(parent, null);
            }
            if ((stateInfo = this.mStateInfo.get(state)) == null) {
                stateInfo = new StateInfo();
                this.mStateInfo.put(state, stateInfo);
            }
            if (stateInfo.parentStateInfo != null && stateInfo.parentStateInfo != parentStateInfo) {
                throw new RuntimeException("state already added");
            }
            stateInfo.state = state;
            stateInfo.parentStateInfo = parentStateInfo;
            stateInfo.active = false;
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)("addStateInternal: X stateInfo: " + stateInfo));
            }
            return stateInfo;
        }

        private SmHandler(Looper looper, StateMachine sm) {
            super(looper);
            this.mSm = sm;
            this.addState(this.mHaltingState, null);
            this.addState(this.mQuittingState, null);
        }

        private final void setInitialState(State initialState) {
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)("setInitialState: initialState=" + initialState.getName()));
            }
            this.mInitialState = initialState;
        }

        private final void transitionTo(IState destState) {
            this.mDestState = (State)destState;
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)("transitionTo: destState=" + this.mDestState.getName()));
            }
        }

        private final void deferMessage(Message msg) {
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)("deferMessage: msg=" + msg.what));
            }
            Message newMsg = this.obtainMessage();
            newMsg.copyFrom(msg);
            this.mDeferredMessages.add(newMsg);
        }

        private final void quit() {
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)"quit:");
            }
            this.sendMessage(this.obtainMessage(-1, mSmHandlerObj));
        }

        private final void quitNow() {
            if (this.mDbg) {
                Log.d((String)StateMachine.TAG, (String)"abort:");
            }
            this.sendMessageAtFrontOfQueue(this.obtainMessage(-1, mSmHandlerObj));
        }

        private final boolean isQuit(Message msg) {
            return msg.what == -1 && msg.obj == mSmHandlerObj;
        }

        private final boolean isDbg() {
            return this.mDbg;
        }

        private final void setDbg(boolean dbg) {
            this.mDbg = dbg;
        }

        private class QuittingState
        extends State {
            private QuittingState() {
            }

            @Override
            public boolean processMessage(Message msg) {
                return false;
            }
        }

        private class HaltingState
        extends State {
            private HaltingState() {
            }

            @Override
            public boolean processMessage(Message msg) {
                SmHandler.this.mSm.haltedProcessMessage(msg);
                return true;
            }
        }

        private class StateInfo {
            State state;
            StateInfo parentStateInfo;
            boolean active;

            private StateInfo() {
            }

            public String toString() {
                return "state=" + this.state.getName() + ",active=" + this.active + ",parent=" + (this.parentStateInfo == null ? "null" : this.parentStateInfo.state.getName());
            }
        }
    }

    private static class LogRecords {
        private static final int DEFAULT_SIZE = 20;
        private Vector<LogRec> mLogRecords = new Vector();
        private int mMaxSize = 20;
        private int mOldestIndex = 0;
        private int mCount = 0;

        private LogRecords() {
        }

        synchronized void setSize(int maxSize) {
            this.mMaxSize = maxSize;
            this.mCount = 0;
            this.mLogRecords.clear();
        }

        synchronized int size() {
            return this.mLogRecords.size();
        }

        synchronized int count() {
            return this.mCount;
        }

        synchronized void cleanup() {
            this.mLogRecords.clear();
        }

        synchronized LogRec get(int index) {
            int nextIndex = this.mOldestIndex + index;
            if (nextIndex >= this.mMaxSize) {
                nextIndex -= this.mMaxSize;
            }
            if (nextIndex >= this.size()) {
                return null;
            }
            return this.mLogRecords.get(nextIndex);
        }

        synchronized void add(Message msg, String messageInfo, State state, State orgState) {
            ++this.mCount;
            if (this.mLogRecords.size() < this.mMaxSize) {
                this.mLogRecords.add(new LogRec(msg, messageInfo, state, orgState));
            } else {
                LogRec pmi = this.mLogRecords.get(this.mOldestIndex);
                ++this.mOldestIndex;
                if (this.mOldestIndex >= this.mMaxSize) {
                    this.mOldestIndex = 0;
                }
                pmi.update(msg, messageInfo, state, orgState);
            }
        }
    }

    public static class LogRec {
        private long mTime;
        private int mWhat;
        private String mInfo;
        private State mState;
        private State mOrgState;

        LogRec(Message msg, String info, State state, State orgState) {
            this.update(msg, info, state, orgState);
        }

        public void update(Message msg, String info, State state, State orgState) {
            this.mTime = System.currentTimeMillis();
            this.mWhat = msg != null ? msg.what : 0;
            this.mInfo = info;
            this.mState = state;
            this.mOrgState = orgState;
        }

        public long getTime() {
            return this.mTime;
        }

        public long getWhat() {
            return this.mWhat;
        }

        public String getInfo() {
            return this.mInfo;
        }

        public State getState() {
            return this.mState;
        }

        public State getOriginalState() {
            return this.mOrgState;
        }

        public String toString(StateMachine sm) {
            StringBuilder sb = new StringBuilder();
            sb.append("time=");
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(this.mTime);
            sb.append(String.format("%tm-%td %tH:%tM:%tS.%tL", c, c, c, c, c, c));
            sb.append(" state=");
            sb.append(this.mState == null ? "<null>" : this.mState.getName());
            sb.append(" orgState=");
            sb.append(this.mOrgState == null ? "<null>" : this.mOrgState.getName());
            sb.append(" what=");
            String what = sm.getWhatToString(this.mWhat);
            if (TextUtils.isEmpty((CharSequence)what)) {
                sb.append(this.mWhat);
                sb.append("(0x");
                sb.append(Integer.toHexString(this.mWhat));
                sb.append(")");
            } else {
                sb.append(what);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mInfo)) {
                sb.append(" ");
                sb.append(this.mInfo);
            }
            return sb.toString();
        }
    }
}

