/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.inner.overlay.tools;

import android.content.Context;
import android.os.Binder;
import android.os.Build;
import android.provider.Settings;
import com.talpa.inner.overlay.Log;
import com.talpa.inner.overlay.service.AccessService;
import com.talpa.inner.overlay.tools.AccessibilityPermissionKt;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\b\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0003\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u0003H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0003\u001a\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u0003H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"invokeCheckOp", "", "context", "Landroid/content/Context;", "method", "Ljava/lang/reflect/Method;", "appOpsService", "", "isXiaoMi", "xiaoMiAlertWindowAllowed", "canDrawOverlays", "canDrawOverlaysSuspend", "(Landroid/content/Context;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isAccessibilityEnabled", "isAccessibilityEnabledSus", "ht-globaltranslate_release"})
public final class PermissionHelperKt {
    @Nullable
    public static final Object canDrawOverlaysSuspend(@NotNull Context $this$canDrawOverlaysSuspend, @NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>($this$canDrawOverlaysSuspend, null){
            int label;
            final /* synthetic */ Context $this_canDrawOverlaysSuspend;
            {
                this.$this_canDrawOverlaysSuspend = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        if (Build.VERSION.SDK_INT >= 23) {
                            bl = Settings.canDrawOverlays((Context)this.$this_canDrawOverlaysSuspend.getApplicationContext());
                        } else if (PermissionHelperKt.access$isXiaoMi()) {
                            Context context = this.$this_canDrawOverlaysSuspend.getApplicationContext();
                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                            bl = PermissionHelperKt.access$xiaoMiAlertWindowAllowed(context);
                        } else {
                            bl = true;
                        }
                        return Boxing.boxBoolean((boolean)bl);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final boolean canDrawOverlays(@NotNull Context $this$canDrawOverlays) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$canDrawOverlays, (String)"<this>");
        if (Build.VERSION.SDK_INT >= 23) {
            bl = Settings.canDrawOverlays((Context)$this$canDrawOverlays.getApplicationContext());
        } else if (PermissionHelperKt.isXiaoMi()) {
            Context context = $this$canDrawOverlays.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            bl = PermissionHelperKt.xiaoMiAlertWindowAllowed(context);
        } else {
            bl = true;
        }
        return bl;
    }

    @Nullable
    public static final Object isAccessibilityEnabledSus(@NotNull Context $this$isAccessibilityEnabledSus, @NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>($this$isAccessibilityEnabledSus, null){
            int label;
            final /* synthetic */ Context $this_isAccessibilityEnabledSus;
            {
                this.$this_isAccessibilityEnabledSus = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        if (AccessService.Companion.isAccessibilityServiceRun()) {
                            Context context = this.$this_isAccessibilityEnabledSus.getApplicationContext();
                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                            if (AccessibilityPermissionKt.isAccessibilitySettingsOn$default(context, null, 2, null)) {
                                bl = true;
                                return Boxing.boxBoolean((boolean)bl);
                            }
                        }
                        bl = false;
                        return Boxing.boxBoolean((boolean)bl);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAccessibilityEnabled(@NotNull Context $this$isAccessibilityEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isAccessibilityEnabled, (String)"<this>");
        if (!AccessService.Companion.isAccessibilityServiceRun()) return false;
        Context context = $this$isAccessibilityEnabled.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        if (!AccessibilityPermissionKt.isAccessibilitySettingsOn$default(context, null, 2, null)) return false;
        return true;
    }

    private static final boolean isXiaoMi() {
        return StringsKt.equals((String)"XiaoMi", (String)Build.MANUFACTURER, (boolean)true);
    }

    private static final boolean xiaoMiAlertWindowAllowed(Context context) {
        try {
            Object object = context.getSystemService("appops");
            if (object == null) {
                return true;
            }
            Object mAppOpsService = object;
            Class<?> localClass = mAppOpsService.getClass();
            Class[] paramsClass = new Class[]{Integer.TYPE, Integer.TYPE, String.class};
            Method mCheckOpMethod = localClass.getMethod("checkOp", Arrays.copyOf(paramsClass, paramsClass.length));
            Intrinsics.checkNotNullExpressionValue((Object)mCheckOpMethod, (String)"mCheckOpMethod");
            return PermissionHelperKt.invokeCheckOp(context, mCheckOpMethod, mAppOpsService);
        }
        catch (Exception e) {
            Log.Companion.e("PermissionHelper", "isAlertWindowAllowed exception", e);
            return true;
        }
    }

    private static final boolean invokeCheckOp(Context context, Method method, Object appOpsService) {
        try {
            Object[] paramsValues = new Object[]{24, Binder.getCallingUid(), context.getPackageName()};
            Object result = method.invoke(appOpsService, Arrays.copyOf(paramsValues, paramsValues.length));
            if (result != null) {
                return (Integer)result == 0;
            }
        }
        catch (Exception e) {
            Log.Companion.i("PermissionHelper", "invokeCheckOp exception ", e);
        }
        return true;
    }

    public static final /* synthetic */ boolean access$isXiaoMi() {
        return PermissionHelperKt.isXiaoMi();
    }

    public static final /* synthetic */ boolean access$xiaoMiAlertWindowAllowed(Context context) {
        return PermissionHelperKt.xiaoMiAlertWindowAllowed(context);
    }
}

