/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.inner.overlay.view.overlay;

import android.content.Context;
import android.speech.tts.UtteranceProgressListener;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.widget.TextView;
import android.widget.Toast;
import androidx.compose.runtime.internal.StabilityInferred;
import com.talpa.inner.overlay.R;
import com.talpa.inner.overlay.tools.TextSpeech;
import com.talpa.inner.overlay.view.overlay.SimpleOverlayView;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/talpa/inner/overlay/view/overlay/SpeechOverlayView;", "Lcom/talpa/inner/overlay/view/overlay/SimpleOverlayView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "postTranslate", "", "translation", "", "targetLanguageTag", "tvTranslation", "Landroid/widget/TextView;", "removeContentView", "OnUtteranceProgressListener", "ht-globaltranslate_release"})
@StabilityInferred(parameters=0)
public final class SpeechOverlayView
extends SimpleOverlayView {
    public static final int $stable;

    public SpeechOverlayView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @Override
    public void postTranslate(@NotNull String translation, @NotNull String targetLanguageTag, @NotNull TextView tvTranslation) {
        Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
        Intrinsics.checkNotNullParameter((Object)targetLanguageTag, (String)"targetLanguageTag");
        Intrinsics.checkNotNullParameter((Object)tvTranslation, (String)"tvTranslation");
        super.postTranslate(translation, targetLanguageTag, tvTranslation);
        tvTranslation.setTextColor(this.getContext().getResources().getColor(R.color.color_floating_translation_speech_default));
        tvTranslation.setText((CharSequence)translation);
        if (this.getTextSpeech$ht_globaltranslate_release().isSpeaking()) {
            this.getTextSpeech$ht_globaltranslate_release().stopSpeak();
        }
        Locale locale = Locale.forLanguageTag(targetLanguageTag);
        TextSpeech textSpeech2 = this.getTextSpeech$ht_globaltranslate_release();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"locale");
        if (textSpeech2.isLanguageAvailable(locale)) {
            this.getTextSpeech$ht_globaltranslate_release().setOnUtteranceProgressListener(new OnUtteranceProgressListener(this.getContext(), tvTranslation, translation));
            if (!this.getTextSpeech$ht_globaltranslate_release().speak(translation, locale)) {
                Toast.makeText((Context)this.getContext().getApplicationContext(), (int)R.string.playback_error, (int)0).show();
            }
        } else {
            Toast.makeText((Context)this.getContext().getApplicationContext(), (int)R.string.playback_error, (int)0).show();
        }
    }

    @Override
    public void removeContentView() {
        super.removeContentView();
        this.getTextSpeech$ht_globaltranslate_release().setOnUtteranceProgressListener(null);
        if (this.getTextSpeech$ht_globaltranslate_release().isSpeaking()) {
            this.getTextSpeech$ht_globaltranslate_release().stopSpeak();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u0014\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0016J*\u0010\u0015\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0012\u0010\u0019\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/talpa/inner/overlay/view/overlay/SpeechOverlayView$OnUtteranceProgressListener;", "Landroid/speech/tts/UtteranceProgressListener;", "context", "Landroid/content/Context;", "textView", "Landroid/widget/TextView;", "translation", "", "(Landroid/content/Context;Landroid/widget/TextView;Ljava/lang/String;)V", "foregroundColorSpan", "Landroid/text/style/ForegroundColorSpan;", "getForegroundColorSpan", "()Landroid/text/style/ForegroundColorSpan;", "highlightColor", "", "getHighlightColor", "()I", "onDone", "", "utteranceId", "onError", "onRangeStart", "start", "end", "frame", "onStart", "ht-globaltranslate_release"})
    private static final class OnUtteranceProgressListener
    extends UtteranceProgressListener {
        @NotNull
        private final Context context;
        @NotNull
        private final TextView textView;
        @NotNull
        private final String translation;
        private final int highlightColor;
        @NotNull
        private final ForegroundColorSpan foregroundColorSpan;

        public OnUtteranceProgressListener(@NotNull Context context, @NotNull TextView textView, @NotNull String translation) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
            Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
            this.context = context;
            this.textView = textView;
            this.translation = translation;
            this.highlightColor = this.context.getResources().getColor(R.color.speech_highlight_color);
            this.foregroundColorSpan = new ForegroundColorSpan(this.highlightColor);
        }

        public final int getHighlightColor() {
            return this.highlightColor;
        }

        @NotNull
        public final ForegroundColorSpan getForegroundColorSpan() {
            return this.foregroundColorSpan;
        }

        public void onStart(@Nullable String utteranceId) {
            System.out.println((Object)("UtteranceProgress#utteranceId=" + utteranceId + "  onStart"));
        }

        public void onDone(@Nullable String utteranceId) {
            System.out.println((Object)("UtteranceProgress#utteranceId=" + utteranceId + "  onDone"));
            TextView $this$onDone_u24lambda_u2d1 = this.textView;
            boolean bl = false;
            $this$onDone_u24lambda_u2d1.post(() -> OnUtteranceProgressListener.onDone$lambda-1$lambda-0($this$onDone_u24lambda_u2d1, this));
        }

        public void onError(@Nullable String utteranceId) {
            System.out.println((Object)("UtteranceProgress#utteranceId=" + utteranceId + "  onError"));
        }

        public void onRangeStart(@Nullable String utteranceId, int start, int end, int frame) {
            super.onRangeStart(utteranceId, start, end, frame);
            try {
                TextView $this$onRangeStart_u24lambda_u2d3 = this.textView;
                boolean bl = false;
                $this$onRangeStart_u24lambda_u2d3.post(() -> OnUtteranceProgressListener.onRangeStart$lambda-3$lambda-2(this, start, end, $this$onRangeStart_u24lambda_u2d3));
                System.out.println((Object)("UtteranceProgress#onRangeStart#start=" + start + "  end=" + end + "  frame=" + frame));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private static final void onDone$lambda-1$lambda-0(TextView $this_with, OnUtteranceProgressListener this$0) {
            Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            $this_with.setText((CharSequence)this$0.translation);
        }

        /*
         * WARNING - void declaration
         */
        private static final void onRangeStart$lambda-3$lambda-2(OnUtteranceProgressListener this$0, int $start, int $end, TextView $this_with) {
            void $this$set$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
            CharSequence $this$toSpannable$iv = this$0.translation;
            boolean $i$f$toSpannable = false;
            SpannableString spannableString = SpannableString.valueOf((CharSequence)$this$toSpannable$iv);
            Intrinsics.checkNotNullExpressionValue((Object)spannableString, (String)"valueOf(this)");
            Spannable translationSpan = (Spannable)spannableString;
            $this$toSpannable$iv = translationSpan;
            ForegroundColorSpan span$iv = this$0.foregroundColorSpan;
            boolean $i$f$set = false;
            $this$set$iv.setSpan((Object)span$iv, $start, $end, 17);
            $this_with.setText((CharSequence)translationSpan);
        }
    }
}

