/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.inner.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.gson.Gson;
import com.hiservice.core.HaveFun;
import com.hiservice.textrecognize.VisionRecognizeKt;
import com.hiservice.translate.HiTranslator;
import com.hiservice.translate.HiTranslatorBuilderKt;
import com.talpa.inner.ITranslateCallback;
import com.talpa.inner.media.projection.MediaProjectionServiceKt;
import com.talpa.inner.media.projection.ui.MultiTranslateActivityKt;
import com.talpa.inner.media.projection.ui.MultiViewItem;
import com.talpa.inner.media.projection.widget.LoadViewManagerKt;
import com.talpa.inner.overlay.Log;
import com.talpa.inner.overlay.ocr.Block;
import com.talpa.inner.overlay.ocr.VisionRecognizeResult;
import com.talpa.inner.overlay.translate.MultiTranslateKt;
import com.talpa.inner.util.BitmapToTextUtil;
import com.talpa.inner.util.BitmapUtil;
import com.talpa.open.global.GlobalTranslateApi;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 72\u00020\u0001:\u00017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\nH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0015J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0015J\u0010\u0010\u001f\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010\"\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0002J\"\u0010&\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010'\u001a\u00020\nH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002JA\u0010,\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010-2\u0016\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\n0/j\b\u0012\u0004\u0012\u00020\n`02\u0006\u0010\u0016\u001a\u00020\n2\u0006\u00101\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b2\u00103J6\u00104\u001a\u0016\u0012\u0004\u0012\u000205\u0018\u00010/j\n\u0012\u0004\u0012\u000205\u0018\u0001`02\u0006\u00106\u001a\u00020\f2\b\b\u0002\u0010\u0016\u001a\u00020\n2\u0006\u00101\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00068"}, d2={"Lcom/talpa/inner/util/BitmapToTextUtil;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isDestroy", "", "mHaveFun", "Lcom/hiservice/core/HaveFun;", "mLastBitmapFilePath", "", "mLastOcrHistory", "Lcom/talpa/inner/overlay/ocr/VisionRecognizeResult;", "mMainHandler", "Landroid/os/Handler;", "getMMainHandler", "()Landroid/os/Handler;", "mMainHandler$delegate", "Lkotlin/Lazy;", "bitmapToText", "bitmap", "Landroid/graphics/Bitmap;", "fromLanguage", "cropOriginBitmap", "bitmapIn", "statusHeight", "", "decodeSourceBitmap", "destroy", "", "parseBitmap", "reOcrTranslate", "callback", "Lcom/talpa/inner/ITranslateCallback;", "reTranslate", "runOnMain", "runnable", "Ljava/lang/Runnable;", "saveBitmapToFile", "name", "toRect", "Landroid/graphics/Rect;", "block", "Lcom/talpa/inner/overlay/ocr/Block;", "translateTexts", "", "needTranslateTexts", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "toLanguage", "translateTexts$ht_globaltranslate_release", "(Ljava/util/ArrayList;Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "translates", "Lcom/talpa/inner/media/projection/ui/MultiViewItem;", "ocrHistory", "Companion", "ht-globaltranslate_release"})
@StabilityInferred(parameters=0)
public final class BitmapToTextUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private HaveFun mHaveFun;
    @NotNull
    private final Lazy mMainHandler$delegate;
    @Nullable
    private VisionRecognizeResult mLastOcrHistory;
    @Nullable
    private String mLastBitmapFilePath;
    private boolean isDestroy;
    public static final int $stable = 8;
    public static final int SUCCESS = 0;
    public static final int FAILED = 1;
    public static final int CANCEL = -1;

    public BitmapToTextUtil(@NotNull Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mMainHandler$delegate = LazyKt.lazy((Function0)mMainHandler.2.INSTANCE);
        String string3 = GlobalTranslateApi.INSTANCE.getAppKey$ht_globaltranslate_release();
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = GlobalTranslateApi.INSTANCE.getAppSecret$ht_globaltranslate_release()) == null) {
            string2 = "";
        }
        this.mHaveFun = HaveFun.Companion.initialization(context, string3, string2);
    }

    private final Handler getMMainHandler() {
        Lazy lazy = this.mMainHandler$delegate;
        return (Handler)lazy.getValue();
    }

    public final int parseBitmap(@NotNull Context context, @NotNull Bitmap bitmapIn) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmapIn, (String)"bitmapIn");
        this.runOnMain(() -> BitmapToTextUtil.parseBitmap$lambda-0(context));
        BitmapToTextUtil.saveBitmapToFile$default(this, context, bitmapIn, null, 4, null);
        int statusHeight = MediaProjectionServiceKt.statusBarHeight(context);
        Ref.BooleanRef isCropStatusBar = new Ref.BooleanRef();
        isCropStatusBar.element = true;
        Bitmap bitmap2 = this.cropOriginBitmap(bitmapIn, statusHeight);
        if (bitmap2 == null) {
            boolean bl = false;
            isCropStatusBar.element = false;
            Log.Companion.errorMsg$default(Log.Companion, "crop bitmap failed!!!, " + statusHeight + ", " + bitmapIn.getWidth() + ", " + bitmapIn.getHeight(), null, 2, null);
            bitmap = bitmapIn;
        } else {
            bitmap = bitmap2;
        }
        Bitmap bitmap3 = bitmap;
        VisionRecognizeResult bl = this.bitmapToText(bitmap3, MultiTranslateKt.multiFromLanguage());
        if (bl == null) {
            boolean bl2 = false;
            this.runOnMain(() -> BitmapToTextUtil.parseBitmap$lambda-3$lambda-2(context));
            return 1;
        }
        VisionRecognizeResult ocrHistory = bl;
        if (this.isDestroy) {
            Log.Companion.warnMsg$default(Log.Companion, "parseBitmap, bitmapToText, isDestroy.", null, 2, null);
            return -1;
        }
        ArrayList<MultiViewItem> items = this.translates(ocrHistory, MultiTranslateKt.multiFromLanguage(), MultiTranslateKt.multiTargetLanguage());
        if (this.isDestroy) {
            Log.Companion.warnMsg$default(Log.Companion, "parseBitmap, translates, isDestroy.", null, 2, null);
            return -1;
        }
        this.runOnMain(() -> BitmapToTextUtil.parseBitmap$lambda-4(this, items, context, isCropStatusBar));
        return 0;
    }

    private final Bitmap cropOriginBitmap(Bitmap bitmapIn, int statusHeight) {
        return BitmapUtil.cropBitmap(bitmapIn, 0, statusHeight, bitmapIn.getWidth(), bitmapIn.getHeight() - statusHeight, false);
    }

    private final void saveBitmapToFile(Context context, Bitmap bitmap, String name) {
        this.mLastBitmapFilePath = null;
        File file = new File(context.getApplicationContext().getExternalCacheDir(), name);
        if (file.exists()) {
            file.delete();
        }
        if (!BitmapUtil.saveBitmapToFile(bitmap, file)) {
            file.deleteOnExit();
        } else {
            this.mLastBitmapFilePath = file.getAbsolutePath();
        }
    }

    static /* synthetic */ void saveBitmapToFile$default(BitmapToTextUtil bitmapToTextUtil, Context context, Bitmap bitmap, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "image_last.jpg";
        }
        bitmapToTextUtil.saveBitmapToFile(context, bitmap, string2);
    }

    public final void reTranslate(@Nullable ITranslateCallback callback2) {
        VisionRecognizeResult visionRecognizeResult = this.mLastOcrHistory;
        if (visionRecognizeResult != null) {
            VisionRecognizeResult it = visionRecognizeResult;
            boolean bl = false;
            if (this.isDestroy) {
                Log.Companion.warnMsg$default(Log.Companion, "reTranslate, start, isDestroy.", null, 2, null);
                ITranslateCallback iTranslateCallback = callback2;
                if (iTranslateCallback != null) {
                    iTranslateCallback.onCancel();
                }
                return;
            }
            ArrayList<MultiViewItem> items = this.translates(it, "", MultiTranslateKt.multiTargetLanguage());
            if (this.isDestroy) {
                Log.Companion.warnMsg$default(Log.Companion, "reTranslate, translates, isDestroy.", null, 2, null);
                ITranslateCallback iTranslateCallback = callback2;
                if (iTranslateCallback != null) {
                    iTranslateCallback.onCancel();
                }
                return;
            }
            Collection collection = items;
            boolean success = !(collection == null || collection.isEmpty());
            ITranslateCallback iTranslateCallback = callback2;
            if (iTranslateCallback != null) {
                iTranslateCallback.onDoneTranslate(success, items);
            }
            return;
        }
        boolean bl = false;
        ITranslateCallback iTranslateCallback = callback2;
        if (iTranslateCallback != null) {
            iTranslateCallback.onDoneTranslate(false, null);
        }
    }

    public final void reOcrTranslate(@Nullable ITranslateCallback callback2) {
        VisionRecognizeResult ocrHistory;
        Bitmap bitmap = this.decodeSourceBitmap();
        if (bitmap == null) {
            boolean bl = false;
            ITranslateCallback iTranslateCallback = callback2;
            if (iTranslateCallback != null) {
                iTranslateCallback.onDoneTranslate(false, null);
            }
            return;
        }
        Bitmap bitmap2 = bitmap;
        VisionRecognizeResult visionRecognizeResult = this.bitmapToText(bitmap2, MultiTranslateKt.multiFromLanguage());
        if (visionRecognizeResult == null) {
            boolean bl = false;
            ITranslateCallback iTranslateCallback = callback2;
            if (iTranslateCallback != null) {
                iTranslateCallback.onDoneTranslate(false, null);
            }
            return;
        }
        VisionRecognizeResult it = ocrHistory = visionRecognizeResult;
        boolean bl = false;
        if (this.isDestroy) {
            Log.Companion.warnMsg$default(Log.Companion, "reTranslate, start, isDestroy.", null, 2, null);
            ITranslateCallback iTranslateCallback = callback2;
            if (iTranslateCallback != null) {
                iTranslateCallback.onCancel();
            }
            return;
        }
        ArrayList<MultiViewItem> items = this.translates(it, "", MultiTranslateKt.multiTargetLanguage());
        if (this.isDestroy) {
            Log.Companion.warnMsg$default(Log.Companion, "reTranslate, translates, isDestroy.", null, 2, null);
            ITranslateCallback iTranslateCallback = callback2;
            if (iTranslateCallback != null) {
                iTranslateCallback.onCancel();
            }
            return;
        }
        Collection collection = items;
        boolean success = !(collection == null || collection.isEmpty());
        ITranslateCallback iTranslateCallback = callback2;
        if (iTranslateCallback != null) {
            iTranslateCallback.onDoneTranslate(success, items);
        }
    }

    @Nullable
    public final Bitmap decodeSourceBitmap() {
        String string2 = this.mLastBitmapFilePath;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return BitmapFactory.decodeFile((String)it);
        }
        return null;
    }

    private final VisionRecognizeResult bitmapToText(Bitmap bitmap, String fromLanguage) {
        String string2;
        if (this.isDestroy) {
            Log.Companion.warnMsg$default(Log.Companion, "bitmapToText, start. isDestroy.", null, 2, null);
            return null;
        }
        String code = Intrinsics.areEqual((Object)fromLanguage, (Object)"auto") ? "" : fromLanguage;
        Log.Companion.infoMsg$default(Log.Companion, "bitmap to text, " + fromLanguage + ", " + code, null, 2, null);
        HaveFun haveFun = this.mHaveFun;
        String string3 = string2 = haveFun == null ? null : VisionRecognizeKt.visionChooseRecognizes((HaveFun)haveFun, (Bitmap)bitmap, (int)0, (String)code);
        if (string2 == null) {
            boolean bl = false;
            Log.Companion.errorMsg$default(Log.Companion, "bitmapToText, result text is null.", null, 2, null);
            return null;
        }
        String text = string2;
        if (this.isDestroy) {
            Log.Companion.warnMsg$default(Log.Companion, "bitmapToText, visionChooseRecognizes, isDestroy.", null, 2, null);
            return null;
        }
        VisionRecognizeResult ocrHistory = null;
        try {
            VisionRecognizeResult bl = (VisionRecognizeResult)new Gson().fromJson(text, VisionRecognizeResult.class);
            if (bl == null) {
                boolean bl2 = false;
                Log.Companion.errorMsg$default(Log.Companion, Intrinsics.stringPlus((String)"net error.text:", (Object)text), null, 2, null);
                return null;
            }
            ocrHistory = bl;
            Log.Companion.infoMsg$default(Log.Companion, "bitmap to text, code:" + ocrHistory.getCode() + ", msg:" + ocrHistory.getMsg(), null, 2, null);
            Iterable $this$forEach$iv = ocrHistory.getBlocks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Block it = (Block)element$iv;
                boolean bl3 = false;
                Log.Companion.infoMsg$default(Log.Companion, "bitmap to text:" + it.getText() + ", rect:" + it.getRect(), null, 2, null);
            }
            if (ocrHistory.getCode() != 200 && ocrHistory.getBlocks().isEmpty()) {
                ocrHistory = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mLastOcrHistory = ocrHistory;
        return ocrHistory;
    }

    static /* synthetic */ VisionRecognizeResult bitmapToText$default(BitmapToTextUtil bitmapToTextUtil, Bitmap bitmap, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "en";
        }
        return bitmapToTextUtil.bitmapToText(bitmap, string2);
    }

    private final ArrayList<MultiViewItem> translates(VisionRecognizeResult ocrHistory, String fromLanguage, String toLanguage) {
        Integer responseSize;
        ArrayList<Block> needTranslateBlocks = new ArrayList<Block>();
        ArrayList<String> needTranslateTexts = new ArrayList<String>();
        Iterable $this$forEach$iv = ocrHistory.getBlocks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block it = (Block)element$iv;
            boolean bl = false;
            needTranslateBlocks.add(it);
            needTranslateTexts.add(it.getText());
        }
        int size = needTranslateTexts.size();
        Object[] translationResult = this.translateTexts$ht_globaltranslate_release(needTranslateTexts, fromLanguage, toLanguage);
        Integer n = responseSize = translationResult == null ? null : Integer.valueOf(translationResult.length);
        if (this.isDestroy) {
            Log.Companion.warnMsg$default(Log.Companion, "translates, isDestroy.", null, 2, null);
            return null;
        }
        Integer n2 = responseSize;
        if (n2 == null || size != n2) {
            Log.Companion.e("translate", Intrinsics.stringPlus((String)"translate failed.request:", needTranslateTexts));
            Log.Companion.e("translate", Intrinsics.stringPlus((String)"translate failed.response:", (Object)(translationResult == null ? null : ArraysKt.toList((Object[])translationResult))));
            return null;
        }
        ArrayList<MultiViewItem> items = new ArrayList<MultiViewItem>();
        Log.Companion.v$default(Log.Companion, "translate", Intrinsics.stringPlus((String)"translate success.request:", needTranslateTexts), null, 4, null);
        Log.Companion.v$default(Log.Companion, "translate", Intrinsics.stringPlus((String)"translate success.response:", (Object)ArraysKt.toList((Object[])translationResult)), null, 4, null);
        Object itemTranslateText = null;
        String itemText = null;
        int itemStatus = 0;
        int n3 = 0;
        while (n3 < size) {
            int n4;
            int index = n4 = n3++;
            boolean bl = false;
            String string2 = needTranslateTexts.get(index);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"needTranslateTexts[index]");
            itemText = string2;
            itemTranslateText = translationResult[index];
            itemStatus = !TextUtils.isEmpty((CharSequence)((CharSequence)itemTranslateText)) ? 1 : -1;
            Log.Companion.i("SkyCar", "response, " + itemText + ':' + itemTranslateText);
            string2 = needTranslateBlocks.get(index);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"needTranslateBlocks[index]");
            items.add(new MultiViewItem(itemText, (String)itemTranslateText, itemStatus, this.toRect((Block)((Object)string2))));
        }
        return items;
    }

    static /* synthetic */ ArrayList translates$default(BitmapToTextUtil bitmapToTextUtil, VisionRecognizeResult visionRecognizeResult, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return bitmapToTextUtil.translates(visionRecognizeResult, string2, string3);
    }

    @Nullable
    public final String[] translateTexts$ht_globaltranslate_release(@NotNull ArrayList<String> needTranslateTexts, @NotNull String fromLanguage, @NotNull String toLanguage) {
        Intrinsics.checkNotNullParameter(needTranslateTexts, (String)"needTranslateTexts");
        Intrinsics.checkNotNullParameter((Object)fromLanguage, (String)"fromLanguage");
        Intrinsics.checkNotNullParameter((Object)toLanguage, (String)"toLanguage");
        try {
            HiTranslator.TranslateResult translateResult;
            HiTranslator.TranslateResult translateResult2;
            Log.Companion.infoMsg$default(Log.Companion, "translate, " + fromLanguage + ", " + toLanguage + ", " + needTranslateTexts, null, 2, null);
            VisionRecognizeKt.setGoogleOcrEnable((boolean)false);
            HaveFun haveFun = this.mHaveFun;
            if (haveFun == null) {
                translateResult2 = null;
            } else {
                Collection $this$toTypedArray$iv = needTranslateTexts;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                translateResult2 = translateResult = HiTranslatorBuilderKt.multiTranslate((HaveFun)haveFun, (String)fromLanguage, (String)toLanguage, (String[])stringArray);
            }
            if (translateResult == null) {
                return null;
            }
            HiTranslator.TranslateResult translateResult3 = translateResult;
            if (translateResult3.isSuccess()) {
                HiTranslator.Translation translation = translateResult3.getResult();
                return translation == null ? null : translation.getTexts();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private final Rect toRect(Block block) {
        Rect result = new Rect();
        int left = 0;
        left = Integer.MAX_VALUE;
        int top = 0;
        top = Integer.MAX_VALUE;
        int right = 0;
        int bottom = 0;
        Iterable $this$forEach$iv = block.getBlockCorners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Point it = (Point)element$iv;
            boolean bl = false;
            left = Math.min(left, it.x);
            right = Math.max(right, it.x);
            top = Math.min(top, it.y);
            bottom = Math.max(bottom, it.y);
        }
        result.left = left;
        result.top = top;
        result.right = right;
        result.bottom = bottom;
        return result;
    }

    private final void runOnMain(Runnable runnable) {
        if (Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper())) {
            runnable.run();
        } else {
            this.getMMainHandler().post(() -> BitmapToTextUtil.runOnMain$lambda-17(runnable));
        }
    }

    public final void destroy() {
        this.isDestroy = true;
    }

    private static final void parseBitmap$lambda-0(Context $context) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        LoadViewManagerKt.showLoadingView($context);
    }

    private static final void parseBitmap$lambda-3$lambda-2(Context $context) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        LoadViewManagerKt.hideLoadingView($context);
        LoadViewManagerKt.ocrFailed($context);
    }

    private static final void parseBitmap$lambda-4(BitmapToTextUtil this$0, ArrayList $items, Context $context, Ref.BooleanRef $isCropStatusBar) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$isCropStatusBar, (String)"$isCropStatusBar");
        if (this$0.isDestroy) {
            Log.Companion.warnMsg$default(Log.Companion, "parseBitmap, translates, main. isDestroy.", null, 2, null);
            return;
        }
        Collection collection = $items;
        if (collection == null || collection.isEmpty()) {
            LoadViewManagerKt.hideLoadingView($context);
            LoadViewManagerKt.translateFailed($context);
        } else {
            MultiTranslateActivityKt.startMultiTranslateActivity($context, $items, $isCropStatusBar.element);
        }
    }

    private static final void runOnMain$lambda-17(Runnable $runnable) {
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        $runnable.run();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/talpa/inner/util/BitmapToTextUtil$Companion;", "", "()V", "CANCEL", "", "FAILED", "SUCCESS", "ht-globaltranslate_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

