/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.inner.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Build;
import android.os.IBinder;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.talpa.inner.overlay.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JavaReflectionUtils {
    public static final String TAG = "screen";

    @Nullable
    public static Method getMethod(@Nullable Class<?> cls, @Nullable String methodName, Class<?> ... paramType) {
        Method[] methods;
        if (null == cls || null == methodName) {
            return null;
        }
        for (Method item : methods = cls.getMethods()) {
            if (!TextUtils.equals((CharSequence)item.getName(), (CharSequence)methodName)) continue;
            try {
                Method m = cls.getMethod(methodName, paramType);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        for (Method item : methods = cls.getDeclaredMethods()) {
            if (!TextUtils.equals((CharSequence)item.getName(), (CharSequence)methodName)) continue;
            try {
                Method m = cls.getDeclaredMethod(methodName, paramType);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public static IBinder getDisplayToken(Class<?> cls) {
        IBinder displayToken = JavaReflectionUtils.getPhysicalDisplayToken(cls);
        Log.i(TAG, "getDisplayToken, getPhysicalDisplayToken:" + (null != displayToken));
        if (null != displayToken) {
            return displayToken;
        }
        displayToken = JavaReflectionUtils.createDisplay(cls);
        Log.i(TAG, "getDisplayToken, createDisplay:" + (null != displayToken));
        if (null != displayToken) {
            return displayToken;
        }
        displayToken = JavaReflectionUtils.getInternalDisplayToken(cls);
        Log.i(TAG, "getDisplayToken, getInternalDisplayToken:" + (null != displayToken));
        return displayToken;
    }

    @Nullable
    private static IBinder createDisplay(Class<?> cls) {
        Method method = JavaReflectionUtils.getMethod(cls, "createDisplay", String.class, Boolean.TYPE);
        try {
            Object displayToken;
            boolean secure = Build.VERSION.SDK_INT <= 30;
            Object object = displayToken = null == method ? null : method.invoke(null, "scrcpy", secure);
            if (displayToken instanceof IBinder) {
                return (IBinder)displayToken;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private static IBinder getInternalDisplayToken(Class<?> cls) {
        Method method = JavaReflectionUtils.getMethod(cls, "getInternalDisplayToken", new Class[0]);
        try {
            Object displayToken;
            Object object = displayToken = null == method ? null : method.invoke(null, new Object[0]);
            if (displayToken instanceof IBinder) {
                return (IBinder)displayToken;
            }
            return null;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    private static IBinder getPhysicalDisplayToken(Class<?> cls) {
        long defaultDisplayId = JavaReflectionUtils.getPhysicalDisplayId(cls);
        Method method = JavaReflectionUtils.getMethod(cls, "getPhysicalDisplayToken", Long.class);
        Object displayToken = null;
        try {
            displayToken = null == method ? null : method.invoke(null, cls, defaultDisplayId);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (displayToken instanceof IBinder) {
            return (IBinder)displayToken;
        }
        return null;
    }

    private static long getPhysicalDisplayId(Class<?> cls) {
        Method method = JavaReflectionUtils.getMethod(cls, "getPhysicalDisplayIds", new Class[0]);
        Object displayIdsObj = null;
        try {
            displayIdsObj = null == method ? null : method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (displayIdsObj instanceof long[] && ((long[])displayIdsObj).length > 0) {
            return ((long[])displayIdsObj)[0];
        }
        return 0L;
    }

    public static Bitmap screenshotQ(Context context) {
        return JavaReflectionUtils.screenshotQ(JavaReflectionUtils.getWidth(context), JavaReflectionUtils.getHeight(context), true);
    }

    public static Bitmap screenshotQ(int width, int height, boolean useIdentityTransform) {
        Class<?> cls = null;
        try {
            cls = Class.forName("android.view.SurfaceControl");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Log.i(TAG, "screenshotQ, cls:" + (null != cls));
        IBinder displayToken = JavaReflectionUtils.getDisplayToken(cls);
        Log.i(TAG, "screenshotQ, getDisplayToken:" + (null != displayToken));
        if (null == displayToken) {
            return null;
        }
        Object captureArgs = JavaReflectionUtils.createBuilder(displayToken, width, height, useIdentityTransform);
        Log.i(TAG, "screenshotQ, createBuilder:" + (null != captureArgs));
        if (null == captureArgs) {
            return null;
        }
        Object screenshotBuffer = JavaReflectionUtils.captureDisplay(cls, captureArgs);
        Log.i(TAG, "screenshotQ, captureDisplay:" + (null != screenshotBuffer));
        if (null == screenshotBuffer) {
            return null;
        }
        Bitmap bm = JavaReflectionUtils.asBitmap(screenshotBuffer);
        Log.i(TAG, "screenshotQ, asBitmap:" + (null != bm));
        return bm;
    }

    private static Bitmap asBitmap(Object screenshotBuffer) {
        Method method = JavaReflectionUtils.getMethod(screenshotBuffer.getClass(), "asBitmap", new Class[0]);
        try {
            Object obj;
            Object object = obj = null == method ? null : method.invoke(screenshotBuffer, new Object[0]);
            if (obj instanceof Bitmap) {
                return (Bitmap)obj;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Object captureDisplay(Class<?> cls, Object captureArgs) {
        Method method = JavaReflectionUtils.getMethod(cls, "captureDisplay", captureArgs.getClass());
        try {
            return null == method ? null : method.invoke(null, captureArgs);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object createBuilder(@NonNull IBinder displayToken, int width, int height, boolean useIdentityTransform) {
        try {
            Method method;
            Method methodSetUseIdentityTransform;
            Class<?> clsBuilder = Class.forName("android.view.SurfaceControl$DisplayCaptureArgs$Builder");
            Object instance2 = clsBuilder.getConstructor(IBinder.class).newInstance(displayToken);
            Method methodSetSize = JavaReflectionUtils.getMethod(clsBuilder, "setSize", Integer.TYPE, Integer.TYPE);
            if (null != methodSetSize) {
                methodSetSize.invoke(instance2, width, height);
            }
            if (null != (methodSetUseIdentityTransform = JavaReflectionUtils.getMethod(clsBuilder, "setUseIdentityTransform", Boolean.TYPE))) {
                methodSetUseIdentityTransform.invoke(instance2, useIdentityTransform);
            }
            if (null != (method = JavaReflectionUtils.getMethod(clsBuilder, "build", new Class[0]))) {
                return method.invoke(instance2, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Bitmap screenshotLow(Context context) {
        return JavaReflectionUtils.screenshotLow(JavaReflectionUtils.getWidth(context), JavaReflectionUtils.getHeight(context));
    }

    public static Bitmap screenshotLow(int width, int height) {
        Class<?> cls = null;
        try {
            cls = Class.forName("android.view.SurfaceControl");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Log.i(TAG, "screenshotLow, cls:" + (null != cls));
        Method method = JavaReflectionUtils.getMethod(cls, "screenshot", Integer.TYPE, Integer.TYPE);
        Log.i(TAG, "screenshotLow, method:" + (null != method));
        if (null == method) {
            return null;
        }
        method.setAccessible(true);
        try {
            Object bmObj = method.invoke(null, width, height);
            Log.i(TAG, "screenshotLow, bmObj:" + (null != bmObj));
            if (bmObj instanceof Bitmap) {
                return (Bitmap)bmObj;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int getStatusBarHeight(Context context) {
        try {
            int id2 = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
            return (int)context.getResources().getDimension(id2);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int getWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static Bitmap screenshotSmartPanel(Context context) {
        Class<?> clsScreenshotHelper = null;
        try {
            clsScreenshotHelper = Class.forName("com.transsion.smartpanel.utils.ScreenshotHelper");
        }
        catch (ClassNotFoundException e) {
            if (!"com.transsion.smartpanel".equals(context.getPackageName())) {
                return null;
            }
            e.printStackTrace();
            Log.e(TAG, "ClassNotFoundException.", e);
        }
        if (null == clsScreenshotHelper) {
            Log.e(TAG, "screenshotSmartPanel, ScreenshotHelper is null.");
            return null;
        }
        Method methodGetInstance = JavaReflectionUtils.getMethod(clsScreenshotHelper, "getInstance", new Class[0]);
        if (null == methodGetInstance) {
            Log.e(TAG, "screenshotSmartPanel, getInstance is null.");
            return null;
        }
        Method methodTakeScreenshot = JavaReflectionUtils.getMethod(clsScreenshotHelper, "takeScreenshot", Context.class, Rect.class);
        if (null == methodTakeScreenshot) {
            Log.e(TAG, "screenshotSmartPanel, takeScreenshot is null.");
            return null;
        }
        try {
            Object instance2 = methodGetInstance.invoke(null, new Object[0]);
            Object bmObj = methodTakeScreenshot.invoke(instance2, context, JavaReflectionUtils.toRect(context));
            Log.i(TAG, "screenshotSmartPanel, bmObj is Bitmap:" + (bmObj instanceof Bitmap));
            if (bmObj instanceof Bitmap) {
                return (Bitmap)bmObj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "invoke failed.", e);
        }
        return null;
    }

    private static Rect toRect(Context context) {
        return new Rect(0, 0, JavaReflectionUtils.getWidth(context), JavaReflectionUtils.getHeight(context));
    }
}

