/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.view.menu;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Insets;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u0007*\u00020\u000b2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"getScreenHeight", "", "Landroid/content/Context;", "getScreenWidth", "isLandscape", "", "pendingStartActivity", "", "action", "", "sendAction", "Landroidx/localbroadcastmanager/content/LocalBroadcastManager;", "ht-overlay_release"})
public final class FloatingMenuKt {
    public static final int getScreenWidth(@NotNull Context $this$getScreenWidth) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getScreenWidth, (String)"<this>");
        Object object = $this$getScreenWidth.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager2 = (WindowManager)object;
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics windowMetrics = windowManager2.getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"windowManager.currentWindowMetrics");
            WindowMetrics windowMetrics2 = windowMetrics;
            Insets insets = windowMetrics2.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"windowMetrics.windowInsets\n            .getInsetsIgnoringVisibility(WindowInsets.Type.systemBars())");
            Insets insets2 = insets;
            n = windowMetrics2.getBounds().width() - insets2.left - insets2.right;
        } else {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            windowManager2.getDefaultDisplay().getMetrics(displayMetrics);
            n = displayMetrics.widthPixels;
        }
        return n;
    }

    public static final int getScreenHeight(@NotNull Context $this$getScreenHeight) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getScreenHeight, (String)"<this>");
        Object object = $this$getScreenHeight.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager2 = (WindowManager)object;
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics windowMetrics = windowManager2.getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"windowManager.currentWindowMetrics");
            WindowMetrics windowMetrics2 = windowMetrics;
            Insets insets = windowMetrics2.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"windowMetrics.windowInsets\n            .getInsetsIgnoringVisibility(WindowInsets.Type.systemBars())");
            Insets insets2 = insets;
            n = windowMetrics2.getBounds().height() - insets2.top - insets2.bottom;
        } else {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            windowManager2.getDefaultDisplay().getMetrics(displayMetrics);
            n = displayMetrics.heightPixels;
        }
        return n;
    }

    public static final boolean isLandscape(@NotNull Context $this$isLandscape) {
        Intrinsics.checkNotNullParameter((Object)$this$isLandscape, (String)"<this>");
        Object object = $this$isLandscape.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        return wm.getDefaultDisplay().getRotation() % 2 != 0;
    }

    public static final void pendingStartActivity(@NotNull Context $this$pendingStartActivity, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)$this$pendingStartActivity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intent intent = new Intent(action);
        intent.addFlags(0x10000000);
        intent.setPackage($this$pendingStartActivity.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)$this$pendingStartActivity, (int)100, (Intent)intent, (int)0x8000000);
        pendingIntent.send();
    }

    public static final void sendAction(@NotNull LocalBroadcastManager $this$sendAction, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)$this$sendAction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        $this$sendAction.sendBroadcast(new Intent(action));
    }
}

