/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.view.menu;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.compose.runtime.internal.StabilityInferred;
import com.talpa.overlay.R;
import com.talpa.overlay.view.menu.FloatingMenuKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0012\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0017H\u0014J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/talpa/overlay/view/menu/MenuView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "mConfigChangeReceiver", "Landroid/content/BroadcastReceiver;", "setOnBackClickListener", "Lkotlin/Function0;", "", "getSetOnBackClickListener", "()Lkotlin/jvm/functions/Function0;", "setSetOnBackClickListener", "(Lkotlin/jvm/functions/Function0;)V", "onAttachedToWindow", "", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onDetachedFromWindow", "registerConfigChangeReceiver", "unregisterConfigChangeReceiver", "updateParams", "ht-overlay_release"})
@StabilityInferred(parameters=0)
public final class MenuView
extends FrameLayout {
    @NotNull
    private final BroadcastReceiver mConfigChangeReceiver;
    @Nullable
    private Function0<Boolean> setOnBackClickListener;
    public static final int $stable = 8;

    public MenuView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mConfigChangeReceiver = new BroadcastReceiver(this){
            final /* synthetic */ MenuView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onReceive(@Nullable Context context, @Nullable Intent intent) {
                String string2;
                Intent intent2 = intent;
                String string3 = string2 = intent2 == null ? null : intent2.getAction();
                if (Intrinsics.areEqual((Object)string2, (Object)"android.intent.action.CONFIGURATION_CHANGED")) {
                    MenuView.access$updateParams(this.this$0);
                }
            }
        };
    }

    public MenuView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.mConfigChangeReceiver = new /* invalid duplicate definition of identical inner class */;
    }

    public MenuView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mConfigChangeReceiver = new /* invalid duplicate definition of identical inner class */;
    }

    public MenuView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mConfigChangeReceiver = new /* invalid duplicate definition of identical inner class */;
    }

    protected void onConfigurationChanged(@Nullable Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        String string2 = "MenuView#onConfigurationChanged";
        boolean bl = false;
        System.out.println((Object)string2);
    }

    private final void updateParams() {
        WindowManager.LayoutParams layoutParams;
        View floatingMenu2 = this.findViewById(R.id.floating_menu);
        ViewGroup.LayoutParams layoutParams2 = this.getLayoutParams();
        WindowManager.LayoutParams layoutParams3 = layoutParams = layoutParams2 instanceof WindowManager.LayoutParams ? (WindowManager.LayoutParams)layoutParams2 : null;
        if (layoutParams == null) {
            return;
        }
        WindowManager.LayoutParams params = layoutParams;
        layoutParams2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)layoutParams2, (String)"context");
        int screenWidth = FloatingMenuKt.getScreenWidth((Context)layoutParams2);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        int screenHeight = FloatingMenuKt.getScreenHeight(context);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        boolean isLandscape = FloatingMenuKt.isLandscape(context2);
        params.width = screenWidth;
        params.height = screenHeight;
        if (Build.VERSION.SDK_INT >= 30 && isLandscape) {
            params.width = screenHeight;
            params.height = screenWidth;
        }
        try {
            Object object = this.getContext().getSystemService("window");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager wm = (WindowManager)object;
            wm.updateViewLayout((View)this, (ViewGroup.LayoutParams)params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int dp276 = (int)this.getResources().getDimension(R.dimen.dp276);
        float endX = (float)(params.width - dp276) / 2.0f;
        float endY = (float)(params.height - dp276) / 3.0f;
        floatingMenu2.setX(endX);
        floatingMenu2.setY(endY);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.registerConfigChangeReceiver();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.unregisterConfigChangeReceiver();
    }

    private final void registerConfigChangeReceiver() {
        IntentFilter configChangeFilter = new IntentFilter();
        configChangeFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        configChangeFilter.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        this.getContext().registerReceiver(this.mConfigChangeReceiver, configChangeFilter);
    }

    private final void unregisterConfigChangeReceiver() {
        this.getContext().unregisterReceiver(this.mConfigChangeReceiver);
    }

    @Nullable
    public final Function0<Boolean> getSetOnBackClickListener() {
        return this.setOnBackClickListener;
    }

    public final void setSetOnBackClickListener(@Nullable Function0<Boolean> function0) {
        this.setOnBackClickListener = function0;
    }

    public static final /* synthetic */ void access$updateParams(MenuView $this) {
        $this.updateParams();
    }
}

