/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.language;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import com.talpa.translate.language.LanguageAdapter;
import com.talpa.translate.language.LanguageExtKt;
import com.talpa.translate.language.R;
import com.talpa.translate.language.databinding.ItemLanguageContentBinding;
import com.talpa.translate.language.databinding.ItemLanguageHeaderBinding;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0004\u0012\u00020\u00050\u0001:\u0002\u0017\u0018B'\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/talpa/translate/language/LanguageAdapter;", "Landroidx/recyclerview/widget/ListAdapter;", "", "", "", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "diff", "Landroidx/recyclerview/widget/DiffUtil$ItemCallback;", "onClickListener", "Landroid/view/View$OnClickListener;", "(Landroidx/recyclerview/widget/DiffUtil$ItemCallback;Landroid/view/View$OnClickListener;)V", "layoutInflater", "Landroid/view/LayoutInflater;", "getItemViewType", "", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "ContentHolder", "HeaderHolder", "language_release"})
public final class LanguageAdapter
extends ListAdapter<Map<String, ? extends Object>, RecyclerView.ViewHolder> {
    private LayoutInflater layoutInflater;
    private final View.OnClickListener onClickListener;

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        LayoutInflater layoutInflater = this.layoutInflater;
        if (layoutInflater == null) {
            layoutInflater = LayoutInflater.from((Context)parent.getContext());
        }
        this.layoutInflater = layoutInflater;
        switch (viewType) {
            case 1: {
                LayoutInflater layoutInflater2 = this.layoutInflater;
                if (layoutInflater2 == null) {
                    Intrinsics.throwNpe();
                }
                ItemLanguageHeaderBinding itemLanguageHeaderBinding = ItemLanguageHeaderBinding.inflate(layoutInflater2, parent, false);
                Intrinsics.checkExpressionValueIsNotNull((Object)itemLanguageHeaderBinding, (String)"ItemLanguageHeaderBindin\u2026nflater!!, parent, false)");
                ItemLanguageHeaderBinding binding = itemLanguageHeaderBinding;
                viewHolder = new HeaderHolder(binding);
                break;
            }
            case 3: {
                LayoutInflater layoutInflater3 = this.layoutInflater;
                if (layoutInflater3 == null) {
                    Intrinsics.throwNpe();
                }
                ItemLanguageHeaderBinding itemLanguageHeaderBinding = ItemLanguageHeaderBinding.inflate(layoutInflater3, parent, false);
                Intrinsics.checkExpressionValueIsNotNull((Object)itemLanguageHeaderBinding, (String)"ItemLanguageHeaderBindin\u2026nflater!!, parent, false)");
                ItemLanguageHeaderBinding binding = itemLanguageHeaderBinding;
                viewHolder = new HeaderHolder(binding);
                break;
            }
            default: {
                LayoutInflater layoutInflater4 = this.layoutInflater;
                if (layoutInflater4 == null) {
                    Intrinsics.throwNpe();
                }
                ItemLanguageContentBinding itemLanguageContentBinding = ItemLanguageContentBinding.inflate(layoutInflater4, parent, false);
                Intrinsics.checkExpressionValueIsNotNull((Object)itemLanguageContentBinding, (String)"ItemLanguageContentBindi\u2026nflater!!, parent, false)");
                ItemLanguageContentBinding binding = itemLanguageContentBinding;
                viewHolder = new ContentHolder(binding);
            }
        }
        return viewHolder;
    }

    public int getItemViewType(int position) {
        Map map = (Map)this.getItem(position);
        Object v = map.get("item_key_view_type");
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        return (Integer)v;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        switch (this.getItemViewType(position)) {
            case 1: {
                HeaderHolder h = (HeaderHolder)holder;
                h.bind(R.string.language_recently_used);
                break;
            }
            case 3: {
                HeaderHolder h = (HeaderHolder)holder;
                h.bind(R.string.language_all_languages);
                break;
            }
            default: {
                Map item;
                ContentHolder h = (ContentHolder)holder;
                Map map = item = (Map)this.getItem(position);
                Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"item");
                h.bind(map, position);
                h.itemView.setOnClickListener(this.onClickListener);
                View view = h.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"h.itemView");
                view.setTag((Object)item);
            }
        }
    }

    public LanguageAdapter(@NotNull DiffUtil.ItemCallback<Map<String, Object>> diff, @NotNull View.OnClickListener onClickListener) {
        Intrinsics.checkParameterIsNotNull(diff, (String)"diff");
        Intrinsics.checkParameterIsNotNull((Object)onClickListener, (String)"onClickListener");
        super(diff);
        this.onClickListener = onClickListener;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/talpa/translate/language/LanguageAdapter$HeaderHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lcom/talpa/translate/language/databinding/ItemLanguageHeaderBinding;", "(Lcom/talpa/translate/language/databinding/ItemLanguageHeaderBinding;)V", "bind", "", "textId", "", "language_release"})
    public static final class HeaderHolder
    extends RecyclerView.ViewHolder {
        private final ItemLanguageHeaderBinding binding;

        public final void bind(int textId) {
            TextView textView = this.binding.title;
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"binding.title");
            TextView textView2 = this.binding.getRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"binding.root");
            textView.setText((CharSequence)textView2.getResources().getString(textId));
        }

        public HeaderHolder(@NotNull ItemLanguageHeaderBinding binding) {
            Intrinsics.checkParameterIsNotNull((Object)binding, (String)"binding");
            super((View)binding.getRoot());
            this.binding = binding;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/talpa/translate/language/LanguageAdapter$ContentHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lcom/talpa/translate/language/databinding/ItemLanguageContentBinding;", "(Lcom/talpa/translate/language/databinding/ItemLanguageContentBinding;)V", "context", "Landroid/content/Context;", "onAllItemClickListener", "Landroid/view/View$OnClickListener;", "onRecentlyUsedItemClickListener", "bind", "", "map", "", "", "", "position", "", "isSelected", "", "sendLocalBroadcast", "action", "languageTag", "language_release"})
    public static final class ContentHolder
    extends RecyclerView.ViewHolder {
        private final Context context;
        private final View.OnClickListener onAllItemClickListener;
        private final View.OnClickListener onRecentlyUsedItemClickListener;
        private final ItemLanguageContentBinding binding;

        private final boolean isSelected() {
            return false;
        }

        private final void sendLocalBroadcast(String action, String languageTag) {
        }

        public final void bind(@NotNull Map<String, ? extends Object> map, int position) {
            block10: {
                boolean isTopLanguage;
                Object object;
                int visibility;
                block9: {
                    boolean isTopLanguage2;
                    Intrinsics.checkParameterIsNotNull(map, (String)"map");
                    Object object2 = map.get("item_key_language_tag");
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    String languageTag = (String)object2;
                    String displayName = LanguageExtKt.languageDisplayName(this.context, languageTag);
                    TextView textView = this.binding.tvTitle;
                    Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"binding.tvTitle");
                    textView.setText((CharSequence)displayName);
                    boolean isSelected = this.isSelected();
                    visibility = isSelected ? 0 : 8;
                    object = map.get("item_key_view_type");
                    if (!Intrinsics.areEqual((Object)object, (Object)4)) break block9;
                    if (!isSelected) {
                        this.binding.getRoot().setOnClickListener(this.onAllItemClickListener);
                    } else {
                        this.binding.getRoot().setOnClickListener(null);
                    }
                    ImageView imageView = this.binding.cbCheck;
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"binding.cbCheck");
                    imageView.setVisibility(visibility);
                    TextView textView2 = this.binding.tvCheckStatus;
                    Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"binding.tvCheckStatus");
                    textView2.setVisibility(8);
                    Object object3 = map.get("item_key_all_language_top");
                    if (!(object3 instanceof Boolean)) {
                        object3 = null;
                    }
                    Boolean bl = (Boolean)object3;
                    boolean bl2 = isTopLanguage2 = bl != null ? bl : false;
                    if (isTopLanguage2) {
                        ImageView imageView2 = this.binding.ivIcon;
                        Intrinsics.checkExpressionValueIsNotNull((Object)imageView2, (String)"binding.ivIcon");
                        imageView2.setVisibility(0);
                        this.binding.ivIcon.setImageResource(R.drawable.ic_lang_all);
                    } else {
                        ImageView imageView3 = this.binding.ivIcon;
                        Intrinsics.checkExpressionValueIsNotNull((Object)imageView3, (String)"binding.ivIcon");
                        imageView3.setVisibility(4);
                    }
                    break block10;
                }
                if (!Intrinsics.areEqual((Object)object, (Object)2)) break block10;
                this.binding.getRoot().setOnClickListener(this.onRecentlyUsedItemClickListener);
                ImageView imageView = this.binding.cbCheck;
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"binding.cbCheck");
                imageView.setVisibility(8);
                TextView textView = this.binding.tvCheckStatus;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"binding.tvCheckStatus");
                textView.setVisibility(visibility);
                Object object4 = map.get("item_key_recent_language_top");
                if (!(object4 instanceof Boolean)) {
                    object4 = null;
                }
                Boolean bl = (Boolean)object4;
                boolean bl3 = isTopLanguage = bl != null ? bl : false;
                if (isTopLanguage) {
                    ImageView imageView4 = this.binding.ivIcon;
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView4, (String)"binding.ivIcon");
                    imageView4.setVisibility(0);
                    this.binding.ivIcon.setImageResource(R.drawable.ic_lang_history);
                } else {
                    ImageView imageView5 = this.binding.ivIcon;
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView5, (String)"binding.ivIcon");
                    imageView5.setVisibility(4);
                    this.binding.ivIcon.setImageResource(0);
                }
            }
        }

        public ContentHolder(@NotNull ItemLanguageContentBinding binding) {
            Intrinsics.checkParameterIsNotNull((Object)binding, (String)"binding");
            super((View)binding.getRoot());
            this.binding = binding;
            ConstraintLayout constraintLayout = this.binding.getRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)constraintLayout, (String)"binding.root");
            Context context = constraintLayout.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"binding.root.context");
            this.context = context;
            this.onAllItemClickListener = onAllItemClickListener.1.INSTANCE;
            this.onRecentlyUsedItemClickListener = onRecentlyUsedItemClickListener.1.INSTANCE;
        }
    }
}

