/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.language;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IBinder;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.activity.OnBackPressedDispatcherKt;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentViewModelLazyKt;
import androidx.lifecycle.CoroutineLiveDataKt;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.LiveDataScope;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.navigation.fragment.FragmentKt;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.talpa.translate.language.LanguageAdapter;
import com.talpa.translate.language.LanguageFragment;
import com.talpa.translate.language.LanguageFragmentKt;
import com.talpa.translate.language.LanguageViewModel;
import com.talpa.translate.language.R;
import com.talpa.translate.language.databinding.FragmentLanguageBinding;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u0003123B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u000f\u001a\u00020\u00102.\u0010\u0011\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00130\u0012j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013`\u0016H\u0002J\"\u0010\u0017\u001a\u00020\u00102\u0018\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00130\u0019H\u0002J\"\u0010\u001a\u001a\u00020\u00102\u0018\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00130\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0002J\b\u0010\u001d\u001a\u00020\u0010H\u0002J \u0010\u001e\u001a\u00020\u00102\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00130 J\u0012\u0010!\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020\u0010H\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0002J\u001a\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020'2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0018\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0012j\b\u0012\u0004\u0012\u00020\u0014`\u0016H\u0002J\b\u0010+\u001a\u00020,H\u0002J\n\u0010-\u001a\u00020\u0010*\u00020\u0001J\u0012\u0010.\u001a\u00020\u0010*\u00020\u00012\u0006\u0010/\u001a\u000200R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u00064"}, d2={"Lcom/talpa/translate/language/LanguageFragment;", "Landroidx/fragment/app/Fragment;", "()V", "adapter", "Lcom/talpa/translate/language/LanguageAdapter;", "binding", "Lcom/talpa/translate/language/databinding/FragmentLanguageBinding;", "textWatcher", "Lcom/talpa/translate/language/LanguageFragment$FilterWatcher;", "viewModel", "Lcom/talpa/translate/language/LanguageViewModel;", "getViewModel", "()Lcom/talpa/translate/language/LanguageViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "excludeLanguageTag", "", "items", "Ljava/util/ArrayList;", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/ArrayList;", "handleAutoDetect", "source", "", "handleRecentLanguageList", "hideSoftKeyboard", "initData", "initView", "onChanged", "languages", "", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroyView", "onItemClick", "v", "Landroid/view/View;", "onViewCreated", "view", "recentLanguageList", "shouldEnabledAutoDetect", "", "hideActionBar", "showActionBar", "backgroundColor", "", "Companion", "FilterWatcher", "LanguageObserver", "language_release"})
public final class LanguageFragment
extends Fragment {
    private final Lazy viewModel$delegate;
    private FragmentLanguageBinding binding;
    private LanguageAdapter adapter;
    private FilterWatcher textWatcher;
    @NotNull
    public static final String BROAD_ACTION_SELECTED_LANGUAGE = "BROAD_ACTION_SELECTED_LANGUAGE";
    @NotNull
    public static final String EXTRA_LANGUAGE_TAG = "EXTRA_LANGUAGE_TAG";
    @NotNull
    public static final String EXTRA_SELECTED_AUTO_DETECT = "EXTRA_SELECTED_AUTO_DETECT";
    @NotNull
    public static final String EXTRA_LANGUAGE_TYPE = "EXTRA_LANGUAGE_TYPE";
    @NotNull
    public static final String EXTRA_ENABLED_AUTO_DETECT = "EXTRA_ENABLED_AUTO_DETECT";
    @NotNull
    public static final String EXTRA_RECENT_LANGUAGE_LIST = "EXTRA_RECENT_LANGUAGE_LIST";
    @NotNull
    public static final String EXTRA_EXCLUDE_LANGUAGE_TAG = "EXTRA_EXCLUDE_LANGUAGE_TAG";
    private static final Companion.DIFF_CALLBACK.1 DIFF_CALLBACK;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    private final LanguageViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        LanguageFragment languageFragment = this;
        Object var3_3 = null;
        boolean bl = false;
        return (LanguageViewModel)((Object)lazy.getValue());
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.adapter = new LanguageAdapter((DiffUtil.ItemCallback<Map<String, Object>>)((DiffUtil.ItemCallback)DIFF_CALLBACK), new View.OnClickListener(this){
            final /* synthetic */ LanguageFragment this$0;

            public final void onClick(View it) {
                View view = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"it");
                LanguageFragment.access$onItemClick(this.this$0, view);
            }
            {
                this.this$0 = languageFragment;
            }
        });
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        FragmentLanguageBinding fragmentLanguageBinding = FragmentLanguageBinding.bind(view);
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentLanguageBinding, (String)"FragmentLanguageBinding.bind(view)");
        this.binding = fragmentLanguageBinding;
        View view2 = view;
        boolean bl = false;
        boolean bl2 = false;
        View $this$apply = view2;
        boolean bl3 = false;
        Context context = this.requireContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"requireContext()");
        int statusBarHeight = LanguageFragmentKt.access$statusBarHeight(context);
        $this$apply.setPadding($this$apply.getPaddingLeft(), $this$apply.getPaddingTop() + statusBarHeight, $this$apply.getPaddingRight(), $this$apply.getPaddingBottom());
        this.initView();
        this.initData();
        FragmentActivity fragmentActivity = this.requireActivity();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"requireActivity()");
        OnBackPressedDispatcher onBackPressedDispatcher = fragmentActivity.getOnBackPressedDispatcher();
        Intrinsics.checkExpressionValueIsNotNull((Object)onBackPressedDispatcher, (String)"requireActivity().onBackPressedDispatcher");
        OnBackPressedDispatcherKt.addCallback((OnBackPressedDispatcher)onBackPressedDispatcher, (LifecycleOwner)this.getViewLifecycleOwner(), (boolean)true, (Function1)((Function1)new Function1<OnBackPressedCallback, Unit>(this){
            final /* synthetic */ LanguageFragment this$0;

            public final void invoke(@NotNull OnBackPressedCallback $this$addCallback) {
                Intrinsics.checkParameterIsNotNull((Object)$this$addCallback, (String)"$receiver");
                FragmentKt.findNavController((Fragment)this.this$0).navigateUp();
            }
            {
                this.this$0 = languageFragment;
                super(1);
            }
        }));
    }

    public void onDestroyView() {
        this.hideSoftKeyboard();
        super.onDestroyView();
        LanguageAdapter languageAdapter = this.adapter;
        if (languageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        LanguageAdapter languageAdapter2 = languageAdapter;
        boolean bl = false;
        List list = CollectionsKt.emptyList();
        languageAdapter2.submitList(list);
        FragmentLanguageBinding fragmentLanguageBinding = this.binding;
        if (fragmentLanguageBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        fragmentLanguageBinding.etLanguageFilter.removeTextChangedListener((TextWatcher)this.textWatcher);
        this._$_clearFindViewByIdCache();
    }

    private final void hideSoftKeyboard() {
        FragmentLanguageBinding fragmentLanguageBinding = this.binding;
        if (fragmentLanguageBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        AppCompatEditText appCompatEditText = fragmentLanguageBinding.etLanguageFilter;
        Intrinsics.checkExpressionValueIsNotNull((Object)appCompatEditText, (String)"binding.etLanguageFilter");
        Object object = appCompatEditText.getWindowToken();
        if (object == null) {
            FragmentActivity fragmentActivity = this.requireActivity();
            Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"requireActivity()");
            View view = fragmentActivity.getCurrentFocus();
            object = view != null ? view.getWindowToken() : null;
        }
        if (object == null) {
            return;
        }
        IBinder windowToken = object;
        Object object2 = this.requireContext().getSystemService("input_method");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object2;
        imm.hideSoftInputFromWindow(windowToken, 0);
    }

    public final void showActionBar(@NotNull Fragment $this$showActionBar, int backgroundColor) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$this$showActionBar, (String)"$this$showActionBar");
            FragmentActivity fragmentActivity = $this$showActionBar.requireActivity();
            if (fragmentActivity == null) {
                throw new TypeCastException("null cannot be cast to non-null type androidx.appcompat.app.AppCompatActivity");
            }
            ActionBar actionBar = ((AppCompatActivity)fragmentActivity).getSupportActionBar();
            if (actionBar == null) break block1;
            ActionBar actionBar2 = actionBar;
            boolean bl = false;
            boolean bl2 = false;
            ActionBar $this$apply = actionBar2;
            boolean bl3 = false;
            Context context = $this$showActionBar.requireContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"requireContext()");
            int color = context.getResources().getColor(backgroundColor);
            ColorDrawable colorDrawable = new ColorDrawable(color);
            $this$apply.setBackgroundDrawable((Drawable)colorDrawable);
            $this$apply.show();
        }
    }

    public final void hideActionBar(@NotNull Fragment $this$hideActionBar) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$this$hideActionBar, (String)"$this$hideActionBar");
            FragmentActivity fragmentActivity = $this$hideActionBar.requireActivity();
            if (fragmentActivity == null) {
                throw new TypeCastException("null cannot be cast to non-null type androidx.appcompat.app.AppCompatActivity");
            }
            ActionBar actionBar = ((AppCompatActivity)fragmentActivity).getSupportActionBar();
            if (actionBar == null) break block1;
            actionBar.hide();
        }
    }

    private final void initView() {
        block3: {
            FragmentLanguageBinding fragmentLanguageBinding = this.binding;
            if (fragmentLanguageBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            }
            RecyclerView recyclerView = fragmentLanguageBinding.recyclerView;
            Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"binding.recyclerView");
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.requireContext()));
            FragmentLanguageBinding fragmentLanguageBinding2 = this.binding;
            if (fragmentLanguageBinding2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            }
            RecyclerView recyclerView2 = fragmentLanguageBinding2.recyclerView;
            Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView2, (String)"binding.recyclerView");
            LanguageAdapter languageAdapter = this.adapter;
            if (languageAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            }
            recyclerView2.setAdapter((RecyclerView.Adapter)languageAdapter);
            View view = this.getView();
            if (view == null || (view = view.findViewById(R.id.iv_back)) == null) break block3;
            view.setOnClickListener(new View.OnClickListener(this){
                final /* synthetic */ LanguageFragment this$0;

                public final void onClick(View it) {
                    FragmentKt.findNavController((Fragment)this.this$0).navigateUp();
                }
                {
                    this.this$0 = languageFragment;
                }
            });
        }
    }

    private final void initData() {
        this.getViewModel().getLanguageLiveData().observe(this.getViewLifecycleOwner(), (Observer)new LanguageObserver(this));
    }

    public final void onChanged(@NotNull List<? extends HashMap<String, Object>> languages) {
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        List items = new ArrayList(languages);
        ArrayList cfr_ignored_0 = (ArrayList)items;
        this.handleAutoDetect(items);
        this.handleRecentLanguageList(items);
        this.excludeLanguageTag((ArrayList)items);
        LanguageAdapter languageAdapter = this.adapter;
        if (languageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        languageAdapter.submitList(items);
        this.textWatcher = new FilterWatcher(this, items);
        FragmentLanguageBinding fragmentLanguageBinding = this.binding;
        if (fragmentLanguageBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        fragmentLanguageBinding.etLanguageFilter.addTextChangedListener((TextWatcher)this.textWatcher);
    }

    private final void handleAutoDetect(List<HashMap<String, Object>> source) {
        if (this.shouldEnabledAutoDetect()) {
            Collection collection = source;
            boolean bl = false;
            if (!collection.isEmpty() && Intrinsics.areEqual((Object)source.get(0).get("item_key_auto_detect"), (Object)true) ^ true) {
                HashMap autoMap = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"item_key_auto_detect", (Object)true), TuplesKt.to((Object)"item_key_language_tag", (Object)"auto"), TuplesKt.to((Object)"item_key_view_type", (Object)4), TuplesKt.to((Object)"item_key_all_language_top", (Object)true)});
                source.add(0, autoMap);
            }
        } else {
            Collection collection = source;
            boolean bl = false;
            if (!collection.isEmpty()) {
                ((Map)source.get(0)).put("item_key_all_language_top", true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRecentLanguageList(List<HashMap<String, Object>> source) {
        void $this$mapIndexedTo$iv$iv;
        ArrayList<String> arrayList = this.recentLanguageList();
        if (arrayList.isEmpty()) {
            return;
        }
        Iterable $this$mapIndexed$iv = arrayList;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void languageTag;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            String string = (String)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            boolean bl2 = false;
            HashMap hashMap = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"item_key_language_tag", (Object)languageTag), TuplesKt.to((Object)"item_key_view_type", (Object)2), TuplesKt.to((Object)"item_key_recent_language_top", (Object)(index == false ? 1 : 0))});
            collection2.add(hashMap);
        }
        List recentList = (List)destination$iv$iv;
        source.addAll(0, recentList);
    }

    private final boolean shouldEnabledAutoDetect() {
        return this.requireArguments().getBoolean(EXTRA_ENABLED_AUTO_DETECT, false);
    }

    private final ArrayList<String> recentLanguageList() {
        ArrayList arrayList = this.requireArguments().getStringArrayList(EXTRA_RECENT_LANGUAGE_LIST);
        if (arrayList == null) {
            boolean bl = false;
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private final void excludeLanguageTag(ArrayList<HashMap<String, Object>> items) {
        void $this$filterIndexedTo$iv$iv;
        String languageTag = this.requireArguments().getString(EXTRA_EXCLUDE_LANGUAGE_TAG);
        if (TextUtils.isEmpty((CharSequence)languageTag)) {
            return;
        }
        Iterable $this$filterIndexed$iv = items;
        boolean $i$f$filterIndexed = false;
        Iterable iterable = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void hashMap;
            void element$iv$iv;
            int n = index$iv$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Object t = item$iv$iv$iv;
            int index$iv$iv = n2;
            boolean bl2 = false;
            HashMap hashMap2 = (HashMap)element$iv$iv;
            int index = index$iv$iv;
            boolean bl3 = false;
            boolean fil = Intrinsics.areEqual(hashMap.get("item_key_language_tag"), (Object)languageTag);
            if (fil && Intrinsics.areEqual(hashMap.get("item_key_all_language_top"), (Object)true)) {
                HashMap<String, Object> hashMap3 = items.get(index + 1);
                Intrinsics.checkExpressionValueIsNotNull(hashMap3, (String)"items[index + 1]");
                ((Map)hashMap3).put("item_key_all_language_top", true);
            }
            if (!fil) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filter = (List)destination$iv$iv;
        Collection collection = filter;
        boolean bl = false;
        if (!collection.isEmpty()) {
            items.removeAll(filter);
        }
    }

    private final void onItemClick(View v) {
        Object object = v.getTag();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.HashMap<kotlin.String, kotlin.Any>");
        }
        HashMap item = (HashMap)object;
        Object v2 = item.get("item_key_language_tag");
        if (!(v2 instanceof String)) {
            v2 = null;
        }
        String languageTag = (String)v2;
        Object v3 = item.get("item_key_auto_detect");
        if (!(v3 instanceof Boolean)) {
            v3 = null;
        }
        Boolean bl = (Boolean)v3;
        boolean autoDetect = bl != null ? bl : false;
        int languageType = this.requireArguments().getInt(EXTRA_LANGUAGE_TYPE, -1);
        Intent intent = new Intent(BROAD_ACTION_SELECTED_LANGUAGE).putExtra(EXTRA_LANGUAGE_TAG, languageTag).putExtra(EXTRA_SELECTED_AUTO_DETECT, autoDetect).putExtra(EXTRA_LANGUAGE_TYPE, languageType);
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"Intent(BROAD_ACTION_SELE\u2026GUAGE_TYPE, languageType)");
        Intent intent2 = intent;
        LocalBroadcastManager.getInstance((Context)this.requireContext()).sendBroadcast(intent2);
        FragmentKt.findNavController((Fragment)this).navigateUp();
    }

    /*
     * WARNING - void declaration
     */
    public LanguageFragment() {
        super(R.layout.fragment_language);
        void factoryProducer$iv;
        void ownerProducer$iv;
        void $this$viewModels$iv;
        Lazy lazy;
        LanguageFragment languageFragment = this;
        Function0 function0 = (Function0)new Function0<LanguageFragment>(this){
            final /* synthetic */ LanguageFragment this$0;

            @NotNull
            public final LanguageFragment invoke() {
                return this.this$0;
            }
            {
                this.this$0 = languageFragment;
                super(0);
            }
        };
        Function0 function02 = (Function0)new Function0<ViewModelProvider.AndroidViewModelFactory>(this){
            final /* synthetic */ LanguageFragment this$0;

            @NotNull
            public final ViewModelProvider.AndroidViewModelFactory invoke() {
                FragmentActivity fragmentActivity = this.this$0.requireActivity();
                Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"requireActivity()");
                ViewModelProvider.AndroidViewModelFactory androidViewModelFactory = ViewModelProvider.AndroidViewModelFactory.getInstance((Application)fragmentActivity.getApplication());
                Intrinsics.checkExpressionValueIsNotNull((Object)androidViewModelFactory, (String)"ViewModelProvider.Androi\u2026reActivity().application)");
                return androidViewModelFactory;
            }
            {
                this.this$0 = languageFragment;
                super(0);
            }
        };
        LanguageFragment languageFragment2 = this;
        boolean $i$f$viewModels = false;
        languageFragment2.viewModel$delegate = lazy = FragmentViewModelLazyKt.createViewModelLazy((Fragment)$this$viewModels$iv, (KClass)Reflection.getOrCreateKotlinClass(LanguageViewModel.class), (Function0)((Function0)new Function0<ViewModelStore>((Function0)ownerProducer$iv){
            final /* synthetic */ Function0 $ownerProducer;
            {
                this.$ownerProducer = function0;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = ((ViewModelStoreOwner)this.$ownerProducer.invoke()).getViewModelStore();
                Intrinsics.checkExpressionValueIsNotNull((Object)viewModelStore, (String)"ownerProducer().viewModelStore");
                return viewModelStore;
            }
        }), (Function0)factoryProducer$iv);
    }

    static {
        Companion = new Companion(null);
        DIFF_CALLBACK = new DiffUtil.ItemCallback<Map<String, ? extends Object>>(){

            public boolean areItemsTheSame(@NotNull Map<String, ? extends Object> oldItem, @NotNull Map<String, ? extends Object> newItem) {
                Intrinsics.checkParameterIsNotNull(oldItem, (String)"oldItem");
                Intrinsics.checkParameterIsNotNull(newItem, (String)"newItem");
                return Intrinsics.areEqual(oldItem, newItem);
            }

            public boolean areContentsTheSame(@NotNull Map<String, ? extends Object> oldItem, @NotNull Map<String, ? extends Object> newItem) {
                Intrinsics.checkParameterIsNotNull(oldItem, (String)"oldItem");
                Intrinsics.checkParameterIsNotNull(newItem, (String)"newItem");
                return Intrinsics.areEqual(oldItem, newItem);
            }
        };
    }

    public static final /* synthetic */ LanguageAdapter access$getAdapter$p(LanguageFragment $this) {
        LanguageAdapter languageAdapter = $this.adapter;
        if (languageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        return languageAdapter;
    }

    public static final /* synthetic */ void access$setAdapter$p(LanguageFragment $this, LanguageAdapter languageAdapter) {
        $this.adapter = languageAdapter;
    }

    public static final /* synthetic */ void access$onItemClick(LanguageFragment $this, View v) {
        $this.onItemClick(v);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0002H\u0016R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00070\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/talpa/translate/language/LanguageFragment$LanguageObserver;", "Landroidx/lifecycle/Observer;", "", "Ljava/util/HashMap;", "", "", "languageFragment", "Lcom/talpa/translate/language/LanguageFragment;", "(Lcom/talpa/translate/language/LanguageFragment;)V", "weakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "onChanged", "", "t", "language_release"})
    private static final class LanguageObserver
    implements Observer<List<? extends HashMap<String, Object>>> {
        private final WeakReference<LanguageFragment> weakReference;

        public void onChanged(@NotNull List<? extends HashMap<String, Object>> t) {
            block0: {
                Intrinsics.checkParameterIsNotNull(t, (String)"t");
                LanguageFragment languageFragment = (LanguageFragment)((Object)this.weakReference.get());
                if (languageFragment == null) break block0;
                languageFragment.onChanged(t);
            }
        }

        public LanguageObserver(@NotNull LanguageFragment languageFragment) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)languageFragment), (String)"languageFragment");
            this.weakReference = new WeakReference<LanguageFragment>(languageFragment);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J*\u0010\u0011\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J*\u0010\u0017\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J8\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001b0\u00050\u001a\"\u0004\b\u0000\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u001b0\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00030\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/talpa/translate/language/LanguageFragment$FilterWatcher;", "Landroid/text/TextWatcher;", "fragment", "Lcom/talpa/translate/language/LanguageFragment;", "source", "", "Ljava/util/HashMap;", "", "", "(Lcom/talpa/translate/language/LanguageFragment;Ljava/util/List;)V", "weakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "afterTextChanged", "", "s", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "", "count", "after", "onTextChanged", "before", "filterScope", "Landroidx/lifecycle/LiveData;", "T", "", "predicate", "Lkotlin/Function1;", "", "language_release"})
    private static final class FilterWatcher
    implements TextWatcher {
        private final WeakReference<LanguageFragment> weakReference;
        private final List<HashMap<String, Object>> source;

        public void afterTextChanged(@Nullable Editable s) {
            Object text;
            LanguageFragment languageFragment = (LanguageFragment)((Object)this.weakReference.get());
            if (languageFragment == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)languageFragment), (String)"weakReference.get() ?: return");
            LanguageFragment fragment = languageFragment;
            LifecycleOwner lifecycleOwner = fragment.getViewLifecycleOwner();
            Intrinsics.checkExpressionValueIsNotNull((Object)lifecycleOwner, (String)"fragment.viewLifecycleOwner");
            LifecycleOwner viewLifecycleOwner = lifecycleOwner;
            Lifecycle lifecycle = viewLifecycleOwner.getLifecycle();
            Intrinsics.checkExpressionValueIsNotNull((Object)lifecycle, (String)"viewLifecycleOwner.lifecycle");
            if (lifecycle.getCurrentState() != Lifecycle.State.RESUMED) {
                return;
            }
            Object object = s;
            if (object == null || (object = object.toString()) == null) {
                return;
            }
            Object object2 = text = object;
            boolean bl = false;
            Object object3 = object2;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            if (TextUtils.isEmpty((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString())) {
                LanguageFragment.access$getAdapter$p(fragment).submitList(this.source);
                return;
            }
            bl = false;
            HashSet set = new HashSet();
            LiveData filterListLiveData2 = this.filterScope((Collection)this.source, (Function1)new Function1<HashMap<String, Object>, Boolean>((String)text, set){
                final /* synthetic */ String $text;
                final /* synthetic */ HashSet $set;

                public final boolean invoke(@NotNull HashMap<String, Object> map) {
                    String displayLanguage;
                    Locale locale;
                    Intrinsics.checkParameterIsNotNull(map, (String)"map");
                    Object object = map.get("item_key_language_tag");
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    String languageTag = (String)object;
                    Locale locale2 = locale = Locale.forLanguageTag(languageTag);
                    Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"locale");
                    String string = displayLanguage = locale2.getDisplayLanguage();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"displayLanguage");
                    return StringsKt.contains((CharSequence)string, (CharSequence)this.$text, (boolean)true) && this.$set.add(languageTag);
                }
                {
                    this.$text = string;
                    this.$set = hashSet;
                    super(1);
                }
            });
            set.clear();
            filterListLiveData2.observe(viewLifecycleOwner, (Observer)new Observer<List<? extends HashMap<String, Object>>>(fragment){
                final /* synthetic */ LanguageFragment $fragment;

                public final void onChanged(List<? extends HashMap<String, Object>> list) {
                    LanguageFragment.access$getAdapter$p(this.$fragment).submitList(list);
                }
                {
                    this.$fragment = languageFragment;
                }
            });
        }

        private final <T> LiveData<List<T>> filterScope(@NotNull Collection<? extends T> $this$filterScope, Function1<? super T, Boolean> predicate) {
            return CoroutineLiveDataKt.liveData$default(null, (long)0L, (Function2)new Function2<LiveDataScope<List<? extends T>>, Continuation<? super Unit>, Object>($this$filterScope, predicate, null){
                private LiveDataScope p$;
                Object L$0;
                int label;
                final /* synthetic */ Collection $this_filterScope;
                final /* synthetic */ Function1 $predicate;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$filterTo$iv$iv;
                            void $this$filter$iv;
                            ResultKt.throwOnFailure((Object)$result);
                            LiveDataScope $this$liveData = this.p$;
                            Iterable iterable = this.$this_filterScope;
                            Function1 function1 = this.$predicate;
                            LiveDataScope liveDataScope = $this$liveData;
                            boolean $i$f$filter = false;
                            void var6_9 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                void predicate$iv;
                                if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            List list = (List)destination$iv$iv;
                            this.L$0 = $this$liveData;
                            this.label = 1;
                            Object object2 = liveDataScope.emit((Object)list, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            LiveDataScope $this$liveData = (LiveDataScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$this_filterScope = collection;
                    this.$predicate = function1;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<LiveDataScope<List<? extends T>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    LiveDataScope liveDataScope = function2.p$ = (LiveDataScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }, (int)3, null);
        }

        public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
        }

        public FilterWatcher(@NotNull LanguageFragment fragment, @NotNull List<? extends HashMap<String, Object>> source) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)fragment), (String)"fragment");
            Intrinsics.checkParameterIsNotNull(source, (String)"source");
            this.source = source;
            this.weakReference = new WeakReference<LanguageFragment>(fragment);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0019\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\b\t*\u0001\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/talpa/translate/language/LanguageFragment$Companion;", "", "()V", "BROAD_ACTION_SELECTED_LANGUAGE", "", "DIFF_CALLBACK", "com/talpa/translate/language/LanguageFragment$Companion$DIFF_CALLBACK$1", "Lcom/talpa/translate/language/LanguageFragment$Companion$DIFF_CALLBACK$1;", "EXTRA_ENABLED_AUTO_DETECT", "EXTRA_EXCLUDE_LANGUAGE_TAG", "EXTRA_LANGUAGE_TAG", "EXTRA_LANGUAGE_TYPE", "EXTRA_RECENT_LANGUAGE_LIST", "EXTRA_SELECTED_AUTO_DETECT", "language_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

