/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.base.view.alert;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.photo.translation.R;
import com.talpa.translate.base.view.alert.AlertAnimateUtil;
import com.talpa.translate.base.view.alert.OnDismissListener;
import com.talpa.translate.base.view.alert.OnItemClickListener;
import java.lang.ref.WeakReference;

public class AlertView {
    private final FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, 80);
    private WeakReference<Context> contextWeak;
    private ViewGroup contentContainer;
    private ViewGroup decorView;
    private ViewGroup rootView;
    private OnDismissListener onDismissListener;
    private OnItemClickListener onItemClickListener;
    private boolean isShowing;
    private Animation outAnim;
    private Animation inAnim;
    private int gravity = 17;
    private Animation.AnimationListener outAnimListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            AlertView.this.dismissImmediately();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };
    private final View.OnTouchListener onCancelableTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                AlertView.this.dismiss();
            }
            return false;
        }
    };

    public AlertView(Context context, OnItemClickListener onItemClickListener) {
        this.contextWeak = new WeakReference<Context>(context);
        this.onItemClickListener = onItemClickListener;
        this.initViews();
        this.init();
        this.initEvents();
    }

    protected void initViews() {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return;
        }
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.decorView = (ViewGroup)((Activity)context).getWindow().getDecorView().findViewById(0x1020002);
        this.rootView = (ViewGroup)layoutInflater.inflate(R.layout.layout_alertview, this.decorView, false);
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.contentContainer = (ViewGroup)this.rootView.findViewById(R.id.content_container);
        int margin_alert_left_right = 0;
        this.params.gravity = 17;
        margin_alert_left_right = context.getResources().getDimensionPixelSize(R.dimen.margin_alert_left_right);
        this.params.setMargins(margin_alert_left_right, 0, margin_alert_left_right, 0);
        this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
        this.gravity = 17;
        this.initAlertViews(layoutInflater);
    }

    protected void initAlertViews(LayoutInflater layoutInflater) {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return;
        }
        ViewGroup viewGroup = (ViewGroup)layoutInflater.inflate(R.layout.layout_alertview_alert, this.contentContainer);
        viewGroup.findViewById(R.id.confirm).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AlertView.this.onItemClickListener != null) {
                    AlertView.this.onItemClickListener.onConfirm(AlertView.this);
                }
            }
        });
        viewGroup.findViewById(R.id.cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AlertView.this.onItemClickListener != null) {
                    AlertView.this.onItemClickListener.onCancel(AlertView.this);
                }
            }
        });
    }

    protected void init() {
        this.inAnim = this.getInAnimation();
        this.outAnim = this.getOutAnimation();
    }

    protected void initEvents() {
    }

    private void onAttached(View view) {
        this.isShowing = true;
        this.decorView.addView(view);
        this.contentContainer.startAnimation(this.inAnim);
    }

    public void show() {
        if (this.isShowing()) {
            return;
        }
        this.onAttached((View)this.rootView);
    }

    public boolean isShowing() {
        return this.rootView.getParent() != null && this.isShowing;
    }

    public void dismiss() {
        this.outAnim.setAnimationListener(this.outAnimListener);
        this.contentContainer.startAnimation(this.outAnim);
    }

    public void dismissImmediately() {
        this.decorView.removeView((View)this.rootView);
        this.isShowing = false;
        if (this.onDismissListener != null) {
            this.onDismissListener.onDismiss(this);
        }
    }

    public Animation getInAnimation() {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return null;
        }
        int res = AlertAnimateUtil.getAnimationResource(this.gravity, true);
        return AnimationUtils.loadAnimation((Context)context, (int)res);
    }

    public Animation getOutAnimation() {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return null;
        }
        int res = AlertAnimateUtil.getAnimationResource(this.gravity, false);
        return AnimationUtils.loadAnimation((Context)context, (int)res);
    }

    public void setMarginBottom(int marginBottom) {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return;
        }
        int margin_alert_left_right = context.getResources().getDimensionPixelSize(R.dimen.margin_alert_left_right);
        this.params.setMargins(margin_alert_left_right, 0, margin_alert_left_right, marginBottom);
        this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    public AlertView setCancelable(boolean isCancelable) {
        View view = this.rootView.findViewById(R.id.outmost_container);
        if (isCancelable) {
            view.setOnTouchListener(this.onCancelableTouchListener);
        } else {
            view.setOnTouchListener(null);
        }
        return this;
    }
}

