/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.base.utils;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.graphics.Rect;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.os.StatFs;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.core.os.LocaleListCompat;
import com.google.common.io.BaseEncoding;
import com.talpa.translate.base.utils.LanguageUtilsKt;
import java.io.File;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u001a.\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001f\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0016\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0017\u001a\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004\u001a\u0006\u0010\u001c\u001a\u00020\u001d\u001a \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004\u001a\u0012\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010#\u001a\u00020$H\u0002\u001a\u001a\u0010%\u001a\u00020\u001f*\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010\t\u001a\u00020'\u001a\n\u0010(\u001a\u00020\u001d*\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"MAX_TEXT_SIZE", "", "MIN_TEXT_SIZE", "PREFER_KEY_SOURCE_LANG", "", "PREFER_NAME", "crypt", "str", "getAutofitTextSize", "text", "paint", "Landroid/text/TextPaint;", "rect", "Landroid/graphics/Rect;", "maxTextSize", "context", "Landroid/content/Context;", "getFreeSpace", "", "getLocaleListCompat", "Landroidx/core/os/LocaleListCompat;", "languages", "", "([Ljava/lang/String;)Landroidx/core/os/LocaleListCompat;", "getSignature", "pm", "Landroid/content/pm/PackageManager;", "packageName", "isSDCardEnable", "", "saveLanguage", "", "preferKey", "value", "signatureDigest", "sig", "Landroid/content/pm/Signature;", "clipboard", "label", "", "isNetworkConnected", "translation_devDebug"})
public final class UtilsKt {
    @NotNull
    public static final String PREFER_KEY_SOURCE_LANG = "key_source_lang";
    @NotNull
    public static final String PREFER_NAME = "prefer_camera";
    public static final int MAX_TEXT_SIZE = 16;
    public static final int MIN_TEXT_SIZE = 4;

    public static final void saveLanguage(@NotNull Context context, @NotNull String preferKey, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)preferKey, (String)"preferKey");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences prefer = context.getSharedPreferences(PREFER_NAME, 0);
        prefer.edit().putString(preferKey, value).apply();
    }

    public static /* synthetic */ void saveLanguage$default(Context context, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = PREFER_KEY_SOURCE_LANG;
        }
        UtilsKt.saveLanguage(context, string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNetworkConnected(@NotNull Context $this$isNetworkConnected) {
        NetworkInfo networkInfo;
        Intrinsics.checkNotNullParameter((Object)$this$isNetworkConnected, (String)"$this$isNetworkConnected");
        Object object = $this$isNetworkConnected.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        NetworkInfo networkInfo2 = networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo2 == null) return false;
        if (!networkInfo2.isAvailable()) return false;
        if (!networkInfo.isConnected()) return false;
        return true;
    }

    @NotNull
    public static final String crypt(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        CharSequence charSequence = str;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return "";
        }
        StringBuffer hexString = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            String string2 = str;
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            md.update(byArray);
            byte[] hash = md.digest();
            int n = hash.length;
            bl2 = false;
            int n2 = 0;
            int n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                int it = n2;
                boolean bl3 = false;
                if ((0xFF & hash[it]) < 16) {
                    hexString.append("0" + Integer.toHexString(0xFF & hash[it]));
                    continue;
                }
                hexString.append(Integer.toHexString(0xFF & hash[it]));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        String string3 = hexString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"hexString.toString()");
        return string3;
    }

    public static final boolean isSDCardEnable() {
        return Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState());
    }

    public static final long getFreeSpace() {
        if (!UtilsKt.isSDCardEnable()) {
            return -1L;
        }
        File file = Environment.getExternalStorageDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"Environment.getExternalStorageDirectory()");
        StatFs stat = new StatFs(file.getPath());
        long blockSize = stat.getBlockSizeLong();
        long availableBlocks = stat.getAvailableBlocksLong();
        long size = availableBlocks * blockSize / 1024L;
        return size;
    }

    @NotNull
    public static final LocaleListCompat getLocaleListCompat(String ... languages) {
        Intrinsics.checkNotNullParameter((Object)languages, (String)"languages");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder builder = stringBuilder;
        boolean bl3 = false;
        String[] $this$forEach$iv = languages;
        boolean $i$f$forEach = false;
        String[] stringArray = $this$forEach$iv;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = stringArray[i];
            boolean bl4 = false;
            builder.append(it);
            builder.append(",");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder()\n        \u2026   }\n        }.toString()");
        String supportList = string2;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        String string3 = locale.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Locale.getDefault().language");
        LocaleListCompat localeListCompat = LocaleListCompat.forLanguageTags((String)LanguageUtilsKt.getOrderedLanguageList(string3, supportList));
        Intrinsics.checkNotNullExpressionValue((Object)localeListCompat, (String)"LocaleListCompat.forLang\u2026).language, supportList))");
        return localeListCompat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final String getSignature(@NotNull PackageManager pm, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)pm, (String)"pm");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        try {
            PackageInfo packageInfo;
            PackageInfo packageInfo2 = packageInfo = pm.getPackageInfo(packageName, 64);
            if (packageInfo2 == null) return null;
            Signature[] signatureArray = packageInfo2.signatures;
            if (signatureArray == null) return null;
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo.signatures, (String)"packageInfo.signatures");
            Signature[] signatureArray2 = packageInfo.signatures;
            boolean bl = false;
            if (signatureArray2.length == 0) {
                return null;
            }
            boolean bl2 = false;
            if (bl2) return null;
            if (packageInfo.signatures[0] == null) {
                return null;
            }
            Signature signature = packageInfo.signatures[0];
            Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"packageInfo.signatures[0]");
            String string2 = UtilsKt.signatureDigest(signature);
            return string2;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private static final String signatureDigest(Signature sig) {
        String string2;
        byte[] signature = sig.toByteArray();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] digest = md.digest(signature);
            string2 = BaseEncoding.base16().lowerCase().encode(digest);
        }
        catch (NoSuchAlgorithmException e) {
            string2 = null;
        }
        return string2;
    }

    public static final int getAutofitTextSize(@NotNull String text, @NotNull TextPaint paint, @NotNull Rect rect, int maxTextSize, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int textsize = maxTextSize;
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        paint.setTextSize(TypedValue.applyDimension((int)2, (float)textsize, (DisplayMetrics)displayMetrics));
        StaticLayout staticLayout = new StaticLayout((CharSequence)text, paint, rect.width(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        while (staticLayout.getHeight() > rect.height() && textsize > 4) {
            paint.setTextSize(TypedValue.applyDimension((int)2, (float)(--textsize), (DisplayMetrics)displayMetrics));
            staticLayout = new StaticLayout((CharSequence)text, paint, rect.width(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        }
        return textsize;
    }

    public static final void clipboard(@NotNull Context $this$clipboard, @NotNull CharSequence label, @NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)$this$clipboard, (String)"$this$clipboard");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            String newLabel = $this$clipboard.getPackageName() + '_' + label;
            Object object = $this$clipboard.getSystemService("clipboard");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.content.ClipboardManager");
            }
            ClipboardManager cm = (ClipboardManager)object;
            ClipData clipData = ClipData.newPlainText((CharSequence)newLabel, (CharSequence)text);
            cm.setPrimaryClip(clipData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

