/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.record;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcelable;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import androidx.annotation.RestrictTo;
import com.talpa.TranslationController;
import com.talpa.translate.activity.ScreenRecordActivity;
import com.talpa.translate.base.common.FrameMetadata;
import com.talpa.translate.camera.view.controls.Facing;
import com.talpa.translate.camera.view.controls.PictureFormat;
import com.talpa.translate.network.HiTranslator;
import com.talpa.translate.network.TransResponse;
import com.talpa.translate.ocr.OcrDispatcher;
import com.talpa.translate.ocr.Recognizer;
import com.talpa.translate.ocr.datasource.TransParams;
import com.talpa.translate.ocr.result.Block;
import com.talpa.translate.ocr.result.OcrResult;
import com.talpa.translate.record.CaptureManager;
import com.talpa.translate.record.CaptureManager$delegateRecTouchEvent$;
import com.talpa.translate.record.CaptureResult;
import com.talpa.translate.record.CaptureTransResult;
import com.talpa.translate.record.ICaptureController;
import com.talpa.translate.record.IRecordListener;
import com.talpa.translate.record.IRecordService;
import com.talpa.translate.service.RecordService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0091\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0015\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0001>B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020 H\u0016J#\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u001eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u001eH\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002J\u001a\u00100\u001a\u00020 2\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0016J\u0012\u00105\u001a\u00020 2\b\u00101\u001a\u0004\u0018\u000102H\u0016J\u0010\u00106\u001a\u00020 2\u0006\u00107\u001a\u00020\u000bH\u0017J\u0010\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020\u0018H\u0016J \u0010:\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020=H\u0017R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006?"}, d2={"Lcom/talpa/translate/record/CaptureManager;", "Landroid/content/ServiceConnection;", "Lcom/talpa/translate/record/ICaptureController;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mCaptureJob", "Lkotlinx/coroutines/Job;", "mContext", "kotlin.jvm.PlatformType", "mCurrentState", "", "mLastResult", "Lcom/talpa/translate/record/CaptureTransResult;", "mLastX", "", "mLastY", "mRecognizeJob", "mRecordService", "Lcom/talpa/translate/record/IRecordService;", "mRemoteCallback", "com/talpa/translate/record/CaptureManager$mRemoteCallback$1", "Lcom/talpa/translate/record/CaptureManager$mRemoteCallback$1;", "mResultListener", "Lcom/talpa/TranslationController$TextRecognizeListener;", "mTranslator", "Lcom/talpa/translate/ocr/Recognizer;", "velocityTracker", "Landroid/view/VelocityTracker;", "captureFrameSync", "Lcom/talpa/translate/record/CaptureResult;", "delegateRecTouchEvent", "", "e", "Landroid/view/MotionEvent;", "destroyRecognizeService", "doTextRecognize", "Lcom/talpa/translate/ocr/result/OcrResult;", "index", "captureResult", "(ILcom/talpa/translate/record/CaptureResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fastAnalyzeArea", "result", "isRectangleOverlap", "", "current", "Landroid/graphics/Rect;", "other", "onServiceConnected", "name", "Landroid/content/ComponentName;", "service", "Landroid/os/IBinder;", "onServiceDisconnected", "setCurrentState", "state", "setTextRecognizeListener", "listener", "startRecordService", "resultCode", "data", "Landroid/content/Intent;", "Companion", "translation_devDebug"})
public final class CaptureManager
implements ServiceConnection,
ICaptureController {
    private TranslationController.TextRecognizeListener mResultListener;
    private IRecordService mRecordService;
    private final Recognizer mTranslator;
    private final Context mContext;
    private int mCurrentState;
    private float mLastX;
    private float mLastY;
    private Job mCaptureJob;
    private Job mRecognizeJob;
    private CaptureTransResult mLastResult;
    private VelocityTracker velocityTracker;
    private final mRemoteCallback.1 mRemoteCallback;
    public static final int RECT_GAP = 12;
    public static final int MIN_DISTANCE = 15;
    public static final int STATE_INITIALIZE = 0;
    public static final int STATE_ASKING_PERMISSION = 1;
    public static final int STATE_PERMISSION_GRANTED = 2;
    public static final int STATE_SERVICE_PREPARED = 3;
    public static final int STATE_CAPTURING_PIC = 4;
    public static final int STATE_CAPTURED_PIC = 5;
    public static final int STATE_RECOGNIZE_START = 6;
    public static final int STATE_RECOGNIZING = 7;
    public static final int STATE_TRANSLATING = 8;
    public static final int STATE_RECOGNIZED_FINISH = 9;
    public static final int STATE_TRANSLATE_FINISH = 10;
    public static final int STATE_ACTION_CLEAR = 11;
    private static final int VELOCITY_TIME_MILLIS = 300;
    private static final int MIN_VELOCITY = 80;
    public static final Companion Companion = new Companion(null);

    @Override
    public void setTextRecognizeListener(@NotNull TranslationController.TextRecognizeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mResultListener = listener;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setCurrentState(int state) {
        this.mCurrentState = state;
        switch (this.mCurrentState) {
            case 0: {
                Log.d((String)"cjslog", (String)"STATE_INITIALIZE");
                break;
            }
            case 1: {
                Log.d((String)"cjslog", (String)"STATE_ASKING_PERMISSION");
                break;
            }
            case 2: {
                Log.d((String)"cjslog", (String)"STATE_PERMISSION_GRANTED");
                break;
            }
            case 3: {
                Log.d((String)"cjslog", (String)"STATE_SERVICE_PREPARED");
                break;
            }
            case 4: {
                Log.d((String)"cjslog", (String)"STATE_CAPTURING_PIC");
                break;
            }
            case 5: {
                Log.d((String)"cjslog", (String)"STATE_CAPTURED_PIC");
                break;
            }
            case 6: {
                Log.d((String)"cjslog", (String)"STATE_RECOGNIZE_START");
                break;
            }
            case 7: {
                Log.d((String)"cjslog", (String)"STATE_RECOGNIZING");
                break;
            }
            case 9: {
                Log.d((String)"cjslog", (String)"STATE_RECOGNIZED_FINISH");
                break;
            }
            case 10: {
                Log.d((String)"cjslog", (String)"STATE_TRANSLATE_FINISH");
                break;
            }
            case 11: {
                Log.d((String)"cjslog", (String)"STATE_ACTION_CLEAR");
                break;
            }
        }
    }

    @Override
    @NotNull
    public CaptureResult captureFrameSync(@NotNull Context context) {
        CaptureResult captureResult;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.mRecordService == null) {
            ScreenRecordActivity.Companion.start(context);
            return new CaptureResult(0, null, null, 6, null);
        }
        try {
            IRecordService iRecordService = this.mRecordService;
            Intrinsics.checkNotNull((Object)iRecordService);
            captureResult = iRecordService.captureFrameSync();
        }
        catch (Exception e) {
            e.printStackTrace();
            captureResult = null;
        }
        CaptureResult captureResult2 = captureResult;
        if (captureResult2 == null) {
            return new CaptureResult(2, null, null, 6, null);
        }
        CaptureResult result = captureResult2;
        this.fastAnalyzeArea(result);
        return result;
    }

    private final boolean isRectangleOverlap(Rect current, Rect other) {
        return current.left < other.right && other.left < current.right && current.top < other.bottom && other.top < current.bottom;
    }

    private final void fastAnalyzeArea(CaptureResult result) {
        if (result.getBitmap() == null) {
            return;
        }
        List list = result.getRects();
        if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
            return;
        }
        List list2 = list;
        if (list2.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rect it = (Rect)element$iv;
            boolean bl = false;
            it.inset(-12, -12);
            int n = 0;
            int n2 = it.left;
            boolean bl2 = false;
            it.left = Math.max(n, n2);
            n = 0;
            n2 = it.top;
            bl2 = false;
            it.top = Math.max(n, n2);
            Bitmap bitmap2 = result.getBitmap();
            Intrinsics.checkNotNull((Object)bitmap2);
            n = bitmap2.getWidth();
            n2 = it.right;
            bl2 = false;
            it.right = Math.min(n, n2);
            Bitmap bitmap3 = result.getBitmap();
            Intrinsics.checkNotNull((Object)bitmap3);
            n = bitmap3.getHeight();
            n2 = it.bottom;
            bl2 = false;
            it.bottom = Math.min(n, n2);
        }
        for (int i = 0; i < list2.size(); ++i) {
            for (int j = i + 1; j < list2.size(); ++j) {
                if (!this.isRectangleOverlap((Rect)list2.get(i), (Rect)list2.get(j))) continue;
                ((Rect)list2.get(i)).union((Rect)list2.get(j));
                list2.remove(j);
                --j;
            }
        }
        result.setRects(list2);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void startRecordService(@NotNull Context context, int resultCode, @NotNull Intent data) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intent serviceIntent = new Intent(context, RecordService.class);
        serviceIntent.putExtra("project_intent", (Parcelable)data);
        serviceIntent.putExtra("project_code", resultCode);
        context.getApplicationContext().bindService(serviceIntent, (ServiceConnection)this, 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object doTextRecognize(int index, @NotNull CaptureResult captureResult, @NotNull Continuation<? super OcrResult> $completion) {
        if (!($completion instanceof doTextRecognize.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ CaptureManager this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.doTextRecognize(0, null, (Continuation<? super OcrResult>)this);
                }
                {
                    this.this$0 = captureManager;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = captureResult.getRects();
                Intrinsics.checkNotNull(v0);
                rect = v0.get(index);
                v1 = new FrameMetadata.Builder().setWidth(rect.width()).setHeight(rect.height()).setCameraFacing(Facing.BACK).setPictureFormat(PictureFormat.JPEG).setRotation(0).build();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"FrameMetadata.Builder()\n\u2026                 .build()");
                v2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"Locale.getDefault()");
                v3 = v2.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"Locale.getDefault().language");
                this.mTranslator.setup(new TransParams(v1, v3));
                v4 = captureResult.getBitmap();
                Intrinsics.checkNotNull((Object)v4);
                v5 = Bitmap.createBitmap((Bitmap)v4, (int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height());
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"Bitmap.createBitmap(\n   \u2026eight()\n                )");
                $continuation.L$0 = this;
                $continuation.I$0 = index;
                $continuation.L$1 = captureResult;
                $continuation.L$2 = rect;
                $continuation.label = 1;
                v6 = this.mTranslator.doOcr(v5, (Continuation<? super OcrResult>)$continuation);
                ** if (v6 != var9_6) goto lbl36
lbl35:
                // 1 sources

                return var9_6;
lbl36:
                // 1 sources

                ** GOTO lbl46
            }
            case 1: {
                rect = (Rect)$continuation.L$2;
                captureResult = (CaptureResult)$continuation.L$1;
                index = $continuation.I$0;
                this = (CaptureManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl46:
                    // 2 sources

                    var5_9 = (OcrResult)v6;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    var5_9 = null;
                }
                return var5_9;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void destroyRecognizeService() {
        IRecordService iRecordService = this.mRecordService;
        if (iRecordService != null) {
            iRecordService.destroyService();
        }
        this.mRecordService = null;
    }

    public void onServiceDisconnected(@Nullable ComponentName name) {
        this.mRecordService = null;
    }

    /*
     * WARNING - void declaration
     */
    public void onServiceConnected(@Nullable ComponentName name, @NotNull IBinder service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        IRecordService iRecordService = IRecordService.Stub.asInterface(service);
        boolean bl = false;
        boolean bl2 = false;
        IRecordService iRecordService2 = iRecordService;
        CaptureManager captureManager = this;
        boolean bl3 = false;
        try {
            void it;
            it.registerListener(this.mRemoteCallback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Unit unit = Unit.INSTANCE;
        captureManager.mRecordService = iRecordService;
        this.setCurrentState(3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void delegateRecTouchEvent(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        VelocityTracker velocityTracker = this.velocityTracker;
        Intrinsics.checkNotNull((Object)velocityTracker);
        velocityTracker.addMovement(e);
        block0 : switch (e.getAction()) {
            case 0: {
                Unit unit;
                Unit unit2;
                this.mLastX = e.getRawX();
                this.mLastY = e.getRawY();
                if (this.mRecordService == null) break;
                Job job = this.mRecognizeJob;
                if (job != null) {
                    Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                Job job2 = this.mCaptureJob;
                if (job2 != null) {
                    Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                this.setCurrentState(3);
                break;
            }
            case 2: {
                switch (this.mCurrentState) {
                    case 0: {
                        float f = e.getRawX() - this.mLastX;
                        boolean bl = false;
                        float dx = Math.abs(f);
                        float f2 = e.getRawY() - this.mLastY;
                        boolean bl2 = false;
                        float dy = Math.abs(f2);
                        f2 = dx * dx + dy * dy;
                        bl2 = false;
                        if (!((float)Math.sqrt(f2) > (float)15)) break block0;
                        Log.d((String)"cjslog", (String)"asking permission");
                        Context context = this.mContext;
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mContext");
                        this.captureFrameSync(context);
                        this.setCurrentState(1);
                        break block0;
                    }
                    case 3: {
                        Unit unit;
                        float dy = e.getRawX() - this.mLastX;
                        boolean bl = false;
                        float dx = Math.abs(dy);
                        float f = e.getRawY() - this.mLastY;
                        boolean bl3 = false;
                        dy = Math.abs(f);
                        f = dx * dx + dy * dy;
                        bl3 = false;
                        if (!((float)Math.sqrt(f) > (float)15)) break block0;
                        Log.d((String)"cjslog", (String)"start capture picture");
                        this.setCurrentState(4);
                        Job job = this.mCaptureJob;
                        if (job != null) {
                            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        this.mCaptureJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            private CoroutineScope p$;
                            Object L$0;
                            Object L$1;
                            int label;
                            final /* synthetic */ CaptureManager this$0;

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Object object2;
                                        Object object3;
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        CoroutineScope $this$launch = this.p$;
                                        Context context = CaptureManager.access$getMContext$p(this.this$0);
                                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mContext");
                                        CaptureResult captureResult = this.this$0.captureFrameSync(context);
                                        CaptureTransResult captureTransResult = new CaptureTransResult(captureResult, null, null, 6, null);
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        CaptureTransResult captureTransResult2 = captureTransResult;
                                        CaptureManager captureManager = this.this$0;
                                        boolean bl3 = false;
                                        boolean bl4 = false;
                                        it.setOcrResultMap((Map<Integer, OcrResult>)new HashMap<K, V>());
                                        bl4 = false;
                                        it.setTransMap((Map<Integer, TransResponse>)new HashMap<K, V>());
                                        Unit unit = Unit.INSTANCE;
                                        CaptureManager.access$setMLastResult$p(captureManager, captureTransResult);
                                        Log.d((String)"cjslog", (String)("picture capture finish:" + ((object3 = CaptureManager.access$getMLastResult$p(this.this$0)) != null && (object3 = ((CaptureTransResult)object3).getCaptureResult()) != null ? ((CaptureResult)object3).getBitmap() : null) + ' ' + ((object2 = CaptureManager.access$getMLastResult$p(this.this$0)) != null && (object2 = ((CaptureTransResult)object2).getCaptureResult()) != null ? ((CaptureResult)object2).getRects() : null)));
                                        this.L$0 = $this$launch;
                                        this.L$1 = captureResult;
                                        this.label = 1;
                                        Object object4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                            private CoroutineScope p$;
                                            int label;
                                            final /* synthetic */ delegateRecTouchEvent.1 this$0;

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object $result) {
                                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        CoroutineScope $this$withContext = this.p$;
                                                        this.this$0.this$0.setCurrentState(5);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }
                                            {
                                                this.this$0 = var1_1;
                                                super(2, continuation);
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                                return function2;
                                            }

                                            public final Object invoke(Object object, Object object2) {
                                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)this);
                                        if (object4 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        CaptureResult captureResult = (CaptureResult)this.L$1;
                                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object4 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            {
                                this.this$0 = captureManager;
                                super(2, continuation);
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                return function2;
                            }

                            public final Object invoke(Object object, Object object2) {
                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        break block0;
                    }
                    case 5: {
                        Unit unit;
                        VelocityTracker velocityTracker2 = this.velocityTracker;
                        Intrinsics.checkNotNull((Object)velocityTracker2);
                        velocityTracker2.computeCurrentVelocity(300);
                        VelocityTracker velocityTracker3 = this.velocityTracker;
                        Intrinsics.checkNotNull((Object)velocityTracker3);
                        float xVelocity = velocityTracker3.getXVelocity();
                        VelocityTracker velocityTracker4 = this.velocityTracker;
                        Intrinsics.checkNotNull((Object)velocityTracker4);
                        float yVelocity = velocityTracker4.getYVelocity();
                        if (!(xVelocity < (float)80) || !(yVelocity < (float)80)) break block0;
                        Object object = this.mLastResult;
                        if (object != null && (object = ((CaptureTransResult)object).getCaptureResult()) != null) {
                            void index;
                            Unit unit3;
                            Object object2 = object;
                            boolean bl = false;
                            boolean bl4 = false;
                            Object result = object2;
                            boolean bl5 = false;
                            Ref.IntRef intRef = new Ref.IntRef();
                            intRef.element = -1;
                            List<Rect> list = ((CaptureResult)result).getRects();
                            if (list != null) {
                                List<Rect> list2 = list;
                                boolean bl6 = false;
                                boolean bl7 = false;
                                List<Rect> rects = list2;
                                boolean bl8 = false;
                                Iterable $this$forEachIndexed$iv = rects;
                                boolean $i$f$forEachIndexed = false;
                                int index$iv = 0;
                                for (Object item$iv : $this$forEachIndexed$iv) {
                                    void rect;
                                    int n = index$iv++;
                                    boolean bl9 = false;
                                    if (n < 0) {
                                        CollectionsKt.throwIndexOverflow();
                                    }
                                    Rect rect2 = (Rect)item$iv;
                                    int i = n;
                                    boolean bl10 = false;
                                    if (!rect.contains((int)e.getRawX(), (int)e.getRawY())) continue;
                                    index.element = i;
                                    break;
                                }
                                unit3 = Unit.INSTANCE;
                            } else {
                                unit3 = null;
                            }
                            if (index.element != -1) {
                                Unit unit4;
                                Unit unit5;
                                CaptureTransResult captureTransResult = this.mLastResult;
                                Intrinsics.checkNotNull((Object)captureTransResult);
                                captureTransResult.setWorkingIndex(index.element);
                                this.setCurrentState(6);
                                TranslationController.TextRecognizeListener textRecognizeListener = this.mResultListener;
                                if (textRecognizeListener != null) {
                                    List<Rect> list3 = ((CaptureResult)result).getRects();
                                    Intrinsics.checkNotNull(list3);
                                    textRecognizeListener.onAreaConfirmed(list3.get(index.element));
                                    unit5 = Unit.INSTANCE;
                                } else {
                                    unit5 = null;
                                }
                                StringBuilder stringBuilder = new StringBuilder().append("recognize picture start: ");
                                List<Rect> list4 = ((CaptureResult)result).getRects();
                                Intrinsics.checkNotNull(list4);
                                Log.d((String)"cjslog", (String)stringBuilder.append(list4.get(index.element)).toString());
                                Job job = this.mRecognizeJob;
                                if (job != null) {
                                    Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                                    unit4 = Unit.INSTANCE;
                                } else {
                                    unit4 = null;
                                }
                                this.mRecognizeJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.IntRef)index, (CaptureResult)result, null, this, e){
                                    private CoroutineScope p$;
                                    Object L$0;
                                    Object L$1;
                                    Object L$2;
                                    Object L$3;
                                    int label;
                                    final /* synthetic */ Ref.IntRef $index;
                                    final /* synthetic */ CaptureResult $result;
                                    final /* synthetic */ CaptureManager this$0;
                                    final /* synthetic */ MotionEvent $e$inlined;
                                    {
                                        this.$index = intRef;
                                        this.$result = captureResult;
                                        this.this$0 = captureManager;
                                        this.$e$inlined = motionEvent;
                                        super(2, continuation);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object $result) {
                                        block15: {
                                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    $this$launch = this.p$;
                                                    this.this$0.setCurrentState(7);
                                                    this.L$0 = $this$launch;
                                                    this.label = 1;
                                                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super OcrResult>, Object>(this, null){
                                                        private CoroutineScope p$;
                                                        Object L$0;
                                                        int label;
                                                        final /* synthetic */ delegateRecTouchEvent$$inlined$let$lambda$1 this$0;
                                                        {
                                                            this.this$0 = var1_1;
                                                            super(2, continuation);
                                                        }

                                                        /*
                                                         * Enabled force condition propagation
                                                         * Lifted jumps to return sites
                                                         */
                                                        @Nullable
                                                        public final Object invokeSuspend(@NotNull Object $result) {
                                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                            switch (this.label) {
                                                                case 0: {
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    CoroutineScope $this$withContext = this.p$;
                                                                    this.L$0 = $this$withContext;
                                                                    this.label = 1;
                                                                    Object object2 = this.this$0.this$0.doTextRecognize(this.this$0.$index.element, this.this$0.$result, (Continuation<? super OcrResult>)this);
                                                                    Object object3 = object2;
                                                                    if (object2 != object) return object3;
                                                                    return object;
                                                                }
                                                                case 1: {
                                                                    CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    Object object3 = $result;
                                                                    return object3;
                                                                }
                                                            }
                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                        }

                                                        @NotNull
                                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                            Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                            Function2<CoroutineScope, Continuation<? super OcrResult>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                            CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                                            function2.p$ = (CoroutineScope)value;
                                                            Function2<CoroutineScope, Continuation<? super OcrResult>, Object> function22 = function2;
                                                            return function22;
                                                        }

                                                        public final Object invoke(Object object, Object object2) {
                                                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                                        }
                                                    }), (Continuation)this);
                                                    if (v0 == var2_2) {
                                                        var4_5 = var2_2;
                                                        return var4_5;
                                                    }
                                                    ** GOTO lbl18
                                                }
                                                case 1: {
                                                    $this$launch = (CoroutineScope)this.L$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
lbl18:
                                                    // 2 sources

                                                    ocrResult = (OcrResult)v0;
                                                    this.this$0.setCurrentState(9);
                                                    if (ocrResult == null) break;
                                                    v1 = CaptureManager.access$getMLastResult$p(this.this$0);
                                                    Intrinsics.checkNotNull((Object)v1);
                                                    v2 = v1.getOcrResultMap();
                                                    Intrinsics.checkNotNull(v2);
                                                    v2.put(Boxing.boxInt((int)this.$index.element), ocrResult);
                                                    var6_9 = new Ref.ObjectRef();
                                                    v3 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                    if (v3 == null || (v3 = v3.getTransTargetLanguage()) == null) {
                                                        v4 = Locale.ENGLISH;
                                                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"Locale.ENGLISH");
                                                        v3 = v4.getLanguage();
                                                    }
                                                    var6_9.element = v3;
                                                    var7_11 = new Ref.ObjectRef();
                                                    var8_13 = false;
                                                    var7_11.element = new ArrayList<E>();
                                                    $this$forEach$iv = ocrResult.getBlocks();
                                                    $i$f$forEach = false;
                                                    for (T element$iv : $this$forEach$iv) {
                                                        it = (Block)element$iv;
                                                        $i$a$-forEach-CaptureManager$delegateRecTouchEvent$2$2$1 = false;
                                                        ((ArrayList)list.element).add(it.getText());
                                                    }
                                                    this.this$0.setCurrentState(8);
                                                    this.L$0 = $this$launch;
                                                    this.L$1 = ocrResult;
                                                    this.L$2 = targetLanguage;
                                                    this.L$3 = list;
                                                    this.label = 2;
                                                    v5 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransResponse>, Object>(this, (Ref.ObjectRef)targetLanguage, (Ref.ObjectRef)list, null){
                                                        private CoroutineScope p$;
                                                        Object L$0;
                                                        int label;
                                                        final /* synthetic */ delegateRecTouchEvent$$inlined$let$lambda$1 this$0;
                                                        final /* synthetic */ Ref.ObjectRef $targetLanguage;
                                                        final /* synthetic */ Ref.ObjectRef $list;
                                                        {
                                                            this.this$0 = var1_1;
                                                            this.$targetLanguage = objectRef;
                                                            this.$list = objectRef2;
                                                            super(2, continuation);
                                                        }

                                                        /*
                                                         * Enabled force condition propagation
                                                         * Lifted jumps to return sites
                                                         */
                                                        @Nullable
                                                        public final Object invokeSuspend(@NotNull Object $result) {
                                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                            switch (this.label) {
                                                                case 0: {
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    CoroutineScope $this$withContext = this.p$;
                                                                    Context context = CaptureManager.access$getMContext$p(this.this$0.this$0);
                                                                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mContext");
                                                                    HiTranslator hiTranslator = HiTranslator.Companion.getInstance(context);
                                                                    Locale locale = Locale.getDefault();
                                                                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
                                                                    String string2 = locale.getLanguage();
                                                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Locale.getDefault().language");
                                                                    String string3 = (String)this.$targetLanguage.element;
                                                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"targetLanguage");
                                                                    this.L$0 = $this$withContext;
                                                                    this.label = 1;
                                                                    Object object2 = hiTranslator.postTranslate(string2, string3, (ArrayList)this.$list.element, (Continuation<? super TransResponse>)this);
                                                                    Object object3 = object2;
                                                                    if (object2 != object) return object3;
                                                                    return object;
                                                                }
                                                                case 1: {
                                                                    CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    Object object3 = $result;
                                                                    return object3;
                                                                }
                                                            }
                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                        }

                                                        @NotNull
                                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                            Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                            Function2<CoroutineScope, Continuation<? super TransResponse>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                            CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                                            function2.p$ = (CoroutineScope)value;
                                                            Function2<CoroutineScope, Continuation<? super TransResponse>, Object> function22 = function2;
                                                            return function22;
                                                        }

                                                        public final Object invoke(Object object, Object object2) {
                                                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                                        }
                                                    }), (Continuation)this);
                                                    if (v5 == var2_2) {
                                                        var4_6 = var2_2;
                                                        return var4_6;
                                                    }
                                                    ** GOTO lbl64
                                                }
                                                case 2: {
                                                    list = (Ref.ObjectRef)this.L$3;
                                                    targetLanguage = (Ref.ObjectRef)this.L$2;
                                                    ocrResult = (OcrResult)this.L$1;
                                                    $this$launch = (CoroutineScope)this.L$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v5 = $result;
lbl64:
                                                    // 2 sources

                                                    transResult = (TransResponse)v5;
                                                    v6 = CaptureManager.access$getMLastResult$p(this.this$0);
                                                    Intrinsics.checkNotNull((Object)v6);
                                                    v6.setWorkingIndex(-1);
                                                    v7 = CaptureManager.access$getMLastResult$p(this.this$0);
                                                    Intrinsics.checkNotNull((Object)v7);
                                                    v8 = v7.getTransMap();
                                                    Intrinsics.checkNotNull(v8);
                                                    v8.put(Boxing.boxInt((int)this.$index.element), transResult);
                                                    v9 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                    if (v9 != null) {
                                                        v10 = this.$index.element;
                                                        v11 = CaptureManager.access$getMLastResult$p(this.this$0);
                                                        Intrinsics.checkNotNull((Object)v11);
                                                        v9.onRecognized(v10, v11);
                                                    }
                                                    if (CaptureManager.access$getMCurrentState$p(this.this$0) == 11) {
                                                        this.this$0.setCurrentState(3);
                                                        CaptureManager.access$setMLastResult$p(this.this$0, null);
                                                    } else {
                                                        this.this$0.setCurrentState(10);
                                                    }
                                                    break block15;
                                                }
                                            }
                                            if (CaptureManager.access$getMCurrentState$p(this.this$0) == 11) {
                                                this.this$0.setCurrentState(3);
                                                CaptureManager.access$setMLastResult$p(this.this$0, null);
                                            } else {
                                                this.this$0.setCurrentState(10);
                                            }
                                            v12 = CaptureManager.access$getMResultListener$p(this.this$0);
                                            if (v12 != null) {
                                                v13 = this.$result.getRects();
                                                Intrinsics.checkNotNull(v13);
                                                v12.onRecognizedFail(v13.get(this.$index.element));
                                            }
                                        }
                                        return Unit.INSTANCE;
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                        function2.p$ = (CoroutineScope)value;
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                                        return function22;
                                    }

                                    public final Object invoke(Object object, Object object2) {
                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            }
                            unit = Unit.INSTANCE;
                            break block0;
                        }
                        unit = null;
                        break block0;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        Unit unit;
                        CaptureTransResult captureTransResult = this.mLastResult;
                        if (captureTransResult != null) {
                            CaptureTransResult captureTransResult2 = captureTransResult;
                            boolean bl = false;
                            boolean bl11 = false;
                            CaptureTransResult transResult = captureTransResult2;
                            boolean bl12 = false;
                            VelocityTracker velocityTracker5 = this.velocityTracker;
                            Intrinsics.checkNotNull((Object)velocityTracker5);
                            velocityTracker5.computeCurrentVelocity(300);
                            VelocityTracker velocityTracker6 = this.velocityTracker;
                            Intrinsics.checkNotNull((Object)velocityTracker6);
                            float xVelocity = velocityTracker6.getXVelocity();
                            VelocityTracker velocityTracker7 = this.velocityTracker;
                            Intrinsics.checkNotNull((Object)velocityTracker7);
                            float yVelocity = velocityTracker7.getYVelocity();
                            if (xVelocity < (float)80 && yVelocity < (float)80) {
                                void index;
                                Unit unit6;
                                Ref.ObjectRef $this$forEachIndexed$iv;
                                CaptureResult captureResult = transResult.getCaptureResult();
                                boolean bl13 = false;
                                boolean bl14 = false;
                                CaptureResult captureResult2 = captureResult;
                                boolean bl15 = false;
                                Ref.IntRef bl8 = new Ref.IntRef();
                                bl8.element = -1;
                                Ref.ObjectRef objectRef = captureResult2.getRects();
                                if (objectRef != null) {
                                    $this$forEachIndexed$iv = objectRef;
                                    boolean $i$f$forEachIndexed = false;
                                    boolean bl16 = false;
                                    Ref.ObjectRef rects = $this$forEachIndexed$iv;
                                    boolean bl17 = false;
                                    Iterable $this$forEachIndexed$iv2 = (Iterable)rects;
                                    boolean $i$f$forEachIndexed2 = false;
                                    int index$iv = 0;
                                    for (Object item$iv : $this$forEachIndexed$iv2) {
                                        void rect;
                                        int n = index$iv++;
                                        boolean bl18 = false;
                                        if (n < 0) {
                                            CollectionsKt.throwIndexOverflow();
                                        }
                                        Rect rect3 = (Rect)item$iv;
                                        int i = n;
                                        boolean bl19 = false;
                                        if (!rect.contains((int)e.getRawX(), (int)e.getRawY())) continue;
                                        index.element = i;
                                        break;
                                    }
                                    unit6 = Unit.INSTANCE;
                                } else {
                                    unit6 = null;
                                }
                                if (index.element != -1 && transResult.getWorkingIndex() != index.element) {
                                    Unit unit7;
                                    transResult.setWorkingIndex(index.element);
                                    TranslationController.TextRecognizeListener textRecognizeListener = this.mResultListener;
                                    if (textRecognizeListener != null) {
                                        List<Rect> list = captureResult2.getRects();
                                        Intrinsics.checkNotNull(list);
                                        textRecognizeListener.onAreaConfirmed(list.get(index.element));
                                        unit7 = Unit.INSTANCE;
                                    } else {
                                        unit7 = null;
                                    }
                                    $this$forEachIndexed$iv = new Ref.ObjectRef();
                                    Object object = this.mResultListener;
                                    if (object == null || (object = object.getTransTargetLanguage()) == null) {
                                        Locale locale = Locale.ENGLISH;
                                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
                                        object = $this$forEachIndexed$iv.element = locale.getLanguage();
                                    }
                                    if (transResult.getOcrResultMap() != null) {
                                        Map<Integer, OcrResult> map = transResult.getOcrResultMap();
                                        Intrinsics.checkNotNull(map);
                                        OcrResult ocrR = map.get(index.element);
                                        if (ocrR != null) {
                                            void targetLanguage;
                                            Unit unit8;
                                            Job job = this.mRecognizeJob;
                                            if (job != null) {
                                                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                                                unit8 = Unit.INSTANCE;
                                            } else {
                                                unit8 = null;
                                            }
                                            this.mRecognizeJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ocrR, (Ref.ObjectRef)targetLanguage, (Ref.IntRef)index, null, transResult, this, e){
                                                private CoroutineScope p$;
                                                Object L$0;
                                                Object L$1;
                                                int label;
                                                final /* synthetic */ OcrResult $ocrR;
                                                final /* synthetic */ Ref.ObjectRef $targetLanguage;
                                                final /* synthetic */ Ref.IntRef $index;
                                                final /* synthetic */ CaptureTransResult $transResult$inlined;
                                                final /* synthetic */ CaptureManager this$0;
                                                final /* synthetic */ MotionEvent $e$inlined;
                                                {
                                                    this.$ocrR = ocrResult;
                                                    this.$targetLanguage = objectRef;
                                                    this.$index = intRef;
                                                    this.$transResult$inlined = captureTransResult;
                                                    this.this$0 = captureManager;
                                                    this.$e$inlined = motionEvent;
                                                    super(2, continuation);
                                                }

                                                /*
                                                 * Unable to fully structure code
                                                 */
                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object $result) {
                                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            $this$launch = this.p$;
                                                            this.this$0.setCurrentState(8);
                                                            var4_5 = new Ref.ObjectRef();
                                                            var5_7 = false;
                                                            var4_5.element = new ArrayList<E>();
                                                            $this$forEach$iv = this.$ocrR.getBlocks();
                                                            $i$f$forEach = false;
                                                            for (T element$iv : $this$forEach$iv) {
                                                                it = (Block)element$iv;
                                                                $i$a$-forEach-CaptureManager$delegateRecTouchEvent$3$1$2$1 = false;
                                                                ((ArrayList)list.element).add(it.getText());
                                                            }
                                                            this.L$0 = $this$launch;
                                                            this.L$1 = list;
                                                            this.label = 1;
                                                            v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransResponse>, Object>(this, (Ref.ObjectRef)list, null){
                                                                private CoroutineScope p$;
                                                                Object L$0;
                                                                int label;
                                                                final /* synthetic */ delegateRecTouchEvent$$inlined$let$lambda$2 this$0;
                                                                final /* synthetic */ Ref.ObjectRef $list;
                                                                {
                                                                    this.this$0 = var1_1;
                                                                    this.$list = objectRef;
                                                                    super(2, continuation);
                                                                }

                                                                /*
                                                                 * Enabled force condition propagation
                                                                 * Lifted jumps to return sites
                                                                 */
                                                                @Nullable
                                                                public final Object invokeSuspend(@NotNull Object $result) {
                                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                    switch (this.label) {
                                                                        case 0: {
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            CoroutineScope $this$withContext = this.p$;
                                                                            Context context = CaptureManager.access$getMContext$p(this.this$0.this$0);
                                                                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mContext");
                                                                            HiTranslator hiTranslator = HiTranslator.Companion.getInstance(context);
                                                                            Locale locale = Locale.getDefault();
                                                                            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
                                                                            String string2 = locale.getLanguage();
                                                                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Locale.getDefault().language");
                                                                            String string3 = (String)this.this$0.$targetLanguage.element;
                                                                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"targetLanguage");
                                                                            this.L$0 = $this$withContext;
                                                                            this.label = 1;
                                                                            Object object2 = hiTranslator.postTranslate(string2, string3, (ArrayList)this.$list.element, (Continuation<? super TransResponse>)this);
                                                                            Object object3 = object2;
                                                                            if (object2 != object) return object3;
                                                                            return object;
                                                                        }
                                                                        case 1: {
                                                                            CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            Object object3 = $result;
                                                                            return object3;
                                                                        }
                                                                    }
                                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                }

                                                                @NotNull
                                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                                    Function2<CoroutineScope, Continuation<? super TransResponse>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                                    CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                                                    function2.p$ = (CoroutineScope)value;
                                                                    Function2<CoroutineScope, Continuation<? super TransResponse>, Object> function22 = function2;
                                                                    return function22;
                                                                }

                                                                public final Object invoke(Object object, Object object2) {
                                                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                                                }
                                                            }), (Continuation)this);
                                                            if (v0 == var2_2) {
                                                                var11_14 = var2_2;
                                                                return var11_14;
                                                            }
                                                            ** GOTO lbl32
                                                        }
                                                        case 1: {
                                                            list = (Ref.ObjectRef)this.L$1;
                                                            $this$launch = (CoroutineScope)this.L$0;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            v0 = $result;
lbl32:
                                                            // 2 sources

                                                            transR = (TransResponse)v0;
                                                            this.this$0.setCurrentState(10);
                                                            this.$transResult$inlined.setWorkingIndex(-1);
                                                            v1 = this.$transResult$inlined.getTransMap();
                                                            Intrinsics.checkNotNull(v1);
                                                            v1.put(Boxing.boxInt((int)this.$index.element), transR);
                                                            v2 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                            if (v2 != null) {
                                                                v2.onRecognized(this.$index.element, this.$transResult$inlined);
                                                            }
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                @NotNull
                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                    CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                                    function2.p$ = (CoroutineScope)value;
                                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                                                    return function22;
                                                }

                                                public final Object invoke(Object object, Object object2) {
                                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)3, null);
                                        } else {
                                            Unit unit9;
                                            Job job = this.mRecognizeJob;
                                            if (job != null) {
                                                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                                                unit9 = Unit.INSTANCE;
                                            } else {
                                                unit9 = null;
                                            }
                                            this.mRecognizeJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.IntRef)index, captureResult2, null, transResult, this, e){
                                                private CoroutineScope p$;
                                                Object L$0;
                                                Object L$1;
                                                Object L$2;
                                                Object L$3;
                                                int label;
                                                final /* synthetic */ Ref.IntRef $index;
                                                final /* synthetic */ CaptureResult $captureResult;
                                                final /* synthetic */ CaptureTransResult $transResult$inlined;
                                                final /* synthetic */ CaptureManager this$0;
                                                final /* synthetic */ MotionEvent $e$inlined;
                                                {
                                                    this.$index = intRef;
                                                    this.$captureResult = captureResult;
                                                    this.$transResult$inlined = captureTransResult;
                                                    this.this$0 = captureManager;
                                                    this.$e$inlined = motionEvent;
                                                    super(2, continuation);
                                                }

                                                /*
                                                 * Unable to fully structure code
                                                 */
                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object $result) {
                                                    block11: {
                                                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                $this$launch = this.p$;
                                                                this.this$0.setCurrentState(7);
                                                                this.L$0 = $this$launch;
                                                                this.label = 1;
                                                                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super OcrResult>, Object>(this, null){
                                                                    private CoroutineScope p$;
                                                                    Object L$0;
                                                                    int label;
                                                                    final /* synthetic */ delegateRecTouchEvent$$inlined$let$lambda$3 this$0;
                                                                    {
                                                                        this.this$0 = var1_1;
                                                                        super(2, continuation);
                                                                    }

                                                                    /*
                                                                     * Enabled force condition propagation
                                                                     * Lifted jumps to return sites
                                                                     */
                                                                    @Nullable
                                                                    public final Object invokeSuspend(@NotNull Object $result) {
                                                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                        switch (this.label) {
                                                                            case 0: {
                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                CoroutineScope $this$withContext = this.p$;
                                                                                this.L$0 = $this$withContext;
                                                                                this.label = 1;
                                                                                Object object2 = this.this$0.this$0.doTextRecognize(this.this$0.$index.element, this.this$0.$captureResult, (Continuation<? super OcrResult>)this);
                                                                                Object object3 = object2;
                                                                                if (object2 != object) return object3;
                                                                                return object;
                                                                            }
                                                                            case 1: {
                                                                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                Object object3 = $result;
                                                                                return object3;
                                                                            }
                                                                        }
                                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                    }

                                                                    @NotNull
                                                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                                        Function2<CoroutineScope, Continuation<? super OcrResult>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                                        CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                                                        function2.p$ = (CoroutineScope)value;
                                                                        Function2<CoroutineScope, Continuation<? super OcrResult>, Object> function22 = function2;
                                                                        return function22;
                                                                    }

                                                                    public final Object invoke(Object object, Object object2) {
                                                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                                                    }
                                                                }), (Continuation)this);
                                                                if (v0 == var2_2) {
                                                                    var4_5 = var2_2;
                                                                    return var4_5;
                                                                }
                                                                ** GOTO lbl18
                                                            }
                                                            case 1: {
                                                                $this$launch = (CoroutineScope)this.L$0;
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v0 = $result;
lbl18:
                                                                // 2 sources

                                                                ocrResult = (OcrResult)v0;
                                                                this.this$0.setCurrentState(9);
                                                                if (ocrResult == null) break;
                                                                v1 = this.$transResult$inlined.getOcrResultMap();
                                                                Intrinsics.checkNotNull(v1);
                                                                v1.put(Boxing.boxInt((int)this.$index.element), ocrResult);
                                                                var6_9 = new Ref.ObjectRef();
                                                                v2 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                                if (v2 == null || (v2 = v2.getTransTargetLanguage()) == null) {
                                                                    v3 = Locale.ENGLISH;
                                                                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"Locale.ENGLISH");
                                                                    v2 = v3.getLanguage();
                                                                }
                                                                var6_9.element = v2;
                                                                var7_11 = new Ref.ObjectRef();
                                                                var8_13 = false;
                                                                var7_11.element = new ArrayList<E>();
                                                                $this$forEach$iv = ocrResult.getBlocks();
                                                                $i$f$forEach = false;
                                                                for (T element$iv : $this$forEach$iv) {
                                                                    it = (Block)element$iv;
                                                                    $i$a$-forEach-CaptureManager$delegateRecTouchEvent$3$1$3$1 = false;
                                                                    ((ArrayList)list.element).add(it.getText());
                                                                }
                                                                this.this$0.setCurrentState(8);
                                                                this.L$0 = $this$launch;
                                                                this.L$1 = ocrResult;
                                                                this.L$2 = targetLanguage;
                                                                this.L$3 = list;
                                                                this.label = 2;
                                                                v4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransResponse>, Object>(this, (Ref.ObjectRef)targetLanguage, (Ref.ObjectRef)list, null){
                                                                    private CoroutineScope p$;
                                                                    Object L$0;
                                                                    int label;
                                                                    final /* synthetic */ delegateRecTouchEvent$$inlined$let$lambda$3 this$0;
                                                                    final /* synthetic */ Ref.ObjectRef $targetLanguage;
                                                                    final /* synthetic */ Ref.ObjectRef $list;
                                                                    {
                                                                        this.this$0 = var1_1;
                                                                        this.$targetLanguage = objectRef;
                                                                        this.$list = objectRef2;
                                                                        super(2, continuation);
                                                                    }

                                                                    /*
                                                                     * Enabled force condition propagation
                                                                     * Lifted jumps to return sites
                                                                     */
                                                                    @Nullable
                                                                    public final Object invokeSuspend(@NotNull Object $result) {
                                                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                        switch (this.label) {
                                                                            case 0: {
                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                CoroutineScope $this$withContext = this.p$;
                                                                                Context context = CaptureManager.access$getMContext$p(this.this$0.this$0);
                                                                                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mContext");
                                                                                HiTranslator hiTranslator = HiTranslator.Companion.getInstance(context);
                                                                                Locale locale = Locale.getDefault();
                                                                                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
                                                                                String string2 = locale.getLanguage();
                                                                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Locale.getDefault().language");
                                                                                String string3 = (String)this.$targetLanguage.element;
                                                                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"targetLanguage");
                                                                                this.L$0 = $this$withContext;
                                                                                this.label = 1;
                                                                                Object object2 = hiTranslator.postTranslate(string2, string3, (ArrayList)this.$list.element, (Continuation<? super TransResponse>)this);
                                                                                Object object3 = object2;
                                                                                if (object2 != object) return object3;
                                                                                return object;
                                                                            }
                                                                            case 1: {
                                                                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                Object object3 = $result;
                                                                                return object3;
                                                                            }
                                                                        }
                                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                    }

                                                                    @NotNull
                                                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                                        Function2<CoroutineScope, Continuation<? super TransResponse>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                                        CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                                                        function2.p$ = (CoroutineScope)value;
                                                                        Function2<CoroutineScope, Continuation<? super TransResponse>, Object> function22 = function2;
                                                                        return function22;
                                                                    }

                                                                    public final Object invoke(Object object, Object object2) {
                                                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                                                    }
                                                                }), (Continuation)this);
                                                                if (v4 == var2_2) {
                                                                    var4_6 = var2_2;
                                                                    return var4_6;
                                                                }
                                                                ** GOTO lbl62
                                                            }
                                                            case 2: {
                                                                list = (Ref.ObjectRef)this.L$3;
                                                                targetLanguage = (Ref.ObjectRef)this.L$2;
                                                                ocrResult = (OcrResult)this.L$1;
                                                                $this$launch = (CoroutineScope)this.L$0;
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v4 = $result;
lbl62:
                                                                // 2 sources

                                                                transR = (TransResponse)v4;
                                                                this.this$0.setCurrentState(10);
                                                                this.$transResult$inlined.setWorkingIndex(-1);
                                                                v5 = this.$transResult$inlined.getTransMap();
                                                                Intrinsics.checkNotNull(v5);
                                                                v5.put(Boxing.boxInt((int)this.$index.element), transR);
                                                                v6 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                                if (v6 != null) {
                                                                    v6.onRecognized(this.$index.element, this.$transResult$inlined);
                                                                }
                                                                break block11;
                                                            }
                                                        }
                                                        this.this$0.setCurrentState(10);
                                                        this.$transResult$inlined.setWorkingIndex(-1);
                                                        v7 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                        if (v7 != null) {
                                                            v8 = this.$captureResult.getRects();
                                                            Intrinsics.checkNotNull(v8);
                                                            v7.onRecognizedFail(v8.get(this.$index.element));
                                                        }
                                                    }
                                                    return Unit.INSTANCE;
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                @NotNull
                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                    CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                                    function2.p$ = (CoroutineScope)value;
                                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                                                    return function22;
                                                }

                                                public final Object invoke(Object object, Object object2) {
                                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)3, null);
                                        }
                                    } else {
                                        Unit unit10;
                                        Job job = this.mRecognizeJob;
                                        if (job != null) {
                                            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                                            unit10 = Unit.INSTANCE;
                                        } else {
                                            unit10 = null;
                                        }
                                        this.mRecognizeJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.IntRef)index, captureResult2, null, transResult, this, e){
                                            private CoroutineScope p$;
                                            Object L$0;
                                            Object L$1;
                                            Object L$2;
                                            Object L$3;
                                            int label;
                                            final /* synthetic */ Ref.IntRef $index;
                                            final /* synthetic */ CaptureResult $captureResult;
                                            final /* synthetic */ CaptureTransResult $transResult$inlined;
                                            final /* synthetic */ CaptureManager this$0;
                                            final /* synthetic */ MotionEvent $e$inlined;
                                            {
                                                this.$index = intRef;
                                                this.$captureResult = captureResult;
                                                this.$transResult$inlined = captureTransResult;
                                                this.this$0 = captureManager;
                                                this.$e$inlined = motionEvent;
                                                super(2, continuation);
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object $result) {
                                                block11: {
                                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            $this$launch = this.p$;
                                                            this.this$0.setCurrentState(7);
                                                            this.L$0 = $this$launch;
                                                            this.label = 1;
                                                            v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super OcrResult>, Object>(this, null){
                                                                private CoroutineScope p$;
                                                                Object L$0;
                                                                int label;
                                                                final /* synthetic */ delegateRecTouchEvent$$inlined$let$lambda$4 this$0;
                                                                {
                                                                    this.this$0 = var1_1;
                                                                    super(2, continuation);
                                                                }

                                                                /*
                                                                 * Enabled force condition propagation
                                                                 * Lifted jumps to return sites
                                                                 */
                                                                @Nullable
                                                                public final Object invokeSuspend(@NotNull Object $result) {
                                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                    switch (this.label) {
                                                                        case 0: {
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            CoroutineScope $this$withContext = this.p$;
                                                                            this.L$0 = $this$withContext;
                                                                            this.label = 1;
                                                                            Object object2 = this.this$0.this$0.doTextRecognize(this.this$0.$index.element, this.this$0.$captureResult, (Continuation<? super OcrResult>)this);
                                                                            Object object3 = object2;
                                                                            if (object2 != object) return object3;
                                                                            return object;
                                                                        }
                                                                        case 1: {
                                                                            CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            Object object3 = $result;
                                                                            return object3;
                                                                        }
                                                                    }
                                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                }

                                                                @NotNull
                                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                                    Function2<CoroutineScope, Continuation<? super OcrResult>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                                    CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                                                    function2.p$ = (CoroutineScope)value;
                                                                    Function2<CoroutineScope, Continuation<? super OcrResult>, Object> function22 = function2;
                                                                    return function22;
                                                                }

                                                                public final Object invoke(Object object, Object object2) {
                                                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                                                }
                                                            }), (Continuation)this);
                                                            if (v0 == var2_2) {
                                                                var4_5 = var2_2;
                                                                return var4_5;
                                                            }
                                                            ** GOTO lbl18
                                                        }
                                                        case 1: {
                                                            $this$launch = (CoroutineScope)this.L$0;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            v0 = $result;
lbl18:
                                                            // 2 sources

                                                            ocrResult = (OcrResult)v0;
                                                            this.this$0.setCurrentState(9);
                                                            if (ocrResult == null) break;
                                                            v1 = this.$transResult$inlined.getOcrResultMap();
                                                            Intrinsics.checkNotNull(v1);
                                                            v1.put(Boxing.boxInt((int)this.$index.element), ocrResult);
                                                            var6_9 = new Ref.ObjectRef();
                                                            v2 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                            if (v2 == null || (v2 = v2.getTransTargetLanguage()) == null) {
                                                                v3 = Locale.ENGLISH;
                                                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"Locale.ENGLISH");
                                                                v2 = v3.getLanguage();
                                                            }
                                                            var6_9.element = v2;
                                                            var7_11 = new Ref.ObjectRef();
                                                            var8_13 = false;
                                                            var7_11.element = new ArrayList<E>();
                                                            $this$forEach$iv = ocrResult.getBlocks();
                                                            $i$f$forEach = false;
                                                            for (T element$iv : $this$forEach$iv) {
                                                                it = (Block)element$iv;
                                                                $i$a$-forEach-CaptureManager$delegateRecTouchEvent$3$1$4$1 = false;
                                                                ((ArrayList)list.element).add(it.getText());
                                                            }
                                                            this.this$0.setCurrentState(8);
                                                            this.L$0 = $this$launch;
                                                            this.L$1 = ocrResult;
                                                            this.L$2 = targetLanguage;
                                                            this.L$3 = list;
                                                            this.label = 2;
                                                            v4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransResponse>, Object>(this, (Ref.ObjectRef)targetLanguage, (Ref.ObjectRef)list, null){
                                                                private CoroutineScope p$;
                                                                Object L$0;
                                                                int label;
                                                                final /* synthetic */ delegateRecTouchEvent$$inlined$let$lambda$4 this$0;
                                                                final /* synthetic */ Ref.ObjectRef $targetLanguage;
                                                                final /* synthetic */ Ref.ObjectRef $list;
                                                                {
                                                                    this.this$0 = var1_1;
                                                                    this.$targetLanguage = objectRef;
                                                                    this.$list = objectRef2;
                                                                    super(2, continuation);
                                                                }

                                                                /*
                                                                 * Enabled force condition propagation
                                                                 * Lifted jumps to return sites
                                                                 */
                                                                @Nullable
                                                                public final Object invokeSuspend(@NotNull Object $result) {
                                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                    switch (this.label) {
                                                                        case 0: {
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            CoroutineScope $this$withContext = this.p$;
                                                                            Context context = CaptureManager.access$getMContext$p(this.this$0.this$0);
                                                                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mContext");
                                                                            HiTranslator hiTranslator = HiTranslator.Companion.getInstance(context);
                                                                            Locale locale = Locale.getDefault();
                                                                            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
                                                                            String string2 = locale.getLanguage();
                                                                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Locale.getDefault().language");
                                                                            String string3 = (String)this.$targetLanguage.element;
                                                                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"targetLanguage");
                                                                            this.L$0 = $this$withContext;
                                                                            this.label = 1;
                                                                            Object object2 = hiTranslator.postTranslate(string2, string3, (ArrayList)this.$list.element, (Continuation<? super TransResponse>)this);
                                                                            Object object3 = object2;
                                                                            if (object2 != object) return object3;
                                                                            return object;
                                                                        }
                                                                        case 1: {
                                                                            CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            Object object3 = $result;
                                                                            return object3;
                                                                        }
                                                                    }
                                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                }

                                                                @NotNull
                                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                                    Function2<CoroutineScope, Continuation<? super TransResponse>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                                    CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                                                    function2.p$ = (CoroutineScope)value;
                                                                    Function2<CoroutineScope, Continuation<? super TransResponse>, Object> function22 = function2;
                                                                    return function22;
                                                                }

                                                                public final Object invoke(Object object, Object object2) {
                                                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                                                }
                                                            }), (Continuation)this);
                                                            if (v4 == var2_2) {
                                                                var4_6 = var2_2;
                                                                return var4_6;
                                                            }
                                                            ** GOTO lbl62
                                                        }
                                                        case 2: {
                                                            list = (Ref.ObjectRef)this.L$3;
                                                            targetLanguage = (Ref.ObjectRef)this.L$2;
                                                            ocrResult = (OcrResult)this.L$1;
                                                            $this$launch = (CoroutineScope)this.L$0;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            v4 = $result;
lbl62:
                                                            // 2 sources

                                                            transR = (TransResponse)v4;
                                                            this.this$0.setCurrentState(10);
                                                            this.$transResult$inlined.setWorkingIndex(-1);
                                                            v5 = this.$transResult$inlined.getTransMap();
                                                            Intrinsics.checkNotNull(v5);
                                                            v5.put(Boxing.boxInt((int)this.$index.element), transR);
                                                            v6 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                            if (v6 != null) {
                                                                v6.onRecognized(this.$index.element, this.$transResult$inlined);
                                                            }
                                                            break block11;
                                                        }
                                                    }
                                                    this.this$0.setCurrentState(10);
                                                    this.$transResult$inlined.setWorkingIndex(-1);
                                                    v7 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                    if (v7 != null) {
                                                        v8 = this.$captureResult.getRects();
                                                        Intrinsics.checkNotNull(v8);
                                                        v7.onRecognizedFail(v8.get(this.$index.element));
                                                    }
                                                }
                                                return Unit.INSTANCE;
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                                function2.p$ = (CoroutineScope)value;
                                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                                                return function22;
                                            }

                                            public final Object invoke(Object object, Object object2) {
                                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)3, null);
                                    }
                                }
                            }
                            unit = Unit.INSTANCE;
                            break block0;
                        }
                        unit = null;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                Unit unit;
                if (this.mRecordService != null) {
                    switch (this.mCurrentState) {
                        case 10: {
                            this.setCurrentState(3);
                            this.mLastResult = null;
                            break;
                        }
                        case 4: 
                        case 7: 
                        case 8: {
                            this.setCurrentState(11);
                            break;
                        }
                    }
                } else {
                    this.setCurrentState(0);
                }
                VelocityTracker velocityTracker8 = this.velocityTracker;
                if (velocityTracker8 != null) {
                    velocityTracker8.recycle();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                this.velocityTracker = null;
                break;
            }
        }
    }

    public CaptureManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mContext = context.getApplicationContext();
        Context context2 = this.mContext;
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"mContext");
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        String string2 = locale.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Locale.getDefault().language");
        this.mTranslator = OcrDispatcher.INSTANCE.dispatchOcrTranslator(context2, string2);
        this.mRemoteCallback = new IRecordListener.Stub(this){
            final /* synthetic */ CaptureManager this$0;

            public void onRecordServiceReady() {
                block0: {
                    Log.d((String)"cjslog", (String)"onRecordServiceReady");
                    TranslationController.TextRecognizeListener textRecognizeListener = CaptureManager.access$getMResultListener$p(this.this$0);
                    if (textRecognizeListener == null) break block0;
                    textRecognizeListener.onRecognizeServiceReady();
                }
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    public static final /* synthetic */ Context access$getMContext$p(CaptureManager $this) {
        return $this.mContext;
    }

    public static final /* synthetic */ CaptureTransResult access$getMLastResult$p(CaptureManager $this) {
        return $this.mLastResult;
    }

    public static final /* synthetic */ void access$setMLastResult$p(CaptureManager $this, CaptureTransResult captureTransResult) {
        $this.mLastResult = captureTransResult;
    }

    public static final /* synthetic */ TranslationController.TextRecognizeListener access$getMResultListener$p(CaptureManager $this) {
        return $this.mResultListener;
    }

    public static final /* synthetic */ void access$setMResultListener$p(CaptureManager $this, TranslationController.TextRecognizeListener textRecognizeListener) {
        $this.mResultListener = textRecognizeListener;
    }

    public static final /* synthetic */ int access$getMCurrentState$p(CaptureManager $this) {
        return $this.mCurrentState;
    }

    public static final /* synthetic */ void access$setMCurrentState$p(CaptureManager $this, int n) {
        $this.mCurrentState = n;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/talpa/translate/record/CaptureManager$Companion;", "", "()V", "MIN_DISTANCE", "", "MIN_VELOCITY", "RECT_GAP", "STATE_ACTION_CLEAR", "STATE_ASKING_PERMISSION", "STATE_CAPTURED_PIC", "STATE_CAPTURING_PIC", "STATE_INITIALIZE", "STATE_PERMISSION_GRANTED", "STATE_RECOGNIZED_FINISH", "STATE_RECOGNIZE_START", "STATE_RECOGNIZING", "STATE_SERVICE_PREPARED", "STATE_TRANSLATE_FINISH", "STATE_TRANSLATING", "VELOCITY_TIME_MILLIS", "translation_devDebug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

